/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.utils;

import android.content.Context;
import com.ss.bytertc.base.utils.RtcContextUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.webrtc.CalledByNative;

public class EffectBeautyResource {
    @CalledByNative
    public static String GetEffectComposeMakeupPath() {
        Context context = RtcContextUtils.getApplicationContext();
        File externalDir = context.getFilesDir();
        File basicBeautyResourcePath = new File(externalDir, "basic_beauty");
        EffectBeautyResource.copyAssetFolder(context, "basic_beauty", basicBeautyResourcePath.getAbsolutePath());
        return basicBeautyResourcePath.getAbsolutePath();
    }

    private static boolean copyAssetFolder(Context context, String srcName, String dstName) {
        try {
            boolean result = true;
            String[] fileList = context.getAssets().list(srcName);
            if (fileList == null) {
                return false;
            }
            if (fileList.length == 0) {
                result = EffectBeautyResource.copyAssetFile(context, srcName, dstName);
            } else {
                File file = new File(dstName);
                result = file.mkdirs();
                for (String filename : fileList) {
                    result &= EffectBeautyResource.copyAssetFolder(context, srcName + File.separator + filename, dstName + File.separator + filename);
                }
            }
            return result;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static boolean copyAssetFile(Context context, String srcName, String dstName) {
        try {
            int read;
            File outFile = new File(dstName);
            if (outFile.exists()) {
                return true;
            }
            InputStream in = context.getAssets().open(srcName);
            if (in == null) {
                return false;
            }
            FileOutputStream out = new FileOutputStream(outFile);
            byte[] buffer = new byte[1024];
            while ((read = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, read);
            }
            in.close();
            ((OutputStream)out).close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }
}

