/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.utils;

import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.os.Build;
import android.support.annotation.RequiresApi;
import org.webrtc.CalledByNative;
import org.webrtc.EglBase;

public class EglBaseUtils {
    @CalledByNative
    public static long getNativeContextFromEGLBaseContext(EglBase.Context eglBaseContext) {
        if (eglBaseContext != null) {
            return eglBaseContext.getNativeEglContext();
        }
        return 0L;
    }

    @RequiresApi(api=17)
    @CalledByNative
    public static EGLContext getCurrentContext() {
        EGLContext currentContext = EGL14.eglGetCurrentContext();
        return currentContext;
    }

    @CalledByNative
    public static EglBase.Context getEGLBaseContext(EglBase eglBase) {
        return eglBase.getEglBaseContext();
    }

    @CalledByNative
    public static EglBase createEGLBase(EGLContext eglContext14) {
        if (eglContext14 == EGL14.EGL_NO_CONTEXT || eglContext14 == null) {
            return EglBase.createEgl14(EglBase.CONFIG_PLAIN);
        }
        return EglBase.createEgl14(eglContext14, EglBase.CONFIG_PLAIN);
    }

    @CalledByNative
    public static void releaseEGLBase(EglBase eglBase) {
        if (eglBase != null) {
            eglBase.release();
        }
    }

    @CalledByNative
    public static long getNativeEGLContext(EGLContext egl14Context) {
        if (egl14Context == null) {
            return 0L;
        }
        return Build.VERSION.SDK_INT >= 21 ? egl14Context.getNativeHandle() : (long)egl14Context.getHandle();
    }
}

