/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.utils;

import android.app.ActivityManager;
import android.content.Context;
import android.os.Build;
import com.ss.bytertc.engine.utils.GPUUtil;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;

public class GetDeviceHelper {
    public static final int BUFFER_SIZE = 8192;
    private static final int ERROR_RESULT = -1;
    private static final String MEMORY_INFO_PATH = "/proc/meminfo";

    public static String getGpuName() {
        String gpuName = "";
        gpuName = Build.VERSION.SDK_INT >= 22 ? GPUUtil.getGPURenderer() : GPUUtil.getGPURendererFallback();
        if (gpuName == null) {
            return "null-null";
        }
        return gpuName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getTotalMemory(Context context) {
        if (context == null) {
            return -1;
        }
        if (Build.VERSION.SDK_INT >= 16) {
            ActivityManager.MemoryInfo outInfo = new ActivityManager.MemoryInfo();
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            if (am == null) {
                return -1;
            }
            am.getMemoryInfo(outInfo);
            return (int)Math.ceil((double)outInfo.totalMem * 1.024 / 1024.0 / 1024.0 / 1024.0);
        }
        long memory = -1L;
        BufferedReader localBufferedReader = null;
        try {
            String line = "";
            String memTotal = "";
            localBufferedReader = new BufferedReader(new FileReader(MEMORY_INFO_PATH), 8192);
            while ((line = localBufferedReader.readLine()) != null) {
                if (!line.contains("MemTotal")) continue;
                String[] total = line.split(":");
                memTotal = total[1].trim();
                break;
            }
            localBufferedReader.close();
            String[] memKb = memTotal.split(" ");
            memTotal = memKb[0].trim();
            memory = Long.parseLong(memTotal);
        }
        catch (Exception e) {
        }
        finally {
            try {
                localBufferedReader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return (int)Math.ceil((double)memory * 1.024 / 1024.0 / 1024.0 / 1024.0);
    }
}

