/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.utils;

import android.content.Context;
import java.io.File;
import java.util.concurrent.atomic.AtomicReference;

public class LogUtil {
    private static AtomicReference<LoggerSink> sLoggerSink = new AtomicReference();
    public static final String DIR_TAIL = "logs";
    private static final String DEBUG_LEVEL = "DEBUG";
    private static final String INFO_LEVEL = "INFO";
    private static final String WARN_LEVEL = "WARNING";
    private static final String ERROR_LEVEL = "ERROR";
    private static final String LOG_TAG = "ByteRTC";
    private static String sDeviceID = null;
    private static LogLevel sLogLevel = LogLevel.LOG_LEVEL_INFO;
    private static String sLogDir = null;

    public static void setLoggerSink(LoggerSink sink) {
        if (sink != null) {
            sLoggerSink.set(sink);
        } else {
            sLoggerSink.compareAndSet(LogUtil.getLoggerSink(), null);
        }
    }

    private static LoggerSink getLoggerSink() {
        return sLoggerSink.get();
    }

    private static void notifyLoggerSinks(LogLevel level, String msg, Throwable throwable) {
        LoggerSink loggerSink;
        if (sLoggerSink != null && (loggerSink = LogUtil.getLoggerSink()) != null) {
            loggerSink.onLoggerMessage(level, msg, throwable);
        }
    }

    public static void setDebug(boolean debug) {
    }

    public static void d(String tag, String message) {
        if (LogLevel.LOG_LEVEL_DEBUG.compareTo(sLogLevel) >= 0) {
            String msg = String.format("[msg:%s]", message);
            LogUtil.notifyLoggerSinks(LogLevel.LOG_LEVEL_DEBUG, String.format("[%s:%s]:%s", LOG_TAG, tag, msg), null);
        }
    }

    public static void i(String tag, String message) {
        if (LogLevel.LOG_LEVEL_INFO.compareTo(sLogLevel) >= 0) {
            String msg = String.format("[msg:%s]", message);
            LogUtil.notifyLoggerSinks(LogLevel.LOG_LEVEL_INFO, String.format("[%s:%s]:%s", LOG_TAG, tag, msg), null);
        }
    }

    public static void w(String tag, String message) {
        if (LogLevel.LOG_LEVEL_WARNING.compareTo(sLogLevel) >= 0) {
            String msg = String.format("[msg:%s]", message);
            LogUtil.notifyLoggerSinks(LogLevel.LOG_LEVEL_WARNING, String.format("[%s:%s]:%s", LOG_TAG, tag, msg), null);
        }
    }

    public static void w(String tag, String message, Throwable exception) {
        if (LogLevel.LOG_LEVEL_WARNING.compareTo(sLogLevel) >= 0) {
            String msg = String.format("[msg:%s]", message);
            LogUtil.notifyLoggerSinks(LogLevel.LOG_LEVEL_WARNING, String.format("[%s:%s]:%s", LOG_TAG, tag, msg), exception);
        }
    }

    public static void e(String tag, String message) {
        if (LogLevel.LOG_LEVEL_ERROR.compareTo(sLogLevel) >= 0) {
            String msg = String.format("[msg:%s]", message);
            LogUtil.notifyLoggerSinks(LogLevel.LOG_LEVEL_ERROR, String.format("[%s:%s]:%s", LOG_TAG, tag, msg), null);
        }
    }

    public static void e(String tag, String message, Throwable exception) {
        if (LogLevel.LOG_LEVEL_ERROR.compareTo(sLogLevel) >= 0) {
            String msg = String.format("[msg:%s]", message);
            LogUtil.notifyLoggerSinks(LogLevel.LOG_LEVEL_ERROR, String.format("[%s:%s]:%s", LOG_TAG, tag, msg), exception);
        }
    }

    public static LogLevel getLogLevel() {
        return sLogLevel;
    }

    public static void setLogLevel(LogLevel logLevel) {
        sLogLevel = logLevel;
    }

    public static String getLogDir(Context context) {
        if (sLogDir != null) {
            return sLogDir;
        }
        sLogDir = context.getExternalFilesDir(null) + File.separator + "RTCEngine" + File.separator + "Log" + File.separator + DIR_TAIL;
        return sLogDir;
    }

    public static void setLogDir(String logDir) {
        sLogDir = logDir + File.separator + DIR_TAIL;
    }

    public static void setDeviceID(String deviceID) {
        sDeviceID = deviceID;
    }

    public static String getDeviceID() {
        return sDeviceID;
    }

    public static interface LoggerSink {
        public void onLoggerMessage(LogLevel var1, String var2, Throwable var3);
    }

    public static enum LogLevel {
        LOG_LEVEL_TRACE,
        LOG_LEVEL_DEBUG,
        LOG_LEVEL_INFO,
        LOG_LEVEL_WARNING,
        LOG_LEVEL_ERROR;

    }
}

