/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.utils;

import android.os.Build;
import android.text.TextUtils;
import java.lang.reflect.Method;

public class RomUtil {
    private static String customOS = "";
    private static String customOSVersion = "";
    private static final String KEY_HARMONYOS_VERSION_NAME = "hw_sc.build.platform.version";
    private static final String KEY_EMUI_VERSION_NAME = "ro.build.version.emui";
    private static final String KEY_MAGICUI_VERSION = "ro.build.version.magic";
    private static final String KEY_MIUI_VERSION_NAME = "ro.miui.ui.version.name";
    private static final String KEY_COLOROS_VERSION_NAME = "ro.build.version.opporom";
    private static final String KEY_VIVO_VERSION_NAME = "ro.vivo.os.name";
    private static final String KEY_VIVO_VERSION = "ro.vivo.os.version";
    private static final String KEY_ONEPLUS_VERSION_NAME = "ro.rom.version";
    private static final String KEY_FLYME_VERSION_NAME = "ro.build.display.id";
    private static final String KEY_NUBIA_VERSION_NAME = "ro.build.nubia.rom.name";
    private static final String KEY_NUBIA_VERSION_CODE = "ro.build.nubia.rom.code";

    private static String getSystemPropertyValue(String key) {
        try {
            Class<?> classType = Class.forName("android.os.SystemProperties");
            Method getMethod = classType.getDeclaredMethod("get", String.class);
            String value = (String)getMethod.invoke(classType, key);
            return value;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean isHarmonyOS() {
        try {
            Class<?> classType = Class.forName("com.huawei.system.BuildEx");
            Method getMethod = classType.getMethod("getOsBrand", new Class[0]);
            String value = (String)getMethod.invoke(classType, new Object[0]);
            return !TextUtils.isEmpty((CharSequence)value);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static String getPhoneSystem(String phoneBrand) {
        if (TextUtils.isEmpty((CharSequence)customOS)) {
            RomUtil.setCustomOSInfo(phoneBrand);
        }
        return customOS + "_" + customOSVersion;
    }

    private static boolean isMagicUI() {
        return false;
    }

    public static String getCustomOSVersion(String phoneBrand) {
        if (TextUtils.isEmpty((CharSequence)customOS)) {
            RomUtil.setCustomOSInfo(phoneBrand);
        }
        return customOSVersion;
    }

    public static String deleteSpaceAndToUpperCase(String str) {
        if (TextUtils.isEmpty((CharSequence)str)) {
            return "";
        }
        return str.replaceAll(" ", "").toUpperCase();
    }

    private static void setCustomOSInfo(String phoneBrand) {
        try {
            switch (RomUtil.deleteSpaceAndToUpperCase(phoneBrand)) {
                case "HUAWEI": {
                    if (RomUtil.isHarmonyOS()) {
                        customOSVersion = RomUtil.getSystemPropertyValue(KEY_HARMONYOS_VERSION_NAME);
                        customOS = "HarmonyOS";
                        break;
                    }
                    customOS = "EMUI";
                    customOSVersion = RomUtil.getSystemPropertyValue(KEY_EMUI_VERSION_NAME);
                    break;
                }
                case "HONOR": {
                    if (!TextUtils.isEmpty((CharSequence)RomUtil.getSystemPropertyValue(KEY_MAGICUI_VERSION))) {
                        customOS = "MagicUI";
                        customOSVersion = RomUtil.getSystemPropertyValue(KEY_MAGICUI_VERSION);
                        break;
                    }
                    if (RomUtil.isHarmonyOS()) {
                        customOS = "HarmonyOS";
                        if (!TextUtils.isEmpty((CharSequence)RomUtil.getSystemPropertyValue(KEY_HARMONYOS_VERSION_NAME))) {
                            customOSVersion = RomUtil.getSystemPropertyValue(KEY_HARMONYOS_VERSION_NAME);
                            break;
                        }
                        customOSVersion = "";
                        break;
                    }
                    customOS = "EMUI";
                    customOSVersion = RomUtil.getSystemPropertyValue(KEY_EMUI_VERSION_NAME);
                    break;
                }
                case "XIAOMI": 
                case "REDMI": {
                    customOS = "MIUI";
                    customOSVersion = RomUtil.getSystemPropertyValue(KEY_MIUI_VERSION_NAME);
                    break;
                }
                case "REALME": 
                case "OPPO": {
                    customOS = "ColorOS";
                    customOSVersion = RomUtil.getSystemPropertyValue(KEY_COLOROS_VERSION_NAME);
                    break;
                }
                case "VIVO": {
                    customOS = "Funtouch";
                    customOSVersion = RomUtil.getSystemPropertyValue(KEY_VIVO_VERSION);
                    break;
                }
                case "ONEPLUS": {
                    customOS = "HydrogenOS";
                    customOSVersion = RomUtil.getSystemPropertyValue(KEY_ONEPLUS_VERSION_NAME);
                    break;
                }
                case "MEIZU": {
                    customOS = "Flyme";
                    customOSVersion = RomUtil.getSystemPropertyValue(KEY_FLYME_VERSION_NAME);
                    break;
                }
                case "NUBIA": {
                    customOS = RomUtil.getSystemPropertyValue(KEY_NUBIA_VERSION_NAME);
                    customOSVersion = RomUtil.getSystemPropertyValue(KEY_NUBIA_VERSION_CODE);
                    break;
                }
                default: {
                    customOS = "Android";
                    customOSVersion = Build.VERSION.RELEASE;
                    break;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

