/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.video.impl;

import android.opengl.EGLContext;
import com.ss.bytertc.engine.data.CameraId;
import com.ss.bytertc.engine.data.ColorSpace;
import com.ss.bytertc.engine.data.VideoContentType;
import com.ss.bytertc.engine.data.VideoFrameType;
import com.ss.bytertc.engine.data.VideoPixelFormat;
import com.ss.bytertc.engine.data.VideoRotation;
import com.ss.bytertc.engine.video.VideoFrame;
import java.nio.ByteBuffer;

public class DirectBufferVideoFrame
extends VideoFrame {
    private ByteBuffer[] dataOfPlanes;
    private int[] strideOfPlanes;
    private ByteBuffer supplementaryInfo;
    private ByteBuffer externalDataInfo;
    private VideoFrameType frameType;
    private VideoPixelFormat pixelFormat;
    private ColorSpace colorSpace = ColorSpace.kColorSpaceYCbCrBT601LimitedRange;
    private VideoRotation rotation = VideoRotation.VIDEO_ROTATION_0;
    private long timestampUs;
    private int width;
    private int height;
    private int textureID = 0;
    private float[] textureMatrix = null;
    private EGLContext eglContext = null;

    public DirectBufferVideoFrame(VideoPixelFormat pixelFormat) {
        int planeCount = 0;
        this.pixelFormat = pixelFormat;
        switch (pixelFormat) {
            case kVideoPixelFormatI420: {
                planeCount = 3;
                this.frameType = VideoFrameType.kVideoFrameTypeRawMemory;
                break;
            }
            case kVideoPixelFormatNV12: 
            case kVideoPixelFormatNV21: {
                planeCount = 2;
                this.frameType = VideoFrameType.kVideoFrameTypeRawMemory;
                break;
            }
            case kVideoPixelFormatRGBA: {
                planeCount = 1;
                this.frameType = VideoFrameType.kVideoFrameTypeRawMemory;
                break;
            }
            default: {
                this.frameType = VideoFrameType.kVideoFrameTypeGLTexture;
            }
        }
        this.dataOfPlanes = new ByteBuffer[planeCount];
        this.strideOfPlanes = new int[planeCount];
    }

    private ByteBuffer convert2DirectBuffer(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (buffer.isDirect()) {
            return buffer;
        }
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(buffer.remaining());
        directBuffer.position(0);
        directBuffer.put(buffer);
        directBuffer.rewind();
        return directBuffer;
    }

    public void setTimeStampUs(long timeStampUs) {
        this.timestampUs = timeStampUs;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setRotation(VideoRotation rotation) {
        this.rotation = rotation;
    }

    public void setColorSpace(ColorSpace colorSpace) {
        this.colorSpace = colorSpace;
    }

    public void setPlaneData(int planeIndex, ByteBuffer buffer) {
        ByteBuffer directBuffer;
        if (this.frameType == VideoFrameType.kVideoFrameTypeGLTexture) {
            return;
        }
        if (planeIndex >= this.dataOfPlanes.length) {
            return;
        }
        this.dataOfPlanes[planeIndex] = directBuffer = this.convert2DirectBuffer(buffer);
    }

    public void setPlaneStride(int planeIndex, int stride) {
        if (this.frameType == VideoFrameType.kVideoFrameTypeGLTexture) {
            return;
        }
        if (planeIndex >= this.dataOfPlanes.length) {
            return;
        }
        this.strideOfPlanes[planeIndex] = stride;
    }

    public void setExternalDataInfo(ByteBuffer externalDataInfo) {
        ByteBuffer directExternalDataInfo;
        this.externalDataInfo = directExternalDataInfo = this.convert2DirectBuffer(externalDataInfo);
    }

    public void setSupplementaryInfo(ByteBuffer supplementaryInfo) {
        ByteBuffer directSupplementaryInfo;
        this.supplementaryInfo = directSupplementaryInfo = this.convert2DirectBuffer(supplementaryInfo);
    }

    public void setTextureID(int textureID) {
        if (this.frameType == VideoFrameType.kVideoFrameTypeRawMemory) {
            return;
        }
        this.textureID = textureID;
    }

    public void setTextureMatrix(float[] textureMatrix) {
        this.textureMatrix = textureMatrix;
    }

    public void setEGLContext(EGLContext eglContext) {
        this.eglContext = eglContext;
    }

    @Override
    public void setReleaseCallback(Runnable releaseCallback) {
        super.setReleaseCallback(releaseCallback);
    }

    @Override
    public VideoFrameType getFrameType() {
        return this.frameType;
    }

    @Override
    public VideoPixelFormat getPixelFormat() {
        return this.pixelFormat;
    }

    @Override
    public VideoContentType getContentType() {
        return VideoContentType.kVideoContentTypeNormalFrame;
    }

    @Override
    public long getTimeStampUs() {
        return this.timestampUs;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public VideoRotation getRotation() {
        return this.rotation;
    }

    @Override
    public ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    @Override
    public int getNumberOfPlanes() {
        return this.dataOfPlanes.length;
    }

    @Override
    public ByteBuffer getPlaneData(int planeIndex) {
        return this.dataOfPlanes[planeIndex];
    }

    @Override
    public int getPlaneStride(int planeIndex) {
        return this.strideOfPlanes[planeIndex];
    }

    @Override
    public ByteBuffer getExternalDataInfo() {
        return this.externalDataInfo;
    }

    @Override
    public ByteBuffer getSupplementaryInfo() {
        return this.supplementaryInfo;
    }

    @Override
    public int getTextureID() {
        return this.textureID;
    }

    @Override
    public float[] getTextureMatrix() {
        return this.textureMatrix;
    }

    @Override
    public EGLContext getEGLContext() {
        return this.eglContext;
    }

    @Override
    public CameraId getCameraId() {
        return CameraId.CAMERA_ID_INVALID;
    }
}

