/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.video.impl;

import android.opengl.EGLContext;
import com.bytedance.realx.base.CalledByNative;
import com.ss.bytertc.engine.data.CameraId;
import com.ss.bytertc.engine.data.ColorSpace;
import com.ss.bytertc.engine.data.VideoContentType;
import com.ss.bytertc.engine.data.VideoFrameType;
import com.ss.bytertc.engine.data.VideoPixelFormat;
import com.ss.bytertc.engine.data.VideoRotation;
import com.ss.bytertc.engine.video.VideoFrame;
import java.nio.ByteBuffer;

public class NativeBufferVideoFrame
extends VideoFrame {
    private long nativeHandle;

    @CalledByNative
    NativeBufferVideoFrame(long nativeHandle) {
        this.nativeHandle = nativeHandle;
        this.setReleaseCallback(() -> {
            if (this.nativeHandle != 0L) {
                NativeBufferVideoFrame.nativeFreeVideoFrame(this.nativeHandle);
                this.nativeHandle = 0L;
            }
        });
    }

    @Override
    public VideoFrameType getFrameType() {
        if (this.nativeHandle == 0L) {
            return null;
        }
        return NativeBufferVideoFrame.nativeGetVideoFrameType(this.nativeHandle);
    }

    @Override
    public VideoPixelFormat getPixelFormat() {
        if (this.nativeHandle == 0L) {
            return null;
        }
        return NativeBufferVideoFrame.nativeGetPixelFormat(this.nativeHandle);
    }

    @Override
    public VideoContentType getContentType() {
        if (this.nativeHandle == 0L) {
            return null;
        }
        return NativeBufferVideoFrame.nativeGetContentType(this.nativeHandle);
    }

    @Override
    public long getTimeStampUs() {
        if (this.nativeHandle == 0L) {
            return 0L;
        }
        return NativeBufferVideoFrame.nativeGetTimeStampUs(this.nativeHandle);
    }

    @Override
    public int getWidth() {
        if (this.nativeHandle == 0L) {
            return 0;
        }
        return NativeBufferVideoFrame.nativeGetWidth(this.nativeHandle);
    }

    @Override
    public int getHeight() {
        if (this.nativeHandle == 0L) {
            return 0;
        }
        return NativeBufferVideoFrame.nativeGetHeight(this.nativeHandle);
    }

    @Override
    public VideoRotation getRotation() {
        if (this.nativeHandle == 0L) {
            return null;
        }
        return NativeBufferVideoFrame.nativeGetRotation(this.nativeHandle);
    }

    @Override
    public ColorSpace getColorSpace() {
        if (this.nativeHandle == 0L) {
            return null;
        }
        return NativeBufferVideoFrame.nativeGetColorSpace(this.nativeHandle);
    }

    @Override
    public CameraId getCameraId() {
        if (this.nativeHandle == 0L) {
            return null;
        }
        return NativeBufferVideoFrame.nativeGetCameraId(this.nativeHandle);
    }

    @Override
    public int getNumberOfPlanes() {
        if (this.nativeHandle == 0L) {
            return 0;
        }
        return NativeBufferVideoFrame.nativeGetNumberOfPlanes(this.nativeHandle);
    }

    @Override
    public ByteBuffer getPlaneData(int planeIndex) {
        if (this.nativeHandle == 0L) {
            return null;
        }
        return NativeBufferVideoFrame.nativeGetPlaneData(this.nativeHandle, planeIndex);
    }

    @Override
    public int getPlaneStride(int planeIndex) {
        if (this.nativeHandle == 0L) {
            return 0;
        }
        return NativeBufferVideoFrame.nativegetPlaneStride(this.nativeHandle, planeIndex);
    }

    @Override
    public ByteBuffer getExternalDataInfo() {
        if (this.nativeHandle == 0L) {
            return null;
        }
        return NativeBufferVideoFrame.nativeGetExternalDataInfo(this.nativeHandle);
    }

    @Override
    public ByteBuffer getSupplementaryInfo() {
        if (this.nativeHandle == 0L) {
            return null;
        }
        return NativeBufferVideoFrame.nativeGetSupplementaryInfo(this.nativeHandle);
    }

    @Override
    public int getTextureID() {
        if (this.nativeHandle == 0L) {
            return 0;
        }
        return NativeBufferVideoFrame.nativeGetTextureID(this.nativeHandle);
    }

    @Override
    public float[] getTextureMatrix() {
        if (this.nativeHandle == 0L) {
            return null;
        }
        return NativeBufferVideoFrame.nativeGetTextureMatrix(this.nativeHandle);
    }

    @Override
    public EGLContext getEGLContext() {
        if (this.nativeHandle == 0L) {
            return null;
        }
        return NativeBufferVideoFrame.nativeGetEglContext(this.nativeHandle);
    }

    private static native VideoFrameType nativeGetVideoFrameType(long var0);

    private static native VideoPixelFormat nativeGetPixelFormat(long var0);

    private static native VideoContentType nativeGetContentType(long var0);

    private static native long nativeGetTimeStampUs(long var0);

    private static native int nativeGetWidth(long var0);

    private static native int nativeGetHeight(long var0);

    private static native VideoRotation nativeGetRotation(long var0);

    private static native ColorSpace nativeGetColorSpace(long var0);

    private static native CameraId nativeGetCameraId(long var0);

    private static native int nativeGetNumberOfPlanes(long var0);

    private static native ByteBuffer nativeGetPlaneData(long var0, int var2);

    private static native int nativegetPlaneStride(long var0, int var2);

    private static native ByteBuffer nativeGetExternalDataInfo(long var0);

    private static native ByteBuffer nativeGetSupplementaryInfo(long var0);

    private static native int nativeGetTextureID(long var0);

    private static native float[] nativeGetTextureMatrix(long var0);

    private static native EGLContext nativeGetEglContext(long var0);

    private static native void nativeFreeVideoFrame(long var0);
}

