/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import com.bytedance.realx.base.RXLogging;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.CameraEnumerator;
import org.webrtc.CameraSession;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.CapturerObserver;
import org.webrtc.Logging;
import org.webrtc.NativeLibrary;
import org.webrtc.NativeLibraryLoader;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;

abstract class CameraCapturer
implements CameraVideoCapturer {
    private static final String TAG = "CameraCapturer";
    private static final int MAX_OPEN_CAMERA_ATTEMPTS = 3;
    private static final int OPEN_CAMERA_DELAY_MS = 500;
    private static final int OPEN_CAMERA_TIMEOUT = 10000;
    private final CameraEnumerator cameraEnumerator;
    @Nullable
    private final CameraVideoCapturer.CameraEventsHandler eventsHandler;
    private final Handler uiThreadHandler;
    private CameraVideoCapturer.ORIENTATION_MODE mOrientationMode = CameraVideoCapturer.ORIENTATION_MODE.ORIENTATION_MODE_ADAPTIVE;
    @Nullable
    private final CameraSession.CreateSessionCallback createSessionCallback = new CameraSession.CreateSessionCallback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDone(CameraSession session) {
            CameraCapturer.this.checkIsOnCameraThread();
            CameraCapturer.this.uiThreadHandler.removeCallbacks(CameraCapturer.this.openCameraTimeoutRunnable);
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                RXLogging.w(CameraCapturer.TAG, "Create session done. Switch state: " + (Object)((Object)CameraCapturer.this.switchState));
                if (session != null) {
                    session.setOrientationMode(CameraCapturer.this.mOrientationMode);
                }
                CameraCapturer.this.capturerObserver.onCapturerStarted(true);
                CameraCapturer.this.sessionOpening = false;
                CameraCapturer.this.currentSession = session;
                CameraCapturer.this.cameraStatistics = new CameraVideoCapturer.CameraStatistics(CameraCapturer.this.surfaceHelper, CameraCapturer.this.eventsHandler);
                CameraCapturer.this.firstFrameObserved = false;
                CameraCapturer.this.stateLock.notifyAll();
                if (CameraCapturer.this.switchState == SwitchState.IN_PROGRESS) {
                    CameraCapturer.this.switchState = SwitchState.IDLE;
                    if (CameraCapturer.this.switchEventsHandler != null) {
                        CameraCapturer.this.switchEventsHandler.onCameraSwitchDone(CameraCapturer.this.cameraEnumerator.isFrontFacing(CameraCapturer.this.cameraName));
                        CameraCapturer.this.switchEventsHandler = null;
                    }
                } else if (CameraCapturer.this.switchState == SwitchState.PENDING) {
                    CameraCapturer.this.switchState = SwitchState.IDLE;
                    CameraCapturer.this.switchCameraInternal(CameraCapturer.this.switchEventsHandler);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(CameraSession.FailureType failureType, String error) {
            CameraCapturer.this.checkIsOnCameraThread();
            CameraCapturer.this.uiThreadHandler.removeCallbacks(CameraCapturer.this.openCameraTimeoutRunnable);
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                CameraCapturer.this.capturerObserver.onCapturerStarted(false);
                CameraCapturer.this.openAttemptsRemaining--;
                if (CameraCapturer.this.openAttemptsRemaining <= 0) {
                    RXLogging.e(CameraCapturer.TAG, "Opening camera failed, passing: " + error);
                    CameraCapturer.this.sessionOpening = false;
                    CameraCapturer.this.stateLock.notifyAll();
                    if (CameraCapturer.this.switchState != SwitchState.IDLE) {
                        if (CameraCapturer.this.switchEventsHandler != null) {
                            CameraCapturer.this.switchEventsHandler.onCameraSwitchError(error);
                            CameraCapturer.this.switchEventsHandler = null;
                        }
                        CameraCapturer.this.switchState = SwitchState.IDLE;
                    }
                    if (failureType == CameraSession.FailureType.DISCONNECTED) {
                        CameraCapturer.this.eventsHandler.onCameraDisconnected();
                    } else {
                        CameraCapturer.this.eventsHandler.onCameraError(error);
                    }
                } else {
                    RXLogging.e(CameraCapturer.TAG, "Opening camera failed, retry: " + error);
                    CameraCapturer.this.createSessionInternal(500);
                }
            }
        }
    };
    @Nullable
    private final CameraSession.Events cameraSessionEventsHandler = new CameraSession.Events(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraOpening() {
            CameraCapturer.this.checkIsOnCameraThread();
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (CameraCapturer.this.currentSession != null) {
                    RXLogging.e(CameraCapturer.TAG, "onCameraOpening while session was open.");
                    return;
                }
                CameraCapturer.this.eventsHandler.onCameraOpening(CameraCapturer.this.cameraName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraError(CameraSession session, String error) {
            CameraCapturer.this.checkIsOnCameraThread();
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (session != CameraCapturer.this.currentSession) {
                    RXLogging.e(CameraCapturer.TAG, "onCameraError from another session: " + error);
                    return;
                }
                CameraCapturer.this.eventsHandler.onCameraError(error);
                CameraCapturer.this.capturerObserver.onCapturerError(error);
                CameraCapturer.this.stopCapture();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraDisconnected(CameraSession session) {
            CameraCapturer.this.checkIsOnCameraThread();
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (session != CameraCapturer.this.currentSession) {
                    RXLogging.e(CameraCapturer.TAG, "onCameraDisconnected from another session.");
                    return;
                }
                CameraCapturer.this.eventsHandler.onCameraDisconnected();
                CameraCapturer.this.capturerObserver.onCapturerError("CameraDisconnected");
                CameraCapturer.this.stopCapture();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraClosed(CameraSession session) {
            CameraCapturer.this.checkIsOnCameraThread();
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (session != CameraCapturer.this.currentSession && CameraCapturer.this.currentSession != null) {
                    RXLogging.e(CameraCapturer.TAG, "onCameraClosed from another session.");
                    return;
                }
                CameraCapturer.this.eventsHandler.onCameraClosed();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFrameCaptured(CameraSession session, VideoFrame frame) {
            CameraCapturer.this.checkIsOnCameraThread();
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                if (session != CameraCapturer.this.currentSession) {
                    Logging.e(CameraCapturer.TAG, "onFrameCaptured from another session.");
                    return;
                }
                if (!CameraCapturer.this.firstFrameObserved) {
                    CameraCapturer.this.eventsHandler.onFirstFrameAvailable();
                    CameraCapturer.this.firstFrameObserved = true;
                }
                if (CameraCapturer.this.cameraStatistics != null) {
                    CameraCapturer.this.cameraStatistics.addFrame();
                }
                CameraCapturer.this.capturerObserver.onFrameCaptured(frame);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCameraConfig(int width, int height, CameraEnumerationAndroid.CaptureFormat.FramerateRange framerateRange) {
            CameraCapturer.this.checkIsOnCameraThread();
            Object object = CameraCapturer.this.stateLock;
            synchronized (object) {
                CameraCapturer.this.eventsHandler.onCameraConfig(width, height, framerateRange);
            }
        }
    };
    private final Runnable openCameraTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            CameraCapturer.this.eventsHandler.onCameraError("Camera failed to start within timeout.");
        }
    };
    @Nullable
    private Handler cameraThreadHandler;
    private Context applicationContext;
    private CapturerObserver capturerObserver;
    @Nullable
    private SurfaceTextureHelper surfaceHelper;
    private final Object stateLock = new Object();
    private boolean sessionOpening;
    @Nullable
    private CameraSession currentSession;
    private String cameraName;
    private int width;
    private int height;
    private int framerate;
    private int openAttemptsRemaining;
    private SwitchState switchState = SwitchState.IDLE;
    @Nullable
    private CameraVideoCapturer.CameraSwitchHandler switchEventsHandler;
    @Nullable
    private CameraVideoCapturer.CameraStatistics cameraStatistics;
    private boolean firstFrameObserved;
    private NativeLibraryLoader nativeLibraryLoader = new NativeLibrary.DefaultLoader();
    private String nativeLibraryName = "bytertc";
    protected boolean mEnableFollowGravity = false;

    @Override
    public void setOrientationMode(CameraVideoCapturer.ORIENTATION_MODE orientationMode) {
        this.mOrientationMode = orientationMode;
    }

    @Override
    public boolean isCameraTorchSupported() {
        AtomicBoolean result = new AtomicBoolean(false);
        ThreadUtils.invokeAtFrontUninterruptibly(this.cameraThreadHandler, () -> {
            if (this.currentSession != null) {
                result.set(this.currentSession.isCameraTorchSupported());
            }
        });
        return result.get();
    }

    @Override
    public void turnOnFlashLight() {
        this.cameraThreadHandler.post(() -> {
            if (this.currentSession != null) {
                this.currentSession.turnOnFlashLight();
            }
        });
    }

    @Override
    public void turnOffFlashLight() {
        this.cameraThreadHandler.post(() -> {
            if (this.currentSession != null) {
                this.currentSession.turnOffFlashLight();
            }
        });
    }

    @Override
    public boolean isCameraZoomSupported() {
        AtomicBoolean result = new AtomicBoolean(false);
        ThreadUtils.invokeAtFrontUninterruptibly(this.cameraThreadHandler, () -> {
            if (this.currentSession != null) {
                result.set(this.currentSession.isCameraZoomSupported());
            }
        });
        return result.get();
    }

    @Override
    public int setCameraZoomRatio(float zoom_val) {
        AtomicInteger result = new AtomicInteger(1);
        ThreadUtils.invokeAtFrontUninterruptibly(this.cameraThreadHandler, () -> {
            if (this.currentSession != null) {
                this.currentSession.setCameraZoomRatio(zoom_val);
                result.set(0);
            }
        });
        return result.get();
    }

    @Override
    public float getCameraZoomMaxRatio() {
        AtomicReference<Float> result = new AtomicReference<Float>(Float.valueOf(1.0f));
        ThreadUtils.invokeAtFrontUninterruptibly(this.cameraThreadHandler, () -> {
            if (this.currentSession != null) {
                result.set(Float.valueOf(this.currentSession.getCameraZoomMaxRatio()));
            }
        });
        return result.get().floatValue();
    }

    public CameraCapturer(String cameraName, @Nullable CameraVideoCapturer.CameraEventsHandler eventsHandler, CameraEnumerator cameraEnumerator) {
        if (eventsHandler == null) {
            eventsHandler = new CameraVideoCapturer.CameraEventsHandler(){

                @Override
                public void onCameraError(String errorDescription) {
                    RXLogging.e(CameraCapturer.TAG, "CameraEventsHandler onCameraError: " + errorDescription);
                }

                @Override
                public void onCameraDisconnected() {
                    RXLogging.e(CameraCapturer.TAG, "CameraEventsHandler onCameraDisconnected");
                }

                @Override
                public void onCameraFreezed(String errorDescription) {
                    RXLogging.e(CameraCapturer.TAG, "CameraEventsHandler onCameraFreezed: " + errorDescription);
                }

                @Override
                public void onCameraOpening(String cameraName) {
                    RXLogging.w(CameraCapturer.TAG, "CameraEventsHandler onCameraOpening" + cameraName);
                }

                @Override
                public void onFirstFrameAvailable() {
                    RXLogging.w(CameraCapturer.TAG, "CameraEventsHandler onFirstFrameAvailable");
                }

                @Override
                public void onCameraClosed() {
                    RXLogging.w(CameraCapturer.TAG, "CameraEventsHandler onCameraClosed");
                }

                @Override
                public void onCameraConfig(int width, int height, CameraEnumerationAndroid.CaptureFormat.FramerateRange framerateRange) {
                    RXLogging.w(CameraCapturer.TAG, "CameraEventsHandler onCameraClosed");
                }
            };
        }
        this.eventsHandler = eventsHandler;
        this.cameraEnumerator = cameraEnumerator;
        this.cameraName = cameraName;
        this.uiThreadHandler = new Handler(Looper.getMainLooper());
        String[] deviceNames = cameraEnumerator.getDeviceNames();
        if (deviceNames.length == 0) {
            throw new RuntimeException("No cameras attached.");
        }
        if (!Arrays.asList(deviceNames).contains(this.cameraName)) {
            throw new IllegalArgumentException("Camera name " + this.cameraName + " does not match any known camera device.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initialize(@Nullable SurfaceTextureHelper surfaceTextureHelper, Context applicationContext, CapturerObserver capturerObserver) {
        this.applicationContext = applicationContext;
        Object object = this.stateLock;
        synchronized (object) {
            this.capturerObserver = capturerObserver;
        }
        this.surfaceHelper = surfaceTextureHelper;
        this.cameraThreadHandler = surfaceTextureHelper == null ? null : surfaceTextureHelper.getHandler();
    }

    @Override
    public void startCapture(int width, int height, int framerate, int min_framerate) {
        this.startCapture(width, height, framerate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startCapture(int width, int height, int framerate) {
        RXLogging.w(TAG, "startCapture: " + width + "x" + height + "@" + framerate);
        if (this.applicationContext == null) {
            throw new RuntimeException("CameraCapturer must be initialized before calling startCapture.");
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.sessionOpening || this.currentSession != null) {
                RXLogging.w(TAG, "Session already open");
                return;
            }
            this.width = width;
            this.height = height;
            this.framerate = framerate;
            this.sessionOpening = true;
            this.openAttemptsRemaining = 3;
            this.createSessionInternal(0);
        }
    }

    private void createSessionInternal(int delayMs) {
        this.uiThreadHandler.postDelayed(this.openCameraTimeoutRunnable, (long)(delayMs + 10000));
        if (this.cameraThreadHandler == null) {
            return;
        }
        this.cameraThreadHandler.postDelayed(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block5: {
                    try {
                        Object object = CameraCapturer.this.stateLock;
                        synchronized (object) {
                            CameraCapturer.this.createCameraSession(CameraCapturer.this.createSessionCallback, CameraCapturer.this.cameraSessionEventsHandler, CameraCapturer.this.applicationContext, CameraCapturer.this.surfaceHelper, CameraCapturer.this.cameraName, CameraCapturer.this.width, CameraCapturer.this.height, CameraCapturer.this.framerate);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        if (CameraCapturer.this.capturerObserver == null) break block5;
                        CameraCapturer.this.capturerObserver.onCapturerError("Create VideoCapture Session fail : " + e.getMessage());
                    }
                }
            }
        }, (long)delayMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopCapture() {
        RXLogging.w(TAG, "Stop capture");
        Object object = this.stateLock;
        synchronized (object) {
            while (this.sessionOpening) {
                RXLogging.w(TAG, "Stop capture: Waiting for session to open");
                try {
                    this.stateLock.wait();
                }
                catch (InterruptedException e) {
                    RXLogging.e(TAG, "Stop capture interrupted while waiting for the session to open.");
                    Thread.currentThread().interrupt();
                    return;
                }
            }
            if (this.currentSession != null) {
                RXLogging.w(TAG, "Stop capture: Nulling session");
                if (this.cameraStatistics != null) {
                    this.cameraStatistics.release();
                    this.cameraStatistics = null;
                }
                final CameraSession oldSession = this.currentSession;
                this.cameraThreadHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        oldSession.stop();
                    }
                });
                this.currentSession = null;
                this.capturerObserver.onCapturerStopped();
            } else {
                RXLogging.w(TAG, "Stop capture: No session open");
            }
        }
        RXLogging.w(TAG, "Stop capture done");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void changeCaptureFormat(int width, int height, int framerate) {
        RXLogging.w(TAG, "changeCaptureFormat: " + width + "x" + height + "@" + framerate);
        Object object = this.stateLock;
        synchronized (object) {
            this.stopCapture();
            this.startCapture(width, height, framerate);
        }
    }

    @Override
    public void dispose() {
        RXLogging.w(TAG, "dispose");
        this.stopCapture();
    }

    @Override
    public void switchCamera(final CameraVideoCapturer.CameraSwitchHandler switchEventsHandler) {
        RXLogging.w(TAG, "switchCamera");
        if (this.cameraThreadHandler != null) {
            this.cameraThreadHandler.post(new Runnable(){

                @Override
                public void run() {
                    CameraCapturer.this.switchCameraInternal(switchEventsHandler);
                }
            });
        }
    }

    @Override
    public boolean isScreencast() {
        return false;
    }

    public void printStackTrace() {
        StackTraceElement[] cameraStackTrace;
        Thread cameraThread = null;
        if (this.cameraThreadHandler != null) {
            cameraThread = this.cameraThreadHandler.getLooper().getThread();
        }
        if (cameraThread != null && (cameraStackTrace = cameraThread.getStackTrace()).length > 0) {
            RXLogging.w(TAG, "CameraCapturer stack trace:");
            for (StackTraceElement traceElem : cameraStackTrace) {
                RXLogging.w(TAG, traceElem.toString());
            }
        }
    }

    @Override
    public int enableFollowGravity(boolean enable) {
        AtomicInteger result = new AtomicInteger(0);
        ThreadUtils.invokeAtFrontUninterruptibly(this.cameraThreadHandler, () -> {
            if (this.currentSession != null) {
                int ret = this.currentSession.enableFollowGravity(enable);
                result.set(ret);
            }
        });
        int ret = result.get();
        if (ret == 0) {
            this.mEnableFollowGravity = enable;
        }
        return ret;
    }

    @Override
    public int getDeviceOrientation() {
        AtomicInteger result = new AtomicInteger(0);
        ThreadUtils.invokeAtFrontUninterruptibly(this.cameraThreadHandler, () -> {
            if (this.currentSession != null) {
                int ret = this.currentSession.getDeviceOrientation();
                result.set(ret);
            }
        });
        return result.get();
    }

    private void reportCameraSwitchError(String error, @Nullable CameraVideoCapturer.CameraSwitchHandler switchEventsHandler) {
        RXLogging.e(TAG, error);
        if (switchEventsHandler != null) {
            switchEventsHandler.onCameraSwitchError(error);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchCameraInternal(@Nullable CameraVideoCapturer.CameraSwitchHandler switchEventsHandler) {
        RXLogging.w(TAG, "switchCamera internal");
        String[] deviceNames = this.cameraEnumerator.getDeviceNames();
        if (deviceNames.length < 2) {
            if (switchEventsHandler != null) {
                switchEventsHandler.onCameraSwitchError("No camera to switch to.");
            }
            return;
        }
        Object object = this.stateLock;
        synchronized (object) {
            if (this.switchState != SwitchState.IDLE) {
                this.reportCameraSwitchError("Camera switch already in progress.", switchEventsHandler);
                return;
            }
            if (!this.sessionOpening && this.currentSession == null) {
                this.reportCameraSwitchError("switchCamera: camera is not running.", switchEventsHandler);
                return;
            }
            this.switchEventsHandler = switchEventsHandler;
            if (this.sessionOpening) {
                this.switchState = SwitchState.PENDING;
                return;
            }
            this.switchState = SwitchState.IN_PROGRESS;
            RXLogging.w(TAG, "switchCamera: Stopping session");
            if (this.cameraStatistics != null) {
                this.cameraStatistics.release();
                this.cameraStatistics = null;
            }
            final CameraSession oldSession = this.currentSession;
            if (this.cameraThreadHandler != null) {
                this.cameraThreadHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        oldSession.stop();
                    }
                });
            }
            this.currentSession = null;
            int cameraNameIndex = Arrays.asList(deviceNames).indexOf(this.cameraName);
            this.cameraName = deviceNames[(cameraNameIndex + 1) % deviceNames.length];
            this.sessionOpening = true;
            this.openAttemptsRemaining = 1;
            this.createSessionInternal(0);
        }
        RXLogging.w(TAG, "switchCamera done");
    }

    private void checkIsOnCameraThread() {
        if (this.cameraThreadHandler == null || Thread.currentThread() != this.cameraThreadHandler.getLooper().getThread()) {
            RXLogging.e(TAG, "Check is on camera thread failed.");
            throw new RuntimeException("Not on camera thread.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCameraName() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.cameraName;
        }
    }

    protected abstract void createCameraSession(CameraSession.CreateSessionCallback var1, CameraSession.Events var2, Context var3, SurfaceTextureHelper var4, String var5, int var6, int var7, int var8);

    static enum SwitchState {
        IDLE,
        PENDING,
        IN_PROGRESS;

    }
}

