/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.annotation.TargetApi;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.opengl.GLES20;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.Surface;
import com.bytedance.realx.RXVideoSurfaceController;
import com.bytedance.realx.base.RXLogging;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.webrtc.EglBase;
import org.webrtc.EglBase14;
import org.webrtc.EncodedImage;
import org.webrtc.GlRectDrawer;
import org.webrtc.GlUtil;
import org.webrtc.MediaCodecWrapper;
import org.webrtc.MediaCodecWrapperFactory;
import org.webrtc.RXVideoCodecDesc;
import org.webrtc.RXVideoCodecProfile;
import org.webrtc.RXVideoCodecStandard;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoCodecStatus;
import org.webrtc.VideoEncoder;
import org.webrtc.VideoFrame;
import org.webrtc.VideoFrameDrawer;
import org.webrtc.YuvHelper;

@TargetApi(value=21)
class HardwareVideoEncoder
implements VideoEncoder {
    private static final String TAG = "HardwareVideoEncoder";
    private static final int MAX_VIDEO_FRAMERATE = 60;
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int DEQUEUE_OUTPUT_BUFFER_TIMEOUT_US = 100000;
    private final MediaCodecWrapperFactory mediaCodecWrapperFactory;
    private final String codecName;
    private final RXVideoCodecDesc codecDesc;
    private final Integer surfaceColorFormat;
    private final Integer yuvColorFormat;
    private final YuvFormat yuvFormat;
    private final int keyFrameIntervalSec;
    private final long forcedKeyFrameNs;
    private EglBase14.Context sharedContext;
    private final GlRectDrawer textureDrawer = new GlRectDrawer();
    private final VideoFrameDrawer videoFrameDrawer = new VideoFrameDrawer();
    private final ThreadUtils.ThreadChecker encodeThreadChecker = new ThreadUtils.ThreadChecker();
    private final ThreadUtils.ThreadChecker outputThreadChecker = new ThreadUtils.ThreadChecker();
    private VideoEncoder.Callback callback;
    private boolean automaticResizeOn;
    @Nullable
    private MediaCodecWrapper codec;
    @Nullable
    private Thread outputThread;
    @Nullable
    private EglBase14 textureEglBase;
    @Nullable
    private Surface textureInputSurface;
    private int width;
    private int height;
    private VideoEncoder.ScaleMode scaleMode;
    private VideoEncoder.BitrateMode bitrateMode;
    private boolean useSurfaceMode;
    private long lastKeyFrameNs;
    @Nullable
    private ByteBuffer configBuffer;
    private int adjustedBitrate;
    private volatile boolean running;
    @Nullable
    private volatile Exception shutdownException;
    private VideoEncoder.Settings settings;

    public HardwareVideoEncoder(MediaCodecWrapperFactory mediaCodecWrapperFactory, String codecName, RXVideoCodecDesc codecDesc, Integer surfaceColorFormat, Integer yuvColorFormat, int keyFrameIntervalSec, int forceKeyFrameIntervalMs, EglBase14.Context sharedContext) {
        this.mediaCodecWrapperFactory = mediaCodecWrapperFactory;
        this.codecName = codecName;
        this.codecDesc = codecDesc;
        this.surfaceColorFormat = surfaceColorFormat;
        this.yuvColorFormat = yuvColorFormat;
        this.yuvFormat = YuvFormat.valueOf(yuvColorFormat);
        this.keyFrameIntervalSec = keyFrameIntervalSec;
        this.forcedKeyFrameNs = TimeUnit.MILLISECONDS.toNanos(forceKeyFrameIntervalMs);
        this.sharedContext = sharedContext;
        this.encodeThreadChecker.detachThread();
    }

    @Override
    public VideoCodecStatus initEncode(VideoEncoder.Settings settings, VideoEncoder.Callback callback) {
        this.encodeThreadChecker.checkIsOnValidThread();
        this.callback = callback;
        this.automaticResizeOn = true;
        this.width = settings.width;
        this.height = settings.height;
        this.scaleMode = settings.scaleMode;
        this.bitrateMode = settings.bitrateMode;
        if (RXVideoSurfaceController.getInstance().usePassSurfaceMode()) {
            RXLogging.e(TAG, "using pass surface mode");
            this.useSurfaceMode = true;
        } else {
            this.useSurfaceMode = this.canUseSurface();
        }
        this.settings = settings;
        RXLogging.i(TAG, "initEncode, codec name:" + this.codecName + ", with resolution:" + this.width + " x " + this.height + ". @ " + settings.targetBps + "kbps. Fps: " + settings.targetFps + " Use surface mode: " + this.useSurfaceMode + " settings.bitrateMode:" + (Object)((Object)settings.bitrateMode) + " qp_min:" + settings.minQp + " qp_max:" + settings.maxQp);
        return this.initEncodeInternal();
    }

    private VideoCodecStatus initEncodeInternal() {
        this.encodeThreadChecker.checkIsOnValidThread();
        this.lastKeyFrameNs = -1L;
        try {
            this.codec = this.mediaCodecWrapperFactory.createByCodecName(this.codecName);
        }
        catch (Exception e) {
            RXLogging.e(TAG, "Cannot create media encoder " + this.codecName, e);
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        int colorFormat = this.useSurfaceMode ? this.surfaceColorFormat : this.yuvColorFormat;
        try {
            RXVideoCodecStandard standard = this.codecDesc.getStandard();
            MediaFormat format = MediaFormat.createVideoFormat((String)standard.mimeType(), (int)this.width, (int)this.height);
            format.setInteger("bitrate", this.settings.targetBps);
            if (VideoEncoder.BitrateMode.CBR == this.settings.bitrateMode) {
                format.setInteger("bitrate-mode", 2);
            } else {
                format.setInteger("bitrate-mode", 1);
            }
            format.setInteger("color-format", colorFormat);
            format.setInteger("frame-rate", this.settings.targetFps);
            format.setInteger("i-frame-interval", this.keyFrameIntervalSec);
            format.setInteger("max-bframes", 0);
            if (this.settings.rangeId == 1) {
                format.setInteger("color-range", 1);
            } else {
                format.setInteger("color-range", 2);
            }
            format.setInteger("color-standard", 4);
            format.setInteger("color-transfer", 3);
            if (standard == RXVideoCodecStandard.H264) {
                RXVideoCodecProfile profile = this.codecDesc.getProfile();
                switch (profile) {
                    case ProfileHigh: 
                    case ProfileConstrainedHigh: {
                        RXLogging.w(TAG, "setting high profile ");
                        format.setInteger("profile", 8);
                        format.setInteger("level", 256);
                        break;
                    }
                    case ProfileBaseline: 
                    case ProfileConstrainedBaseline: 
                    case ProfileMain: {
                        RXLogging.w(TAG, "setting baseline profile ");
                        format.setInteger("profile", 1);
                        format.setInteger("level", 256);
                        break;
                    }
                    default: {
                        RXLogging.w(TAG, "Unknown profile level id: " + (Object)((Object)profile) + "default to baseline profile");
                        format.setInteger("profile", 1);
                        format.setInteger("level", 256);
                        break;
                    }
                }
            } else if (standard == RXVideoCodecStandard.ByteVC1) {
                RXVideoCodecProfile profile = this.codecDesc.getProfile();
                switch (profile) {
                    case ByteVC1ProfileMain: {
                        format.setInteger("profile", 1);
                        format.setInteger("level", 8);
                        break;
                    }
                    case ByteVC1ProfileMain10: {
                        format.setInteger("profile", 2);
                        format.setInteger("level", 8);
                        break;
                    }
                    case ByteVC1ProfileMain10HDR10: {
                        format.setInteger("profile", 4096);
                        format.setInteger("level", 8);
                        break;
                    }
                    default: {
                        RXLogging.w(TAG, "Unknown profile level id: " + (Object)((Object)profile) + "default to Main profile");
                        format.setInteger("profile", 1);
                        format.setInteger("level", 8);
                        break;
                    }
                }
            } else if (standard == RXVideoCodecStandard.VP8) {
                format.setInteger("profile", 1);
            }
            if (standard != RXVideoCodecStandard.VP8) {
                RXLogging.w(TAG, "maxqp:" + this.settings.maxQp + " minqp:" + this.settings.minQp);
                format.setInteger("vendor.qti-ext-enc-qp-range.qp-i-min", this.settings.minQp);
                format.setInteger("vendor.qti-ext-enc-qp-range.qp-i-max", this.settings.maxQp);
                format.setInteger("vendor.qti-ext-enc-qp-range.qp-p-min", this.settings.minQp);
                format.setInteger("vendor.qti-ext-enc-qp-range.qp-p-max", this.settings.maxQp);
                format.setInteger("vendor.rtc-ext-enc-qp-range.qp-i-min", this.settings.minQp);
                format.setInteger("vendor.rtc-ext-enc-qp-range.qp-i-max", this.settings.maxQp);
                format.setInteger("vendor.rtc-ext-enc-qp-range.qp-p-min", this.settings.minQp);
                format.setInteger("vendor.rtc-ext-enc-qp-range.qp-p-max", this.settings.maxQp);
                format.setInteger("vendor.rtc-ext-enc-low-latency.enable", 1);
            }
            if (this.settings.temporalLayerNum > 1) {
                format.setString("ts-schema", "android.generic." + this.settings.temporalLayerNum);
            }
            RXLogging.w(TAG, "Format: " + format);
            this.codec.configure(format, null, null, 1);
            if (RXVideoSurfaceController.getInstance().usePassSurfaceMode()) {
                this.textureInputSurface = this.codec.createInputSurface();
                RXVideoSurfaceController.getInstance().setSurface(this.textureInputSurface);
            } else if (this.useSurfaceMode) {
                this.textureInputSurface = this.codec.createInputSurface();
                this.sharedContext = new EglBase14.Context(EGL14.EGL_NO_CONTEXT);
                this.textureEglBase = new EglBase14(null, EglBase.CONFIG_RECORDABLE);
                this.textureEglBase.createSurface(this.textureInputSurface);
                this.textureEglBase.makeCurrent();
            }
            this.codec.start();
        }
        catch (Exception e) {
            RXLogging.e(TAG, "initEncodeInternal failed", e);
            this.release();
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        this.running = true;
        this.outputThreadChecker.detachThread();
        this.outputThread = this.createOutputThread();
        this.outputThread.start();
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoCodecStatus release() {
        VideoCodecStatus returnValue;
        this.encodeThreadChecker.checkIsOnValidThread();
        if (this.outputThread == null) {
            returnValue = VideoCodecStatus.OK;
        } else {
            this.running = false;
            if (!ThreadUtils.joinUninterruptibly(this.outputThread, 5000L)) {
                RXLogging.e(TAG, "Media encoder release timeout");
                returnValue = VideoCodecStatus.TIMEOUT;
            } else if (this.shutdownException != null) {
                RXLogging.e(TAG, "Media encoder release exception", this.shutdownException);
                returnValue = VideoCodecStatus.ERROR;
            } else {
                returnValue = VideoCodecStatus.OK;
            }
        }
        this.textureDrawer.release();
        this.videoFrameDrawer.release();
        if (this.textureEglBase != null) {
            this.textureEglBase.release();
            this.textureEglBase = null;
        }
        if (this.textureInputSurface != null) {
            this.textureInputSurface.release();
            this.textureInputSurface = null;
        }
        this.codec = null;
        this.outputThread = null;
        this.encodeThreadChecker.detachThread();
        return returnValue;
    }

    @Override
    public VideoCodecStatus requestKeyFrame() {
        long current_time = System.currentTimeMillis();
        this.requestKeyFrame(current_time);
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoCodecStatus encode(VideoFrame videoFrame, boolean keyFrameRequested) {
        VideoCodecStatus returnValue;
        VideoFrame.TextureBuffer textureBuffer;
        EGLContext eglContext;
        EglBase14.Context newSharedContext;
        this.encodeThreadChecker.checkIsOnValidThread();
        GlUtil.clearGLES2Error(TAG);
        if (this.codec == null) {
            return VideoCodecStatus.UNINITIALIZED;
        }
        VideoFrame.Buffer originVideoFrameBuffer = videoFrame.getBuffer();
        boolean isTextureBuffer = originVideoFrameBuffer instanceof VideoFrame.TextureBuffer;
        int frameWidth = videoFrame.getBuffer().getWidth();
        int frameHeight = videoFrame.getBuffer().getHeight();
        boolean shouldUseSurfaceMode = this.canUseSurface() && isTextureBuffer;
        boolean isEglEnvChanged = false;
        if (shouldUseSurfaceMode && (newSharedContext = new EglBase14.Context(eglContext = (textureBuffer = (VideoFrame.TextureBuffer)originVideoFrameBuffer).getEglContext())).getNativeEglContext() != this.sharedContext.getNativeEglContext()) {
            isEglEnvChanged = true;
            this.sharedContext = newSharedContext;
        }
        if (shouldUseSurfaceMode != this.useSurfaceMode) {
            VideoCodecStatus status = this.resetCodec(frameWidth, frameHeight, shouldUseSurfaceMode);
            isEglEnvChanged = false;
            if (status != VideoCodecStatus.OK) {
                return status;
            }
        }
        if (isEglEnvChanged && this.useSurfaceMode && !RXVideoSurfaceController.getInstance().usePassSurfaceMode()) {
            this.textureDrawer.release();
            this.videoFrameDrawer.release();
            if (this.textureEglBase != null) {
                this.textureEglBase.release();
                this.textureEglBase = null;
            }
            this.textureEglBase = new EglBase14(this.sharedContext, EglBase.CONFIG_RECORDABLE);
            this.textureEglBase.createSurface(this.textureInputSurface);
            this.textureEglBase.makeCurrent();
        }
        VideoFrame.Buffer videoFrameBuffer = originVideoFrameBuffer;
        if (keyFrameRequested) {
            RXLogging.i(TAG, "Request key frame");
        }
        if (keyFrameRequested || this.shouldForceKeyFrame(videoFrame.getTimestampNs())) {
            this.requestKeyFrame(videoFrame.getTimestampNs());
        }
        int bufferSize = videoFrameBuffer.getHeight() * videoFrameBuffer.getWidth() * 3 / 2;
        if (this.useSurfaceMode) {
            this.textureEglBase.makeCurrent();
            returnValue = this.encodeTextureBuffer(videoFrame);
        } else {
            returnValue = this.encodeByteBuffer(videoFrame, videoFrameBuffer, bufferSize);
        }
        return returnValue;
    }

    private VideoCodecStatus encodeTextureBuffer(VideoFrame videoFrame) {
        this.encodeThreadChecker.checkIsOnValidThread();
        try {
            GLES20.glClear((int)16384);
            VideoFrame derotatedFrame = new VideoFrame(videoFrame.getBuffer(), 0, videoFrame.getTimestampNs());
            this.videoFrameDrawer.drawFrame(derotatedFrame, this.textureDrawer, null);
            this.textureEglBase.swapBuffers(videoFrame.getTimestampNs());
        }
        catch (Exception e) {
            RXLogging.e(TAG, "encodeTexture failed", e);
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        return VideoCodecStatus.OK;
    }

    private VideoCodecStatus encodeByteBuffer(VideoFrame videoFrame, VideoFrame.Buffer videoFrameBuffer, int bufferSize) {
        ByteBuffer buffer;
        int index;
        this.encodeThreadChecker.checkIsOnValidThread();
        long presentationTimestampUs = videoFrame.getTimestampNs() / 1000L;
        try {
            index = this.codec.dequeueInputBuffer(0L);
        }
        catch (Exception e) {
            RXLogging.e(TAG, "dequeueInputBuffer failed", e);
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        if (index == -1) {
            RXLogging.i(TAG, "Dropped frame, no input buffers available");
            return VideoCodecStatus.NO_OUTPUT;
        }
        try {
            buffer = this.codec.getInputBuffers()[index];
        }
        catch (Exception e) {
            RXLogging.e(TAG, "getInputBuffers failed", e);
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        this.fillInputBuffer(buffer, videoFrameBuffer);
        try {
            this.codec.queueInputBuffer(index, 0, bufferSize, presentationTimestampUs, 0);
        }
        catch (Exception e) {
            RXLogging.e(TAG, "queueInputBuffer failed", e);
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        return VideoCodecStatus.OK;
    }

    @Override
    public VideoCodecStatus setRateAllocation(int bitrateBitps, int framerate) {
        this.encodeThreadChecker.checkIsOnValidThread();
        if (framerate > 60) {
            framerate = 60;
        }
        this.updateBitrate(bitrateBitps);
        return VideoCodecStatus.OK;
    }

    public VideoEncoder.ScalingSettings getScalingSettings() {
        this.encodeThreadChecker.checkIsOnValidThread();
        if (this.automaticResizeOn) {
            if (this.codecDesc.getStandard() == RXVideoCodecStandard.VP8) {
                int kLowVp8QpThreshold = 29;
                int kHighVp8QpThreshold = 95;
                return new VideoEncoder.ScalingSettings(29, 95);
            }
            if (this.codecDesc.getStandard() == RXVideoCodecStandard.VP8) {
                int kLowH264QpThreshold = 24;
                int kHighH264QpThreshold = 37;
                return new VideoEncoder.ScalingSettings(24, 37);
            }
        }
        return VideoEncoder.ScalingSettings.OFF;
    }

    private VideoCodecStatus resetCodec(int newWidth, int newHeight, boolean newUseSurfaceMode) {
        this.encodeThreadChecker.checkIsOnValidThread();
        VideoCodecStatus status = this.release();
        if (status != VideoCodecStatus.OK) {
            return status;
        }
        this.width = newWidth;
        this.height = newHeight;
        this.useSurfaceMode = newUseSurfaceMode;
        return this.initEncodeInternal();
    }

    private boolean shouldForceKeyFrame(long presentationTimestampNs) {
        this.encodeThreadChecker.checkIsOnValidThread();
        return this.forcedKeyFrameNs > 0L && presentationTimestampNs > this.lastKeyFrameNs + this.forcedKeyFrameNs;
    }

    private void requestKeyFrame(long presentationTimestampNs) {
        this.encodeThreadChecker.checkIsOnValidThread();
        try {
            Bundle b = new Bundle();
            b.putInt("request-sync", 0);
            this.codec.setParameters(b);
        }
        catch (Exception e) {
            RXLogging.e(TAG, "requestKeyFrame failed", e);
            return;
        }
        this.lastKeyFrameNs = presentationTimestampNs;
    }

    private Thread createOutputThread() {
        return new Thread("video_encoded_thread"){

            @Override
            public void run() {
                while (HardwareVideoEncoder.this.running) {
                    HardwareVideoEncoder.this.deliverEncodedImage();
                }
                HardwareVideoEncoder.this.releaseCodecOnOutputThread();
            }
        };
    }

    protected void deliverEncodedImage() {
        block12: {
            this.outputThreadChecker.checkIsOnValidThread();
            long start_time = System.currentTimeMillis();
            try {
                MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
                int index = this.codec.dequeueOutputBuffer(info, 100000L);
                if (index == -2) {
                    MediaFormat format = this.codec.getOutputFormat();
                    RXLogging.i(TAG, "output format changed: " + format.toString());
                    return;
                }
                if (index == -1) {
                    return;
                }
                if (index != -3 && index < 0) {
                    RXLogging.e(TAG, "should not be here: index:" + index);
                    return;
                }
                ByteBuffer codecOutputBuffer = this.codec.getOutputBuffers()[index];
                codecOutputBuffer.position(info.offset);
                codecOutputBuffer.limit(info.offset + info.size);
                if ((info.flags & 2) != 0) {
                    RXLogging.i(TAG, "Config frame generated. Offset: " + info.offset + ". Size: " + info.size);
                    this.configBuffer = ByteBuffer.allocateDirect(info.size);
                    this.configBuffer.put(codecOutputBuffer);
                } else {
                    ByteBuffer frameBuffer;
                    boolean isKeyFrame;
                    boolean bl = isKeyFrame = (info.flags & 1) != 0;
                    if (isKeyFrame) {
                        RXLogging.i(TAG, "Sync frame generated");
                    }
                    if (isKeyFrame && (this.codecDesc.getStandard() == RXVideoCodecStandard.H264 || this.codecDesc.getStandard() == RXVideoCodecStandard.ByteVC1)) {
                        RXLogging.i(TAG, "Prepending config frame of size " + this.configBuffer.capacity() + " to output buffer with offset " + info.offset + ", size " + info.size);
                        frameBuffer = ByteBuffer.allocateDirect(info.size + this.configBuffer.capacity());
                        this.configBuffer.rewind();
                        frameBuffer.put(this.configBuffer);
                        frameBuffer.put(codecOutputBuffer);
                        frameBuffer.rewind();
                    } else {
                        frameBuffer = codecOutputBuffer.slice();
                    }
                    EncodedImage.FrameType frameType = isKeyFrame ? EncodedImage.FrameType.VideoFrameKey : EncodedImage.FrameType.VideoFrameDelta;
                    EncodedImage.Builder builder = EncodedImage.builder().setEncodedWidth(this.width).setEncodedHeight(this.height).setCaptureTimeNs(info.presentationTimeUs * 1000L).setBuffer(frameBuffer).setFrameType(frameType);
                    this.callback.onEncodedFrame(builder.createEncodedImage(), new VideoEncoder.CodecSpecificInfo(this.codecDesc.getStandard()));
                }
                this.codec.releaseOutputBuffer(index, false);
            }
            catch (Exception e) {
                long end_time = System.currentTimeMillis();
                if (end_time - start_time >= 100L) break block12;
                RXLogging.e(TAG, "deliverOutput failed", e);
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void releaseCodecOnOutputThread() {
        this.outputThreadChecker.checkIsOnValidThread();
        RXLogging.i(TAG, "Releasing MediaCodec on output thread");
        try {
            this.codec.stop();
        }
        catch (Exception e) {
            RXLogging.e(TAG, "Media encoder stop failed", e);
        }
        try {
            this.codec.release();
        }
        catch (Exception e) {
            RXLogging.e(TAG, "Media encoder release failed", e);
            this.shutdownException = e;
        }
        this.configBuffer = null;
        RXLogging.i(TAG, "Release on output thread done");
    }

    private VideoCodecStatus updateBitrate(int bitrateBitps) {
        this.encodeThreadChecker.checkIsOnValidThread();
        try {
            Bundle params = new Bundle();
            params.putInt("video-bitrate", bitrateBitps);
            this.codec.setParameters(params);
            return VideoCodecStatus.OK;
        }
        catch (Exception e) {
            RXLogging.e(TAG, "updateBitrate failed", e);
            return VideoCodecStatus.ERROR;
        }
    }

    private boolean canUseSurface() {
        return this.sharedContext != null && this.surfaceColorFormat != null;
    }

    protected void fillInputBuffer(ByteBuffer buffer, VideoFrame.Buffer videoFrameBuffer) {
        this.yuvFormat.fillBuffer(buffer, videoFrameBuffer);
    }

    private static enum YuvFormat {
        I420{

            @Override
            void fillBuffer(ByteBuffer dstBuffer, VideoFrame.Buffer srcBuffer) {
                if (srcBuffer == null) {
                    return;
                }
                VideoFrame.I420Buffer i420 = srcBuffer.toI420();
                if (i420 == null) {
                    return;
                }
                YuvHelper.I420Copy(i420.getDataY(), i420.getStrideY(), i420.getDataU(), i420.getStrideU(), i420.getDataV(), i420.getStrideV(), dstBuffer, i420.getWidth(), i420.getHeight());
                i420.release();
            }
        }
        ,
        NV12{

            @Override
            void fillBuffer(ByteBuffer dstBuffer, VideoFrame.Buffer srcBuffer) {
                if (srcBuffer == null) {
                    return;
                }
                if (srcBuffer instanceof VideoFrame.NV12Buffer) {
                    VideoFrame.NV12Buffer nv12Buffer = srcBuffer.toNV12();
                    YuvHelper.NV12Copy(nv12Buffer.getDataY(), nv12Buffer.getStrideY(), nv12Buffer.getDataUV(), nv12Buffer.getStrideUV(), dstBuffer, nv12Buffer.getWidth(), nv12Buffer.getHeight());
                    nv12Buffer.release();
                } else {
                    VideoFrame.I420Buffer i420 = srcBuffer.toI420();
                    if (i420 == null) {
                        return;
                    }
                    YuvHelper.I420ToNV12(i420.getDataY(), i420.getStrideY(), i420.getDataU(), i420.getStrideU(), i420.getDataV(), i420.getStrideV(), dstBuffer, i420.getWidth(), i420.getHeight());
                    i420.release();
                }
            }
        };


        abstract void fillBuffer(ByteBuffer var1, VideoFrame.Buffer var2);

        static YuvFormat valueOf(int colorFormat) {
            switch (colorFormat) {
                case 19: {
                    return I420;
                }
                case 21: 
                case 2141391872: 
                case 2141391876: {
                    return NV12;
                }
            }
            throw new IllegalArgumentException("Unsupported colorFormat: " + colorFormat);
        }
    }
}

