/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.support.annotation.Nullable;
import java.util.ArrayList;
import org.webrtc.AndroidVideoDecoder;
import org.webrtc.CalledByNative;
import org.webrtc.EglBase;
import org.webrtc.Logging;
import org.webrtc.MediaCodecUtils;
import org.webrtc.MediaCodecWrapperFactoryImpl;
import org.webrtc.RXVideoCodecDesc;
import org.webrtc.RXVideoCodecProfile;
import org.webrtc.RXVideoCodecStandard;
import org.webrtc.VideoDecoder;

class MediaCodecVideoDecoderFactory {
    private static final String TAG = "MediaCodecVideoDecoderFactory";
    @Nullable
    private EglBase.Context sharedContext;

    @CalledByNative
    public MediaCodecVideoDecoderFactory(@Nullable EglBase.Context sharedContext) {
        this.sharedContext = sharedContext;
    }

    @CalledByNative
    public void setHardwareContext(EglBase.Context sharedContext) {
        this.sharedContext = sharedContext;
    }

    @CalledByNative
    public void enableEglLock(boolean enable) {
        Logging.e(TAG, "MediaCodecVideoDecoderFactory enableEglLock:" + enable);
        EglBase.EglLock.enableEglLock = enable;
    }

    @Nullable
    @CalledByNative
    public VideoDecoder createDecoder(RXVideoCodecDesc codecDesc) {
        RXVideoCodecStandard standard = codecDesc.getStandard();
        MediaCodecInfo info = this.findCodecForType(standard);
        if (info == null) {
            return null;
        }
        String mime = standard.mimeType();
        MediaCodecInfo.CodecCapabilities capabilities = info.getCapabilitiesForType(mime);
        return new AndroidVideoDecoder(new MediaCodecWrapperFactoryImpl(), info.getName(), standard, MediaCodecUtils.selectColorFormat(MediaCodecUtils.DECODER_COLOR_FORMATS, capabilities), this.sharedContext);
    }

    @CalledByNative
    public RXVideoCodecDesc[] getSupportedCodecs() {
        ArrayList<RXVideoCodecDesc> supportedCodecInfos = new ArrayList<RXVideoCodecDesc>();
        RXVideoCodecStandard standard = RXVideoCodecStandard.H264;
        MediaCodecInfo codec = this.findCodecForType(standard);
        if (codec != null) {
            if (this.isH264HighProfileSupported(codec, standard)) {
                supportedCodecInfos.add(new RXVideoCodecDesc(standard, RXVideoCodecProfile.ProfileHigh));
            }
            supportedCodecInfos.add(new RXVideoCodecDesc(standard, RXVideoCodecProfile.ProfileBaseline));
        }
        return supportedCodecInfos.toArray(new RXVideoCodecDesc[supportedCodecInfos.size()]);
    }

    @Nullable
    private MediaCodecInfo findCodecForType(RXVideoCodecStandard type) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        for (int i = 0; i < MediaCodecList.getCodecCount(); ++i) {
            MediaCodecInfo info = null;
            try {
                info = MediaCodecList.getCodecInfoAt((int)i);
            }
            catch (IllegalArgumentException e) {
                Logging.e(TAG, "Cannot retrieve decoder codec info", e);
            }
            if (info == null || info.isEncoder() || !this.isSupportedCodec(info, type)) continue;
            return info;
        }
        return null;
    }

    private boolean isSupportedCodec(MediaCodecInfo info, RXVideoCodecStandard type) {
        String name = info.getName();
        if (!MediaCodecUtils.codecSupportsType(info, type)) {
            return false;
        }
        return MediaCodecUtils.selectColorFormat(MediaCodecUtils.DECODER_COLOR_FORMATS, info.getCapabilitiesForType(type.mimeType())) != null;
    }

    private boolean isH264HighProfileSupported(MediaCodecInfo info, RXVideoCodecStandard type) {
        String name = info.getName();
        if (Build.VERSION.SDK_INT >= 21 && name.startsWith("OMX.qcom.")) {
            return true;
        }
        if (Build.VERSION.SDK_INT >= 23 && name.startsWith("OMX.Exynos.")) {
            return true;
        }
        MediaCodecInfo.CodecCapabilities cap = info.getCapabilitiesForType(type.mimeType());
        for (int i = 0; i < cap.profileLevels.length; ++i) {
            if (8 != cap.profileLevels[i].profile) continue;
            return true;
        }
        return false;
    }
}

