/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import org.webrtc.CalledByNative;
import org.webrtc.CapturerObserver;
import org.webrtc.VideoFrame;

class NativeCapturerObserver
implements CapturerObserver {
    private final long nativeSource;

    @CalledByNative
    public NativeCapturerObserver(long nativeSource) {
        this.nativeSource = nativeSource;
    }

    @Override
    public void onCapturerStarted(boolean success) {
        NativeCapturerObserver.nativeCapturerStarted(this.nativeSource, success);
    }

    @Override
    public void onCapturerStopped() {
        NativeCapturerObserver.nativeCapturerStopped(this.nativeSource);
    }

    @Override
    public void onCapturerError(String errorMsg) {
    }

    @Override
    public void onFrameCaptured(VideoFrame frame) {
        NativeCapturerObserver.nativeOnFrameCaptured(this.nativeSource, frame.getBuffer().getWidth(), frame.getBuffer().getHeight(), frame.getRotation(), frame.getTimestampNs(), frame.getBuffer());
    }

    private static native void nativeCapturerStarted(long var0, boolean var2);

    private static native void nativeCapturerStopped(long var0);

    private static native void nativeOnFrameCaptured(long var0, int var2, int var3, int var4, long var5, VideoFrame.Buffer var7);
}

