/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.app.ActivityManager;
import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.BatteryManager;
import android.os.Build;
import android.os.Debug;
import android.os.PowerManager;
import android.os.Process;
import android.provider.Settings;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import org.webrtc.CalledByNative;
import org.webrtc.ContextUtils;

public class RXPerformanceMonitorAndroid {
    private static final float ERROR_RESULT = 0.0f;
    private static final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            String path = pathname.getName();
            if (path.startsWith("cpu")) {
                for (int i = 3; i < path.length(); ++i) {
                    if (path.charAt(i) >= '0' && path.charAt(i) <= '9') continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };
    private static final FileFilter CPU_IDLE_STATE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            String path = pathname.getName();
            if (path.startsWith("state")) {
                for (int i = 5; i < path.length(); ++i) {
                    if (path.charAt(i) >= '0' && path.charAt(i) <= '9') continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };
    private static BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            if (batteryStatus == null) {
                batteryStatus = new Intent();
            }
            charge_status = intent.getIntExtra("status", -1);
            battery_temperature = batteryStatus.getIntExtra("temperature", -1);
        }
    };
    private static int mCpuCoreCount = -1;
    private static int charge_status = -1;
    private static int battery_temperature = -1;
    private static int mCpuIdleStateCount = -1;
    private static Context context = ContextUtils.getApplicationContext();
    private static BatteryManager batteryManager = (BatteryManager)context.getSystemService("batterymanager");
    private static IntentFilter ifilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
    private static Intent batteryStatus = context.registerReceiver(mBroadcastReceiver, ifilter);
    private static PowerManager powerManager = (PowerManager)context.getSystemService("power");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public static float getCurrentAppCPUTime() {
        block6: {
            float f;
            BufferedReader reader;
            block5: {
                String[] cpuInfos = new String[]{};
                reader = null;
                reader = new BufferedReader(new InputStreamReader(new FileInputStream("/proc/" + Process.myPid() + "/stat")), 1000);
                String load = reader.readLine();
                reader.close();
                if (load != null) {
                    cpuInfos = load.split(" ");
                }
                if (cpuInfos.length <= 17) break block5;
                float f2 = Float.parseFloat(cpuInfos[13]) + Float.parseFloat(cpuInfos[14]) + Float.parseFloat(cpuInfos[15]) + Float.parseFloat(cpuInfos[16]);
                RXPerformanceMonitorAndroid.close(reader);
                return f2;
            }
            try {
                f = 0.0f;
            }
            catch (Exception exception) {
                RXPerformanceMonitorAndroid.close(reader);
                break block6;
            }
            catch (Throwable throwable) {
                RXPerformanceMonitorAndroid.close(reader);
                throw throwable;
            }
            RXPerformanceMonitorAndroid.close(reader);
            return f;
        }
        return 0.0f;
    }

    @CalledByNative
    public static boolean getIfRoomsDevice() {
        return "a3382".equals(Build.MODEL.toLowerCase());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public static long getCurrentTotalCPUTime() {
        File cpuFile = new File("/proc/stat");
        if (!cpuFile.exists()) {
            return 0L;
        }
        try {
            FileInputStream fin;
            block11: {
                fin = new FileInputStream(cpuFile);
                try {
                    long cpuTime;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(fin));
                    String line = reader.readLine();
                    if (line == null || !line.startsWith("cpu")) break block11;
                    String[] cpuInfos = line.split(" ");
                    int startIndex = cpuInfos[0].equals("cpu") ? 2 : 1;
                    long l = cpuTime = Long.parseLong(cpuInfos[startIndex]) + Long.parseLong(cpuInfos[startIndex + 1]) + Long.parseLong(cpuInfos[startIndex + 2]) + Long.parseLong(cpuInfos[startIndex + 3]) + Long.parseLong(cpuInfos[startIndex + 4]) + Long.parseLong(cpuInfos[startIndex + 5]) + Long.parseLong(cpuInfos[startIndex + 6]);
                }
                catch (Throwable throwable) {
                    try {
                        fin.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                fin.close();
            }
            fin.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            return 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public static long getCurrentIdleCPUTime() {
        if ("a3382".equals(Build.MODEL.toLowerCase())) {
            return 0L;
        }
        File cpuFile = new File("/proc/stat");
        if (!cpuFile.exists()) {
            return 0L;
        }
        try {
            FileInputStream fin;
            block12: {
                fin = new FileInputStream(cpuFile);
                try {
                    long idleTime;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(fin));
                    String line = reader.readLine();
                    if (line == null || !line.startsWith("cpu")) break block12;
                    String[] cpuInfos = line.split(" ");
                    int startIndex = cpuInfos[0].equals("cpu") ? 2 : 1;
                    long l = idleTime = Long.parseLong(cpuInfos[startIndex + 3]);
                }
                catch (Throwable throwable) {
                    try {
                        fin.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                fin.close();
            }
            fin.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            return 0L;
        }
    }

    @CalledByNative
    public static long getDeviceTotalCPUTime() {
        long totalCpuTime = 0L;
        int cpuCores = mCpuCoreCount;
        if (cpuCores <= 0) {
            cpuCores = RXPerformanceMonitorAndroid.getCpuCores();
        }
        if (cpuCores <= 0) {
            return totalCpuTime;
        }
        for (int i = 0; i < cpuCores; ++i) {
            String tempPath = "/sys/devices/system/cpu/cpu" + i + "/cpufreq/stats/time_in_state";
            long tempCpuTime = RXPerformanceMonitorAndroid.getDeviceCpuTime(tempPath);
            if (tempCpuTime > 0L) {
                totalCpuTime += tempCpuTime;
                continue;
            }
            return 0L;
        }
        return totalCpuTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getDeviceCpuTime(String cpuTimePath) {
        BufferedReader reader = null;
        long cpuInAllState = 0L;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(cpuTimePath)), 1000);
            String oneLine = null;
            while ((oneLine = reader.readLine()) != null) {
                String[] cpuInfos = oneLine.split(" ");
                if (cpuInfos.length >= 2) {
                    cpuInAllState += Long.parseLong(cpuInfos[1]);
                    continue;
                }
                cpuInAllState = 0L;
                break;
            }
            reader.close();
            RXPerformanceMonitorAndroid.close(reader);
        }
        catch (Exception ex) {
            cpuInAllState = 0L;
        }
        finally {
            RXPerformanceMonitorAndroid.close(reader);
        }
        return cpuInAllState;
    }

    @CalledByNative
    public static long getDeviceTotalCPUIdleTime() {
        long idleTime = 0L;
        int cpuCores = mCpuCoreCount;
        if (cpuCores <= 0) {
            cpuCores = RXPerformanceMonitorAndroid.getCpuCores();
        }
        if (cpuCores <= 0) {
            return idleTime;
        }
        int cpuIdleStateCount = mCpuIdleStateCount;
        if (cpuIdleStateCount <= 0) {
            cpuIdleStateCount = RXPerformanceMonitorAndroid.getCpuIdleStateCount();
        }
        if (cpuIdleStateCount <= 0) {
            return idleTime;
        }
        for (int i = 0; i < cpuCores; ++i) {
            for (int j = 0; j < cpuIdleStateCount; ++j) {
                String tempPath = "/sys/devices/system/cpu/cpu" + i + "/cpuidle/state" + j + "/time";
                long tempIdleTime = RXPerformanceMonitorAndroid.getIdleStateTime(tempPath);
                if (tempIdleTime > 0L) {
                    idleTime += tempIdleTime;
                    continue;
                }
                return 0L;
            }
        }
        return idleTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long getIdleStateTime(String idleTimePath) {
        block5: {
            long l;
            BufferedReader reader;
            block4: {
                reader = null;
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(idleTimePath)), 1000);
                String oneLine = reader.readLine();
                reader.close();
                if (oneLine == null) break block4;
                long l2 = Long.parseLong(oneLine);
                RXPerformanceMonitorAndroid.close(reader);
                return l2;
            }
            try {
                l = 0L;
            }
            catch (Exception exception) {
                RXPerformanceMonitorAndroid.close(reader);
                break block5;
            }
            catch (Throwable throwable) {
                RXPerformanceMonitorAndroid.close(reader);
                throw throwable;
            }
            RXPerformanceMonitorAndroid.close(reader);
            return l;
        }
        return 0L;
    }

    private static int getCpuIdleStateCount() {
        int idleStateCount = -1;
        if (Build.VERSION.SDK_INT <= 10) {
            return idleStateCount;
        }
        try {
            idleStateCount = new File("/sys/devices/system/cpu/cpu0/cpuidle/").listFiles(CPU_IDLE_STATE_FILTER).length;
        }
        catch (Exception e) {
            idleStateCount = -1;
        }
        mCpuIdleStateCount = idleStateCount;
        return idleStateCount;
    }

    @CalledByNative
    public static int getPidMemorySize(int pid, Context context) {
        if (context == null) {
            return 0;
        }
        try {
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            if (am == null) {
                return 0;
            }
            int[] myMempid = new int[]{pid};
            Debug.MemoryInfo[] memoryInfo = am.getProcessMemoryInfo(myMempid);
            return memoryInfo[0].getTotalPss();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @CalledByNative
    public static int getCurrentPidMemorySize() {
        Context context = ContextUtils.getApplicationContext();
        if (context == null) {
            return 0;
        }
        try {
            ActivityManager am = (ActivityManager)context.getSystemService("activity");
            if (am == null) {
                return 0;
            }
            int[] myMempid = new int[]{Process.myPid()};
            Debug.MemoryInfo[] memoryInfo = am.getProcessMemoryInfo(myMempid);
            return memoryInfo[0].getTotalPss();
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @CalledByNative
    public static int getThreadCount() {
        return Thread.activeCount();
    }

    @CalledByNative
    public static int getCpuCores() {
        int cores = 0;
        if (Build.VERSION.SDK_INT <= 10) {
            return 1;
        }
        try {
            cores = new File("/sys/devices/system/cpu/").listFiles(CPU_FILTER).length;
        }
        catch (SecurityException e) {
            cores = -1;
        }
        catch (NullPointerException e) {
            cores = -1;
        }
        mCpuCoreCount = cores;
        return cores;
    }

    @CalledByNative
    public static int getChargeStatus() {
        int status = -1;
        status = Build.VERSION.SDK_INT >= 26 && batteryManager != null ? batteryManager.getIntProperty(6) : charge_status;
        if (status == 5 || status == 2) {
            return 1;
        }
        return 0;
    }

    @CalledByNative
    public static int getThermalState() {
        int thermalState = 4;
        if (Build.VERSION.SDK_INT >= 29 && powerManager != null) {
            thermalState = powerManager.getCurrentThermalStatus();
            switch (thermalState) {
                case 0: 
                case 1: {
                    thermalState = 0;
                    break;
                }
                case 2: {
                    thermalState = 1;
                    break;
                }
                case 3: 
                case 4: {
                    thermalState = 2;
                    break;
                }
                case 5: 
                case 6: {
                    thermalState = 3;
                }
            }
        }
        return thermalState;
    }

    @CalledByNative
    public static int getBatteryLevel() {
        int level = -1;
        if (Build.VERSION.SDK_INT >= 21 && batteryManager != null) {
            level = batteryManager.getIntProperty(4);
        }
        return level;
    }

    @CalledByNative
    public static int getBatterySaveStatus() {
        int powerSaveMode = -1;
        if (Build.MANUFACTURER.equalsIgnoreCase("Xiaomi")) {
            try {
                powerSaveMode = Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"POWER_SAVE_MODE_OPEN");
            }
            catch (Exception e) {
                powerSaveMode = -1;
                e.printStackTrace();
            }
        } else if (Build.MANUFACTURER.equalsIgnoreCase("Huawei")) {
            try {
                powerSaveMode = Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"SmartModeStatus") == 4 ? 1 : 0;
            }
            catch (Exception e) {
                powerSaveMode = -1;
                e.printStackTrace();
            }
        } else if (Build.VERSION.SDK_INT >= 21 && powerManager != null) {
            powerSaveMode = powerManager.isPowerSaveMode() ? 1 : 0;
        }
        return powerSaveMode;
    }

    @CalledByNative
    public static int getBatteryTemperature() {
        return battery_temperature / 10;
    }

    @CalledByNative
    public static int getScreenBrightness() {
        if (Build.MANUFACTURER.equalsIgnoreCase("Xiaomi")) {
            return -1;
        }
        ContentResolver contentResolver = context.getContentResolver();
        int defVal = -1;
        int curVal = Settings.System.getInt((ContentResolver)contentResolver, (String)"screen_brightness", (int)defVal);
        return (int)((double)curVal / 255.0 * 100.0);
    }

    public static void close(Closeable stream) {
        try {
            if (stream != null) {
                stream.close();
            }
        }
        catch (Throwable ignored) {
            ignored.printStackTrace();
        }
    }
}

