/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import java.nio.ByteBuffer;
import org.webrtc.CalledByNative;
import org.webrtc.JniCommon;
import org.webrtc.VideoStream;

class WrappedNativeStreamBuffer
implements VideoStream.Buffer {
    private final int size;
    private final ByteBuffer data;
    private final long nativeBuffer;

    @CalledByNative
    WrappedNativeStreamBuffer(int size, ByteBuffer data, long nativeBuffer) {
        this.size = size;
        this.data = data;
        this.nativeBuffer = nativeBuffer;
        this.retain();
    }

    @Override
    public int getDataSize() {
        return this.size;
    }

    @Override
    public ByteBuffer getData() {
        return this.data.slice();
    }

    @Override
    public void retain() {
        JniCommon.nativeAddRef(this.nativeBuffer);
    }

    @Override
    public void release() {
        JniCommon.nativeReleaseRef(this.nativeBuffer);
    }
}

