/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae.base;

import android.support.annotation.Nullable;
import com.bytedance.bae.base.RefCounted;
import java.util.concurrent.atomic.AtomicInteger;

class RefCountDelegate
implements RefCounted {
    private final AtomicInteger refCount = new AtomicInteger(1);
    @Nullable
    private final Runnable releaseCallback;

    public RefCountDelegate(@Nullable Runnable releaseCallback) {
        this.releaseCallback = releaseCallback;
    }

    @Override
    public void retain() {
        this.refCount.incrementAndGet();
    }

    @Override
    public void release() {
        if (this.refCount.decrementAndGet() == 0 && this.releaseCallback != null) {
            this.releaseCallback.run();
        }
    }
}

