/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae.codec;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.Build;
import android.support.annotation.Nullable;
import com.bytedance.bae.base.BaeLogging;
import com.bytedance.bae.base.CalledByNative;
import java.nio.ByteBuffer;

public class MediaCodecAACDecoder {
    private static final String TAG = "MediaCodecAACDecoder";
    private static final int MAX_WAITING_TIME = 300;
    private String mMimeType = "audio/mp4a-latm";
    private MediaCodec mAACDecoder = null;
    private int mSampleRate = 44100;
    private int mChannels = 1;
    private MediaFormat mOutputFormat;
    private int mProfile = 2;
    private int mHasADTS = 0;
    @Nullable
    private byte[] mDecodedData;
    private byte[] mAsc;
    private ByteBuffer[] mInputBuffers;
    private ByteBuffer[] mOutputBuffers;
    private MediaCodec.BufferInfo mBufferInfo;
    private long input_ts = 0L;
    private long output_ts = 0L;

    @CalledByNative
    MediaCodecAACDecoder() {
        BaeLogging.e(TAG, "MediaCodecAAC Decoder Created");
    }

    @CalledByNative
    public boolean openEncoder() {
        try {
            this.mAACDecoder = MediaCodec.createDecoderByType((String)this.mMimeType);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mAACDecoder = null;
            BaeLogging.e(TAG, "Open AAC Decoder failed");
            return false;
        }
        return this.mAACDecoder != null;
    }

    @CalledByNative
    public void closeDecoder() {
        try {
            if (this.mAACDecoder != null) {
                this.mAACDecoder.stop();
                this.mAACDecoder.release();
                this.mAACDecoder = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaeLogging.e(TAG, "close AAC decoder failed");
        }
    }

    @CalledByNative
    public void setProfileValue(String profile) {
        this.mProfile = profile.equals("he_aac") ? 5 : (profile.equals("he_aac_v2") ? 29 : 2);
    }

    @CalledByNative
    public void setSampeRateValue(int sr) {
        this.mSampleRate = sr;
    }

    @CalledByNative
    public void setChannelsValue(int ch) {
        this.mChannels = ch;
    }

    @CalledByNative
    public void setADTSValue(int has_adts) {
        this.mHasADTS = has_adts;
    }

    @CalledByNative
    @Nullable
    public byte[] getDecodedData() {
        return this.mDecodedData;
    }

    @CalledByNative
    public int getOutputChannels() {
        return this.mOutputFormat.getInteger("channel-count");
    }

    @CalledByNative
    public int getOutputSampleRate() {
        return this.mOutputFormat.getInteger("sample-rate");
    }

    @CalledByNative
    public void setInputTs(long ts) {
        this.input_ts = ts;
    }

    @CalledByNative
    public long getOutputTs() {
        return this.output_ts;
    }

    @Nullable
    private void genAsc() {
        int sr_idx = 0;
        int half_sr_idx = 0;
        int ch_mode = 0;
        byte profile = 0;
        this.mAsc = this.mProfile == 2 ? new byte[2] : new byte[4];
        if (48000 == this.mSampleRate) {
            sr_idx = 3;
            half_sr_idx = 6;
        } else if (44100 == this.mSampleRate) {
            sr_idx = 4;
            half_sr_idx = 7;
        } else if (32000 == this.mSampleRate) {
            sr_idx = 5;
            half_sr_idx = 8;
        }
        if (1 == this.mChannels) {
            ch_mode = 1;
        } else if (2 == this.mChannels) {
            ch_mode = 2;
        }
        profile = (byte)this.mProfile;
        if (2 == this.mProfile) {
            this.mAsc[0] = (byte)(profile << 3 | sr_idx >> 1);
            this.mAsc[1] = (byte)(sr_idx << 7 | ch_mode << 3);
        } else if (5 == this.mProfile) {
            this.mAsc[0] = (byte)(profile << 3 | half_sr_idx >> 1);
            this.mAsc[1] = (byte)(half_sr_idx << 7 | ch_mode << 3 | sr_idx >> 1);
            this.mAsc[2] = (byte)(sr_idx << 7 | 8);
            this.mAsc[3] = 0;
        } else if (29 == this.mProfile) {
            this.mAsc[0] = (byte)(profile << 3 | half_sr_idx >> 1);
            this.mAsc[1] = (byte)(half_sr_idx << 7 | 8 | sr_idx >> 1);
            this.mAsc[2] = (byte)(sr_idx << 7 | 8);
            this.mAsc[3] = 0;
        }
    }

    @CalledByNative
    public boolean configAndStartDecoder() {
        try {
            MediaFormat mediaFormat = MediaFormat.createAudioFormat((String)this.mMimeType, (int)this.mSampleRate, (int)this.mChannels);
            mediaFormat.setInteger("aac-profile", this.mProfile);
            mediaFormat.setInteger("is-adts", this.mHasADTS);
            mediaFormat.setInteger("aac-max-output-channel_count", this.mChannels);
            this.genAsc();
            ByteBuffer csd_0 = ByteBuffer.wrap(this.mAsc);
            mediaFormat.setByteBuffer("csd-0", csd_0);
            this.mAACDecoder.configure(mediaFormat, null, null, 0);
            this.mAACDecoder.start();
            this.mBufferInfo = new MediaCodec.BufferInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.closeDecoder();
            BaeLogging.e(TAG, "Config and Start Decoder Error");
            return false;
        }
        return true;
    }

    @CalledByNative
    public boolean decodeProcess(byte[] data) {
        try {
            if (null == this.mAACDecoder) {
                return false;
            }
            this.mDecodedData = null;
            int inputIndex = this.mAACDecoder.dequeueInputBuffer(300L);
            if (inputIndex >= 0) {
                ByteBuffer in_buf;
                if (Build.VERSION.SDK_INT >= 21) {
                    in_buf = this.mAACDecoder.getInputBuffer(inputIndex);
                } else {
                    this.mInputBuffers = this.mAACDecoder.getInputBuffers();
                    in_buf = this.mInputBuffers[inputIndex];
                    in_buf.limit(data.length);
                }
                in_buf.clear();
                in_buf.put(data);
                this.mAACDecoder.queueInputBuffer(inputIndex, 0, data.length, this.input_ts * 1000000L / (long)this.mSampleRate, 0);
            }
            int outputIndex = this.mAACDecoder.dequeueOutputBuffer(this.mBufferInfo, 0L);
            int bytePacketSize = this.mBufferInfo.size;
            if (bytePacketSize <= 0 || outputIndex < 0) {
                return true;
            }
            this.output_ts = this.mBufferInfo.presentationTimeUs * (long)this.mSampleRate / 1000000L;
            ByteBuffer buf = null;
            if (Build.VERSION.SDK_INT >= 21) {
                buf = this.mAACDecoder.getOutputBuffer(outputIndex);
            } else {
                this.mOutputBuffers = this.mAACDecoder.getOutputBuffers();
                buf = this.mOutputBuffers[outputIndex];
                buf.limit(this.mBufferInfo.size);
            }
            this.mDecodedData = new byte[bytePacketSize];
            buf.get(this.mDecodedData, this.mBufferInfo.offset, this.mBufferInfo.size);
            buf.clear();
            this.mOutputFormat = this.mAACDecoder.getOutputFormat(outputIndex);
            this.mAACDecoder.releaseOutputBuffer(outputIndex, false);
        }
        catch (Exception e) {
            e.printStackTrace();
            BaeLogging.e(TAG, "AAC Decoder Decode failed");
            return false;
        }
        return true;
    }
}

