/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae.hwearback;

import com.bytedance.bae.base.BaeLogging;
import com.bytedance.bae.base.ContextUtils;
import com.bytedance.bae.hwearback.IHardWareEarback;
import com.bytedance.bae.hwearback.SlientPlayer;
import com.bytedance.bae.router.device.VivoKTVHelper;
import com.bytedance.bae.webrtc.WebRtcAudioEarBack;

public class VivoEarback
implements IHardWareEarback {
    private static final String TAG = VivoEarback.class.getName();
    private VivoKTVHelper vivoKtvHelper;
    private SlientPlayer slientPlayer;
    private WebRtcAudioEarBack webRtcAudioEarBack;

    public VivoEarback(WebRtcAudioEarBack earBack) {
        this.webRtcAudioEarBack = earBack;
    }

    @Override
    public int init() {
        this.vivoKtvHelper = new VivoKTVHelper(ContextUtils.getApplicationContext());
        this.slientPlayer = new SlientPlayer();
        if (this.vivoKtvHelper.isDeviceSupportKaraoke()) {
            this.vivoKtvHelper.openKTVDevice();
        }
        boolean isSupportHardwareEarback = this.isSupport();
        if (this.webRtcAudioEarBack != null) {
            this.webRtcAudioEarBack.onHardwareEarbackSupported(isSupportHardwareEarback);
        }
        this.printLog("inited, isSupportHardwareEarback=" + isSupportHardwareEarback);
        return 0;
    }

    @Override
    public int release() {
        this.printLog("release");
        if (this.vivoKtvHelper != null) {
            this.close();
            this.vivoKtvHelper.closeKTVDevice();
        }
        return 0;
    }

    @Override
    public boolean isSupport() {
        if (this.vivoKtvHelper != null) {
            return this.vivoKtvHelper.isDeviceSupportKaraoke();
        }
        return false;
    }

    @Override
    public int open() {
        if (this.vivoKtvHelper != null && this.slientPlayer != null) {
            this.printLog("open");
            this.slientPlayer.play();
            this.vivoKtvHelper.setPlayFeedbackParam(1);
            return 0;
        }
        return -1;
    }

    @Override
    public int close() {
        if (this.vivoKtvHelper != null && this.slientPlayer != null) {
            this.printLog("close");
            this.slientPlayer.stop();
            this.vivoKtvHelper.setPlayFeedbackParam(0);
            return 0;
        }
        return -1;
    }

    @Override
    public int setEffect(int value) {
        if (this.vivoKtvHelper != null) {
            this.printLog("setEffect value=" + value);
            if (value >= 0 && value <= this.vivoKtvHelper.getEffectSize()) {
                this.vivoKtvHelper.setCustomMode(value);
                return 0;
            }
            BaeLogging.w(TAG, String.format("ByteAudioEarBackEffect vivo valid is [%d,%d], value is %d, ignore it", 0, this.vivoKtvHelper.getEffectSize(), value));
            return -1;
        }
        return -1;
    }

    @Override
    public int setEqualizer(int value) {
        return -1;
    }

    @Override
    public int setVolume(int volume) {
        if (this.vivoKtvHelper != null) {
            this.printLog("setVolume volume=" + volume);
            int kVol = (int)(15.0 * (double)volume / 100.0);
            this.vivoKtvHelper.setMicVolParam(kVol);
            return 0;
        }
        return -1;
    }

    private void printLog(String message) {
        BaeLogging.i(TAG, TAG + ":" + message);
    }
}

