/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.realx.video.camera;

import android.content.Context;
import android.content.Intent;
import android.hardware.Camera;
import android.media.projection.MediaProjection;
import android.os.Build;
import android.support.v4.content.ContextCompat;
import android.view.WindowManager;
import com.bytedance.realx.RXNativeFunctions;
import com.bytedance.realx.base.CalledByNative;
import com.bytedance.realx.base.RXLogging;
import org.webrtc.Camera1Capturer;
import org.webrtc.Camera1Enumerator;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.CapturerObserver;
import org.webrtc.ContextUtils;
import org.webrtc.EglBase;
import org.webrtc.ScreenCapturerAndroid;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoFrame;

public class RXVideoCaptureAndroid {
    private static final String TAG = "RXVideoCaptureAndroid";
    private SurfaceTextureHelper mSurfaceTextureHelper;
    private VideoCapturer mVideoCapturer = null;
    private CameraVideoCapturer.CameraEventsHandler mCameraEventsHandler = null;
    private boolean mIsFrontCamera = true;
    private boolean mIsVideoCaptureInited = false;
    private boolean mIsVideoCaptureWorking = false;
    private boolean mIsCaptureScreen = false;
    private int mWidth = 0;
    private int mHeight = 0;
    private long mNativeCaptureObserver;
    private EglBase cameraEglBase = null;
    private EglBase.Context sharedEglGroup = null;
    private Intent mCaptureScreenIntent = null;
    private int mCaptureBufferType;
    private final int UIDeviceOrientationPortrait = 0;
    private final int UIDeviceOrientationLandscapeLeft = 90;
    private final int UIDeviceOrientationPortraitUpsidedown = 180;
    private final int UIDeviceOrientationLandscapeRight = 270;
    private CapturerObserver localCapturerObserver = new CapturerObserver(){

        @Override
        public void onCapturerStarted(boolean b) {
            if (b) {
                RXLogging.w(RXVideoCaptureAndroid.TAG, "onCapturerStarted...");
                RXNativeFunctions.nativeOnCapturerStarted(RXVideoCaptureAndroid.this.mNativeCaptureObserver, b);
            } else {
                RXNativeFunctions.nativeOnCapturerError(RXVideoCaptureAndroid.this.mNativeCaptureObserver, 0);
            }
        }

        @Override
        public void onCapturerStopped() {
            RXLogging.w(RXVideoCaptureAndroid.TAG, "onCapturerStopped...");
            RXNativeFunctions.nativeOnCapturerStopped(RXVideoCaptureAndroid.this.mNativeCaptureObserver);
        }

        @Override
        public void onCapturerError(String errorMsg) {
            RXLogging.e(RXVideoCaptureAndroid.TAG, "onCapturerError: " + errorMsg);
            if (errorMsg.equals("CAMERA_ERROR_SERVER_DIED")) {
                RXNativeFunctions.nativeOnCapturerError(RXVideoCaptureAndroid.this.mNativeCaptureObserver, -1005);
            } else if (errorMsg.equals("CAMERA_ERROR_EVICTED") || errorMsg.equals("CAMERA_ERROR_UNKNOWN")) {
                RXNativeFunctions.nativeOnCapturerError(RXVideoCaptureAndroid.this.mNativeCaptureObserver, -1004);
            } else {
                RXNativeFunctions.nativeOnCapturerError(RXVideoCaptureAndroid.this.mNativeCaptureObserver, -1005);
            }
        }

        @Override
        public void onFrameCaptured(VideoFrame videoFrame) {
            RXNativeFunctions.nativeOnFrameCaptured(RXVideoCaptureAndroid.this.mNativeCaptureObserver, videoFrame);
        }
    };

    @CalledByNative
    RXVideoCaptureAndroid(boolean captureScreen, long nativeCaptureObserver, EglBase.Context ctx) {
        RXLogging.w(TAG, "RXVideoCaptureAndroid Created, CaptureScreen=" + captureScreen);
        this.mIsCaptureScreen = captureScreen;
        this.mNativeCaptureObserver = nativeCaptureObserver;
        this.sharedEglGroup = ctx;
    }

    @CalledByNative
    public void startCapture(int width, int height, int frameRate, int cameraPosition, int captureBufferType, Intent intent, boolean faceae) {
        RXLogging.w(TAG, "startCapture...");
        this.mWidth = width;
        this.mHeight = height;
        this.mCaptureScreenIntent = intent;
        this.mCaptureBufferType = captureBufferType;
        Context context = ContextUtils.getApplicationContext();
        if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.CAMERA") != 0) {
            RXNativeFunctions.nativeOnCapturerError(this.mNativeCaptureObserver, -100);
            return;
        }
        if (this.mVideoCapturer != null) {
            this.mVideoCapturer.dispose();
            this.mVideoCapturer = null;
            this.mIsVideoCaptureInited = false;
            this.mIsVideoCaptureWorking = false;
        }
        this.mVideoCapturer = this.createVideoCapturer(this.mIsCaptureScreen, cameraPosition, this.mCaptureScreenIntent);
        if (this.cameraEglBase == null) {
            this.cameraEglBase = EglBase.create(this.sharedEglGroup);
        }
        this.mSurfaceTextureHelper = SurfaceTextureHelper.create("RXLocalCapturer", this.cameraEglBase.getEglBaseContext());
        if (this.mVideoCapturer != null && this.mSurfaceTextureHelper != null) {
            this.mVideoCapturer.initialize(this.mSurfaceTextureHelper, ContextUtils.getApplicationContext(), this.localCapturerObserver);
            this.mIsVideoCaptureInited = true;
            if (this.mVideoCapturer instanceof Camera1Capturer) {
                ((Camera1Capturer)this.mVideoCapturer).enableFaceAE(faceae);
            }
            this.startVideoCapture(width, height, frameRate);
        } else {
            this.mIsVideoCaptureInited = false;
            this.mIsVideoCaptureWorking = false;
        }
    }

    @CalledByNative
    public void stopCapture() {
        RXLogging.w(TAG, "stopCapture...");
        if (this.mVideoCapturer != null && this.mIsVideoCaptureInited && this.mIsVideoCaptureWorking) {
            try {
                this.mVideoCapturer.stopCapture();
                this.mIsVideoCaptureWorking = false;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @CalledByNative
    public int enableFollowGravity(boolean enable) {
        if (this.mVideoCapturer != null && this.mIsVideoCaptureInited && this.mIsVideoCaptureWorking) {
            return this.mVideoCapturer.enableFollowGravity(enable);
        }
        return 0;
    }

    @CalledByNative
    public boolean isCameraTorchSupported() {
        if (this.mVideoCapturer != null && this.mIsVideoCaptureInited && this.mIsVideoCaptureWorking) {
            return this.mVideoCapturer.isCameraTorchSupported();
        }
        return false;
    }

    @CalledByNative
    public void turnOnFlashLight() {
        if (this.mVideoCapturer != null && this.mIsVideoCaptureInited && this.mIsVideoCaptureWorking) {
            this.mVideoCapturer.turnOnFlashLight();
        }
    }

    @CalledByNative
    public void turnOffFlashLight() {
        if (this.mVideoCapturer != null && this.mIsVideoCaptureInited && this.mIsVideoCaptureWorking) {
            this.mVideoCapturer.turnOffFlashLight();
        }
    }

    @CalledByNative
    public boolean isCameraZoomSupported() {
        if (this.mVideoCapturer != null && this.mIsVideoCaptureInited && this.mIsVideoCaptureWorking) {
            return this.mVideoCapturer.isCameraZoomSupported();
        }
        return false;
    }

    @CalledByNative
    public int setCameraZoomRatio(float zoom) {
        if (this.mVideoCapturer != null && this.mIsVideoCaptureInited && this.mIsVideoCaptureWorking) {
            return this.mVideoCapturer.setCameraZoomRatio(zoom);
        }
        return -1;
    }

    @CalledByNative
    public float getCameraZoomMaxRatio() {
        if (this.mVideoCapturer != null && this.mIsVideoCaptureInited && this.mIsVideoCaptureWorking) {
            return this.mVideoCapturer.getCameraZoomMaxRatio();
        }
        return -1.0f;
    }

    @CalledByNative
    public void release() {
        if (this.mVideoCapturer != null) {
            this.stopCapture();
            this.mVideoCapturer.dispose();
            this.mVideoCapturer = null;
        }
        if (this.cameraEglBase != null) {
            this.cameraEglBase.release();
            this.cameraEglBase = null;
        }
        if (this.mSurfaceTextureHelper != null) {
            this.mSurfaceTextureHelper.dispose();
            this.mSurfaceTextureHelper = null;
        }
        this.mIsVideoCaptureInited = false;
        this.mIsVideoCaptureWorking = false;
        this.sharedEglGroup = null;
        this.mCaptureScreenIntent = null;
    }

    @CalledByNative
    public void switchCamera() {
        if (this.mVideoCapturer == null || !this.mIsVideoCaptureInited) {
            return;
        }
        if (this.mVideoCapturer instanceof CameraVideoCapturer) {
            this.mIsFrontCamera = !this.mIsFrontCamera;
            CameraVideoCapturer cameraVideoCapturer = (CameraVideoCapturer)this.mVideoCapturer;
            cameraVideoCapturer.switchCamera(new CameraVideoCapturer.CameraSwitchHandler(){

                @Override
                public void onCameraSwitchDone(boolean isFrontFacing) {
                    RXVideoCaptureAndroid.this.mIsFrontCamera = isFrontFacing;
                }

                @Override
                public void onCameraSwitchError(String errorDescription) {
                }
            });
        }
    }

    public int getCameraFace() {
        if (this.mIsFrontCamera) {
            return 1;
        }
        return 0;
    }

    @CalledByNative
    int getUIOrientation() {
        Context context = ContextUtils.getApplicationContext();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        switch (wm.getDefaultDisplay().getRotation()) {
            case 1: {
                return 270;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 90;
            }
        }
        return 0;
    }

    @CalledByNative
    int getDeviceOrientation() {
        if (this.mVideoCapturer != null && this.mIsVideoCaptureInited && this.mIsVideoCaptureWorking) {
            return this.mVideoCapturer.getDeviceOrientation();
        }
        return this.getUIOrientation();
    }

    @CalledByNative
    static int[] getCameraSensorOrientations() {
        int count = Camera.getNumberOfCameras();
        if (count <= 0) {
            RXLogging.w(TAG, "getNumberOfCameras failed on count " + count);
            return null;
        }
        int[] rotations = new int[count];
        Camera.CameraInfo info = new Camera.CameraInfo();
        for (int i = 0; i < count; ++i) {
            try {
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
                rotations[i] = info.orientation;
                continue;
            }
            catch (Exception var) {
                RXLogging.w(TAG, "getCameraInfo failed on index " + i + ',' + var.getMessage());
                return null;
            }
        }
        return rotations;
    }

    @CalledByNative
    static boolean isFrontCamera(int index) {
        Camera.CameraInfo info = new Camera.CameraInfo();
        try {
            Camera.getCameraInfo((int)index, (Camera.CameraInfo)info);
            if (info.facing == 1) {
                return true;
            }
        }
        catch (Exception var) {
            RXLogging.w(TAG, "getCameraInfo failed on index " + index + ',' + var.getMessage());
            return false;
        }
        return false;
    }

    private VideoCapturer createVideoCapturer(boolean captureScreen, int cameraPosition, Intent mediaProjectionPermissionResultData) {
        try {
            String[] deviceNames;
            if (captureScreen) {
                return new ScreenCapturerAndroid(mediaProjectionPermissionResultData, new MediaProjection.Callback(){

                    public void onStop() {
                        RXLogging.e(RXVideoCaptureAndroid.TAG, "User revoked permission to capture the screen.");
                    }
                });
            }
            Camera1Enumerator enumerator = new Camera1Enumerator(this.mCaptureBufferType != 1 && this.isCaptureToTextureSupported(), false);
            for (String name : deviceNames = enumerator.getDeviceNames()) {
                CameraVideoCapturer capturer;
                if (enumerator.isFrontFacing(name) && cameraPosition == 1 && (capturer = enumerator.createCapturer(name, this.mCameraEventsHandler)) != null) {
                    return capturer;
                }
                if (!enumerator.isBackFacing(name) || cameraPosition != 0 || (capturer = enumerator.createCapturer(name, this.mCameraEventsHandler)) == null) continue;
                return capturer;
            }
        }
        catch (IllegalArgumentException e) {
            RXLogging.e(TAG, "Create VideoCapture fail : " + e.getMessage());
            return null;
        }
        return null;
    }

    private void startVideoCapture(int width, int height, int fps) {
        RXLogging.w(TAG, String.format("startVideoCapture: width: %d, height: &d, fps: &d", width, height, fps));
        if (this.mVideoCapturer != null) {
            try {
                this.mVideoCapturer.startCapture(width, height, fps);
                this.mIsVideoCaptureWorking = true;
            }
            catch (IllegalArgumentException e) {
                RXLogging.e(TAG, "VideoCapture startCapture fail : " + e.getMessage());
            }
        }
    }

    private boolean isCaptureToTextureSupported() {
        return Build.VERSION.SDK_INT > 18 || !"samsung".equalsIgnoreCase(Build.MANUFACTURER) || Build.MODEL == null || !Build.MODEL.contains("SM-N") && !Build.MODEL.contains("GT-N");
    }

    public class BufferType {
        public static final int TEXTURE_BUFFER = 0;
        public static final int BYTE_BUFFER = 1;
    }
}

