/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.base.utils;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.support.v4.content.ContextCompat;
import com.ss.bytertc.base.utils.RtcContextUtils;
import org.webrtc.CalledByNative;

public final class WlanMonitor {
    @RequiresApi(api=21)
    @CalledByNative
    public static int getFrequency() {
        if (Build.VERSION.SDK_INT < 21) {
            return 0;
        }
        try {
            Context context = RtcContextUtils.getApplicationContext();
            if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_WIFI_STATE") != 0) {
                return 0;
            }
            WifiManager wifiMgr = (WifiManager)context.getSystemService("wifi");
            if (wifiMgr == null) {
                return 0;
            }
            WifiInfo wifiInfo = wifiMgr.getConnectionInfo();
            if (wifiInfo == null) {
                return 0;
            }
            return wifiInfo.getFrequency();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    @CalledByNative
    public static int getSignalQuality() {
        try {
            Context context = RtcContextUtils.getApplicationContext();
            if (ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_WIFI_STATE") != 0) {
                return 0;
            }
            WifiManager wifiMgr = (WifiManager)context.getSystemService("wifi");
            if (wifiMgr == null) {
                return 0;
            }
            WifiInfo wifiInfo = wifiMgr.getConnectionInfo();
            if (wifiInfo == null) {
                return 0;
            }
            return wifiInfo.getRssi();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }
}

