/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine;

import com.ss.bytertc.engine.VideoStreamDescription;
import com.ss.bytertc.engine.data.VideoOrientation;
import org.webrtc.CalledByNative;

public class VideoEncoderConfig {
    public int width;
    public int height;
    public int frameRate;
    public int maxBitrate = -1;
    public EncoderPreference encodePreference = EncoderPreference.MaintainFramerate;
    public VideoOrientation orientation = VideoOrientation.Adaptive;

    @CalledByNative
    private static VideoStreamDescription create(int width, int height, int frameRate, int maxBitrate) {
        return new VideoStreamDescription(width, height, frameRate, maxBitrate);
    }

    public VideoEncoderConfig() {
    }

    public VideoEncoderConfig(int width, int height, int frameRate, int maxBitrate) {
        this.width = width;
        this.height = height;
        this.frameRate = frameRate;
        this.maxBitrate = maxBitrate;
    }

    public VideoEncoderConfig(int width, int height, int frameRate, int maxBitrate, int codecName, int codecMode, int encodePrefer, int orientation) {
        this.width = width;
        this.height = height;
        this.frameRate = frameRate;
        this.maxBitrate = maxBitrate;
        this.encodePreference = EncoderPreference.convertFromInt(encodePrefer);
        this.orientation = VideoOrientation.fromId(orientation);
    }

    public boolean isValid() {
        return this.width > 0 && this.height > 0 && this.frameRate > 0;
    }

    public String toString() {
        return "VideoEncoderConfig{width=" + this.width + "height=" + this.height + ", frameRate=" + this.frameRate + ", maxBitrate=" + this.maxBitrate + ", encodePreference=" + (Object)((Object)this.encodePreference) + ", orientation=" + (Object)((Object)this.orientation) + '}';
    }

    public static enum EncoderPreference {
        Disabled(0),
        MaintainFramerate(1),
        MaintainQuality(2),
        Balance(3);

        private int value;

        private EncoderPreference(int v) {
            this.value = v;
        }

        public static EncoderPreference convertFromInt(int v) {
            return EncoderPreference.values()[v];
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum VideoCodecType {
        CODEC_TYPE_AUTO(0),
        CODEC_TYPE_H264(1),
        CODEC_TYPE_BYTEVC1(2);

        private int value;

        private VideoCodecType(int v) {
            this.value = v;
        }

        public static VideoCodecType convertFromInt(int v) {
            return VideoCodecType.values()[v];
        }

        public int getValue() {
            return this.value;
        }
    }

    public static enum CodecMode {
        CODEC_MODE_AUTO(0),
        CODEC_MODE_HARDWARE(1),
        CODEC_MODE_SOFTWARE(2);

        private int value;

        private CodecMode(int v) {
            this.value = v;
        }

        public static CodecMode convertFromInt(int v) {
            return CodecMode.values()[v];
        }

        public int getValue() {
            return this.value;
        }
    }
}

