/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.adapter;

import android.support.annotation.Nullable;
import com.ss.bytertc.engine.mediaio.CountDownLatchI420Buffer;
import com.ss.bytertc.engine.utils.LogUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import org.webrtc.JavaI420Buffer;
import org.webrtc.VideoFrame;

public class VideoFrameConverter {
    private static final String TAG = "VideoFrameConverter";
    private static int MAX_BYTE_BUFFER_POOL_SIZE = 2;
    private ByteBuffer[] byteBuffers = new ByteBuffer[3];
    final int[] strides = new int[3];
    final int[] steps = new int[2];
    private ArrayList<ByteBufferHolder> byteBufferPool = new ArrayList();
    private boolean isBufferDirect;
    private int abandonFrameCount = 0;

    public VideoFrameConverter() {
        this(false);
    }

    public VideoFrameConverter(boolean isBufferDirect) {
        for (int i = 0; i < MAX_BYTE_BUFFER_POOL_SIZE; ++i) {
            ByteBufferHolder holder = new ByteBufferHolder();
            this.byteBufferPool.add(holder);
        }
        this.isBufferDirect = isBufferDirect;
    }

    public boolean convertRawYUV2ByteHolder(ByteBufferHolder dest, ByteBuffer y, ByteBuffer u, ByteBuffer v, int ystride, int ustride, int vstride, int width, int height) {
        int stepUV = (width + 1) / 2;
        int cap = width * height + stepUV * 2 * height;
        this.checkReuseByteBuffer(cap, dest);
        return this.convertRawYUV2ByteBuffer(dest.byteBuffer, y, u, v, ystride, ustride, vstride, width, height);
    }

    private boolean convertRawYUV2ByteBuffer(@Nullable ByteBuffer dest, ByteBuffer y, ByteBuffer u, ByteBuffer v, int ystride, int ustride, int vstride, int width, int height) {
        this.strides[0] = ystride;
        this.strides[1] = ustride;
        this.strides[2] = vstride;
        this.steps[0] = width;
        this.steps[1] = (width + 1) / 2;
        int cap = width * height + this.steps[1] * 2 * height;
        y.clear();
        u.clear();
        v.clear();
        if (dest == null || cap > dest.capacity()) {
            return false;
        }
        dest.clear();
        this.byteBuffers[0] = y;
        this.byteBuffers[1] = u;
        this.byteBuffers[2] = v;
        block0: for (int i = 0; i < this.byteBuffers.length; ++i) {
            ByteBuffer cBuffer = this.byteBuffers[i];
            int cStride = this.strides[i];
            int cStep = i == 0 ? this.steps[0] : this.steps[1];
            int cStrideDifference = cStride - cStep;
            if (cStride == cStep) {
                dest.put(cBuffer);
                continue;
            }
            while (cBuffer.hasRemaining() && cBuffer.position() + cStep <= cBuffer.capacity()) {
                cBuffer.limit(cBuffer.position() + cStep);
                dest.put(cBuffer);
                int destPosition = cBuffer.position() + cStrideDifference;
                if (destPosition > cBuffer.capacity()) continue block0;
                cBuffer.limit(cBuffer.capacity());
                cBuffer.position(destPosition);
            }
        }
        this.byteBuffers[0] = null;
        this.byteBuffers[1] = null;
        this.byteBuffers[2] = null;
        return true;
    }

    private boolean convertRawYUV2ByteArray(@Nullable byte[] dest, ByteBuffer y, ByteBuffer u, ByteBuffer v, int ystride, int ustride, int vstride, int width, int height) {
        this.strides[0] = ystride;
        this.strides[1] = ustride;
        this.strides[2] = vstride;
        this.steps[0] = width;
        this.steps[1] = (width + 1) / 2;
        int cap = width * height + this.steps[1] * 2 * height;
        y.clear();
        u.clear();
        v.clear();
        if (dest == null || cap > dest.length) {
            return false;
        }
        int destOffset = 0;
        this.byteBuffers[0] = y;
        this.byteBuffers[1] = u;
        this.byteBuffers[2] = v;
        block0: for (int i = 0; i < this.byteBuffers.length; ++i) {
            ByteBuffer cBuffer = this.byteBuffers[i];
            int cStride = this.strides[i];
            int cStep = i == 0 ? this.steps[0] : this.steps[1];
            int cStrideDifference = cStride - cStep;
            if (cStride == cStep) {
                int copyLength = cBuffer.remaining();
                cBuffer.get(dest, destOffset, copyLength);
                destOffset += copyLength;
                continue;
            }
            while (cBuffer.hasRemaining() && cBuffer.position() + cStep <= cBuffer.capacity()) {
                cBuffer.get(dest, destOffset, cStep);
                destOffset += cStep;
                int destPosition = cBuffer.position() + cStrideDifference;
                if (!cBuffer.hasRemaining() || destPosition > cBuffer.capacity()) continue block0;
                cBuffer.position(destPosition);
            }
        }
        this.byteBuffers[0] = null;
        this.byteBuffers[1] = null;
        this.byteBuffers[2] = null;
        return true;
    }

    public ByteBuffer convertRawYUV2ByteArray(byte[] y, byte[] u, byte[] v, int ystride, int ustride, int vstride, int width, int height) {
        ByteBuffer bufferY = ByteBuffer.allocateDirect(y.length);
        bufferY.order(ByteOrder.nativeOrder());
        bufferY.put(y);
        bufferY.position(0);
        ByteBuffer bufferU = ByteBuffer.allocateDirect(u.length);
        bufferU.order(ByteOrder.nativeOrder());
        bufferU.put(u);
        bufferU.position(0);
        ByteBuffer bufferV = ByteBuffer.allocateDirect(v.length);
        bufferV.order(ByteOrder.nativeOrder());
        bufferV.put(v);
        bufferV.position(0);
        int stepUV = (width + 1) / 2;
        int cap = width * height + stepUV * 2 * width;
        ByteBuffer buffer = ByteBuffer.allocate(cap);
        buffer.clear();
        this.convertRawYUV2ByteArray(buffer.array(), bufferY, bufferU, bufferV, ystride, ustride, vstride, width, height);
        return buffer;
    }

    public ByteBufferHolder convert2YUV(VideoFrame frame) {
        ByteBufferHolder holder = this.getPendingBuffer();
        if (holder == null) {
            return null;
        }
        int width = frame.getBuffer().getWidth();
        int height = frame.getBuffer().getHeight();
        I420BufferWrapper i420BufferWrapper = new I420BufferWrapper(frame);
        VideoFrame.I420Buffer i420Buffer = i420BufferWrapper.getBuffer();
        boolean isConvertSuccess = this.convertRawYUV2ByteHolder(holder, i420Buffer.getDataY(), i420Buffer.getDataU(), i420Buffer.getDataV(), i420Buffer.getStrideY(), i420Buffer.getStrideU(), i420Buffer.getStrideV(), width, height);
        i420BufferWrapper.release();
        if (!isConvertSuccess) {
            return null;
        }
        return holder;
    }

    public VideoFrame.I420Buffer convertToJavaI420Buffer(ByteBuffer data, int width, int height, boolean useCountDownLatchI420Buffer) {
        if (data == null) {
            return null;
        }
        ByteBufferHolder byteBufferHolder = this.getPendingBuffer();
        if (byteBufferHolder == null) {
            ++this.abandonFrameCount;
            if (this.abandonFrameCount >= 60) {
                LogUtil.e(TAG, "drop frame > 60 !!! please check Buffer for release");
                this.abandonFrameCount = 0;
            }
            return null;
        }
        this.abandonFrameCount = 0;
        int chromaHeight = (height + 1) / 2;
        int strideUV = (width + 1) / 2;
        int cap = width * height + 2 * strideUV * chromaHeight;
        this.checkReuseByteBuffer(cap, byteBufferHolder);
        ByteBuffer buffer = byteBufferHolder.getByteBuffer();
        data.position(0);
        buffer.position(0);
        if (data.limit() > cap) {
            data.limit(cap);
        }
        buffer.limit(cap);
        buffer.put(data);
        int yPos = 0;
        int uPos = yPos + width * height;
        int vPos = uPos + strideUV * chromaHeight;
        buffer.position(yPos);
        buffer.limit(uPos);
        ByteBuffer bufferY = buffer.slice();
        buffer.position(uPos);
        buffer.limit(vPos);
        ByteBuffer bufferU = buffer.slice();
        buffer.position(vPos);
        buffer.limit(vPos + strideUV * chromaHeight);
        ByteBuffer bufferV = buffer.slice();
        if (useCountDownLatchI420Buffer) {
            return CountDownLatchI420Buffer.wrap(width, height, bufferY, width, bufferU, strideUV, bufferV, strideUV, () -> byteBufferHolder.setPending(false));
        }
        return JavaI420Buffer.wrap(width, height, bufferY, width, bufferU, strideUV, bufferV, strideUV, () -> byteBufferHolder.setPending(false));
    }

    public VideoFrame.I420Buffer convertToJavaI420Buffer(byte[] data, int width, int height, boolean useCountDownLatchI420Buffer) {
        if (data == null) {
            return null;
        }
        ByteBufferHolder byteBufferHolder = this.getPendingBuffer();
        if (byteBufferHolder == null) {
            ++this.abandonFrameCount;
            if (this.abandonFrameCount >= 60) {
                LogUtil.e(TAG, "drop frame > 60 !!! please check Buffer for release ");
                this.abandonFrameCount = 0;
            }
            return null;
        }
        this.abandonFrameCount = 0;
        int chromaHeight = (height + 1) / 2;
        int strideUV = (width + 1) / 2;
        int cap = width * height + 2 * strideUV * chromaHeight;
        this.checkReuseByteBuffer(cap, byteBufferHolder);
        ByteBuffer buffer = byteBufferHolder.getByteBuffer();
        buffer.position(0);
        buffer.limit(cap);
        int length = Math.min(data.length, cap);
        buffer.put(data, 0, length);
        int yPos = 0;
        int uPos = yPos + width * height;
        int vPos = uPos + strideUV * chromaHeight;
        buffer.position(yPos);
        buffer.limit(uPos);
        ByteBuffer bufferY = buffer.slice();
        buffer.position(uPos);
        buffer.limit(vPos);
        ByteBuffer bufferU = buffer.slice();
        buffer.position(vPos);
        buffer.limit(vPos + strideUV * chromaHeight);
        ByteBuffer bufferV = buffer.slice();
        if (useCountDownLatchI420Buffer) {
            return CountDownLatchI420Buffer.wrap(width, height, bufferY, width, bufferU, strideUV, bufferV, strideUV, () -> byteBufferHolder.setPending(false));
        }
        return JavaI420Buffer.wrap(width, height, bufferY, width, bufferU, strideUV, bufferV, strideUV, () -> byteBufferHolder.setPending(false));
    }

    public void checkReuseByteBuffer(int minCap, ByteBufferHolder holder) {
        if (holder.getByteBuffer() == null || holder.getByteBuffer().capacity() < minCap) {
            ByteBuffer buffer = this.isBufferDirect ? ByteBuffer.allocateDirect(minCap) : ByteBuffer.allocate(minCap);
            buffer.order(ByteOrder.nativeOrder());
            holder.setByteBuffer(buffer);
        }
    }

    private ByteBufferHolder getPendingBuffer() {
        for (ByteBufferHolder holder : this.byteBufferPool) {
            if (holder.isPending) continue;
            holder.setPending(true);
            return holder;
        }
        return null;
    }

    protected static class ByteBufferHolder {
        private volatile boolean isPending = false;
        private ByteBuffer byteBuffer;

        protected ByteBufferHolder() {
        }

        public boolean isPending() {
            return this.isPending;
        }

        public void setPending(boolean pending) {
            this.isPending = pending;
        }

        public ByteBuffer getByteBuffer() {
            if (this.byteBuffer != null) {
                this.byteBuffer.clear();
            }
            return this.byteBuffer;
        }

        private void setByteBuffer(ByteBuffer buffer) {
            this.byteBuffer = buffer;
        }

        public byte[] getArray() {
            if (this.byteBuffer != null) {
                this.byteBuffer.clear();
                if (this.byteBuffer.hasArray() && this.byteBuffer.arrayOffset() == 0) {
                    return this.byteBuffer.array();
                }
                byte[] bytes = new byte[this.byteBuffer.remaining()];
                this.byteBuffer.get(bytes, 0, bytes.length);
                return bytes;
            }
            return null;
        }
    }

    private static class I420BufferWrapper {
        private VideoFrame.I420Buffer i420Buffer;
        private boolean needManualRelease;

        public I420BufferWrapper(VideoFrame frame) {
            if (frame.getBuffer() instanceof JavaI420Buffer) {
                this.i420Buffer = (JavaI420Buffer)frame.getBuffer();
                this.needManualRelease = false;
            } else {
                this.i420Buffer = frame.getBuffer().toI420();
                this.needManualRelease = true;
                frame.getBuffer().release();
            }
        }

        public VideoFrame.I420Buffer getBuffer() {
            return this.i420Buffer;
        }

        public void release() {
            if (this.i420Buffer instanceof JavaI420Buffer && this.needManualRelease) {
                this.i420Buffer.release();
            }
        }
    }
}

