/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.handler;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import java.util.concurrent.Executor;

public class AppExecutors {
    private static final AppExecutors INSTANCE = new AppExecutors(new MainThreadExecutor());
    private final Executor mMainThread;

    private AppExecutors(Executor mainThread) {
        this.mMainThread = mainThread;
    }

    public static AppExecutors getInstance() {
        return INSTANCE;
    }

    public Executor mainThread() {
        return this.mMainThread;
    }

    private static class MainThreadExecutor
    implements Executor {
        private Handler mainThreadHandler = new Handler(Looper.getMainLooper());

        private MainThreadExecutor() {
        }

        @Override
        public void execute(@NonNull Runnable command) {
            this.mainThreadHandler.post(command);
        }
    }
}

