/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.handler;

import com.ss.bytertc.engine.IAudioProcessor;
import com.ss.bytertc.engine.data.AudioChannel;
import com.ss.bytertc.engine.data.AudioSampleRate;
import com.ss.bytertc.engine.engineimpl.RTCEngineImpl;
import com.ss.bytertc.engine.engineimpl.RTCVideoImpl;
import com.ss.bytertc.engine.utils.AudioFrameImpl;
import com.ss.bytertc.engine.utils.IAudioFrame;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.webrtc.CalledByNative;

public class NativeAudioProcessor {
    private static final String TAG = "NativeAudioProcesser";
    private WeakReference<RTCEngineImpl> mRtcEngineImpl;
    private WeakReference<RTCVideoImpl> mRtcVideoImpl;

    public NativeAudioProcessor(RTCEngineImpl rtcEngineImpl) {
        this.mRtcEngineImpl = new WeakReference<RTCEngineImpl>(rtcEngineImpl);
    }

    public NativeAudioProcessor(RTCVideoImpl rtcVideoImpl) {
        this.mRtcVideoImpl = new WeakReference<RTCVideoImpl>(rtcVideoImpl);
    }

    @CalledByNative
    int ProcessAudioFrame(IAudioFrame frame) {
        RTCVideoImpl strongVideo;
        IAudioProcessor audioFilter;
        RTCEngineImpl strongEngine;
        if (this.mRtcEngineImpl != null && (strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get()) != null && (audioFilter = strongEngine.getAudioProcessor()) != null) {
            return audioFilter.processAudioFrame(frame);
        }
        if (this.mRtcVideoImpl != null && (strongVideo = (RTCVideoImpl)this.mRtcVideoImpl.get()) != null && (audioFilter = strongVideo.getAudioProcessor()) != null) {
            return audioFilter.processAudioFrame(frame);
        }
        return -1;
    }

    @CalledByNative
    private static IAudioFrame createAudioFrameImpl(ByteBuffer buffer, int samples_per_channel, AudioSampleRate sampleRate, AudioChannel channel) {
        buffer.order(ByteOrder.nativeOrder());
        return new AudioFrameImpl(buffer, samples_per_channel, sampleRate, channel);
    }
}

