/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.handler;

import com.ss.bytertc.engine.InternalAudioVolumeInfo;
import com.ss.bytertc.engine.InternalLocalStreamStats;
import com.ss.bytertc.engine.InternalNetworkQualityInfo;
import com.ss.bytertc.engine.InternalRTCStats;
import com.ss.bytertc.engine.InternalRTCUser;
import com.ss.bytertc.engine.InternalRemoteStreamStats;
import com.ss.bytertc.engine.InternalRemoteStreamSwitch;
import com.ss.bytertc.engine.InternalSourceWantedData;
import com.ss.bytertc.engine.RTCStream;
import com.ss.bytertc.engine.SubscribeConfig;
import com.ss.bytertc.engine.SubscribeState;
import com.ss.bytertc.engine.SysStats;
import com.ss.bytertc.engine.UserInfo;
import com.ss.bytertc.engine.data.AVSyncState;
import com.ss.bytertc.engine.data.AudioMixingError;
import com.ss.bytertc.engine.data.AudioMixingState;
import com.ss.bytertc.engine.data.AudioPlaybackDevice;
import com.ss.bytertc.engine.data.AudioRoute;
import com.ss.bytertc.engine.data.ForwardStreamEventInfo;
import com.ss.bytertc.engine.data.ForwardStreamStateInfo;
import com.ss.bytertc.engine.data.LocalAudioPropertiesInfo;
import com.ss.bytertc.engine.data.LocalAudioStreamError;
import com.ss.bytertc.engine.data.LocalAudioStreamState;
import com.ss.bytertc.engine.data.MuteState;
import com.ss.bytertc.engine.data.RecordingInfo;
import com.ss.bytertc.engine.data.RecordingProgress;
import com.ss.bytertc.engine.data.RemoteAudioPropertiesInfo;
import com.ss.bytertc.engine.data.RemoteAudioState;
import com.ss.bytertc.engine.data.RemoteAudioStateChangeReason;
import com.ss.bytertc.engine.data.RemoteStreamKey;
import com.ss.bytertc.engine.data.StreamIndex;
import com.ss.bytertc.engine.data.StreamSycnInfoConfig;
import com.ss.bytertc.engine.data.VideoFrameInfo;
import com.ss.bytertc.engine.engineimpl.RTCEngineImpl;
import com.ss.bytertc.engine.handler.IRTCEngineEventHandler;
import com.ss.bytertc.engine.type.AudioDeviceType;
import com.ss.bytertc.engine.type.AudioVolumeInfo;
import com.ss.bytertc.engine.type.EchoTestResult;
import com.ss.bytertc.engine.type.FirstFramePlayState;
import com.ss.bytertc.engine.type.FirstFrameSendState;
import com.ss.bytertc.engine.type.LocalStreamStats;
import com.ss.bytertc.engine.type.LocalVideoStreamError;
import com.ss.bytertc.engine.type.LocalVideoStreamState;
import com.ss.bytertc.engine.type.MediaStreamType;
import com.ss.bytertc.engine.type.NetworkDetectionLinkType;
import com.ss.bytertc.engine.type.NetworkDetectionStopReason;
import com.ss.bytertc.engine.type.NetworkQualityStats;
import com.ss.bytertc.engine.type.PerformanceAlarmMode;
import com.ss.bytertc.engine.type.PerformanceAlarmReason;
import com.ss.bytertc.engine.type.RTCRoomStats;
import com.ss.bytertc.engine.type.RangeAudioMode;
import com.ss.bytertc.engine.type.RecordingErrorCode;
import com.ss.bytertc.engine.type.RecordingState;
import com.ss.bytertc.engine.type.RemoteStreamStats;
import com.ss.bytertc.engine.type.RemoteStreamSwitch;
import com.ss.bytertc.engine.type.RemoteVideoState;
import com.ss.bytertc.engine.type.RemoteVideoStateChangeReason;
import com.ss.bytertc.engine.type.RtcUser;
import com.ss.bytertc.engine.type.SEIStreamUpdateEvent;
import com.ss.bytertc.engine.type.SourceWantedData;
import com.ss.bytertc.engine.type.StreamRemoveReason;
import com.ss.bytertc.engine.type.VideoDeviceType;
import com.ss.bytertc.engine.utils.LogUtil;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.CalledByNative;

public class RTCEngineEventHandler {
    private String mRoom;
    private String mUser;
    private String mSession;
    private State mState = State.IDLE;
    private static final String TAG = "RtcEngineEventHandler";
    private static final String WEBRTC_MONITOR_TAG = "live_webrtc_monitor_log";
    private static final String WEBRTC_MEDIA_STAT_KEY = "rtc_media_statistics";
    private static final String WEBRTC_TRANSPORT_STAT_KEY = "rtc_transport_statistics";
    private static final String WEBRTC_STATISTICS_KEY = "rtc_statistics";
    private long mJoinChannelTime = 0L;
    private WeakReference<RTCEngineImpl> mRtcEngineImpl;

    public RTCEngineEventHandler(RTCEngineImpl rtcEngineImpl) {
        this.mRtcEngineImpl = new WeakReference<RTCEngineImpl>(rtcEngineImpl);
    }

    public void setJoinChannelTime(long time) {
        this.mJoinChannelTime = time;
    }

    @CalledByNative
    public void onRoomStateChanged(String roomId, String uid, int state, String extraInfo) {
        LogUtil.d(TAG, "onRoomStateChanged...");
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onRoomStateChanged(roomId, uid, state, extraInfo);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onRoomStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onStreamStateChanged(String roomId, String uid, int state, String extraInfo) {
        LogUtil.d(TAG, "onStreamStateChanged...");
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onStreamStateChanged(roomId, uid, state, extraInfo);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onStreamStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onLeaveRoom(InternalRTCStats stats) {
        LogUtil.d(TAG, "onLeaveChannel...");
    }

    @CalledByNative
    public void onRoomStats(InternalRTCStats stats) {
        LogUtil.d(TAG, "onRtcStats...");
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onRoomStats(new RTCRoomStats(stats));
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onRtcStats callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onSysStats(SysStats stats) {
        LogUtil.e(TAG, "onSysStats... " + stats.toString());
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onSysStats(stats);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onSysStats callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onStreamAdd(RTCStream stream) {
        LogUtil.d(TAG, "onStreamAdd...");
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onStreamAdd(stream);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onStreamAdd callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onStreamSubscribed(int stateCode, String userId, SubscribeConfig info) {
        LogUtil.d(TAG, "onStreamSubscribed...");
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onStreamSubscribed(SubscribeState.values()[stateCode], userId, info);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onStreamSubscribed callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onStreamPublishSuccess(String uid, boolean isScreen) {
        LogUtil.d(TAG, "onStreamPublishSucceed...");
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onStreamPublishSuccess(uid, isScreen);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onStreamPublishSucceed callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserJoined(UserInfo userInfo, int elapsed) {
        LogUtil.d(TAG, "onUserJoined... uid: " + userInfo.getUid() + ", extraInfo: " + userInfo.getExtraInfo() + ", elapsed: " + elapsed);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserJoined(userInfo, elapsed);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserJoined callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserLeave(String uid, int reason) {
        LogUtil.d(TAG, "onUserLeave... uid: " + uid + ", reason: " + reason);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserLeave(uid, reason);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserLeave callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onTokenWillExpire() {
        LogUtil.d(TAG, "onTokenWillExpire");
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onTokenWillExpire();
            }
        }
        catch (Exception exception) {
            LogUtil.e(TAG, "onTokenWillExpire callback catch exception.\n" + exception.getMessage());
        }
    }

    @CalledByNative
    public void onMuteAllRemoteAudio(String uid, MuteState muteState) {
        LogUtil.d(TAG, "onMuteAllRemoteAudio... uid: " + uid + ", muteState: " + muteState.value());
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onMuteAllRemoteAudio(uid, muteState);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onMuteAllRemoteAudio callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onMuteAllRemoteVideo(String uid, MuteState muteState) {
        LogUtil.d(TAG, "onMuteAllRemoteVideo... uid: " + uid + ", muteState: " + (Object)((Object)muteState));
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onMuteAllRemoteVideo(uid, muteState);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onMuteAllRemoteVideo callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserMuteAudio(String uid, MuteState muteState) {
        LogUtil.d(TAG, "onUserMuteAudio... uid: " + uid + ", muteState: " + muteState.value());
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserMuteAudio(uid, muteState);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserMuteAudio callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserMuteVideo(String uid, MuteState muteState) {
        boolean muted = muteState == MuteState.MUTE_STATE_ON;
        LogUtil.d(TAG, "onUserMuteVideo... uid: " + uid + ", muted: " + muted);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserMuteVideo(uid, muteState);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserMuteVideo callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserPublishStream(String uid, int type) {
        LogUtil.d(TAG, "onUserPublishStream... uid: " + uid + ", type: " + type);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserPublishStream(uid, MediaStreamType.valueOf(type));
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserPublishStream callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserUnPublishStream(String uid, int type, int reason) {
        LogUtil.d(TAG, "onUserUnPublishStream... uid: " + uid + ", type: " + type + ", reasen:" + reason);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserUnPublishStream(uid, MediaStreamType.valueOf(type), StreamRemoveReason.values()[reason]);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserUnPublishStream callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserPublishScreen(String uid, int type) {
        LogUtil.d(TAG, "onUserPublishScreen... uid: " + uid + ", type: " + type);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserPublishScreen(uid, MediaStreamType.valueOf(type));
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserPublishScreen callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserUnPublishScreen(String uid, int type, int reason) {
        LogUtil.d(TAG, "onUserUnPublishScreen... uid: " + uid + ", type: " + type + ", reasen:" + reason);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserUnPublishScreen(uid, MediaStreamType.valueOf(type), StreamRemoveReason.values()[reason]);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserUnPublishScreen callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserEnableLocalAudio(String uid, boolean enabled) {
        LogUtil.d(TAG, "onUserEnableLocalAudio... uid: " + uid + ", enabled: " + enabled);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserEnableLocalAudio(uid, enabled);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserEnableLocalAudio callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserStartVideoCapture(String uid) {
        LogUtil.d(TAG, "onUserStartVideoCapture... uid: " + uid);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserStartVideoCapture(uid);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserStartVideoCapture callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserStopVideoCapture(String uid) {
        LogUtil.d(TAG, "onUserStopVideoCapture... uid: " + uid);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserStopVideoCapture(uid);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserStopVideoCapture callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserStartAudioCapture(String uid) {
        LogUtil.d(TAG, "onUserStartAudioCapture... uid: " + uid);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserStartAudioCapture(uid);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserStartAudioCapture callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserStopAudioCapture(String uid) {
        LogUtil.d(TAG, "onUserStopAudioCapture... uid: " + uid);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserStopAudioCapture(uid);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserStopAudioCapture callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onLocalStreamStats(InternalLocalStreamStats stats) {
        LogUtil.d(TAG, "onLocalStreamStats...");
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onLocalStreamStats(new LocalStreamStats(stats));
            }
        }
        catch (Exception e) {
            LogUtil.e(TAG, "onLocalStreamStats callback catch exception.\n" + e.getMessage());
        }
    }

    @CalledByNative
    public void onRemoteStreamStats(InternalRemoteStreamStats stats) {
        LogUtil.d(TAG, "onRemoteStreamStats...");
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                int quality = 0;
                switch (stats.audioStats.quality) {
                    case -1: {
                        quality = 6;
                        break;
                    }
                    case 0: {
                        quality = 5;
                        break;
                    }
                    case 1: {
                        quality = 4;
                        break;
                    }
                    case 2: {
                        quality = 3;
                        break;
                    }
                    case 3: {
                        quality = 2;
                        break;
                    }
                    case 4: {
                        quality = 1;
                        break;
                    }
                }
                stats.audioStats.quality = quality;
                engineEventHandlerRef.onRemoteStreamStats(new RemoteStreamStats(stats));
            }
        }
        catch (Exception e) {
            LogUtil.e(TAG, "onRemoteStreamStats callback catch exception.\n" + e.getMessage());
        }
    }

    @CalledByNative
    public void onLocalAudioStateChanged(LocalAudioStreamState state, LocalAudioStreamError error) {
        LogUtil.d(TAG, "onLocalAudioStateChanged...");
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onLocalAudioStateChanged(state, error);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onLocalAudioStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRemoteAudioStateChanged(RemoteStreamKey key, RemoteAudioState state, RemoteAudioStateChangeReason reason) {
        LogUtil.d(TAG, "onRemoteAudioStateChanged...");
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onRemoteAudioStateChanged(key, state, reason);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onRemoteAudioStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onLocalVideoStateChanged(StreamIndex index, LocalVideoStreamState state, LocalVideoStreamError error) {
        LogUtil.d(TAG, "onLocalVideoStateChanged...");
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onLocalVideoStateChanged(index, state, error);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onLocalVideoStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRemoteVideoStateChanged(RemoteStreamKey streamKey, RemoteVideoState videoState, RemoteVideoStateChangeReason videoStateReason) {
        LogUtil.d(TAG, "onRemoteVideoStateChanged...");
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onRemoteVideoStateChanged(streamKey, videoState, videoStateReason);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onRemoteVideoStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onStreamRemove(RTCStream bs, int reason) {
        LogUtil.d(TAG, "onStreamRemove...uid: " + bs.userId);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onStreamRemove(bs, StreamRemoveReason.values()[reason]);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onStreamRemove callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAudioMixingFinished() {
        LogUtil.d(TAG, "onAudioMixingFinished...");
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onAudioMixingFinished();
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onAudioMixingFinished callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAudioPlaybackDeviceChanged(AudioPlaybackDevice device) {
        LogUtil.d(TAG, "onAudioPlaybackDeviceChanged...device: " + device.value());
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onAudioPlaybackDeviceChanged(device);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onAudioPlaybackDeviceChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAudioRouteChanged(AudioRoute route) {
        LogUtil.d(TAG, "onAudioRouteChanged...route: " + route.value());
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onAudioRouteChanged(route);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onAudioRouteChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onActiveSpeaker(String uid) {
        LogUtil.d(TAG, "onActiveSpeaker...uid: " + uid);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onActiveSpeaker(uid);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onActiveSpeaker callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAudioEffectFinished(int soundId) {
        LogUtil.d(TAG, "onAudioEffectFinished...soundId: " + soundId);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onAudioEffectFinished(soundId);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onAudioEffectFinished callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onError(int errorNum) {
        LogUtil.d(TAG, "onError...errorNum: " + errorNum);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onError(errorNum);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onError callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onWarning(int warnNum) {
        LogUtil.d(TAG, "onWarning, warnNum: " + warnNum);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onWarning(warnNum);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onWarning callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onResponse(String res) {
        LogUtil.d(TAG, "onResponse, res: " + res);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onResponse(res);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onResponse callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onFirstLocalAudioFrame(StreamIndex streamIndex) {
        LogUtil.d(TAG, "onFirstLocalAudioFrame...streamIndex: " + streamIndex.value());
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onFirstLocalAudioFrame(streamIndex);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onFirstLocalAudioFrame callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onFirstRemoteAudioFrame(RemoteStreamKey remoteStreamKey) {
        LogUtil.d(TAG, "onFirstRemoteAudioFrame...uid: " + remoteStreamKey.getUserId() + ", roomid: " + remoteStreamKey.getRoomId() + ", streamIndex: " + remoteStreamKey.getStreamIndex().value());
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onFirstRemoteAudioFrame(remoteStreamKey);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onFirstRemoteAudioFrame callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onFirstLocalVideoFrameCaptured(StreamIndex streamIndex, VideoFrameInfo videoFrameInfo) {
        LogUtil.d(TAG, "onFirstLocalVideoFrame...width: " + videoFrameInfo.getWidth() + ", height: " + videoFrameInfo.getHeight());
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onFirstLocalVideoFrameCaptured(streamIndex, videoFrameInfo);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onFirstLocalVideoFrame callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onFirstRemoteVideoFrameRendered(RemoteStreamKey streamKey, VideoFrameInfo videoFrameInfo) {
        LogUtil.d(TAG, "onFirstRemoteVideoFrameRendered...uid: " + streamKey.getUserId() + ", StreamIndex:" + (Object)((Object)streamKey.getStreamIndex()) + ", width: " + videoFrameInfo.getWidth() + ", height: " + videoFrameInfo.getHeight());
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onFirstRemoteVideoFrameRendered(streamKey, videoFrameInfo);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onFirstRemoteVideoFrameRendered callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onFirstRemoteVideoFrameDecoded(RemoteStreamKey streamKey, VideoFrameInfo videoFrameInfo) {
        LogUtil.d(TAG, "onFirstRemoteVideoFrameDecoded...uid: " + streamKey.getUserId() + ", StreamIndex:" + (Object)((Object)streamKey.getStreamIndex()) + ", width: " + videoFrameInfo.getWidth() + ", height: " + videoFrameInfo.getHeight());
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onFirstRemoteVideoFrameDecoded(streamKey, videoFrameInfo);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onFirstRemoteVideoFrameDecoded callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onLocalVideoSizeChanged(StreamIndex streamIndex, VideoFrameInfo frameInfo) {
        LogUtil.d(TAG, "onLocalVideoSizeChanged... streamIndex: " + (Object)((Object)streamIndex) + ", frameInfo: " + frameInfo);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onLocalVideoSizeChanged(streamIndex, frameInfo);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onLocalVideoSizeChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRemoteVideoSizeChanged(RemoteStreamKey streamKey, VideoFrameInfo frameInfo) {
        LogUtil.d(TAG, "onRemoteVideoSizeChanged... RemoteStreamKey: " + streamKey + ", frameInfo: " + frameInfo);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onRemoteVideoSizeChanged(streamKey, frameInfo);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onRemoteVideoSizeChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAudioVolumeIndication(InternalAudioVolumeInfo[] speakers, int totalRemoteVolume) {
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            AudioVolumeInfo[] speakersInfo = new AudioVolumeInfo[speakers.length];
            for (int index = 0; index < speakers.length; ++index) {
                speakersInfo[index] = new AudioVolumeInfo(speakers[index]);
            }
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onAudioVolumeIndication(speakersInfo, totalRemoteVolume);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onAudioVolumeIndication callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onLogReport(String logType, String logContent) {
        try {
            if (WEBRTC_MONITOR_TAG.equals(logType)) {
                IRTCEngineEventHandler engineEventHandlerRef;
                JSONObject logJson;
                try {
                    logJson = new JSONObject(logContent);
                }
                catch (JSONException exception) {
                    LogUtil.d(TAG, "onLogReport...parse json catch exception: " + exception.getMessage());
                    return;
                }
                RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
                if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                    engineEventHandlerRef.onLogReport(logType, logJson);
                }
                return;
            }
            LogUtil.i(logType, logContent);
            return;
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onLogReport callback catch exception.\n" + ex.getMessage());
            return;
        }
    }

    @CalledByNative
    public void onRoomMessageReceived(String uid, String message) {
        LogUtil.d(TAG, "onRoomMessageReceived: " + message);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onRoomMessageReceived(uid, message);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onRoomMessageReceived callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRoomBinaryMessageReceived(String uid, ByteBuffer message) {
        LogUtil.d(TAG, "onRoomBinaryMessageReceived, length: " + message.capacity());
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onRoomBinaryMessageReceived(uid, message);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onRoomBinaryMessageReceived callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserMessageReceived(String uid, String message) {
        LogUtil.d(TAG, "onUserMessageReceived: " + uid + message);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserMessageReceived(uid, message);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserMessageReceived callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onSEIMessageReceived(RemoteStreamKey key, ByteBuffer msg) {
        LogUtil.d(TAG, "onSEIMessageReceived" + key.getRoomId() + key.getUserId());
        try {
            IRTCEngineEventHandler engineEventHandler;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandler = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandler.onSEIMessageReceived(key, msg);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onSEIMessageReceived callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onSEIStreamUpdate(RemoteStreamKey key, int event) {
        LogUtil.d(TAG, "onSEIStreamUpdate" + key.getRoomId() + key.getUserId());
        try {
            IRTCEngineEventHandler engineEventHandler;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandler = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandler.onSEIStreamUpdate(key, SEIStreamUpdateEvent.values()[event]);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onSEIStreamUpdate callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserBinaryMessageReceived(String uid, ByteBuffer message) {
        LogUtil.d(TAG, "onUserBinaryMessageReceived: " + uid + message.capacity());
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserBinaryMessageReceived(uid, message);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserBinaryMessageReceived callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserMessageSendResult(long msgid, int error) {
        LogUtil.d(TAG, "onUserMessageSendResult: " + msgid + error);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserMessageSendResult(msgid, error);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserMessageSendResult callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRoomMessageSendResult(long msgid, int error) {
        LogUtil.d(TAG, "onRoomMessageSendResult: " + msgid + error);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onRoomMessageSendResult(msgid, error);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onRoomMessageSendResult callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onLoginResult(String uid, int error_code, int elapsed) {
        LogUtil.d(TAG, "OnLoginResult: " + uid + error_code + elapsed);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onLoginResult(uid, error_code, elapsed);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onLoginResult callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onLogout() {
        LogUtil.d(TAG, "onLogout");
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onLogout();
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onLogout callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onServerParamsSetResult(int error) {
        LogUtil.d(TAG, "onServerParamsSetResult: " + error);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onServerParamsSetResult(error);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onServerParamsSetResult callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onGetPeerOnlineStatus(String peerUserId, int status) {
        LogUtil.d(TAG, "onGetPeerOnlineStatus: " + peerUserId + status);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onGetPeerOnlineStatus(peerUserId, status);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onGetPeerOnlineStatus callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserMessageReceivedOutsideRoom(String uid, String message) {
        LogUtil.d(TAG, "onUserMessageReceivedOutsideRoom: " + uid + message);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserMessageReceivedOutsideRoom(uid, message);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserMessageReceivedOutsideRoom callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserBinaryMessageReceivedOutsideRoom(String uid, ByteBuffer message) {
        LogUtil.d(TAG, "onUserBinaryMessageReceivedOutsideRoom: " + uid + message.capacity());
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserBinaryMessageReceivedOutsideRoom(uid, message);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserBinaryMessageReceivedOutsideRoom callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserMessageSendResultOutsideRoom(long msgid, int error) {
        LogUtil.d(TAG, "onUserMessageSendResultOutsideRoom: " + msgid + error);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserMessageSendResultOutsideRoom(msgid, error);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserMessageSendResultOutsideRoom callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onServerMessageSendResult(long msgid, int error, ByteBuffer message) {
        LogUtil.d(TAG, "onServerMessageSendResult: " + msgid + error);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onServerMessageSendResult(msgid, error, message);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onServerMessageSendResult callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onNetworkProbeResult(int type, int quality, int rtt, double lost_rate, int bitrate, int jitter) {
        LogUtil.d(TAG, "onNetworkProbeResult: " + type + "," + quality + "," + rtt + "," + lost_rate + "," + bitrate + "," + jitter);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onNetworkDetectionResult(NetworkDetectionLinkType.values()[type], quality, rtt, lost_rate, bitrate, jitter);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onNetworkDetectionResult callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onNetworkProbeStopped(int err_code) {
        LogUtil.d(TAG, "onNetworkProbeStopped: " + err_code);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onNetworkDetectionStopped(NetworkDetectionStopReason.values()[err_code]);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onNetworkDetectionStopped callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onConnectionStateChanged(int state) {
        LogUtil.i(TAG, "onConnectionStateChanged, state: " + state);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onConnectionStateChanged(state, -1);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onConnectionStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onNetworkTypeChanged(int type) {
        LogUtil.i(TAG, "onNetworkTypeChanged, type: " + type);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onNetworkTypeChanged(type);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onNetworkTypeChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onPerformanceAlarms(int mode, String roomId, int reason, InternalSourceWantedData data) {
        LogUtil.d(TAG, "onPerformanceAlarms, level: " + reason + ", data: " + data);
        try {
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null) {
                PerformanceAlarmReason level;
                switch (reason) {
                    case 0: {
                        level = PerformanceAlarmReason.PERFORMANCE_ALARM_REASON_BANDWIDTH_FALLBACKED;
                        break;
                    }
                    case 1: {
                        level = PerformanceAlarmReason.PERFORMANCE_ALARM_REASON_BANDWIDTH_RESUMED;
                        break;
                    }
                    case 2: {
                        level = PerformanceAlarmReason.PERFORMANCE_ALARM_REASON_PERFORMANCE_FALLBACKED;
                        break;
                    }
                    case 3: {
                        level = PerformanceAlarmReason.PERFORMANCE_ALARM_REASON_PERFORMANCE_RESUMED;
                        break;
                    }
                    default: {
                        level = PerformanceAlarmReason.PERFORMANCE_ALARM_REASON_PERFORMANCE_RESUMED;
                    }
                }
                IRTCEngineEventHandler engineEventHandlerRef = strongEngine.getRtcEngineHandler();
                if (engineEventHandlerRef != null) {
                    engineEventHandlerRef.onPerformanceAlarms(mode == 0 ? PerformanceAlarmMode.PERFORMANCE_ALARM_MODE_NORMAL : PerformanceAlarmMode.PERFORMANCE_ALARM_MODE_SIMULCAST, roomId, level, new SourceWantedData(data));
                }
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onPerformanceAlarms callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onSubscribe(String uid, boolean isReconnect) {
        LogUtil.d(TAG, "onSubscribe, uesr_id: " + uid + ", isReconnect: " + isReconnect);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onSubscribe(uid, isReconnect);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onSubsribe callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUnSubscribe(String uid, boolean isReconnect) {
        LogUtil.d(TAG, "onUnSubscribe, uesr_id: " + uid + ", isReconnect: " + isReconnect);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUnSubscribe(uid, isReconnect);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUnSubscribe callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRemoteUserAudioSendModeChange(String uid, int mode) {
        LogUtil.d(TAG, "remote user audio send mode change: " + mode);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onRemoteUserAudioSendModeChange(uid, RangeAudioMode.values()[mode]);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onRemoteUserAudioSendModeChange callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRemoteUserAudioRecvModeChange(String uid, int mode) {
        LogUtil.d(TAG, "remote user audio recv mode change: " + mode);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onRemoteUserAudioRecvModeChange(uid, RangeAudioMode.values()[mode]);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onRemoteUserAudioRecvModeChange callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onSimulcastSubscribeFallback(InternalRemoteStreamSwitch event) {
        LogUtil.d(TAG, "onSimulcastSubscribeFallback, uid: " + event.uid + ", isScreen: " + event.isScreen + ", before_video_index: " + event.before_video_index + ", after_video_index: " + event.after_video_index + ", before_enable: " + event.before_enable + ", after_enable: " + event.after_enable + ", reason: " + event.reason);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onSimulcastSubscribeFallback(new RemoteStreamSwitch(event));
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onRemoteStreamSwitch callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public static ByteBuffer allocateDirectByteBuffer(int capacity) {
        return ByteBuffer.allocateDirect(capacity);
    }

    @CalledByNative
    public void onMediaDeviceStateChanged(String device_id, int device_type, int device_state, int device_error) {
        LogUtil.d(TAG, "onMediaDeviceStateChanged, MediaDeviceType: " + device_type + ", device_state: " + device_state);
        try {
            IRTCEngineEventHandler handler;
            RTCEngineImpl rtcEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (rtcEngine != null && (handler = rtcEngine.getRtcEngineHandler()) != null) {
                handler.onMediaDeviceStateChanged(device_id, device_type, device_state, device_error);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onMediaDeviceStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAudioDeviceStateChanged(String device_id, AudioDeviceType device_type, int device_state, int device_error) {
        LogUtil.d(TAG, "onAudioDeviceStateChanged, AudioDeviceType: " + (Object)((Object)device_type) + ", device_state: " + device_state);
        try {
            IRTCEngineEventHandler handler;
            RTCEngineImpl rtcEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (rtcEngine != null && (handler = rtcEngine.getRtcEngineHandler()) != null) {
                handler.onAudioDeviceStateChanged(device_id, device_type, device_state, device_error);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onAudioDeviceStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onVideoDeviceStateChanged(String device_id, VideoDeviceType device_type, int device_state, int device_error) {
        LogUtil.d(TAG, "onVideoDeviceStateChanged, VideoDeviceType: " + (Object)((Object)device_type) + ", device_state: " + device_state);
        try {
            IRTCEngineEventHandler handler;
            RTCEngineImpl rtcEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (rtcEngine != null && (handler = rtcEngine.getRtcEngineHandler()) != null) {
                handler.onVideoDeviceStateChanged(device_id, device_type, device_state, device_error);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onVideoDeviceStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onMediaDeviceWarning(String device_id, int device_type, int device_warning) {
        LogUtil.d(TAG, "onMediaDeviceWarning, MediaDeviceType: " + device_type + ", device_warning " + device_warning);
        try {
            IRTCEngineEventHandler handler;
            RTCEngineImpl rtcEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (rtcEngine != null && (handler = rtcEngine.getRtcEngineHandler()) != null) {
                handler.onMediaDeviceWarning(device_id, device_type, device_warning);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onMediaDeviceWarning callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAudioDeviceWarning(String device_id, AudioDeviceType device_type, int device_warning) {
        LogUtil.d(TAG, "onAudioDeviceWarning, AudioDeviceType: " + (Object)((Object)device_type) + ", device_warning " + device_warning);
        try {
            IRTCEngineEventHandler handler;
            RTCEngineImpl rtcEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (rtcEngine != null && (handler = rtcEngine.getRtcEngineHandler()) != null) {
                handler.onAudioDeviceWarning(device_id, device_type, device_warning);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onAudioDeviceWarning callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onVideoDeviceWarning(String device_id, VideoDeviceType device_type, int device_warning) {
        LogUtil.d(TAG, "onVideoDeviceWarning, VideoDeviceType: " + (Object)((Object)device_type) + ", device_warning " + device_warning);
        try {
            IRTCEngineEventHandler handler;
            RTCEngineImpl rtcEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (rtcEngine != null && (handler = rtcEngine.getRtcEngineHandler()) != null) {
                handler.onVideoDeviceWarning(device_id, device_type, device_warning);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onVideoDeviceWarning callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAudioFrameSendStateChanged(InternalRTCUser user, int state) {
        LogUtil.d(TAG, "onAudioFrameSendStateChanged, user: " + user + ", state: " + state);
        FirstFrameSendState sendState = FirstFrameSendState.FIRST_FRAME_SEND_STATE_SENDING;
        switch (state) {
            case 0: {
                sendState = FirstFrameSendState.FIRST_FRAME_SEND_STATE_SENDING;
                break;
            }
            case 1: {
                sendState = FirstFrameSendState.FIRST_FRAME_SEND_STATE_SENT;
                break;
            }
            case 2: {
                sendState = FirstFrameSendState.FIRST_FRAME_SEND_STAT_END;
                break;
            }
        }
        try {
            IRTCEngineEventHandler handler;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (handler = strongEngine.getRtcEngineHandler()) != null) {
                handler.onAudioFrameSendStateChanged(new RtcUser(user), sendState);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onAudioFrameSendStateChanged callback catch exception.\n");
        }
    }

    @CalledByNative
    public void onVideoFrameSendStateChanged(InternalRTCUser user, int state) {
        LogUtil.d(TAG, "onVideoFrameSendStateChanged, user: " + user + ", state: " + state);
        FirstFrameSendState sendState = FirstFrameSendState.FIRST_FRAME_SEND_STATE_SENDING;
        switch (state) {
            case 0: {
                sendState = FirstFrameSendState.FIRST_FRAME_SEND_STATE_SENDING;
                break;
            }
            case 1: {
                sendState = FirstFrameSendState.FIRST_FRAME_SEND_STATE_SENT;
                break;
            }
            case 2: {
                sendState = FirstFrameSendState.FIRST_FRAME_SEND_STAT_END;
                break;
            }
        }
        try {
            IRTCEngineEventHandler handler;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (handler = strongEngine.getRtcEngineHandler()) != null) {
                handler.onVideoFrameSendStateChanged(new RtcUser(user), sendState);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onVideoFrameSendStateChanged callback catch exception.\n");
        }
    }

    @CalledByNative
    public void onScreenVideoFrameSendStateChanged(InternalRTCUser user, int state) {
        LogUtil.d(TAG, "onScreenVideoFrameSendStateChanged, user: " + user + ", state: " + state);
        FirstFrameSendState sendState = FirstFrameSendState.FIRST_FRAME_SEND_STATE_SENDING;
        switch (state) {
            case 0: {
                sendState = FirstFrameSendState.FIRST_FRAME_SEND_STATE_SENDING;
                break;
            }
            case 1: {
                sendState = FirstFrameSendState.FIRST_FRAME_SEND_STATE_SENT;
                break;
            }
            case 2: {
                sendState = FirstFrameSendState.FIRST_FRAME_SEND_STAT_END;
                break;
            }
        }
        try {
            IRTCEngineEventHandler handler;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (handler = strongEngine.getRtcEngineHandler()) != null) {
                handler.onScreenVideoFrameSendStateChanged(new RtcUser(user), sendState);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onScreenVideoFrameSendStateChanged callback catch exception.\n");
        }
    }

    @CalledByNative
    public void onAudioFramePlayStateChanged(InternalRTCUser user, int state) {
        LogUtil.d(TAG, "onAudioFramePlayStateChanged, user: " + user + ", state: " + state);
        FirstFramePlayState playState = FirstFramePlayState.FIRST_FRAME_PLAY_STATE_PLAYING;
        switch (state) {
            case 0: {
                playState = FirstFramePlayState.FIRST_FRAME_PLAY_STATE_PLAYING;
                break;
            }
            case 1: {
                playState = FirstFramePlayState.FIRST_FRAME_PLAY_STATE_PLAYED;
                break;
            }
            case 2: {
                playState = FirstFramePlayState.FIRST_FRAME_PLAY_STATE_END;
                break;
            }
        }
        try {
            IRTCEngineEventHandler handler;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (handler = strongEngine.getRtcEngineHandler()) != null) {
                handler.onAudioFramePlayStateChanged(new RtcUser(user), playState);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onAudioFramePlayStateChanged callback catch exception.\n");
        }
    }

    @CalledByNative
    public void onVideoFramePlayStateChanged(InternalRTCUser user, int state) {
        LogUtil.d(TAG, "onVideoFramePlayStateChanged, user: " + user + ", state: " + state);
        FirstFramePlayState playState = FirstFramePlayState.FIRST_FRAME_PLAY_STATE_PLAYING;
        switch (state) {
            case 0: {
                playState = FirstFramePlayState.FIRST_FRAME_PLAY_STATE_PLAYING;
                break;
            }
            case 1: {
                playState = FirstFramePlayState.FIRST_FRAME_PLAY_STATE_PLAYED;
                break;
            }
            case 2: {
                playState = FirstFramePlayState.FIRST_FRAME_PLAY_STATE_END;
                break;
            }
        }
        try {
            IRTCEngineEventHandler handler;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (handler = strongEngine.getRtcEngineHandler()) != null) {
                handler.onVideoFramePlayStateChanged(new RtcUser(user), playState);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onVideoFramePlayStateChanged callback catch exception.\n");
        }
    }

    @CalledByNative
    public void onScreenVideoFramePlayStateChanged(InternalRTCUser user, int state) {
        LogUtil.d(TAG, "onScreenVideoFramePlayStateChanged, user: " + user + ", state: " + state);
        FirstFramePlayState playState = FirstFramePlayState.FIRST_FRAME_PLAY_STATE_PLAYING;
        switch (state) {
            case 0: {
                playState = FirstFramePlayState.FIRST_FRAME_PLAY_STATE_PLAYING;
                break;
            }
            case 1: {
                playState = FirstFramePlayState.FIRST_FRAME_PLAY_STATE_PLAYED;
                break;
            }
            case 2: {
                playState = FirstFramePlayState.FIRST_FRAME_PLAY_STATE_END;
                break;
            }
        }
        try {
            IRTCEngineEventHandler handler;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (handler = strongEngine.getRtcEngineHandler()) != null) {
                handler.onScreenVideoFramePlayStateChanged(new RtcUser(user), playState);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onScreenVideoFramePlayStateChanged callback catch exception.\n");
        }
    }

    @CalledByNative
    public void onHttpProxyState(int state) {
        LogUtil.i(TAG, "onHttpProxyState, state: " + state);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onHttpProxyState(state);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onHttpProxyState callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onHttpsProxyState(int state) {
        LogUtil.i(TAG, "onHttpsProxyState, state: " + state);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onHttpsProxyState(state);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onHttpsProxyState callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onSocks5ProxyState(int state, String cmd, String proxy_address, String local_address, String remote_address) {
        LogUtil.i(TAG, "onSocks5ProxyState, state: " + state + ", cmd: " + cmd + ", proxy_address: " + proxy_address + ", local_address: " + local_address + ", remote_address: " + remote_address);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onSocks5ProxyState(state, cmd, proxy_address, local_address, remote_address);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onSocks5ProxyState callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRecordingStateUpdate(StreamIndex type, int state, int errorCode, RecordingInfo info) {
        LogUtil.d(TAG, "onRecordingStateUpdate, StreamIndex: " + (Object)((Object)type) + ", RecordingState: " + state + ", RecordingErrorCode: " + errorCode + ", info.filePath: " + info.filePath);
        try {
            IRTCEngineEventHandler handler;
            RTCEngineImpl rtcEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (rtcEngine != null && (handler = rtcEngine.getRtcEngineHandler()) != null) {
                handler.onRecordingStateUpdate(type, RecordingState.fromId(state), RecordingErrorCode.fromId(errorCode), info);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onRecordingStateUpdate callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRecordingProgressUpdate(StreamIndex type, RecordingProgress progress, RecordingInfo info) {
        LogUtil.d(TAG, "onRecordingProgressUpdate, StreamIndex: " + (Object)((Object)type) + ", progress.dur: " + progress.duration + ", progress.fileSize: " + progress.fileSize + ", info.filePath: " + info.filePath);
        try {
            IRTCEngineEventHandler handler;
            RTCEngineImpl rtcEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (rtcEngine != null && (handler = rtcEngine.getRtcEngineHandler()) != null) {
                handler.onRecordingProgressUpdate(type, progress, info);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onRecordingProgressUpdate callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAudioMixingStateChanged(int mixId, AudioMixingState state, AudioMixingError error) {
        LogUtil.d(TAG, "onAudioMixingStateChanged... mixId: " + mixId + ", state: " + state.value() + ", error: " + error.value());
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onAudioMixingStateChanged(mixId, state, error);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onAudioMixingStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAVSyncStateChange(AVSyncState state) {
        LogUtil.d(TAG, "onAVSyncStateChange state: " + state.value());
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onAVSyncStateChange(state);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onAudioMixingStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAudioMixingPlayingProgress(int mixId, long progress) {
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onAudioMixingPlayingProgress(mixId, progress);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onAudioMixingPlayingProgress callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onVideoStreamBanned(String user, boolean banned) {
        LogUtil.d(TAG, "onVideoStreamBanned, user: " + user + ", banned: " + (banned ? "true" : "false"));
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onVideoStreamBanned(user, banned);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onVideoStreamBanned callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAudioStreamBanned(String user, boolean banned) {
        LogUtil.d(TAG, "onAudioStreamBanned, user: " + user + ", banned: " + (banned ? "true" : "false"));
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onAudioStreamBanned(user, banned);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onAudioStreamBanned callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onLocalAudioPropertiesReport(LocalAudioPropertiesInfo[] audioPropertiesInfos) {
        LogUtil.d(TAG, "onLocalAudioPropertiesReport");
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onLocalAudioPropertiesReport(audioPropertiesInfos);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onLocalAudioPropertiesReport callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAudioPlaybackDeviceTestVolume(int volume) {
        LogUtil.d(TAG, "onAudioPlaybackDeviceTestVolume");
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onAudioPlaybackDeviceTestVolume(volume);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onAudioPlaybackDeviceTestVolume callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRemoteAudioPropertiesReport(RemoteAudioPropertiesInfo[] audio_properties_infos, int totalRemoteVolume) {
        LogUtil.d(TAG, "onRemoteAudioPropertiesReport");
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onRemoteAudioPropertiesReport(audio_properties_infos, totalRemoteVolume);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onRemoteAudioPropertiesReport callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onActiveSpeaker(String roomId, String uid) {
        LogUtil.d(TAG, "onActiveSpeaker");
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onActiveSpeaker(roomId, uid);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onActiveSpeaker callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onStreamSyncInfoReceived(RemoteStreamKey streamKey, ByteBuffer data, int streamType) {
        LogUtil.d(TAG, "onStreamSyncInfoReceived");
        try {
            IRTCEngineEventHandler engineEventHandler;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandler = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandler.onStreamSyncInfoReceived(streamKey, StreamSycnInfoConfig.SyncInfoStreamType.SYNC_INFO_STREAM_TYPE_AUDIO, data);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onStreamSyncInfoReceived callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onForwardStreamStateChanged(ForwardStreamStateInfo[] stateInfos) {
        LogUtil.d(TAG, "OnForwardStreamStateChanged");
        try {
            IRTCEngineEventHandler engineEventHandler;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandler = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandler.onForwardStreamStateChanged(stateInfos);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "OnForwardStreamStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onForwardStreamEvent(ForwardStreamEventInfo[] eventInfos) {
        LogUtil.d(TAG, "OnForwardStreamEvent");
        try {
            IRTCEngineEventHandler engineEventHandler;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandler = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandler.onForwardStreamEvent(eventInfos);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "OnForwardStreamEvent callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onNetworkQuality(InternalNetworkQualityInfo lQuality, InternalNetworkQualityInfo[] rQualities) {
        LogUtil.d(TAG, "Local onNetworkQuality, uid: " + lQuality.uid + ", info: " + lQuality.toString());
        try {
            IRTCEngineEventHandler engineEventHandler;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandler = strongEngine.getRtcEngineHandler()) != null) {
                NetworkQualityStats[] remoteQualities = new NetworkQualityStats[rQualities.length];
                for (int i = 0; i < rQualities.length; ++i) {
                    LogUtil.d(TAG, "Remote onNetworkQuality, uid: " + rQualities[i].uid + ", info: " + rQualities[i].toString());
                    remoteQualities[i] = new NetworkQualityStats(rQualities[i]);
                }
                engineEventHandler.onNetworkQuality(new NetworkQualityStats(lQuality), remoteQualities);
            }
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onNetworkQuality callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onPushPublicStreamResult(String publicStreamId, int errorCode) {
        int code = errorCode;
        LogUtil.d(TAG, "onPushPublicStreamError error(" + code + ") streamId:" + publicStreamId);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onPushPublicStreamResult(publicStreamId, code);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onPushPublicStreamError callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onPlayPublicStreamResult(String publicStreamId, int errorCode) {
        int code = errorCode;
        LogUtil.d(TAG, "onPlayPublicStreamError error(" + code + ") streamId:" + publicStreamId);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onPlayPublicStreamResult(publicStreamId, code);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onPlayPublicStreamError callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onPublicStreamSEIMessageReceived(String publicStreamId, ByteBuffer msg) {
        LogUtil.d(TAG, "onPublicStreamSEIMessageReceived, streamid" + publicStreamId);
        try {
            IRTCEngineEventHandler engineEventHandler;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandler = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandler.onPublicStreamSEIMessageReceived(publicStreamId, msg);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onPublicStreamSEIMessageReceived callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onFirstPublicStreamVideoFrameDecoded(String publicStreamId, VideoFrameInfo videoFrameInfo) {
        LogUtil.d(TAG, "onFirstPublicStreamVideoFrameDecoded...streamid: " + publicStreamId + ", width: " + videoFrameInfo.getWidth() + ", height: " + videoFrameInfo.getHeight());
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onFirstPublicStreamVideoFrameDecoded(publicStreamId, videoFrameInfo);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onFirstPublicStreamVideoFrameDecoded callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onFirstPublicStreamAudioFrame(String publicStreamId) {
        LogUtil.d(TAG, "onFirstPublicStreamAudioFrame...streamid: " + publicStreamId);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onFirstPublicStreamAudioFrame(publicStreamId);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onFirstPublicStreamAudioFrame callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onCloudProxyConnected(int interval) {
        LogUtil.i(TAG, "onCloudProxyConnected, interval: " + interval);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onCloudProxyConnected(interval);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onCloudProxyConnected callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onEchoTestResult(int errorCode) {
        LogUtil.d(TAG, "onEchoTestResult...error code: " + errorCode);
        try {
            IRTCEngineEventHandler engineEventHandlerRef;
            RTCEngineImpl strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                EchoTestResult result = EchoTestResult.ECHO_TEST_SUCCESS;
                switch (errorCode) {
                    case 1: {
                        result = EchoTestResult.ECHO_TEST_TIMEOUT;
                        break;
                    }
                    case 2: {
                        result = EchoTestResult.ECHO_TEST_INTERVAL_SHORT;
                        break;
                    }
                    case 3: {
                        result = EchoTestResult.ECHO_TEST_AUDIO_DEVICE_ERROR;
                        break;
                    }
                    case 4: {
                        result = EchoTestResult.ECHO_TEST_VIDEO_DEVICE_ERROR;
                        break;
                    }
                    case 5: {
                        result = EchoTestResult.ECHO_TEST_AUDIO_RECEIVE_ERROR;
                        break;
                    }
                    case 6: {
                        result = EchoTestResult.ECHO_TEST_VIDEO_RECEIVE_ERROR;
                        break;
                    }
                    case 7: {
                        result = EchoTestResult.ECHO_TEST_INTERNAL_ERROR;
                        break;
                    }
                }
                engineEventHandlerRef.onEchoTestResult(result);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onEchoTestResult callback catch exception.\n" + ex.getMessage());
        }
    }

    private static enum State {
        IDLE,
        IN_ROOM;

    }
}

