/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.live;

import com.ss.bytertc.engine.live.ByteRTCStreamMixingType;
import com.ss.bytertc.engine.utils.LogUtil;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.CalledByNative;

public class LiveTranscoding {
    private static final String TAG = "LiveTranscoding";
    private String url;
    private String action = "";
    private ByteRTCStreamMixingType mixType = ByteRTCStreamMixingType.STREAM_MIXING_BY_SERVER;
    private VideoConfig video;
    private AudioConfig audio;
    private Layout layout;
    private JSONObject advancedConfig;
    private String roomId;
    private String userId;
    private JSONObject authInfo;
    public static final String ACTION_START = "started";
    public static final String ACTION_CHANGED = "layoutChanged";
    public static final String ACTION_STOPPED = "stopped";

    @CalledByNative
    public String getFieldUrl() {
        return this.url == null ? "" : this.url;
    }

    @CalledByNative
    public String getFieldAction() {
        return this.action == null ? "" : this.action;
    }

    @CalledByNative
    public int getFieldMixType() {
        return this.mixType.value();
    }

    @CalledByNative
    public String getFieldRoomId() {
        return this.roomId == null ? "" : this.roomId;
    }

    @CalledByNative
    public String getFieldUserId() {
        return this.userId == null ? "" : this.userId;
    }

    @CalledByNative
    public String getFieldAdvancedConfig() {
        return this.advancedConfig == null ? "" : this.advancedConfig.toString();
    }

    @CalledByNative
    public String getFieldAuthInfo() {
        return this.authInfo == null ? "" : this.authInfo.toString();
    }

    @CalledByNative
    public String getFieldVideoConfigCodec() {
        return this.video == null ? "" : (this.video.codec == null ? "" : this.video.codec);
    }

    @CalledByNative
    public int getFieldVideoConfigBitrate() {
        return this.video == null ? 0 : this.video.bitRate;
    }

    @CalledByNative
    public int getFieldVideoConfigFps() {
        return this.video == null ? 0 : this.video.fps;
    }

    @CalledByNative
    public int getFieldVideoConfigGop() {
        return this.video == null ? 0 : this.video.gop;
    }

    @CalledByNative
    public int getFieldVideoConfigHeight() {
        return this.video == null ? 0 : this.video.height;
    }

    @CalledByNative
    public int getFieldVideoConfigWidth() {
        return this.video == null ? 0 : this.video.width;
    }

    @CalledByNative
    public boolean getFieldVideoConfigLowLatency() {
        return this.video == null ? false : this.video.lowLatency;
    }

    @CalledByNative
    public String getFieldAudioConfigAacProfile() {
        return this.audio == null ? "" : (this.audio.aacProfile == null ? "" : this.audio.aacProfile);
    }

    @CalledByNative
    public String getFieldAudioConfigCodec() {
        return this.audio == null ? "" : (this.audio.codec == null ? "" : this.audio.codec);
    }

    @CalledByNative
    public int getFieldAudioConfigBitrate() {
        return this.audio == null ? 0 : this.audio.bitRate;
    }

    @CalledByNative
    public int getFieldAudioConfigSampleRate() {
        return this.audio == null ? 0 : this.audio.sampleRate;
    }

    @CalledByNative
    public int getFieldAudioConfigChannels() {
        return this.audio == null ? 0 : this.audio.channels;
    }

    @CalledByNative
    public Region[] getFieldLayoutRegions() {
        return this.layout == null ? null : this.layout.regions;
    }

    @CalledByNative
    public String getFieldLayoutAppData() {
        return this.layout == null ? "" : (this.layout.appData == null ? "" : this.layout.appData);
    }

    @CalledByNative
    public String getFieldLayoutBackgroundColor() {
        return this.layout == null ? "" : (this.layout.backgroundColor == null ? "" : this.layout.backgroundColor);
    }

    @CalledByNative
    public String getFieldLayoutRegionUid(Region region) {
        return region == null ? "" : (region.uid == null ? "" : region.uid);
    }

    @CalledByNative
    public String getFieldLayoutRegionRoomId(Region region) {
        return region == null ? "" : (region.roomId == null ? "" : region.roomId);
    }

    @CalledByNative
    public double getFieldLayoutRegionX(Region region) {
        return region == null ? 0.0 : region.x;
    }

    @CalledByNative
    public double getFieldLayoutRegionY(Region region) {
        return region == null ? 0.0 : region.y;
    }

    @CalledByNative
    public double getFieldLayoutRegionW(Region region) {
        return region == null ? 0.0 : region.w;
    }

    @CalledByNative
    public double getFieldLayoutRegionH(Region region) {
        return region == null ? 0.0 : region.h;
    }

    @CalledByNative
    public int getFieldLayoutRegionZorder(Region region) {
        return region == null ? 0 : region.zorder;
    }

    @CalledByNative
    public double getFieldLayoutRegionAlpha(Region region) {
        return region == null ? 0.0 : region.alpha;
    }

    @CalledByNative
    public int getFieldLayoutRegionContentControl(Region region) {
        return region == null ? 0 : region.contentControl.getValue();
    }

    @CalledByNative
    public int getFieldLayoutRegionRenderMode(Region region) {
        return region == null ? 0 : region.renderMode.getValue();
    }

    @CalledByNative
    public boolean getFieldLayoutRegionLocalUser(Region region) {
        return region == null ? false : region.localUser;
    }

    @CalledByNative
    public boolean getFieldLayoutRegionScreenStream(Region region) {
        return region == null ? false : region.screenStream;
    }

    @CalledByNative
    public int getFieldLayoutRegionType(Region region) {
        return region == null ? 0 : region.type.getValue();
    }

    @CalledByNative
    public byte[] getFieldLayoutRegionData(Region region) {
        return region == null ? null : region.data;
    }

    @CalledByNative
    public int getFieldLayoutRegionDataParamImageWidth(Region region) {
        return region == null ? 0 : region.dataParam.imageWidth;
    }

    @CalledByNative
    public int getFieldLayoutRegionDataParamImageHeight(Region region) {
        return region == null ? 0 : region.dataParam.imageHeight;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setRoomId(String roomId) {
        this.roomId = roomId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setVideo(VideoConfig video) {
        this.video = video;
    }

    public void setAudio(AudioConfig audio) {
        this.audio = audio;
    }

    public void setLayout(Layout layout) {
        this.layout = layout;
    }

    public void setAdvancedConfig(JSONObject advancedConfig) {
        this.advancedConfig = advancedConfig;
    }

    public void setAuthInfo(JSONObject authInfo) {
        this.authInfo = authInfo;
    }

    public ByteRTCStreamMixingType getMixType() {
        return this.mixType;
    }

    public void setMixType(ByteRTCStreamMixingType mixType) {
        this.mixType = mixType;
    }

    public String getUrl() {
        return this.url;
    }

    public VideoConfig getVideo() {
        return this.video;
    }

    public AudioConfig getAudio() {
        return this.audio;
    }

    public Layout getLayout() {
        return this.layout;
    }

    public JSONObject getTranscodeMessage() {
        JSONObject videoConfigJson = new JSONObject();
        JSONObject audioConfigJson = new JSONObject();
        JSONObject layoutJson = new JSONObject();
        JSONObject canvasJson = new JSONObject();
        JSONArray regionsJson = new JSONArray();
        JSONObject urlJson = new JSONObject();
        JSONObject transcodeMeta = new JSONObject();
        JSONObject liveTranscodeJson = new JSONObject();
        try {
            videoConfigJson.put("codec", (Object)this.video.codec);
            videoConfigJson.put("fps", this.video.fps);
            videoConfigJson.put("gop", this.video.gop);
            videoConfigJson.put("lowLatency", this.video.lowLatency);
            videoConfigJson.put("bitRate", this.video.bitRate);
            videoConfigJson.put("width", this.video.width);
            videoConfigJson.put("height", this.video.height);
            audioConfigJson.put("codec", (Object)this.audio.codec);
            audioConfigJson.put("bitRate", this.audio.bitRate);
            audioConfigJson.put("sampleRate", this.audio.sampleRate);
            audioConfigJson.put("channels", this.audio.channels);
            audioConfigJson.put("profile", (Object)this.audio.aacProfile);
            canvasJson.put("bgnd", (Object)this.layout.backgroundColor);
            if (this.layout.regions != null) {
                for (Region region : this.layout.regions) {
                    JSONObject regionJson = new JSONObject();
                    regionJson.put("uid", (Object)region.uid);
                    regionJson.put("roomID", (Object)region.roomId);
                    regionJson.put("x", region.x);
                    regionJson.put("y", region.y);
                    regionJson.put("w", region.w);
                    regionJson.put("h", region.h);
                    regionJson.put("zorder", region.zorder);
                    regionJson.put("alpha", region.alpha);
                    regionJson.put("contentControl", (Object)region.contentControl);
                    regionJson.put("renderMode", (Object)region.renderMode);
                    regionJson.put("local_user", region.localUser);
                    regionJson.put("screen", region.screenStream);
                    regionsJson.put((Object)regionJson);
                }
            }
            layoutJson.put("canvas", (Object)canvasJson);
            layoutJson.put("regions", (Object)regionsJson);
            layoutJson.put("app_data", (Object)this.layout.appData);
            urlJson.put("url", (Object)this.url);
            transcodeMeta.put("transcode", (Object)urlJson);
            transcodeMeta.put("video", (Object)videoConfigJson);
            transcodeMeta.put("audio", (Object)audioConfigJson);
            transcodeMeta.put("layout", (Object)layoutJson);
            transcodeMeta.put("advancedConfig", (Object)this.advancedConfig);
            if (this.authInfo != null) {
                transcodeMeta.put("authInfo", (Object)this.authInfo);
            }
            liveTranscodeJson.put("mixingType", (Object)this.mixType);
            liveTranscodeJson.put("type", (Object)"transcode");
            liveTranscodeJson.put("roomId", (Object)this.roomId);
            liveTranscodeJson.put("userId", (Object)this.userId);
            liveTranscodeJson.put("action", (Object)this.action);
            liveTranscodeJson.put("transcodeMeta", (Object)transcodeMeta);
        }
        catch (JSONException e) {
            LogUtil.w(TAG, "get json message happen exception", e);
            return null;
        }
        return liveTranscodeJson;
    }

    public static LiveTranscoding getDefualtLiveTranscode() {
        VideoConfig videoConfig = new VideoConfig();
        videoConfig.setCodec("H264").setFps(30).setGop(60).setKBitRate(500).setHeight(640).setWidth(360).setLowLatency(true);
        AudioConfig audioConfig = new AudioConfig();
        audioConfig.setCodec("AAC").setSampleRate(48000).setChannels(2).setKBitRate(64).setAacProfile(AACProfile.AAC_PROFILE_LC);
        Layout.Builder layoutBuilder = new Layout.Builder();
        layoutBuilder.backgroundColor("#000000").appData("");
        LiveTranscoding liveTranscode = new LiveTranscoding();
        liveTranscode.setAudio(audioConfig);
        liveTranscode.setVideo(videoConfig);
        liveTranscode.setLayout(layoutBuilder.builder());
        liveTranscode.setUrl(null);
        return liveTranscode;
    }

    public static class Layout {
        private Region[] regions;
        private String appData;
        private String backgroundColor;

        public Region[] getRegions() {
            return this.regions;
        }

        public void setRegions(Region[] regions) {
            this.regions = regions;
        }

        public String getAppData() {
            return this.appData;
        }

        public void setAppData(String appData) {
            this.appData = appData;
        }

        public String getBackgroundColor() {
            return this.backgroundColor;
        }

        public void setBackgroundColor(String backgroundColor) {
            this.backgroundColor = backgroundColor;
        }

        public String toString() {
            JSONObject layoutJson = new JSONObject();
            JSONArray regionsJson = new JSONArray();
            JSONObject canvasJson = new JSONObject();
            try {
                if (this.regions != null) {
                    for (Region region : this.regions) {
                        JSONObject regionJson = new JSONObject();
                        regionJson.put("uid", (Object)region.uid);
                        regionJson.put("roomID", (Object)region.roomId);
                        regionJson.put("x", region.x);
                        regionJson.put("y", region.y);
                        regionJson.put("w", region.w);
                        regionJson.put("h", region.h);
                        regionJson.put("zorder", region.zorder);
                        regionJson.put("alpha", region.alpha);
                        regionJson.put("contentControl", (Object)region.contentControl);
                        regionJson.put("renderMode", (Object)region.renderMode);
                        regionJson.put("screen", region.screenStream);
                        regionsJson.put((Object)regionJson);
                    }
                }
                layoutJson.put("canvas", (Object)canvasJson);
                layoutJson.put("regions", (Object)regionsJson);
                layoutJson.put("app_data", (Object)this.appData);
            }
            catch (JSONException e) {
                LogUtil.w(LiveTranscoding.TAG, "create layout json message happen exception", e);
                return null;
            }
            return layoutJson.toString();
        }

        static /* synthetic */ Region[] access$002(Layout x0, Region[] x1) {
            x0.regions = x1;
            return x1;
        }

        public static class Builder {
            private ArrayList<Region> regions;
            private String appData = "";
            private String backgroundColor = "#000000";

            public Builder addRegion(Region region) {
                if (this.regions == null) {
                    this.regions = new ArrayList();
                }
                this.regions.add(region);
                return this;
            }

            public Builder appData(String appData) {
                this.appData = appData;
                return this;
            }

            public Builder backgroundColor(String backgroundColor) {
                this.backgroundColor = backgroundColor;
                return this;
            }

            public Layout builder() {
                Layout layout = new Layout();
                if (this.regions != null) {
                    Layout.access$002(layout, this.regions.toArray(new Region[this.regions.size()]));
                }
                layout.appData = this.appData;
                layout.backgroundColor = this.backgroundColor;
                return layout;
            }
        }
    }

    public static class Region {
        private String uid;
        private String roomId;
        private double x;
        private double y;
        private double w;
        private double h;
        private int zorder;
        private double alpha;
        private TranscoderContentControlType contentControl = TranscoderContentControlType.HAS_AUDIO_AND_VIDEO;
        private TranscoderRenderMode renderMode = TranscoderRenderMode.RENDER_HIDDEN;
        private boolean localUser = false;
        private boolean screenStream = false;
        private TranscoderLayoutRegionType type = TranscoderLayoutRegionType.LAYOUT_REGION_TYPE_VIDEO_STREAM;
        private byte[] data = null;
        private DataParam dataParam = new DataParam();

        public Region uid(String uid) {
            this.uid = uid;
            return this;
        }

        public Region roomId(String roomId) {
            this.roomId = roomId;
            return this;
        }

        public Region zorder(int zorder) {
            this.zorder = zorder;
            return this;
        }

        public Region alpha(double alpha) {
            this.alpha = alpha;
            return this;
        }

        public Region contentControl(TranscoderContentControlType contentControl) {
            this.contentControl = contentControl;
            return this;
        }

        public Region renderMode(TranscoderRenderMode renderMode) {
            this.renderMode = renderMode;
            return this;
        }

        public Region position(double x, double y) {
            this.x = x;
            this.y = y;
            return this;
        }

        public Region size(double width, double height) {
            this.w = width;
            this.h = height;
            return this;
        }

        public boolean isScreenStream() {
            return this.screenStream;
        }

        public Region setScreenStream(boolean screenStream) {
            this.screenStream = screenStream;
            return this;
        }

        public boolean isLocalUser() {
            return this.localUser;
        }

        public Region setLocalUser(boolean localUser) {
            this.localUser = localUser;
            return this;
        }

        public Region type(TranscoderLayoutRegionType type) {
            this.type = type;
            return this;
        }

        public Region data(byte[] data) {
            this.data = data;
            return this;
        }

        public Region dataParam(DataParam dataParam) {
            this.dataParam = dataParam;
            return this;
        }

        public static class DataParam {
            private int imageWidth;
            private int imageHeight;

            public DataParam setImageWidth(int imageWidth) {
                this.imageWidth = imageWidth;
                return this;
            }

            public DataParam setImageHeight(int imageHeight) {
                this.imageHeight = imageHeight;
                return this;
            }
        }
    }

    public static class AudioConfig {
        private String codec = "AAC";
        private int bitRate = 64000;
        private int sampleRate = 48000;
        private int channels = 2;
        private String aacProfile = AACProfile.AAC_PROFILE_LC.getValue();

        public AudioConfig setCodec(String codec) {
            this.codec = codec;
            return this;
        }

        public AudioConfig setKBitRate(int kBitRate) {
            int n = kBitRate = kBitRate > 0 ? kBitRate : 0;
            if (kBitRate > 0x200000) {
                kBitRate = 0x200000;
            }
            this.bitRate = kBitRate * 1000;
            return this;
        }

        public AudioConfig setSampleRate(int sampleRate) {
            this.sampleRate = sampleRate;
            return this;
        }

        public AudioConfig setChannels(int channels) {
            this.channels = channels;
            return this;
        }

        public AudioConfig setAacProfile(AACProfile aacProfile) {
            this.aacProfile = aacProfile.getValue();
            return this;
        }
    }

    public static class VideoConfig {
        private String codec = "H264";
        private int fps = 30;
        private int gop = 60;
        private boolean lowLatency = true;
        private int bitRate = 500000;
        private int width = 360;
        private int height = 640;

        public VideoConfig setCodec(String codec) {
            this.codec = codec;
            return this;
        }

        public VideoConfig setFps(int fps) {
            this.fps = fps;
            return this;
        }

        public VideoConfig setGop(int gop) {
            this.gop = gop;
            return this;
        }

        public VideoConfig setLowLatency(boolean lowLatency) {
            this.lowLatency = lowLatency;
            return this;
        }

        public VideoConfig setKBitRate(int kBitRate) {
            int n = kBitRate = kBitRate > 0 ? kBitRate : 0;
            if (kBitRate > 0x200000) {
                kBitRate = 0x200000;
            }
            this.bitRate = kBitRate * 1000;
            return this;
        }

        public VideoConfig setWidth(int width) {
            this.width = width;
            return this;
        }

        public VideoConfig setHeight(int height) {
            this.height = height;
            return this;
        }

        public static enum VideoCodecType {
            VIDEO_CODEC_TYPE_H264("H264"),
            VIDEO_CODEC_TYPE_BYTEVC1("ByteVC1");

            private String videoCodecType = "H264";

            private VideoCodecType(String value) {
                this.videoCodecType = value;
            }

            public String getValue() {
                return this.videoCodecType;
            }
        }
    }

    public static enum AACProfile {
        AAC_PROFILE_LC("LC"),
        AAC_PROFILE_HEV1("HEv1"),
        AAC_PROFILE_HEV2("HEv2");

        private String AacProfile = "LC";

        private AACProfile(String value) {
            this.AacProfile = value;
        }

        public String getValue() {
            return this.AacProfile;
        }
    }

    public static enum TranscoderLayoutRegionType {
        LAYOUT_REGION_TYPE_VIDEO_STREAM(0),
        LAYOUT_REGION_TYPE_IMAGE(1);

        private int regionType;

        private TranscoderLayoutRegionType(int value) {
            this.regionType = value;
        }

        public int getValue() {
            return this.regionType;
        }
    }

    public static enum TranscoderRenderMode {
        RENDER_UNKNOWN(0),
        RENDER_HIDDEN(1),
        RENDER_FIT(2),
        RENDER_ADAPTIVE(3);

        private int renderMode;

        private TranscoderRenderMode(int value) {
            this.renderMode = value;
        }

        public int getValue() {
            return this.renderMode;
        }
    }

    public static enum TranscoderContentControlType {
        HAS_AUDIO_AND_VIDEO(0),
        HAS_AUDIO_ONLY(1),
        HAS_VIDEO_ONLY(2);

        private int contentControlType;

        private TranscoderContentControlType(int value) {
            this.contentControlType = value;
        }

        public int getValue() {
            return this.contentControlType;
        }
    }
}

