/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.mediaio;

import android.support.annotation.NonNull;
import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import org.webrtc.JavaI420Buffer;
import org.webrtc.VideoFrame;

public class CountDownLatchI420Buffer
implements VideoFrame.I420Buffer {
    @NonNull
    private final JavaI420Buffer buffer;
    private final CountDownLatch mCountDownLatch = new CountDownLatch(1);
    private Runnable mCustomReleaseCallback;

    private CountDownLatchI420Buffer(int width, int height, ByteBuffer dataY, int strideY, ByteBuffer dataU, int strideU, ByteBuffer dataV, int strideV, Runnable customReleaseCallback) {
        this.mCustomReleaseCallback = customReleaseCallback;
        Runnable runnable = () -> {
            this.mCountDownLatch.countDown();
            if (this.mCustomReleaseCallback != null) {
                customReleaseCallback.run();
            }
        };
        this.buffer = JavaI420Buffer.wrap(width, height, dataY, strideY, dataU, strideU, dataV, strideV, runnable);
    }

    public static CountDownLatchI420Buffer wrap(int width, int height, ByteBuffer dataY, int strideY, ByteBuffer dataU, int strideU, ByteBuffer dataV, int strideV, Runnable customReleaseCallback) {
        return new CountDownLatchI420Buffer(width, height, dataY, strideY, dataU, strideU, dataV, strideV, customReleaseCallback);
    }

    public CountDownLatch getLatch() {
        return this.mCountDownLatch;
    }

    @Override
    public ByteBuffer getDataY() {
        return this.buffer.getDataY();
    }

    @Override
    public ByteBuffer getDataU() {
        return this.buffer.getDataU();
    }

    @Override
    public ByteBuffer getDataV() {
        return this.buffer.getDataV();
    }

    @Override
    public int getStrideY() {
        return this.buffer.getStrideY();
    }

    @Override
    public int getStrideU() {
        return this.buffer.getStrideU();
    }

    @Override
    public int getStrideV() {
        return this.buffer.getStrideV();
    }

    @Override
    public int getWidth() {
        return this.buffer.getWidth();
    }

    @Override
    public int getHeight() {
        return this.buffer.getHeight();
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return this.buffer.toI420();
    }

    @Override
    public void retain() {
        this.buffer.retain();
    }

    @Override
    public void release() {
        this.buffer.release();
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int i, int i1, int i2, int i3, int i4, int i5) {
        return this.buffer.cropAndScale(i, i1, i2, i3, i4, i5);
    }

    @Override
    public VideoFrame.Buffer scaleAndFill(int i, int i1, int i2, int i3) {
        return this.buffer.scaleAndFill(i, i1, i2, i3);
    }
}

