/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.utils;

import android.content.Context;
import android.net.Uri;
import com.ss.bytertc.base.utils.RtcContextUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.webrtc.CalledByNative;

public class GetFileData {
    @CalledByNative
    public static ByteBuffer readFile(String srcUri) {
        Context context = RtcContextUtils.getApplicationContext();
        if (srcUri.startsWith("/assets/") && context != null) {
            return GetFileData.getAssets(context, srcUri.substring("/assets/".length()));
        }
        if (srcUri.startsWith("content://") && context != null) {
            return GetFileData.getOthers(context, srcUri);
        }
        return null;
    }

    public static ByteBuffer getOthers(Context context, String srcUri) {
        try {
            Uri uri = Uri.parse((String)srcUri);
            String s = uri.getPath();
            InputStream inputStream = context.getContentResolver().openInputStream(uri);
            byte[] buffer = new byte[inputStream.available()];
            int size = inputStream.read(buffer);
            inputStream.close();
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
            return GetFileData.convertDirectBuffer(byteBuffer);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static ByteBuffer getAssets(Context context, String srcUri) {
        try {
            InputStream inputStream = context.getResources().getAssets().open(srcUri);
            byte[] buffer = new byte[inputStream.available()];
            int size = inputStream.read(buffer);
            inputStream.close();
            ByteBuffer byteBuffer = ByteBuffer.wrap(buffer);
            return GetFileData.convertDirectBuffer(byteBuffer);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static ByteBuffer convertDirectBuffer(ByteBuffer buffer) {
        if (buffer == null) {
            return null;
        }
        if (buffer.isDirect()) {
            return buffer;
        }
        ByteBuffer directBuffer = ByteBuffer.allocateDirect(buffer.remaining());
        directBuffer.position(0);
        directBuffer.put(buffer);
        directBuffer.rewind();
        return directBuffer;
    }
}

