/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.video;

import android.opengl.EGLContext;
import android.support.annotation.NonNull;
import com.ss.bytertc.engine.data.CameraId;
import com.ss.bytertc.engine.data.ColorSpace;
import com.ss.bytertc.engine.data.VideoContentType;
import com.ss.bytertc.engine.data.VideoFrameType;
import com.ss.bytertc.engine.data.VideoPixelFormat;
import com.ss.bytertc.engine.data.VideoRotation;
import com.ss.bytertc.engine.mediaio.RefObject;
import java.nio.ByteBuffer;
import org.webrtc.CalledByNative;

public abstract class VideoFrame {
    @NonNull
    private final RefObject refCount = new RefObject(() -> {
        if (this.userReleaseCallback != null) {
            this.userReleaseCallback.run();
        }
    });
    private Runnable userReleaseCallback = null;

    public synchronized void setReleaseCallback(Runnable releaseCallback) {
        this.userReleaseCallback = releaseCallback;
    }

    public synchronized boolean hasReleaseCallback() {
        return this.userReleaseCallback != null;
    }

    @CalledByNative
    public abstract VideoFrameType getFrameType();

    @CalledByNative
    public abstract VideoPixelFormat getPixelFormat();

    @CalledByNative
    public abstract VideoContentType getContentType();

    @CalledByNative
    public abstract long getTimeStampUs();

    @CalledByNative
    public abstract int getWidth();

    @CalledByNative
    public abstract int getHeight();

    @CalledByNative
    public abstract VideoRotation getRotation();

    @CalledByNative
    public abstract ColorSpace getColorSpace();

    @CalledByNative
    public abstract CameraId getCameraId();

    @CalledByNative
    public abstract int getNumberOfPlanes();

    @CalledByNative
    public abstract ByteBuffer getPlaneData(int var1);

    @CalledByNative
    public abstract int getPlaneStride(int var1);

    @CalledByNative
    public abstract ByteBuffer getExternalDataInfo();

    @CalledByNative
    public abstract ByteBuffer getSupplementaryInfo();

    @CalledByNative
    public abstract int getTextureID();

    @CalledByNative
    public abstract float[] getTextureMatrix();

    @CalledByNative
    public abstract EGLContext getEGLContext();

    @CalledByNative
    public synchronized void retain() {
        if (this.refCount != null) {
            this.refCount.retain();
        }
    }

    @CalledByNative
    public synchronized void release() {
        if (this.refCount != null) {
            this.refCount.release();
        }
    }
}

