/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.video.impl;

import android.opengl.EGLContext;
import com.ss.bytertc.engine.data.CameraId;
import com.ss.bytertc.engine.data.ColorSpace;
import com.ss.bytertc.engine.data.VideoContentType;
import com.ss.bytertc.engine.data.VideoFrameType;
import com.ss.bytertc.engine.data.VideoPixelFormat;
import com.ss.bytertc.engine.data.VideoRotation;
import com.ss.bytertc.engine.video.VideoFrame;
import com.ss.bytertc.engine.video.impl.NativeBufferVideoFrame;
import java.nio.ByteBuffer;
import org.webrtc.CalledByNative;
import org.webrtc.VideoFrame;

public class WebrtcWrapperVideoFrame
extends VideoFrame {
    private final NativeBufferVideoFrame cppFrameWrapper;
    private final org.webrtc.VideoFrame webrtcVideoFrame;
    private VideoFrame.Buffer videoBuffer = null;
    private final EGLContext eglContext;
    private VideoFrameType frameType;
    private VideoPixelFormat pixelFormat;

    @CalledByNative
    WebrtcWrapperVideoFrame(VideoFrame.Buffer webrtcVideoFrameBuffer, EGLContext eglContext, long nativeHandle) {
        this.cppFrameWrapper = new NativeBufferVideoFrame(nativeHandle);
        this.webrtcVideoFrame = null;
        this.eglContext = eglContext;
        this.setReleaseCallback(() -> {
            this.cppFrameWrapper.release();
            if (this.videoBuffer != null) {
                this.videoBuffer.release();
            }
        });
        this.init(webrtcVideoFrameBuffer, eglContext);
    }

    public WebrtcWrapperVideoFrame(org.webrtc.VideoFrame webrtcVideoFrame, EGLContext eglContext) {
        this.cppFrameWrapper = null;
        this.webrtcVideoFrame = webrtcVideoFrame;
        this.eglContext = eglContext;
        webrtcVideoFrame.retain();
        this.setReleaseCallback(() -> {
            webrtcVideoFrame.release();
            if (this.videoBuffer != null) {
                this.videoBuffer.release();
            }
        });
        this.init(webrtcVideoFrame.getBuffer(), eglContext);
    }

    private void init(VideoFrame.Buffer webrtcVideoFrameBuffer, EGLContext eglContext) {
        int type = webrtcVideoFrameBuffer.getBufferType();
        if (type == 4) {
            this.frameType = VideoFrameType.kVideoFrameTypeGLTexture;
            this.videoBuffer = webrtcVideoFrameBuffer;
            this.videoBuffer.retain();
            this.pixelFormat = ((VideoFrame.TextureBuffer)this.videoBuffer).getType() == VideoFrame.TextureBuffer.Type.RGB ? VideoPixelFormat.kVideoPixelFormatTexture2D : VideoPixelFormat.kVideoPixelFormatTextureOES;
        } else {
            this.frameType = VideoFrameType.kVideoFrameTypeRawMemory;
            this.videoBuffer = webrtcVideoFrameBuffer.toI420();
            this.pixelFormat = VideoPixelFormat.kVideoPixelFormatI420;
        }
    }

    @Override
    public VideoFrameType getFrameType() {
        return this.frameType;
    }

    @Override
    public VideoPixelFormat getPixelFormat() {
        return this.pixelFormat;
    }

    @Override
    public VideoContentType getContentType() {
        if (this.cppFrameWrapper != null) {
            return this.cppFrameWrapper.getContentType();
        }
        return VideoContentType.kVideoContentTypeNormalFrame;
    }

    @Override
    public long getTimeStampUs() {
        if (this.cppFrameWrapper != null) {
            return this.cppFrameWrapper.getTimeStampUs();
        }
        if (this.webrtcVideoFrame != null) {
            return this.webrtcVideoFrame.getTimestampNs();
        }
        return 0L;
    }

    @Override
    public int getWidth() {
        if (this.videoBuffer != null) {
            return this.videoBuffer.getWidth();
        }
        return 0;
    }

    @Override
    public int getHeight() {
        if (this.videoBuffer != null) {
            return this.videoBuffer.getHeight();
        }
        return 0;
    }

    @Override
    public VideoRotation getRotation() {
        if (this.cppFrameWrapper != null) {
            return this.cppFrameWrapper.getRotation();
        }
        if (this.webrtcVideoFrame != null) {
            return VideoRotation.fromId(this.webrtcVideoFrame.getRotation());
        }
        return null;
    }

    @Override
    public ColorSpace getColorSpace() {
        if (this.cppFrameWrapper != null) {
            return this.cppFrameWrapper.getColorSpace();
        }
        if (this.webrtcVideoFrame != null) {
            return ColorSpace.kColorSpaceYCbCrBT601LimitedRange;
        }
        return null;
    }

    @Override
    public CameraId getCameraId() {
        if (this.cppFrameWrapper != null) {
            return this.cppFrameWrapper.getCameraId();
        }
        return null;
    }

    @Override
    public int getNumberOfPlanes() {
        if (this.pixelFormat == VideoPixelFormat.kVideoPixelFormatI420) {
            return 3;
        }
        return 0;
    }

    @Override
    public ByteBuffer getPlaneData(int planeIndex) {
        if (this.frameType == VideoFrameType.kVideoFrameTypeGLTexture) {
            return null;
        }
        if (this.videoBuffer == null) {
            return null;
        }
        VideoFrame.I420Buffer i420Buffer = (VideoFrame.I420Buffer)this.videoBuffer;
        if (planeIndex == 0) {
            return i420Buffer.getDataY();
        }
        if (planeIndex == 1) {
            return i420Buffer.getDataU();
        }
        if (planeIndex == 2) {
            return i420Buffer.getDataV();
        }
        return null;
    }

    @Override
    public int getPlaneStride(int planeIndex) {
        if (this.frameType == VideoFrameType.kVideoFrameTypeGLTexture) {
            return 0;
        }
        if (this.videoBuffer == null) {
            return 0;
        }
        VideoFrame.I420Buffer i420Buffer = (VideoFrame.I420Buffer)this.videoBuffer;
        if (planeIndex == 0) {
            return i420Buffer.getStrideY();
        }
        if (planeIndex == 1) {
            return i420Buffer.getStrideU();
        }
        if (planeIndex == 2) {
            return i420Buffer.getStrideV();
        }
        return 0;
    }

    @Override
    public ByteBuffer getExternalDataInfo() {
        if (this.cppFrameWrapper != null) {
            return this.cppFrameWrapper.getExternalDataInfo();
        }
        if (this.webrtcVideoFrame != null) {
            return this.webrtcVideoFrame.getExtendedData();
        }
        return null;
    }

    @Override
    public ByteBuffer getSupplementaryInfo() {
        if (this.cppFrameWrapper != null) {
            return this.cppFrameWrapper.getSupplementaryInfo();
        }
        return null;
    }

    @Override
    public int getTextureID() {
        if (this.frameType == VideoFrameType.kVideoFrameTypeRawMemory) {
            return 0;
        }
        if (this.videoBuffer == null) {
            return 0;
        }
        VideoFrame.TextureBuffer textureBuffer = (VideoFrame.TextureBuffer)this.videoBuffer;
        return textureBuffer.getTextureId();
    }

    @Override
    public float[] getTextureMatrix() {
        if (this.frameType == VideoFrameType.kVideoFrameTypeRawMemory) {
            return null;
        }
        if (this.videoBuffer == null) {
            return null;
        }
        VideoFrame.TextureBuffer textureBuffer = (VideoFrame.TextureBuffer)this.videoBuffer;
        return textureBuffer.nativeGetTransFormMatrix();
    }

    @Override
    public EGLContext getEGLContext() {
        return this.eglContext;
    }
}

