/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.SystemClock;
import android.support.annotation.Nullable;
import android.view.Surface;
import com.bytedance.realx.base.RXLogging;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.webrtc.EglBase;
import org.webrtc.EncodedImage;
import org.webrtc.JavaI420Buffer;
import org.webrtc.MediaCodecUtils;
import org.webrtc.MediaCodecWrapper;
import org.webrtc.MediaCodecWrapperFactory;
import org.webrtc.NV12Buffer;
import org.webrtc.NullBuffer;
import org.webrtc.RXVideoCodecStandard;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoCodecStatus;
import org.webrtc.VideoDecoder;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;
import org.webrtc.YuvHelper;

class AndroidVideoDecoder
implements VideoDecoder,
VideoSink {
    private static final String TAG = "AndroidVideoDecoder";
    private static final String MEDIA_FORMAT_KEY_STRIDE = "stride";
    private static final String MEDIA_FORMAT_KEY_SLICE_HEIGHT = "slice-height";
    private static final String MEDIA_FORMAT_KEY_CROP_LEFT = "crop-left";
    private static final String MEDIA_FORMAT_KEY_CROP_RIGHT = "crop-right";
    private static final String MEDIA_FORMAT_KEY_CROP_TOP = "crop-top";
    private static final String MEDIA_FORMAT_KEY_CROP_BOTTOM = "crop-bottom";
    private static final int MEDIA_CODEC_RELEASE_TIMEOUT_MS = 5000;
    private static final int DEQUEUE_INPUT_TIMEOUT_US = 500000;
    private static final int DEQUEUE_OUTPUT_BUFFER_TIMEOUT_US = 100000;
    private static final int MAX_RECREATE_DECODER_COUNT = 5;
    private static final int MIN_OUTPUT_FRAME_TIME_DELTA_MS = 10;
    private static final int MAX_OUTPUT_FRAME_WAIT_TIME_MS = 1300;
    private static final int DEFAULT_OUTPUT_FRAME_WAIT_TIME_MS = 16;
    private final MediaCodecWrapperFactory mediaCodecWrapperFactory;
    private final String codecName;
    private final RXVideoCodecStandard codecType;
    private int colorFormat;
    private int maxExSurfaceRecreateDecoderCount = 0;
    @Nullable
    private Thread outputThread;
    private ThreadUtils.ThreadChecker outputThreadChecker;
    private ThreadUtils.ThreadChecker decoderThreadChecker;
    private volatile boolean running;
    @Nullable
    private volatile Exception shutdownException;
    private final Object dimensionLock = new Object();
    private int width;
    private int height;
    private int encoded_width;
    private int encoded_height;
    private int stride;
    private int sliceHeight;
    private boolean hasDecodedFirstFrame;
    private boolean keyFrameRequired;
    private final EglBase.Context sharedContext;
    private final Object surfaceTextureHelperLock = new Object();
    @Nullable
    private SurfaceTextureHelper surfaceTextureHelper;
    @Nullable
    private Surface surface;
    @Nullable
    private Surface ex_surface;
    private long lastOutputTime = 0L;
    private long currentOutputTime = 0L;
    private long lastInputTime = 0L;
    private long currentInputTimeDelta = 0L;
    private long packetCount2s = 0L;
    private long timeForAvg = 0L;
    private long avgInputTimeDelta = 0L;
    private long inputFrameCount = 0L;
    private long outputFrameCount = 0L;
    private long minFrameCache = -1L;
    private long currentFrameCache = -1L;
    private final Object smoothOutputLock = new Object();
    private boolean usingInternalSurfaceLast = true;
    private final Object renderedTextureMetadataLock = new Object();
    @Nullable
    private DecodedTextureMetadata renderedTextureMetadata;
    @Nullable
    private VideoDecoder.Callback callback;
    @Nullable
    private VideoDecoder.Settings settings;
    @Nullable
    private MediaCodecWrapper codec;

    AndroidVideoDecoder(MediaCodecWrapperFactory mediaCodecWrapperFactory, String codecName, RXVideoCodecStandard codecType, int colorFormat, EglBase.Context sharedContext) {
        if (!this.isSupportedColorFormat(colorFormat)) {
            throw new IllegalArgumentException("Unsupported color format: " + colorFormat);
        }
        RXLogging.w(TAG, "ctor name: " + codecName + " type: " + (Object)((Object)codecType) + " color format: " + colorFormat + " context: " + sharedContext);
        this.mediaCodecWrapperFactory = mediaCodecWrapperFactory;
        this.codecName = codecName;
        this.codecType = codecType;
        this.colorFormat = colorFormat;
        this.sharedContext = sharedContext;
        this.width = 0;
        this.height = 0;
    }

    @Override
    public void setExternalSurface(Surface surface) {
        RXLogging.w(TAG, "set external surface . surface:" + surface);
        if (surface != null) {
            this.ex_surface = surface;
            this.surface = null;
        }
    }

    @Override
    public void disableExternalSurface() {
        RXLogging.w(TAG, "disable external surface.");
        this.ex_surface = null;
    }

    @Override
    public VideoCodecStatus initDecode(VideoDecoder.Settings settings, VideoDecoder.Callback callback) {
        this.callback = callback;
        this.settings = settings;
        return VideoCodecStatus.OK;
    }

    private VideoCodecStatus initDecodeInternal(int width, int height) {
        if (this.callback == null) {
            RXLogging.d(TAG, "callback uninitalized");
            return VideoCodecStatus.UNINITIALIZED;
        }
        long startTime = SystemClock.elapsedRealtime();
        this.decoderThreadChecker = new ThreadUtils.ThreadChecker();
        if (this.sharedContext != null && this.ex_surface == null && !this.settings.enableYUVOutput) {
            this.surfaceTextureHelper = this.createSurfaceTextureHelper();
            if (this.surfaceTextureHelper == null) {
                return VideoCodecStatus.FALLBACK_SOFTWARE;
            }
            this.surface = new Surface(this.surfaceTextureHelper.getSurfaceTexture());
            this.surfaceTextureHelper.startListening(this);
        }
        RXLogging.w(TAG, "initDecodeInternal name: " + this.codecName + " type: " + (Object)((Object)this.codecType) + " width: " + width + " height: " + height + " sharedContext:" + this.sharedContext + " outputByDts:" + this.settings.outputByDts + ", external surface:" + this.ex_surface + ", internal surface:" + this.surface + " smoothOutput:" + this.settings.enableSmoothOutput + " yuv mode:" + this.settings.enableYUVOutput + ", latencyInsensitiveMode:" + this.settings.latencyInsensitiveMode);
        if (this.outputThread != null) {
            RXLogging.e(TAG, "initDecodeInternal called while the codec is already running");
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        this.width = width;
        this.height = height;
        this.stride = width;
        this.sliceHeight = height;
        this.hasDecodedFirstFrame = false;
        this.keyFrameRequired = true;
        this.inputFrameCount = 0L;
        this.outputFrameCount = 0L;
        this.minFrameCache = -1L;
        this.currentFrameCache = -1L;
        try {
            this.codec = this.mediaCodecWrapperFactory.createByCodecName(this.codecName);
        }
        catch (IOException | IllegalArgumentException | IllegalStateException | NullPointerException e) {
            RXLogging.e(TAG, "Cannot create media decoder " + this.codecName);
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        try {
            MediaFormat format = MediaFormat.createVideoFormat((String)this.codecType.mimeType(), (int)width, (int)height);
            if (this.sharedContext == null) {
                format.setInteger("color-format", this.colorFormat);
            }
            if (this.settings.outputByDts) {
                format.setInteger("low-latency", 1);
                format.setInteger("vendor.qti-ext-dec-picture-order.enable", 1);
                format.setInteger("vendor.qti-ext-dec-low-latency.enable", 1);
                format.setInteger("vendor.rtc-ext-dec-low-latency.enable", 1);
                if (width < height) {
                    format.setInteger("vendor.hisi-ext-low-latency-video-dec.video-scene-for-low-latency-req", 1);
                }
                format.setInteger("vendor.hisi-ext-low-latency-video-dec.video-scene-for-low-latency-rdy", -1);
                format.setInteger("fast-output-mode", 1);
            }
            if (this.maxExSurfaceRecreateDecoderCount >= 2) {
                this.ex_surface = null;
            }
            if (this.ex_surface != null) {
                ++this.maxExSurfaceRecreateDecoderCount;
                this.codec.configure(format, this.ex_surface, null, 0);
                RXLogging.w(TAG, "init codec done with external surface:" + this.ex_surface);
            } else {
                this.codec.configure(format, this.surface, null, 0);
                RXLogging.w(TAG, "init codec done with internal surface:" + this.surface);
            }
            this.codec.start();
        }
        catch (IllegalArgumentException | IllegalStateException e) {
            RXLogging.e(TAG, "initDecode failed", e);
            StringWriter stringW = new StringWriter();
            e.printStackTrace(new PrintWriter(stringW));
            this.callback.onMediaCodecStatus(VideoCodecStatus.MEDIACODEC_EXCEPTION, stringW.toString());
            this.codec.release();
            this.releaseSurface();
            return VideoCodecStatus.FALLBACK_SOFTWARE;
        }
        this.running = true;
        this.maxExSurfaceRecreateDecoderCount = 0;
        this.outputThread = this.createOutputThread();
        this.outputThread.start();
        long finishTime = SystemClock.elapsedRealtime();
        long costTime = finishTime - startTime;
        this.callback.onDecoderInited(costTime);
        RXLogging.w(TAG, "initDecodeInternal done,init video decoder cost time:" + costTime);
        if (this.ex_surface != null && this.surface == null) {
            this.usingInternalSurfaceLast = false;
        } else if (this.ex_surface == null && this.surface != null && !this.usingInternalSurfaceLast) {
            this.usingInternalSurfaceLast = true;
            this.callback.onMediaCodecStatus(VideoCodecStatus.USING_INTERNAL_SURFACE, "using internal surface");
        }
        return VideoCodecStatus.OK;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VideoCodecStatus decode(EncodedImage frame) {
        long currentInputTime = SystemClock.elapsedRealtime();
        if (this.lastInputTime > 0L) {
            this.currentInputTimeDelta = currentInputTime - this.lastInputTime;
        }
        this.lastInputTime = currentInputTime;
        ++this.packetCount2s;
        if (0L == this.timeForAvg) {
            this.timeForAvg = currentInputTime;
        }
        if (currentInputTime - this.timeForAvg >= 2000L && this.packetCount2s > 0L) {
            this.avgInputTimeDelta = (currentInputTime - this.timeForAvg) / this.packetCount2s;
            this.packetCount2s = 0L;
            this.timeForAvg = currentInputTime;
        }
        try {
            ByteBuffer buffer;
            int index;
            if (frame.encodedWidth != this.encoded_width || frame.encodedHeight != this.encoded_height) {
                VideoCodecStatus ret = this.reinitDecode(frame.encodedWidth, frame.encodedHeight);
                if (ret != VideoCodecStatus.OK) {
                    return ret;
                }
                Object object = this.dimensionLock;
                synchronized (object) {
                    this.encoded_width = frame.encodedWidth;
                    this.encoded_height = frame.encodedHeight;
                    this.width = frame.encodedWidth;
                    this.height = frame.encodedHeight;
                }
            }
            this.decoderThreadChecker.checkIsOnValidThread();
            if (this.codec == null || this.callback == null) {
                RXLogging.d(TAG, "decode uninitalized, codec: " + (this.codec != null) + ", callback: " + this.callback);
                return VideoCodecStatus.UNINITIALIZED;
            }
            if (frame.buffer == null) {
                RXLogging.e(TAG, "decode() - no input data");
                return VideoCodecStatus.ERR_PARAMETER;
            }
            int size = frame.buffer.remaining();
            if (size == 0) {
                RXLogging.e(TAG, "decode() - input buffer empty");
                return VideoCodecStatus.ERR_PARAMETER;
            }
            if (this.keyFrameRequired) {
                if (frame.frameType != EncodedImage.FrameType.VideoFrameKey) {
                    RXLogging.e(TAG, "decode() - key frame required first");
                    return VideoCodecStatus.NO_OUTPUT;
                }
                if (!frame.completeFrame) {
                    RXLogging.e(TAG, "decode() - complete frame required first");
                    return VideoCodecStatus.NO_OUTPUT;
                }
            }
            try {
                index = this.codec.dequeueInputBuffer(this.settings.latencyInsensitiveMode ? 5000000L : 500000L);
            }
            catch (IllegalStateException e) {
                RXLogging.e(TAG, "dequeueInputBuffer failed", e);
                return VideoCodecStatus.ERROR;
            }
            if (index < 0) {
                RXLogging.e(TAG, "decode() - no HW buffers available; decoder falling behind");
                return VideoCodecStatus.OVERLOAD;
            }
            try {
                buffer = this.codec.getInputBuffers()[index];
            }
            catch (IllegalStateException e) {
                RXLogging.e(TAG, "getInputBuffers failed", e);
                return VideoCodecStatus.ERROR;
            }
            if (buffer.capacity() < size) {
                RXLogging.e(TAG, "decode() - HW buffer too small");
                return VideoCodecStatus.OVERLOAD;
            }
            buffer.put(frame.buffer);
            try {
                this.codec.queueInputBuffer(index, 0, size, TimeUnit.NANOSECONDS.toMicros(frame.captureTimeNs), 0);
            }
            catch (IllegalStateException e) {
                RXLogging.e(TAG, "queueInputBuffer failed", e);
                return VideoCodecStatus.ERROR;
            }
            if (this.keyFrameRequired) {
                this.keyFrameRequired = false;
            }
            if (!this.settings.latencyInsensitiveMode) {
                long delta = this.inputFrameCount - this.outputFrameCount;
                long l = this.currentFrameCache = delta > 0L ? delta : this.currentFrameCache;
                if (this.currentFrameCache > this.minFrameCache) {
                    try {
                        Object object = this.smoothOutputLock;
                        synchronized (object) {
                            RXLogging.i(TAG, "notify currentFrameCache:" + this.currentFrameCache + " minFrameCache:" + this.minFrameCache);
                            this.smoothOutputLock.notify();
                        }
                    }
                    catch (Exception e) {
                        RXLogging.e(TAG, "currentFrameCache:" + this.currentFrameCache + " minFrameCache:" + this.minFrameCache);
                    }
                }
            }
            ++this.inputFrameCount;
            return VideoCodecStatus.OK;
        }
        catch (Exception e) {
            RXLogging.e(TAG, "android decode err", e);
            return VideoCodecStatus.ERROR;
        }
    }

    @Override
    public boolean getPrefersLateDecoding() {
        return true;
    }

    @Override
    public String getImplementationName() {
        return this.codecName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VideoCodecStatus release() {
        RXLogging.d(TAG, "release");
        VideoCodecStatus status = this.releaseInternal();
        this.releaseSurface();
        Object object = this.renderedTextureMetadataLock;
        synchronized (object) {
            this.renderedTextureMetadata = null;
        }
        this.callback = null;
        return status;
    }

    private VideoCodecStatus releaseInternal() {
        if (!this.running) {
            RXLogging.d(TAG, "release: Decoder is not running.");
            return VideoCodecStatus.OK;
        }
        try {
            this.running = false;
            if (!ThreadUtils.joinUninterruptibly(this.outputThread, 5000L)) {
                RXLogging.e(TAG, "Media decoder release timeout", new RuntimeException());
                VideoCodecStatus videoCodecStatus = VideoCodecStatus.TIMEOUT;
                return videoCodecStatus;
            }
            if (this.shutdownException != null) {
                RXLogging.e(TAG, "Media decoder release error", new RuntimeException(this.shutdownException));
                this.shutdownException = null;
                VideoCodecStatus videoCodecStatus = VideoCodecStatus.ERROR;
                return videoCodecStatus;
            }
        }
        finally {
            this.codec = null;
            this.outputThread = null;
        }
        return VideoCodecStatus.OK;
    }

    private VideoCodecStatus reinitDecode(int newWidth, int newHeight) {
        VideoCodecStatus status = this.releaseInternal();
        if (status != VideoCodecStatus.OK) {
            RXLogging.e(TAG, "releaseInternal err");
            return status;
        }
        VideoCodecStatus ret = VideoCodecStatus.FALLBACK_SOFTWARE;
        for (int i = 0; i < 5 && VideoCodecStatus.OK != (ret = this.initDecodeInternal(newWidth, newHeight)); ++i) {
        }
        return ret;
    }

    private Thread createOutputThread() {
        return new Thread("AndroidVideoDecoder.outputThread"){

            @Override
            public void run() {
                AndroidVideoDecoder.this.outputThreadChecker = new ThreadUtils.ThreadChecker();
                while (AndroidVideoDecoder.this.running) {
                    AndroidVideoDecoder.this.deliverDecodedFrame();
                }
                AndroidVideoDecoder.this.releaseCodecOnOutputThread();
            }
        };
    }

    protected void deliverDecodedFrame() {
        this.outputThreadChecker.checkIsOnValidThread();
        try {
            MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
            int result = this.codec.dequeueOutputBuffer(info, this.settings.latencyInsensitiveMode ? 25000L : 100000L);
            if (result == -2) {
                this.reformat(this.codec.getOutputFormat());
                return;
            }
            if (result < 0) {
                RXLogging.d(TAG, "dequeueOutputBuffer returned " + result);
                return;
            }
            ++this.outputFrameCount;
            if (this.ex_surface != null) {
                try {
                    this.codec.releaseOutputBuffer(result, true);
                }
                catch (IllegalStateException e) {
                    StringWriter stringW = new StringWriter();
                    e.printStackTrace(new PrintWriter(stringW));
                    this.callback.onMediaCodecStatus(VideoCodecStatus.MEDIACODEC_EXCEPTION, stringW.toString());
                    return;
                }
                if (!this.hasDecodedFirstFrame) {
                    this.hasDecodedFirstFrame = true;
                }
                NullBuffer buffer = new NullBuffer(this.width, this.height, null);
                int buffer_type = buffer.getBufferType();
                VideoFrame frame = new VideoFrame(buffer, 0, info.presentationTimeUs * 1000L);
                this.callback.onDecodedFrame(frame);
                frame.release();
                return;
            }
            this.hasDecodedFirstFrame = true;
            if (this.surfaceTextureHelper != null) {
                this.deliverTextureFrame(result, info);
            } else {
                this.deliverByteFrame(result, info);
            }
        }
        catch (IllegalStateException e) {
            RXLogging.e(TAG, "deliverDecodedFrame failed", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void smoothOutputFrame() {
        this.currentOutputTime = SystemClock.elapsedRealtime();
        if (this.outputFrameCount > this.inputFrameCount) {
            this.outputFrameCount = this.inputFrameCount;
        }
        this.minFrameCache = this.minFrameCache < 0L ? this.currentFrameCache : (this.minFrameCache > this.currentFrameCache && this.currentFrameCache >= 0L ? this.currentFrameCache : this.minFrameCache);
        long outputDelta = this.currentOutputTime - this.lastOutputTime;
        long smoothOutputDelta = 0L;
        if (this.avgInputTimeDelta <= 0L) {
            smoothOutputDelta = this.currentInputTimeDelta > 0L ? this.currentInputTimeDelta : 16L;
        } else if (this.currentInputTimeDelta >= this.avgInputTimeDelta) {
            smoothOutputDelta = this.avgInputTimeDelta;
        } else {
            long l = smoothOutputDelta = this.currentInputTimeDelta > 10L ? this.currentInputTimeDelta : 10L;
        }
        if (this.lastOutputTime > 0L && outputDelta < smoothOutputDelta) {
            long waitMs = smoothOutputDelta - outputDelta;
            if (this.currentFrameCache > this.minFrameCache) {
                waitMs /= 2L;
            }
            waitMs = waitMs > 1300L ? 1300L : waitMs;
            try {
                Object object = this.smoothOutputLock;
                synchronized (object) {
                    this.smoothOutputLock.wait(waitMs);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.lastOutputTime = SystemClock.elapsedRealtime();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverTextureFrame(int index, MediaCodec.BufferInfo info) {
        int height;
        int width;
        Object object = this.dimensionLock;
        synchronized (object) {
            width = this.width;
            height = this.height;
        }
        if (this.settings.enableSmoothOutput && !this.settings.latencyInsensitiveMode) {
            this.smoothOutputFrame();
        }
        if (this.settings.latencyInsensitiveMode && this.running) {
            boolean shouldWait = true;
            int maxTryCount = 200;
            int currentTryCount = 0;
            while (shouldWait && currentTryCount < maxTryCount) {
                ++currentTryCount;
                Object object2 = this.renderedTextureMetadataLock;
                synchronized (object2) {
                    shouldWait = this.renderedTextureMetadata != null;
                }
                if (!shouldWait) continue;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        Object object3 = this.renderedTextureMetadataLock;
        synchronized (object3) {
            if (this.renderedTextureMetadata != null) {
                try {
                    this.codec.releaseOutputBuffer(index, false);
                }
                catch (IllegalStateException e) {
                    RXLogging.e(TAG, "releaseOutputBuffer failed", e);
                }
                return;
            }
            Object e = this.surfaceTextureHelperLock;
            synchronized (e) {
                if (this.surfaceTextureHelper == null) {
                    RXLogging.e(TAG, "surfaceTextureHelper is null, decoder is error.");
                    try {
                        this.codec.releaseOutputBuffer(index, false);
                    }
                    catch (IllegalStateException e2) {
                        RXLogging.e(TAG, "releaseOutputBuffer failed", e2);
                    }
                    return;
                }
                this.surfaceTextureHelper.setTextureSize(width, height);
            }
            this.renderedTextureMetadata = new DecodedTextureMetadata(info.presentationTimeUs);
            try {
                this.codec.releaseOutputBuffer(index, true);
            }
            catch (IllegalStateException e2) {
                RXLogging.e(TAG, "releaseOutputBuffer failed!", e2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFrame(VideoFrame frame) {
        long timestampNs;
        Object object = this.renderedTextureMetadataLock;
        synchronized (object) {
            if (this.renderedTextureMetadata == null) {
                throw new IllegalStateException("Rendered texture metadata was null in onTextureFrameAvailable.");
            }
            timestampNs = this.renderedTextureMetadata.presentationTimestampUs * 1000L;
            this.renderedTextureMetadata = null;
        }
        VideoFrame frameWithModifiedTimeStamp = new VideoFrame(frame.getBuffer(), 0, timestampNs);
        this.callback.onDecodedFrame(frameWithModifiedTimeStamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deliverByteFrame(int result, MediaCodec.BufferInfo info) {
        int sliceHeight;
        int stride;
        int height;
        int width;
        Object object = this.dimensionLock;
        synchronized (object) {
            width = this.width;
            height = this.height;
            stride = this.stride;
            sliceHeight = this.sliceHeight;
        }
        if (info.size < width * height * 3 / 2) {
            RXLogging.e(TAG, "Insufficient output buffer size: " + info.size);
            return;
        }
        if (info.size < stride * height * 3 / 2 && sliceHeight == height && stride > width) {
            stride = info.size * 2 / (height * 3);
        }
        ByteBuffer buffer = this.codec.getOutputBuffers()[result];
        buffer.position(info.offset);
        buffer.limit(info.offset + info.size);
        buffer = buffer.slice();
        VideoFrame.Buffer frameBuffer = this.colorFormat == 19 ? this.copyI420Buffer(buffer, stride, sliceHeight, width, height) : this.copyNV12ToI420Buffer(buffer, stride, sliceHeight, width, height);
        if (frameBuffer == null) {
            return;
        }
        this.codec.releaseOutputBuffer(result, false);
        long presentationTimeNs = info.presentationTimeUs * 1000L;
        VideoFrame frame = new VideoFrame(frameBuffer, 0, presentationTimeNs);
        this.callback.onDecodedFrame(frame);
        frame.release();
    }

    private VideoFrame.Buffer copyNV12ToI420Buffer(ByteBuffer buffer, int stride, int sliceHeight, int width, int height) {
        return new NV12Buffer(width, height, stride, sliceHeight, buffer, null).toI420();
    }

    private VideoFrame.Buffer copyI420Buffer(ByteBuffer buffer, int stride, int sliceHeight, int width, int height) {
        if (stride % 2 != 0) {
            throw new AssertionError((Object)("Stride is not divisible by two: " + stride));
        }
        int chromaWidth = (width + 1) / 2;
        int chromaHeight = sliceHeight % 2 == 0 ? (height + 1) / 2 : height / 2;
        int uvStride = stride / 2;
        boolean yPos = false;
        int yEnd = 0 + stride * height;
        int uPos = 0 + stride * sliceHeight;
        int uEnd = uPos + uvStride * chromaHeight;
        int vPos = uPos + uvStride * sliceHeight / 2;
        int vEnd = vPos + uvStride * chromaHeight;
        VideoFrame.I420Buffer frameBuffer = this.allocateI420Buffer(width, height);
        if (frameBuffer == null) {
            return null;
        }
        buffer.limit(yEnd);
        buffer.position(0);
        this.copyPlane(buffer.slice(), stride, frameBuffer.getDataY(), frameBuffer.getStrideY(), width, height);
        buffer.limit(uEnd);
        buffer.position(uPos);
        this.copyPlane(buffer.slice(), uvStride, frameBuffer.getDataU(), frameBuffer.getStrideU(), chromaWidth, chromaHeight);
        if (sliceHeight % 2 == 1) {
            buffer.position(uPos + uvStride * (chromaHeight - 1));
            ByteBuffer dataU = frameBuffer.getDataU();
            dataU.position(frameBuffer.getStrideU() * chromaHeight);
            dataU.put(buffer);
        }
        buffer.limit(vEnd);
        buffer.position(vPos);
        this.copyPlane(buffer.slice(), uvStride, frameBuffer.getDataV(), frameBuffer.getStrideV(), chromaWidth, chromaHeight);
        if (sliceHeight % 2 == 1) {
            buffer.position(vPos + uvStride * (chromaHeight - 1));
            ByteBuffer dataV = frameBuffer.getDataV();
            dataV.position(frameBuffer.getStrideV() * chromaHeight);
            dataV.put(buffer);
        }
        return frameBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reformat(MediaFormat format) {
        int newHeight;
        int newWidth;
        this.outputThreadChecker.checkIsOnValidThread();
        if (format.containsKey(MEDIA_FORMAT_KEY_CROP_LEFT) && format.containsKey(MEDIA_FORMAT_KEY_CROP_RIGHT) && format.containsKey(MEDIA_FORMAT_KEY_CROP_BOTTOM) && format.containsKey(MEDIA_FORMAT_KEY_CROP_TOP)) {
            newWidth = 1 + format.getInteger(MEDIA_FORMAT_KEY_CROP_RIGHT) - format.getInteger(MEDIA_FORMAT_KEY_CROP_LEFT);
            newHeight = 1 + format.getInteger(MEDIA_FORMAT_KEY_CROP_BOTTOM) - format.getInteger(MEDIA_FORMAT_KEY_CROP_TOP);
            RXLogging.i(TAG, "stream have crop info newWidth:" + newWidth + " newHeight:" + newHeight);
        } else {
            newWidth = format.getInteger("width");
            newHeight = format.getInteger("height");
        }
        Object object = this.dimensionLock;
        synchronized (object) {
            if (this.hasDecodedFirstFrame && (this.width != newWidth || this.height != newHeight)) {
                this.stopOnOutputThread(new RuntimeException("Unexpected size change. Configured " + this.width + "*" + this.height + ". New " + newWidth + "*" + newHeight));
                return;
            }
            this.width = newWidth;
            this.height = newHeight;
        }
        if (this.surfaceTextureHelper == null && this.ex_surface == null && format.containsKey("color-format")) {
            this.colorFormat = format.getInteger("color-format");
            RXLogging.i(TAG, "Color: 0x" + Integer.toHexString(this.colorFormat));
            if (!this.isSupportedColorFormat(this.colorFormat)) {
                this.stopOnOutputThread(new IllegalStateException("Unsupported color format: " + this.colorFormat));
                return;
            }
        }
        object = this.dimensionLock;
        synchronized (object) {
            if (format.containsKey(MEDIA_FORMAT_KEY_STRIDE)) {
                this.stride = format.getInteger(MEDIA_FORMAT_KEY_STRIDE);
            }
            if (format.containsKey(MEDIA_FORMAT_KEY_SLICE_HEIGHT)) {
                this.sliceHeight = format.getInteger(MEDIA_FORMAT_KEY_SLICE_HEIGHT);
            }
            RXLogging.i(TAG, "Frame stride and slice height: " + this.stride + " x " + this.sliceHeight);
            this.stride = Math.max(this.width, this.stride);
            this.sliceHeight = Math.max(this.height, this.sliceHeight);
        }
    }

    private void releaseCodecOnOutputThread() {
        this.outputThreadChecker.checkIsOnValidThread();
        RXLogging.i(TAG, "Releasing MediaCodec on output thread");
        try {
            this.codec.stop();
        }
        catch (Exception e) {
            RXLogging.e(TAG, "Media decoder stop failed", e);
        }
        try {
            this.codec.release();
        }
        catch (Exception e) {
            RXLogging.e(TAG, "Media decoder release failed", e);
            this.shutdownException = e;
        }
        this.releaseSurface();
        RXLogging.i(TAG, "Release on output thread done");
    }

    private void stopOnOutputThread(Exception e) {
        this.outputThreadChecker.checkIsOnValidThread();
        this.running = false;
        this.shutdownException = e;
    }

    private boolean isSupportedColorFormat(int colorFormat) {
        for (int supported : MediaCodecUtils.DECODER_COLOR_FORMATS) {
            if (supported != colorFormat) continue;
            return true;
        }
        return false;
    }

    protected SurfaceTextureHelper createSurfaceTextureHelper() {
        return SurfaceTextureHelper.create("decoder-texture-thread", this.sharedContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseSurface() {
        if (this.surface != null) {
            this.surface.release();
            this.surface = null;
        }
        Object object = this.surfaceTextureHelperLock;
        synchronized (object) {
            if (this.surfaceTextureHelper != null) {
                this.surfaceTextureHelper.stopListening();
                this.surfaceTextureHelper.dispose();
                this.surfaceTextureHelper = null;
            }
        }
    }

    protected VideoFrame.I420Buffer allocateI420Buffer(int width, int height) {
        return JavaI420Buffer.allocate(width, height);
    }

    protected void copyPlane(ByteBuffer src, int srcStride, ByteBuffer dst, int dstStride, int width, int height) {
        YuvHelper.copyPlane(src, srcStride, dst, dstStride, width, height);
    }

    private static class DecodedTextureMetadata {
        final long presentationTimestampUs;

        DecodedTextureMetadata(long presentationTimestampUs) {
            this.presentationTimestampUs = presentationTimestampUs;
        }
    }
}

