/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.content.Context;
import android.graphics.Matrix;
import android.view.WindowManager;
import org.webrtc.CameraEnumerationAndroid;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.TextureBufferImpl;
import org.webrtc.VideoFrame;

interface CameraSession {
    public void stop();

    public boolean isCameraTorchSupported();

    public void turnOnFlashLight();

    public void turnOffFlashLight();

    public boolean isCameraZoomSupported();

    public int setCameraZoomRatio(float var1);

    public float getCameraZoomMaxRatio();

    public void setOrientationMode(CameraVideoCapturer.ORIENTATION_MODE var1);

    public int enableFollowGravity(boolean var1);

    public int getDeviceOrientation();

    public static int getDeviceUIOrientation(Context context) {
        WindowManager wm = (WindowManager)context.getSystemService("window");
        switch (wm.getDefaultDisplay().getRotation()) {
            case 1: {
                return UIDeviceOrientation.LandscapeRight.value();
            }
            case 2: {
                return UIDeviceOrientation.PortraitUpsideDown.value();
            }
            case 3: {
                return UIDeviceOrientation.LandscapeLeft.value();
            }
        }
        return UIDeviceOrientation.Portrait.value();
    }

    public static VideoFrame.TextureBuffer createTextureBufferWithModifiedTransformMatrix(TextureBufferImpl buffer, boolean mirror, int rotation) {
        Matrix transformMatrix = new Matrix();
        transformMatrix.preTranslate(0.5f, 0.5f);
        if (mirror) {
            transformMatrix.preScale(-1.0f, 1.0f);
        }
        transformMatrix.preRotate((float)rotation);
        transformMatrix.preTranslate(-0.5f, -0.5f);
        return buffer.applyTransformMatrix(transformMatrix, buffer.getWidth(), buffer.getHeight());
    }

    public static interface Events {
        public void onCameraOpening();

        public void onCameraError(CameraSession var1, String var2);

        public void onCameraDisconnected(CameraSession var1);

        public void onCameraClosed(CameraSession var1);

        public void onFrameCaptured(CameraSession var1, VideoFrame var2);

        public void onCameraConfig(int var1, int var2, CameraEnumerationAndroid.CaptureFormat.FramerateRange var3);
    }

    public static interface CreateSessionCallback {
        public void onDone(CameraSession var1);

        public void onFailure(FailureType var1, String var2);
    }

    public static enum UIDeviceOrientation {
        Portrait(0),
        LandscapeLeft(90),
        PortraitUpsideDown(180),
        LandscapeRight(270);

        private int value = 0;

        public int value() {
            return this.value;
        }

        private UIDeviceOrientation(int value) {
            this.value = value;
        }
    }

    public static enum FailureType {
        ERROR,
        DISCONNECTED;

    }
}

