/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import org.webrtc.CalledByNative;
import org.webrtc.VideoCodecStatus;
import org.webrtc.VideoDecoder;
import org.webrtc.VideoFrame;

class VideoDecoderWrapper {
    VideoDecoderWrapper() {
    }

    @CalledByNative
    static VideoDecoder.Callback createDecoderCallback(final long nativeDecoder) {
        return new VideoDecoder.Callback(){

            @Override
            public void onDecodedFrame(VideoFrame frame) {
                if (nativeDecoder != 0L) {
                    VideoDecoderWrapper.nativeOnDecodedFrame(nativeDecoder, frame);
                }
            }

            @Override
            public void onDecoderInited(long time) {
                if (nativeDecoder != 0L) {
                    VideoDecoderWrapper.nativeOnDecoderInited(nativeDecoder, time);
                }
            }

            @Override
            public void onMediaCodecStatus(VideoCodecStatus type, String info) {
                if (nativeDecoder != 0L && info != null && info.length() != 0) {
                    VideoDecoderWrapper.nativeOnMediaCodecStatus(nativeDecoder, type, info);
                }
            }
        };
    }

    private static native void nativeOnDecodedFrame(long var0, VideoFrame var2);

    private static native void nativeOnDecoderInited(long var0, long var2);

    private static native void nativeOnMediaCodecStatus(long var0, VideoCodecStatus var2, String var3);
}

