/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.support.annotation.Nullable;
import org.webrtc.CalledByNative;
import org.webrtc.EncodedImage;
import org.webrtc.RXVideoCodecStandard;
import org.webrtc.VideoCodecStatus;
import org.webrtc.VideoFrame;

public interface VideoEncoder {
    @CalledByNative
    public VideoCodecStatus initEncode(Settings var1, Callback var2);

    @CalledByNative
    public VideoCodecStatus release();

    @CalledByNative
    public VideoCodecStatus encode(VideoFrame var1, boolean var2);

    @CalledByNative
    public VideoCodecStatus requestKeyFrame();

    @CalledByNative
    public VideoCodecStatus setRateAllocation(int var1, int var2);

    public static interface Callback {
        public void onEncodedFrame(EncodedImage var1, CodecSpecificInfo var2);
    }

    public static class ScalingSettings {
        public final boolean on;
        @Nullable
        public final Integer low;
        @Nullable
        public final Integer high;
        public static final ScalingSettings OFF = new ScalingSettings();

        public ScalingSettings(int low, int high) {
            this.on = true;
            this.low = low;
            this.high = high;
        }

        private ScalingSettings() {
            this.on = false;
            this.low = null;
            this.high = null;
        }

        @Deprecated
        public ScalingSettings(boolean on) {
            this.on = on;
            this.low = null;
            this.high = null;
        }

        @Deprecated
        public ScalingSettings(boolean on, int low, int high) {
            this.on = on;
            this.low = low;
            this.high = high;
        }

        public String toString() {
            return this.on ? "[ " + this.low + ", " + this.high + " ]" : "OFF";
        }
    }

    public static class CodecSpecificInfo {
        public RXVideoCodecStandard codec_standard;

        public CodecSpecificInfo(RXVideoCodecStandard standard) {
            this.codec_standard = standard;
        }
    }

    public static class Settings {
        public final int width;
        public final int height;
        public final ScaleMode scaleMode;
        public final int targetBps;
        public final int targetFps;
        public final int primaryId;
        public final int transferId;
        public final int matrixId;
        public final int rangeId;
        public final int maxQp;
        public final int minQp;
        public final int temporalLayerNum;
        public final BitrateMode bitrateMode;

        @CalledByNative(value="Settings")
        public Settings(int width, int height, int scaleModeValue, int targetBps, int targetFps, int primaryId, int transferId, int matrixId, int rangeId, int maxQp, int minQp, int temporalLayerNum, int bitrateModeValue) {
            this.width = width;
            this.height = height;
            this.scaleMode = ScaleMode.fromValue(scaleModeValue);
            this.targetBps = targetBps;
            this.targetFps = targetFps;
            this.primaryId = primaryId;
            this.transferId = transferId;
            this.matrixId = matrixId;
            this.rangeId = rangeId;
            this.maxQp = maxQp;
            this.minQp = minQp;
            this.temporalLayerNum = temporalLayerNum;
            this.bitrateMode = BitrateMode.fromValue(bitrateModeValue);
        }
    }

    public static enum BitrateMode {
        AUTO(0),
        VBR(1),
        CBR(2);

        private int value;

        private BitrateMode(int value) {
            this.value = value;
        }

        static BitrateMode fromValue(int value) {
            switch (value) {
                case 0: {
                    return AUTO;
                }
                case 1: {
                    return VBR;
                }
                case 2: {
                    return CBR;
                }
            }
            return AUTO;
        }
    }

    public static enum ScaleMode {
        AUTO(0),
        STRETCH(1),
        FIT_WITH_CROPPING(2),
        FIT_WITH_FILLING(3);

        private int value;

        private ScaleMode(int value) {
            this.value = value;
        }

        static ScaleMode fromValue(int value) {
            switch (value) {
                case 0: {
                    return AUTO;
                }
                case 1: {
                    return STRETCH;
                }
                case 2: {
                    return FIT_WITH_CROPPING;
                }
                case 3: {
                    return FIT_WITH_FILLING;
                }
            }
            return AUTO;
        }
    }
}

