/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.graphics.Matrix;
import android.opengl.EGLContext;
import com.bytedance.realx.base.RXLogging;
import java.nio.ByteBuffer;
import org.webrtc.CalledByNative;
import org.webrtc.FilterType;
import org.webrtc.RefCounted;

public class VideoFrame
implements RefCounted {
    private final Buffer buffer;
    private final int rotation;
    private final long timestampNs;
    private final ByteBuffer extendedData;
    private boolean isFlip = false;
    private int colorSpace = 0;

    public VideoFrame(Buffer buffer, int rotation, long timestampNs) {
        this(buffer, null, rotation, timestampNs);
    }

    public VideoFrame(Buffer buffer, int rotation, long timestampNs, boolean isFlip) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer not allowed to be null");
        }
        if (rotation % 90 != 0) {
            throw new IllegalArgumentException("rotation must be a multiple of 90");
        }
        this.buffer = buffer;
        this.rotation = rotation;
        this.timestampNs = timestampNs;
        this.extendedData = null;
        this.isFlip = isFlip;
    }

    public VideoFrame(Buffer buffer, ByteBuffer extendedData, int rotation, long timestampNs) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer not allowed to be null");
        }
        if (rotation % 90 != 0) {
            throw new IllegalArgumentException("rotation must be a multiple of 90");
        }
        this.buffer = buffer;
        this.rotation = rotation;
        this.timestampNs = timestampNs;
        this.extendedData = extendedData;
    }

    public VideoFrame(Buffer buffer, ByteBuffer extendedData, int rotation, long timestampNs, boolean isFlip) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer not allowed to be null");
        }
        if (rotation % 90 != 0) {
            throw new IllegalArgumentException("rotation must be a multiple of 90");
        }
        this.buffer = buffer;
        this.rotation = rotation;
        this.timestampNs = timestampNs;
        this.extendedData = extendedData;
        this.isFlip = isFlip;
    }

    @CalledByNative
    public VideoFrame(Buffer buffer, ByteBuffer extendedData, int rotation, long timestampNs, boolean isFlip, int colorSpace) {
        if (buffer == null) {
            throw new IllegalArgumentException("buffer not allowed to be null");
        }
        if (rotation % 90 != 0) {
            throw new IllegalArgumentException("rotation must be a multiple of 90");
        }
        this.buffer = buffer;
        this.rotation = rotation;
        this.timestampNs = timestampNs;
        this.extendedData = extendedData;
        this.isFlip = isFlip;
        this.colorSpace = colorSpace;
    }

    @CalledByNative
    public Buffer getBuffer() {
        return this.buffer;
    }

    public ByteBuffer getExtendedData() {
        return this.extendedData;
    }

    @CalledByNative
    public int getRotation() {
        return this.rotation;
    }

    @CalledByNative
    public int getColorSpace() {
        return this.colorSpace;
    }

    @CalledByNative
    public long getTimestampNs() {
        return this.timestampNs;
    }

    @CalledByNative
    public boolean getFlipState() {
        return this.isFlip;
    }

    @CalledByNative
    public void setFlipState(boolean flip) {
        this.isFlip = flip;
    }

    @CalledByNative
    public static ByteBuffer allocateDirectByteBuffer(int capacity) {
        return ByteBuffer.allocateDirect(capacity);
    }

    public int getRotatedWidth() {
        if (this.rotation % 180 == 0) {
            return this.buffer.getWidth();
        }
        return this.buffer.getHeight();
    }

    public int getRotatedHeight() {
        if (this.rotation % 180 == 0) {
            return this.buffer.getHeight();
        }
        return this.buffer.getWidth();
    }

    @Override
    public void retain() {
        this.buffer.retain();
    }

    @Override
    @CalledByNative
    public void release() {
        this.buffer.release();
    }

    public static enum ColorSpace {
        kUnknown(0),
        kYCbCrBT601LimitedRange(1),
        kYCbCrBT601FullRange(2),
        kYCbCrBT709LimitedRange(3),
        kYCbCrBT709FullRange(4);

        private int colorSpace = 0;

        private ColorSpace(int colorSpace) {
            this.colorSpace = colorSpace;
        }

        public int getColorSpace() {
            return this.colorSpace;
        }
    }

    public static interface TextureBuffer
    extends Buffer {
        @CalledByNative(value="TextureBuffer")
        public EGLContext getEglContext();

        @CalledByNative(value="TextureBuffer")
        public long getNativeEglContext();

        @CalledByNative(value="TextureBuffer")
        public Type getType();

        @CalledByNative(value="TextureBuffer")
        public int getTextureId();

        @CalledByNative(value="TextureBuffer")
        public Matrix getTransformMatrix();

        @CalledByNative(value="TextureBuffer")
        public float[] nativeGetTransFormMatrix();

        @CalledByNative(value="TextureBuffer")
        public int getTypeGlTarget();

        @CalledByNative(value="TextureBuffer")
        public FilterType getScaleFilter();

        @CalledByNative(value="TextureBuffer")
        public int getUnscaledWidth();

        @CalledByNative(value="TextureBuffer")
        public int getUnscaledHeight();

        @CalledByNative(value="TextureBuffer")
        public Buffer cropAndScaleWithFilter(int var1, int var2, int var3, int var4, int var5, int var6, int var7);

        @Override
        @CalledByNative(value="TextureBuffer")
        default public int getBufferType() {
            return 4;
        }

        public static enum Type {
            OES(36197),
            RGB(3553);

            private final int glTarget;

            private Type(int glTarget) {
                this.glTarget = glTarget;
            }

            @CalledByNative(value="TextureBuffer")
            public int getGlTarget() {
                return this.glTarget;
            }
        }
    }

    public static interface NV12Buffer
    extends Buffer {
        @CalledByNative(value="NV12Buffer")
        public ByteBuffer getDataY();

        @CalledByNative(value="NV12Buffer")
        public ByteBuffer getDataUV();

        @CalledByNative(value="NV12Buffer")
        public int getStrideY();

        @CalledByNative(value="NV12Buffer")
        public int getStrideUV();

        @Override
        @CalledByNative(value="NV12Buffer")
        default public int getBufferType() {
            return 1;
        }
    }

    public static interface I420Buffer
    extends Buffer {
        @CalledByNative(value="I420Buffer")
        public ByteBuffer getDataY();

        @CalledByNative(value="I420Buffer")
        public ByteBuffer getDataU();

        @CalledByNative(value="I420Buffer")
        public ByteBuffer getDataV();

        @CalledByNative(value="I420Buffer")
        public int getStrideY();

        @CalledByNative(value="I420Buffer")
        public int getStrideU();

        @CalledByNative(value="I420Buffer")
        public int getStrideV();

        @Override
        @CalledByNative(value="I420Buffer")
        default public int getBufferType() {
            return 3;
        }
    }

    public static interface Buffer
    extends RefCounted {
        @CalledByNative(value="Buffer")
        public int getBufferType();

        @CalledByNative(value="Buffer")
        public int getWidth();

        @CalledByNative(value="Buffer")
        public int getHeight();

        @CalledByNative(value="Buffer")
        public I420Buffer toI420();

        @CalledByNative(value="Buffer")
        default public NV12Buffer toNV12() {
            RXLogging.e("VideoFrame", "toNV12 has not been implemented, default return null");
            return null;
        }

        @Override
        @CalledByNative(value="Buffer")
        public void retain();

        @Override
        @CalledByNative(value="Buffer")
        public void release();

        @CalledByNative(value="Buffer")
        public Buffer cropAndScale(int var1, int var2, int var3, int var4, int var5, int var6);

        @CalledByNative(value="Buffer")
        public Buffer scaleAndFill(int var1, int var2, int var3, int var4);

        public static interface BufferType {
            public static final int Null = 0;
            public static final int Nv12 = 1;
            public static final int Nv21 = 2;
            public static final int I420 = 3;
            public static final int Texture = 4;
        }
    }
}

