/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae.router.device;

import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.media.AudioManager;

public class KaraokeMediaHelper {
    private final String KARAOKE_ENABLE = "audio_karaoke_enable";
    private final String KARAOKE_VOLUME = "audio_karaoke_volume";
    private final String KARAOKE_EQ = "audio_karaoke_EQ";
    private final String KARAOKE_REVERB = "audio_karaoke_Reverb";
    private final String KARAOKE_SUPPORT = "audio_karaoke_support";
    private final String KARAOKE_APP_SUPPORT = "karaoke_app_support";
    private final String KARAOKE_KTVMODE = "audio_karaoke_ktvmode";
    private final int VOLUME_MAX_APP = 15;
    private final int VOLUME_MIN_APP = 0;
    private boolean mInitialized;
    private int mEnabled;
    private int mVolume;
    private int mEqMode;
    private int mReverbMode;
    private ContentResolver mContentResolver;
    private Context mContext;
    private SharedPreferences mSp;
    private AudioManager mAudioManager;

    public KaraokeMediaHelper(Context context) {
        this.mContext = context;
        this.mContentResolver = this.mContext.getContentResolver();
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        this.mSp = this.mContext.getSharedPreferences("loopback_mode", 0);
        this.mInitialized = false;
    }

    public static KaraokeMediaHelper getInstance(Context context) {
        KaraokeMediaHelper manager = new KaraokeMediaHelper(context);
        return manager;
    }

    public boolean isDeviceSupportKaraoke() {
        String support = this.mAudioManager.getParameters("audio_karaoke_support");
        return support.contains("true");
    }

    public boolean isAppSupportKaraoke(String appName) {
        String support = this.mAudioManager.getParameters("karaoke_app_support:" + appName);
        return support.contains("true");
    }

    public void openKTVDevice() {
        if (this.mInitialized) {
            return;
        }
        this.mVolume = this.mSp.getInt("audio_karaoke_volume", 50);
        this.mEqMode = this.mSp.getInt("audio_karaoke_EQ", 0);
        this.mReverbMode = this.mSp.getInt("audio_karaoke_Reverb", 0);
        this.mAudioManager.setParameters("audio_karaoke_ktvmode=enable");
        this.mAudioManager.setParameters("audio_karaoke_volume=" + this.mVolume);
        this.mAudioManager.setParameters("audio_karaoke_EQ=" + this.mEqMode);
        this.mAudioManager.setParameters("audio_karaoke_Reverb=" + this.mReverbMode);
        this.mInitialized = true;
    }

    public void closeKTVDevice() {
        this.mAudioManager.setParameters("audio_karaoke_ktvmode=disable");
        this.mInitialized = false;
    }

    public void setMicVolParam(int param) {
        if (param > 15) {
            param = 15;
        }
        if (param < 0) {
            param = 0;
        }
        if (this.mVolume != param && this.isEnable()) {
            this.mAudioManager.setParameters("audio_karaoke_volume=" + param);
            this.mVolume = param;
        }
    }

    public int getMicVolParam() {
        return this.mVolume;
    }

    public void setPlayFeedbackParam(int enabled) {
        if (this.mEnabled == enabled) {
            return;
        }
        this.mEnabled = enabled;
        this.mAudioManager.setParameters("audio_karaoke_enable=" + enabled);
    }

    public int getPlayFeedbackParam() {
        if (this.isEnable()) {
            return 1;
        }
        return 0;
    }

    public void setFeedbackEffect(int revertMode) {
        if (revertMode > 0 && revertMode <= 3 && this.mReverbMode != revertMode) {
            this.mAudioManager.setParameters("audio_karaoke_Reverb=" + revertMode);
            this.mReverbMode = revertMode;
        }
    }

    public boolean isEnable() {
        return this.mEnabled == 1;
    }
}

