/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae.webrtc;

import android.os.Build;
import com.bytedance.bae.hwearback.HardwareEarbackPackageChecker;
import com.bytedance.bae.hwearback.HuaweiEarback;
import com.bytedance.bae.hwearback.IHardWareEarback;
import com.bytedance.bae.hwearback.VivoEarback;
import com.bytedance.bae.webrtc.WebRtcAudioManager;

public class WebRtcAudioEarBack {
    private static final String TAG = WebRtcAudioEarBack.class.getName();
    private EarBackType earback_type;
    IHardWareEarback hardWareEarback;
    private WebRtcAudioManager audioManager;

    public void ByteAudioEarBackInit() {
        String brand = Build.BRAND;
        if (brand.equalsIgnoreCase("HUAWEI") || brand.equalsIgnoreCase("HONOR")) {
            if (HardwareEarbackPackageChecker.isHuaweiEarbackPackageSupported()) {
                this.earback_type = EarBackType.hwEarBackType;
                this.hardWareEarback = new HuaweiEarback(this);
            }
        } else if (brand.equalsIgnoreCase("VIVO")) {
            this.earback_type = EarBackType.vivoEarBackType;
            this.hardWareEarback = new VivoEarback(this);
        } else if (!brand.equalsIgnoreCase("XIAOMI") && !brand.equalsIgnoreCase("Redmi")) {
            this.earback_type = EarBackType.openslesType;
        }
        if (this.hardWareEarback != null) {
            this.hardWareEarback.init();
        } else {
            this.onHardwareEarbackSupported(false);
        }
    }

    public void ByteAudioEarBackRelease() {
        if (this.hardWareEarback != null) {
            this.hardWareEarback.release();
            this.onHardwareEarbackReleased(true);
        }
    }

    public boolean ByteAudioEarBackSupport() {
        boolean isSupport = false;
        if (this.hardWareEarback != null) {
            isSupport = this.hardWareEarback.isSupport();
        }
        return isSupport;
    }

    public int ByteAudioEarBackSetVolume(int vol) {
        int success = -1;
        if (this.hardWareEarback != null) {
            success = this.hardWareEarback.setVolume(vol);
        }
        return success;
    }

    public void ByteAudioEarBackEffect(int value) {
        if (this.hardWareEarback != null) {
            this.hardWareEarback.setEffect(value);
        }
    }

    public void ByteAudioEarBackEqualizer(int value) {
        if (this.hardWareEarback != null) {
            this.hardWareEarback.setEqualizer(value);
        }
    }

    public int ByteAudioEarBackEnable(boolean enable) {
        int enableSuccess = -1;
        if (this.hardWareEarback != null) {
            enableSuccess = enable ? this.hardWareEarback.open() : this.hardWareEarback.close();
        }
        return enableSuccess;
    }

    public void onHardwareEarbackSupported(boolean isSupported) {
        if (this.audioManager != null) {
            this.audioManager.onHardwareEarbackSupported(isSupported);
        }
    }

    public void onHardwareEarbackReleased(boolean success) {
        if (this.audioManager != null) {
            this.audioManager.onHardwareEarbackReleased(success);
        }
    }

    public WebRtcAudioEarBack(WebRtcAudioManager webRtcAudioManager) {
        this.audioManager = webRtcAudioManager;
        this.ByteAudioEarBackInit();
    }

    public static enum EarBackType {
        hwEarBackType,
        vivoEarBackType,
        xiaomiEarBackType,
        openslesType;

    }
}

