/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae.webrtc;

import android.media.audiofx.AcousticEchoCanceler;
import android.media.audiofx.AudioEffect;
import android.media.audiofx.NoiseSuppressor;
import android.os.Build;
import android.support.annotation.Nullable;
import com.bytedance.bae.base.BaeLogging;
import com.bytedance.bae.webrtc.WebRtcAudioUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class WebRtcAudioEffects {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioEffects";
    private static Map<String, List<String>> audioEffectBlackList = new HashMap<String, List<String>>();
    private static final UUID AOSP_ACOUSTIC_ECHO_CANCELER = UUID.fromString("bb392ec0-8d4d-11e0-a896-0002a5d5c51b");
    private static final UUID AOSP_NOISE_SUPPRESSOR = UUID.fromString("c06c8400-8e06-11e0-9cb6-0002a5d5c51b");
    @Nullable
    private static AudioEffect.Descriptor[] cachedEffects;
    @Nullable
    private AcousticEchoCanceler aec;
    @Nullable
    private NoiseSuppressor ns;
    private boolean shouldEnableAec;
    private boolean shouldEnableNs;

    public static boolean isAcousticEchoCancelerSupported() {
        return WebRtcAudioEffects.isAcousticEchoCancelerEffectAvailable();
    }

    public static boolean isNoiseSuppressorSupported() {
        return WebRtcAudioEffects.isNoiseSuppressorEffectAvailable();
    }

    public static boolean isAcousticEchoCancelerBlacklisted() {
        List<String> blackListedModels = WebRtcAudioUtils.getBlackListedModelsForAecUsage();
        boolean isBlacklisted = blackListedModels.contains(Build.MODEL);
        if (isBlacklisted) {
            BaeLogging.w(TAG, Build.MODEL + " is blacklisted for HW AEC usage!");
        }
        return isBlacklisted;
    }

    public static boolean isNoiseSuppressorBlacklisted() {
        List<String> blackListedModels = WebRtcAudioUtils.getBlackListedModelsForNsUsage();
        boolean isBlacklisted = blackListedModels.contains(Build.MODEL);
        if (isBlacklisted) {
            BaeLogging.w(TAG, Build.MODEL + " is blacklisted for HW NS usage!");
        }
        return isBlacklisted;
    }

    private static boolean isAcousticEchoCancelerExcludedByUUID() {
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        for (AudioEffect.Descriptor d : WebRtcAudioEffects.getAvailableEffects()) {
            if (!d.type.equals(AudioEffect.EFFECT_TYPE_AEC) || !d.uuid.equals(AOSP_ACOUSTIC_ECHO_CANCELER)) continue;
            return true;
        }
        return false;
    }

    private static boolean isNoiseSuppressorExcludedByUUID() {
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        for (AudioEffect.Descriptor d : WebRtcAudioEffects.getAvailableEffects()) {
            if (!d.type.equals(AudioEffect.EFFECT_TYPE_NS) || !d.uuid.equals(AOSP_NOISE_SUPPRESSOR)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAcousticEchoCancelerEffectAvailable() {
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        return WebRtcAudioEffects.isEffectTypeAvailable(AudioEffect.EFFECT_TYPE_AEC);
    }

    private static boolean isNoiseSuppressorEffectAvailable() {
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        return WebRtcAudioEffects.isEffectTypeAvailable(AudioEffect.EFFECT_TYPE_NS);
    }

    public static boolean canUseAcousticEchoCanceler() {
        boolean canUseAcousticEchoCanceler = WebRtcAudioEffects.isAcousticEchoCancelerSupported() && !WebRtcAudioUtils.useWebRtcBasedAcousticEchoCanceler() && !WebRtcAudioEffects.isAcousticEchoCancelerBlacklisted();
        BaeLogging.i(TAG, "canUseAcousticEchoCanceler: " + canUseAcousticEchoCanceler);
        return canUseAcousticEchoCanceler;
    }

    public static boolean canUseNoiseSuppressor() {
        boolean canUseNoiseSuppressor = WebRtcAudioEffects.isNoiseSuppressorSupported() && !WebRtcAudioUtils.useWebRtcBasedNoiseSuppressor() && !WebRtcAudioEffects.isNoiseSuppressorBlacklisted();
        BaeLogging.i(TAG, "canUseNoiseSuppressor: " + canUseNoiseSuppressor);
        return canUseNoiseSuppressor;
    }

    public static WebRtcAudioEffects create() {
        return new WebRtcAudioEffects();
    }

    private WebRtcAudioEffects() {
        BaeLogging.i(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
    }

    public boolean setAEC(boolean enable) {
        BaeLogging.i(TAG, "setAEC(" + enable + ")");
        if (!WebRtcAudioEffects.canUseAcousticEchoCanceler()) {
            BaeLogging.w(TAG, "Platform AEC is not supported");
            this.shouldEnableAec = false;
            return false;
        }
        if (this.aec != null && enable != this.shouldEnableAec) {
            BaeLogging.e(TAG, "Platform AEC state can't be modified while recording");
            return false;
        }
        this.shouldEnableAec = enable;
        return true;
    }

    public boolean setNS(boolean enable) {
        BaeLogging.i(TAG, "setNS(" + enable + ")");
        if (!WebRtcAudioEffects.canUseNoiseSuppressor()) {
            BaeLogging.w(TAG, "Platform NS is not supported");
            this.shouldEnableNs = false;
            return false;
        }
        if (this.ns != null && enable != this.shouldEnableNs) {
            BaeLogging.e(TAG, "Platform NS state can't be modified while recording");
            return false;
        }
        this.shouldEnableNs = enable;
        return true;
    }

    public void enable(int audioSession) {
        boolean enable;
        boolean after;
        boolean befored;
        BaeLogging.i(TAG, "enable(audioSession=" + audioSession + ")");
        if (WebRtcAudioEffects.isAcousticEchoCancelerSupported()) {
            befored = false;
            after = false;
            enable = false;
            try {
                if (this.aec != null) {
                    BaeLogging.e(TAG, "Release previous aec instance");
                    this.aec.release();
                    this.aec = null;
                }
                this.aec = AcousticEchoCanceler.create((int)audioSession);
                if (this.aec != null) {
                    befored = this.aec.getEnabled();
                    boolean bl = enable = this.shouldEnableAec && WebRtcAudioEffects.canUseAcousticEchoCanceler();
                    if (this.aec.setEnabled(enable) != 0) {
                        BaeLogging.e(TAG, "Failed to set the AcousticEchoCanceler state");
                    }
                    after = this.aec.getEnabled();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.aec != null) {
                BaeLogging.i(TAG, "AcousticEchoCanceler: was " + (befored ? "enabled" : "disabled") + ", enable: " + enable + ", is now: " + (after ? "enabled" : "disabled"));
            } else {
                BaeLogging.e(TAG, "Failed to create the AcousticEchoCanceler instance");
            }
        }
        if (WebRtcAudioEffects.isNoiseSuppressorSupported()) {
            befored = false;
            after = false;
            enable = false;
            try {
                if (this.ns != null) {
                    BaeLogging.e(TAG, "Release previous ns instance");
                    this.ns.release();
                    this.ns = null;
                }
                this.ns = NoiseSuppressor.create((int)audioSession);
                if (this.ns != null) {
                    befored = this.ns.getEnabled();
                    boolean bl = enable = this.shouldEnableNs && WebRtcAudioEffects.canUseNoiseSuppressor();
                    if (this.ns.setEnabled(enable) != 0) {
                        BaeLogging.e(TAG, "Failed to set the NoiseSuppressor state");
                    }
                    after = this.ns.getEnabled();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.ns != null) {
                BaeLogging.i(TAG, "NoiseSuppressor: was " + (befored ? "enabled" : "disabled") + ", enable: " + enable + ", is now: " + (after ? "enabled" : "disabled"));
            } else {
                BaeLogging.e(TAG, "Failed to create the NoiseSuppressor instance");
            }
        }
    }

    public void release() {
        BaeLogging.i(TAG, "release");
        try {
            if (this.aec != null) {
                this.aec.release();
                this.aec = null;
            }
            if (this.ns != null) {
                this.ns.release();
                this.ns = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.aec = null;
            this.ns = null;
        }
    }

    private boolean effectTypeIsVoIP(UUID type) {
        if (Build.VERSION.SDK_INT < 18) {
            return false;
        }
        return AudioEffect.EFFECT_TYPE_AEC.equals(type) && WebRtcAudioEffects.isAcousticEchoCancelerSupported() || AudioEffect.EFFECT_TYPE_NS.equals(type) && WebRtcAudioEffects.isNoiseSuppressorSupported();
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    @Nullable
    private static AudioEffect.Descriptor[] getAvailableEffects() {
        if (cachedEffects != null) {
            return cachedEffects;
        }
        try {
            cachedEffects = AudioEffect.queryEffects();
        }
        catch (Exception e) {
            e.printStackTrace();
            return cachedEffects;
        }
        return cachedEffects;
    }

    private static boolean isEffectTypeAvailable(UUID effectType) {
        AudioEffect.Descriptor[] effects = WebRtcAudioEffects.getAvailableEffects();
        if (effects == null) {
            return false;
        }
        for (AudioEffect.Descriptor d : effects) {
            if (!d.type.equals(effectType)) continue;
            return true;
        }
        return false;
    }

    private static void initAudioEffectBlackList() {
        audioEffectBlackList.put("vivo", new ArrayList());
        audioEffectBlackList.get("vivo").add("Funtouch OS_3.1_PD1616_D_7.17.5");
    }

    public static boolean IsAudioEffectSupported() {
        String brand;
        if (audioEffectBlackList.isEmpty()) {
            WebRtcAudioEffects.initAudioEffectBlackList();
        }
        if ((brand = WebRtcAudioUtils.getProductBrand()).isEmpty()) {
            return true;
        }
        if (!audioEffectBlackList.containsKey(brand)) {
            return true;
        }
        String rom_version = WebRtcAudioUtils.getRomVersion(brand);
        boolean isRomInBlackList = audioEffectBlackList.get(brand).contains(rom_version);
        BaeLogging.w(TAG, "IsAudioEffectSupported, " + brand + ", " + rom_version + ", in black list = " + isRomInBlackList);
        return !isRomInBlackList;
    }
}

