/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae.webrtc;

import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import android.net.Uri;
import android.os.Build;
import android.os.ParcelFileDescriptor;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.URLUtil;
import com.bytedance.bae.base.BaeLogging;
import com.bytedance.bae.base.CalledByNative;
import com.bytedance.bae.base.ContextUtils;
import java.io.FileDescriptor;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.util.Vector;

class WebRtcAudioFile {
    private static final String TAG = "WebRtcAudioRecordFile";
    private static final int MAX_DECODER_RETRY_COUNT = 100;
    @Nullable
    private MediaCodec mMediaCodec;
    @Nullable
    private MediaExtractor mExtractor;
    @Nullable
    private MediaFormat mUsedTrackFormat;
    private boolean eoInputStream;
    private boolean eoOutputStream;
    private int mSampleRate = 0;
    private int mChannels = 0;
    private long mFileLength;
    private int mRetryCount;
    private int mUsedTrackIdx;
    private Vector<Integer> mTrackIds;
    private ByteBuffer[] mInputBuffers;
    private ByteBuffer[] mOutputBuffers;
    @Nullable
    private byte[] mDecodedData;
    private HttpURLConnection oc;

    @CalledByNative
    WebRtcAudioFile() {
        BaeLogging.e(TAG, "AudioMix WebRtcAudioFile");
    }

    @CalledByNative
    boolean init(String fileName, int useTrack) {
        try {
            BaeLogging.i(TAG, "Try to decode audio file : " + fileName);
            this.mTrackIds = new Vector();
            if (URLUtil.isNetworkUrl((String)fileName)) {
                String string = fileName = this.checkUrlEncoded(fileName) ? fileName : this.encodeUrl(fileName);
                if (fileName == null || !this.isAvailableOnlineURL(fileName)) {
                    return false;
                }
            }
            this.mRetryCount = 0;
            this.mExtractor = new MediaExtractor();
            Context context = ContextUtils.getApplicationContext();
            if (fileName.startsWith("/assets/") && context != null) {
                AssetFileDescriptor assetFileDescriptor = context.getAssets().openFd(fileName.substring("/assets/".length()));
                this.mExtractor.setDataSource(assetFileDescriptor.getFileDescriptor(), assetFileDescriptor.getStartOffset(), assetFileDescriptor.getLength());
            } else if (fileName.startsWith("content://") && context != null) {
                Uri uri = Uri.parse((String)fileName);
                ParcelFileDescriptor parcelFileDescriptor = context.getContentResolver().openFileDescriptor(uri, "r");
                FileDescriptor fileDescriptor = parcelFileDescriptor.getFileDescriptor();
                this.mExtractor.setDataSource(fileDescriptor);
            } else {
                this.mExtractor.setDataSource(fileName);
            }
            int trackCount = this.mExtractor.getTrackCount();
            for (int i = 0; i < trackCount; ++i) {
                this.mExtractor.unselectTrack(i);
            }
            if (useTrack + 1 > trackCount) {
                BaeLogging.e(TAG, "useTrack > trackCount");
                return false;
            }
            int audio_track = 0;
            this.mChannels = 0;
            for (int i = 0; i < trackCount; ++i) {
                MediaFormat current_format = this.mExtractor.getTrackFormat(i);
                String mimeType = current_format.getString("mime");
                if (!mimeType.contains("audio/")) continue;
                if (useTrack == audio_track) {
                    this.mExtractor.selectTrack(i);
                    this.mMediaCodec = MediaCodec.createDecoderByType((String)mimeType);
                    this.mMediaCodec.configure(current_format, null, null, 0);
                    this.mUsedTrackFormat = current_format;
                    this.mUsedTrackIdx = audio_track;
                }
                ++audio_track;
                this.mTrackIds.addElement(new Integer(i));
                int current_ch = current_format.getInteger("channel-count");
                if (current_ch <= this.mChannels) continue;
                this.mChannels = current_ch;
            }
            if (this.mMediaCodec == null) {
                BaeLogging.e(TAG, "mMediaCodec is null");
                return false;
            }
            this.mMediaCodec.start();
            this.mSampleRate = this.mUsedTrackFormat.getInteger("sample-rate");
            this.mFileLength = this.mUsedTrackFormat.getLong("durationUs");
        }
        catch (Exception e) {
            e.printStackTrace();
            BaeLogging.e(TAG, "Error when creating audio file decode, error:" + e.getMessage());
            BaeLogging.e(TAG, "stack track: " + Log.getStackTraceString((Throwable)e));
            return false;
        }
        return true;
    }

    @CalledByNative
    public int getChannelCount() {
        return this.mChannels;
    }

    @CalledByNative
    public int getSampleRate() {
        return this.mSampleRate;
    }

    @CalledByNative
    public long getFileLength() {
        return this.mFileLength / 1000L;
    }

    @CalledByNative
    public long getCurrentFilePosition() {
        long ret = 0L;
        try {
            ret = this.mExtractor.getSampleTime() / 1000L;
        }
        catch (Exception e) {
            e.printStackTrace();
            BaeLogging.e(TAG, "Error when getCurrentFilePosition");
        }
        return ret;
    }

    @CalledByNative
    public int getUsedTrackIdx() {
        return this.mUsedTrackIdx;
    }

    @CalledByNative
    public int getAudioTrackCount() {
        if (this.mTrackIds == null) {
            return 0;
        }
        return this.mTrackIds.size();
    }

    @CalledByNative
    public void disConnectURL() {
        BaeLogging.e(TAG, "disConnectURL");
        if (this.oc != null) {
            this.oc.disconnect();
        }
    }

    @CalledByNative
    public void selectTrack(int trackIdx) {
        try {
            if (this.mTrackIds == null) {
                return;
            }
            if (trackIdx + 1 > this.mTrackIds.size()) {
                return;
            }
            if (this.mUsedTrackIdx == trackIdx) {
                return;
            }
            if (this.mExtractor == null || this.mMediaCodec == null) {
                BaeLogging.e(TAG, "mExtractor or mMediaCodec is null, mExtractor = " + this.mExtractor + ", mMediaCodec = " + this.mMediaCodec);
                return;
            }
            MediaFormat used_format = this.mExtractor.getTrackFormat(this.mTrackIds.get(trackIdx).intValue());
            if (this.mSampleRate != used_format.getInteger("sample-rate")) {
                BaeLogging.e(TAG, "mSampleRate = " + this.mSampleRate + ", used_SampleRate = " + used_format.getInteger("sample-rate"));
                return;
            }
            long current_postion = this.mExtractor.getSampleTime();
            BaeLogging.e(TAG, "++current_postion = " + current_postion);
            this.mExtractor.unselectTrack(this.mTrackIds.get(this.mUsedTrackIdx).intValue());
            this.mMediaCodec.stop();
            String mimeType = used_format.getString("mime");
            this.mExtractor.selectTrack(this.mTrackIds.get(trackIdx).intValue());
            this.mExtractor.seekTo(current_postion, 2);
            this.mMediaCodec.configure(used_format, null, null, 0);
            this.mMediaCodec.start();
            this.mUsedTrackFormat = used_format;
            this.mUsedTrackIdx = trackIdx;
            return;
        }
        catch (Exception e) {
            e.printStackTrace();
            BaeLogging.e(TAG, "Error when selectTrack");
            return;
        }
    }

    @CalledByNative
    public void setCurrentFilePosition(long position) {
        if (this.eoOutputStream) {
            try {
                this.mMediaCodec.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
                BaeLogging.e(TAG, "Error when setCurrentFilePosition, mMediaCodec.flush");
            }
        }
        try {
            this.mExtractor.seekTo(position * 1000L, 2);
            this.eoInputStream = false;
            this.eoOutputStream = false;
        }
        catch (Exception e) {
            e.printStackTrace();
            BaeLogging.e(TAG, "Error when setCurrentFilePosition, mExtractor.seekTo");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @CalledByNative
    public boolean readAudioData() {
        try {
            int index;
            if (this.mMediaCodec == null || this.mExtractor == null) {
                return this.eoInputStream;
            }
            if (!this.eoInputStream && (index = this.mMediaCodec.dequeueInputBuffer(0L)) >= 0) {
                ByteBuffer buf;
                if (Build.VERSION.SDK_INT >= 21) {
                    buf = this.mMediaCodec.getInputBuffer(index);
                } else {
                    this.mInputBuffers = this.mMediaCodec.getInputBuffers();
                    buf = this.mInputBuffers[index];
                }
                int sampleSize = this.mExtractor.readSampleData(buf, 0);
                if (sampleSize <= 0) {
                    sampleSize = 0;
                    this.eoInputStream = true;
                }
                long presentationTimeUs = this.mExtractor.getSampleTime();
                int flags = this.mExtractor.getSampleFlags();
                if (this.eoInputStream) {
                    flags |= 4;
                }
                this.mMediaCodec.queueInputBuffer(index, 0, sampleSize, presentationTimeUs, flags);
                this.mExtractor.advance();
            }
            if (this.eoOutputStream) return this.eoOutputStream;
            MediaCodec.BufferInfo info = new MediaCodec.BufferInfo();
            int index2 = this.mMediaCodec.dequeueOutputBuffer(info, 0L);
            this.mDecodedData = null;
            switch (index2) {
                case -3: 
                case -2: {
                    this.mDecodedData = new byte[0];
                    return this.eoOutputStream;
                }
                case -1: {
                    ++this.mRetryCount;
                    if (this.mRetryCount >= 100 && (Build.BRAND.toLowerCase().contains("meizu") || Build.MANUFACTURER.toLowerCase().contains("meizu") || Build.BRAND.toLowerCase().contains("vivo") || Build.MANUFACTURER.toLowerCase().contains("vivo"))) {
                        BaeLogging.e(TAG, "EAGAIN count=" + this.mRetryCount + " presentationTimeUs=" + info.presentationTimeUs + " totalUs=" + this.mFileLength + " Force EOS");
                        this.eoOutputStream = true;
                        this.mRetryCount = 0;
                    }
                    this.mDecodedData = new byte[0];
                    return this.eoOutputStream;
                }
                default: {
                    this.mRetryCount = 0;
                    if (index2 < 0) return this.eoOutputStream;
                    if ((info.flags & 4) == 4) {
                        this.eoOutputStream = true;
                    }
                    ByteBuffer buf = null;
                    if (Build.VERSION.SDK_INT >= 21) {
                        buf = this.mMediaCodec.getOutputBuffer(index2);
                    } else {
                        this.mOutputBuffers = this.mMediaCodec.getOutputBuffers();
                        buf = this.mOutputBuffers[index2];
                        buf.limit(info.size);
                    }
                    int used_ch = this.mUsedTrackFormat.getInteger("channel-count");
                    if (used_ch != this.mChannels && this.mChannels == 2) {
                        this.mDecodedData = new byte[buf.limit() * 2];
                        for (int i = 0; i < info.size / 2; ++i) {
                            this.mDecodedData[4 * i] = buf.get();
                            this.mDecodedData[4 * i + 2] = this.mDecodedData[4 * i];
                            this.mDecodedData[4 * i + 1] = buf.get();
                            this.mDecodedData[4 * i + 3] = this.mDecodedData[4 * i + 1];
                        }
                        buf.clear();
                    } else if (used_ch == this.mChannels) {
                        this.mDecodedData = new byte[buf.limit()];
                        buf.get(this.mDecodedData, info.offset, info.size);
                        buf.clear();
                    }
                    this.mMediaCodec.releaseOutputBuffer(index2, false);
                }
            }
            return this.eoOutputStream;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.eoOutputStream;
    }

    @CalledByNative
    public void uninit() {
        try {
            if (this.mMediaCodec != null) {
                this.mMediaCodec.stop();
                this.mMediaCodec.release();
                this.mMediaCodec = null;
            }
            if (this.mExtractor != null) {
                this.mExtractor.release();
                this.mExtractor = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BaeLogging.e(TAG, "Error when releasing audio file stream" + e.getMessage());
        }
        this.eoOutputStream = false;
        this.eoInputStream = false;
    }

    @CalledByNative
    @Nullable
    public byte[] getDecodedData() {
        return this.mDecodedData;
    }

    private boolean checkInfoChange() {
        if (Build.VERSION.SDK_INT < 19) {
            return false;
        }
        try {
            MediaFormat curr_format = this.mMediaCodec.getOutputFormat();
            int curr_rate = curr_format.getInteger("sample-rate");
            int curr_channels = curr_format.getInteger("channel-count");
            boolean change = this.mSampleRate != curr_rate || this.mChannels != curr_channels;
            this.mSampleRate = curr_rate;
            this.mChannels = curr_channels;
            return change;
        }
        catch (Exception e) {
            e.printStackTrace();
            BaeLogging.e(TAG, "Error when checking file's new format");
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAvailableOnlineURL(String path) {
        BaeLogging.e(TAG, "isAvailableOnlineURL");
        this.oc = null;
        boolean isAvailableURL = false;
        try {
            URL urlObj = new URL(path);
            this.oc = (HttpURLConnection)urlObj.openConnection();
            this.oc.setUseCaches(false);
            this.oc.setConnectTimeout(4000);
            BaeLogging.e(TAG, "connect done....");
            int status = 404;
            status = this.oc.getResponseCode();
            if (200 == status) {
                isAvailableURL = true;
            } else {
                isAvailableURL = false;
                BaeLogging.e(TAG, "url is not available, error:" + status);
            }
            InputStream inputStream = this.oc.getInputStream();
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            BaeLogging.e(TAG, "++Error when test online url: " + exception.getMessage());
            isAvailableURL = false;
        }
        finally {
            if (this.oc != null) {
                this.oc.disconnect();
            }
        }
        return isAvailableURL;
    }

    private boolean checkUrlEncoded(String path) {
        try {
            String str = URLDecoder.decode(path, "UTF-8");
            return !TextUtils.equals((CharSequence)path, (CharSequence)str);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            BaeLogging.e(TAG, "Error when releasing audio file stream");
            return false;
        }
    }

    private String encodeUrl(String path) {
        BaeLogging.e(TAG, "encodedUrl");
        try {
            URL uRL = new URL(path);
            URI uRI = new URI(uRL.getProtocol(), uRL.getUserInfo(), uRL.getHost(), uRL.getPort(), uRL.getPath(), uRL.getQuery(), uRL.getRef());
            return uRI.toASCIIString();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return path;
        }
    }
}

