/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae.webrtc;

import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioRecordingConfiguration;
import android.media.AudioTrack;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.telephony.PhoneStateListener;
import android.telephony.ServiceState;
import android.telephony.TelephonyManager;
import com.bytedance.bae.base.BaeLogging;
import com.bytedance.bae.base.ContextUtils;
import com.bytedance.bae.webrtc.WebRtcAudioEarBack;
import com.bytedance.bae.webrtc.WebRtcAudioEffects;
import com.bytedance.bae.webrtc.WebRtcAudioUtils;
import com.bytedance.bae.webrtc.observer.VolumeChangedObserver;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class WebRtcAudioManager
implements VolumeChangedObserver.OnVolumeChangedListener {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioManager";
    private static final boolean blacklistDeviceForAAudioUsage = true;
    private static boolean useStereoOutput;
    private static boolean useStereoInput;
    private static boolean blacklistDeviceForOpenSLESUsage;
    private static boolean blacklistDeviceForOpenSLESUsageIsOverridden;
    private static final int BITS_PER_SAMPLE = 16;
    private static final int DEFAULT_FRAME_PER_BUFFER = 256;
    private long nativeAudioManager;
    private final AudioManager audioManager;
    private boolean initialized;
    private int nativeSampleRate;
    private int nativeChannels;
    private boolean hardwareAEC;
    private boolean hardwareAGC;
    private boolean hardwareNS;
    private boolean lowLatencyOutput;
    private boolean lowLatencyInput;
    private boolean proAudio;
    private boolean aAudio;
    private int sampleRate;
    private int outputChannels;
    private int inputChannels;
    private int outputBufferSize;
    private int inputBufferSize;
    private int preferAudioLayer = 0;
    private AudioManagerRecordingCallback recordingCallback = null;
    private AudioManagerPhoneStateListener phoneStateListener = null;
    private Set<NativeRecordCallbackInfo> lastRecordcallbackInfos;
    private VolumeChangedObserver mVolumeChangedObserver;
    private static int MAX_VOLUMED;
    private static int MAX_VOLUMED_VOIP;
    private WebRtcAudioEarBack mByteAudioEarback;

    public static synchronized void setBlacklistDeviceForOpenSLESUsage(boolean enable) {
        blacklistDeviceForOpenSLESUsageIsOverridden = true;
        blacklistDeviceForOpenSLESUsage = enable;
    }

    public static synchronized void setStereoOutput(boolean enable) {
        BaeLogging.w(TAG, "Overriding default output behavior: setStereoOutput(" + enable + ')');
        useStereoOutput = enable;
    }

    public static synchronized void setStereoInput(boolean enable) {
        BaeLogging.w(TAG, "Overriding default input behavior: setStereoInput(" + enable + ')');
        useStereoInput = enable;
    }

    public static synchronized boolean getStereoOutput() {
        return useStereoOutput;
    }

    public static synchronized boolean getStereoInput() {
        return useStereoInput;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onVolumeChanged(int streamType, int volume) {
        double max = streamType == 0 ? (double)MAX_VOLUMED_VOIP : (double)MAX_VOLUMED;
        double v = 1.0 * (double)volume / max * 100.0;
        WebRtcAudioManager webRtcAudioManager = this;
        synchronized (webRtcAudioManager) {
            if (this.nativeAudioManager != 0L) {
                this.onVolumeChanged(streamType, (int)v, this.nativeAudioManager);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    WebRtcAudioManager(long nativeAudioManager) {
        WebRtcAudioManager webRtcAudioManager = this;
        synchronized (webRtcAudioManager) {
            BaeLogging.i(TAG, "ctor(" + this + ")" + WebRtcAudioUtils.getThreadInfo());
            this.nativeAudioManager = nativeAudioManager;
            this.audioManager = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
            MAX_VOLUMED = this.audioManager.getStreamMaxVolume(3);
            MAX_VOLUMED_VOIP = this.audioManager.getStreamMaxVolume(0);
            this.refreshAudioParameters();
            WebRtcAudioUtils.logAudioState(TAG);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean init() {
        WebRtcAudioManager webRtcAudioManager = this;
        synchronized (webRtcAudioManager) {
            BaeLogging.i(TAG, "init(" + this + ")" + WebRtcAudioUtils.getThreadInfo());
            if (this.initialized) {
                return true;
            }
            BaeLogging.i(TAG, "audio mode is: " + WebRtcAudioUtils.modeToString(this.audioManager.getMode()));
            if (Build.VERSION.SDK_INT >= 24 && this.recordingCallback == null) {
                this.recordingCallback = new AudioManagerRecordingCallback(this);
                this.audioManager.registerAudioRecordingCallback((AudioManager.AudioRecordingCallback)this.recordingCallback, null);
            }
            this.registerPhoneStateListener(32);
            this.mVolumeChangedObserver = new VolumeChangedObserver(this);
            int mode = this.audioManager.getMode();
            if (mode == 0) {
                int volume = this.audioManager.getStreamVolume(3);
                this.onVolumeChanged(3, volume);
            } else if (mode == 3) {
                int volume = this.audioManager.getStreamVolume(0);
                this.onVolumeChanged(0, volume);
            }
            this.initialized = true;
        }
        return true;
    }

    private void registerPhoneStateListener(final int events) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    TelephonyManager telephonyManager;
                    if (WebRtcAudioManager.this.phoneStateListener == null) {
                        WebRtcAudioManager.this.phoneStateListener = new AudioManagerPhoneStateListener();
                    }
                    if ((telephonyManager = (TelephonyManager)ContextUtils.getApplicationContext().getSystemService("phone")) != null) {
                        telephonyManager.listen((PhoneStateListener)WebRtcAudioManager.this.phoneStateListener, events);
                    }
                    BaeLogging.i(WebRtcAudioManager.TAG, "registerPhoneStateListener success with event: " + events);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    BaeLogging.e(WebRtcAudioManager.TAG, "registerPhoneStateListener (" + events + "), error: " + t.getCause() + ", " + t.getMessage());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate() {
        WebRtcAudioManager webRtcAudioManager = this;
        synchronized (webRtcAudioManager) {
            BaeLogging.i(TAG, "terminate(" + this + ")" + WebRtcAudioUtils.getThreadInfo());
            if (Build.VERSION.SDK_INT >= 24 && this.recordingCallback != null) {
                this.audioManager.unregisterAudioRecordingCallback((AudioManager.AudioRecordingCallback)this.recordingCallback);
                this.recordingCallback = null;
            }
            this.registerPhoneStateListener(0);
            if (this.mVolumeChangedObserver != null) {
                this.mVolumeChangedObserver.release();
                this.mVolumeChangedObserver = null;
            }
            if (this.mByteAudioEarback != null) {
                this.mByteAudioEarback.ByteAudioEarBackRelease();
            }
            this.nativeAudioManager = 0L;
            this.initialized = false;
        }
    }

    private boolean isCommunicationModeEnabled() {
        return this.audioManager.getMode() == 3;
    }

    private int SetAudioMode(int mode) {
        try {
            if (mode == this.getMode()) {
                return 0;
            }
            this.audioManager.setMode(mode);
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1;
        }
        return 0;
    }

    private boolean isWiredHeadsetOn() {
        return this.audioManager.isWiredHeadsetOn();
    }

    private boolean isDeviceBlacklistedForOpenSLESUsage() {
        boolean blacklisted;
        boolean bl = blacklisted = blacklistDeviceForOpenSLESUsageIsOverridden ? blacklistDeviceForOpenSLESUsage : WebRtcAudioUtils.deviceIsBlacklistedForOpenSLESUsage();
        if (blacklisted) {
            BaeLogging.i(TAG, Build.MODEL + " is blacklisted for OpenSL ES usage!");
        }
        return blacklisted;
    }

    private boolean isOpenSLESRecordShouldUseVoiceRecognition() {
        return Build.BRAND.equals("samsung") && Build.VERSION.SDK_INT >= 21;
    }

    private void refreshAudioParameters() {
        this.storeAudioParameters();
        this.nativeCacheAudioParameters(this.sampleRate, this.outputChannels, this.inputChannels, this.hardwareAEC, this.hardwareAGC, this.hardwareNS, this.lowLatencyOutput, this.lowLatencyInput, this.proAudio, this.aAudio, this.outputBufferSize, this.inputBufferSize, this.preferAudioLayer, this.nativeAudioManager);
    }

    private void storeAudioParameters() {
        this.outputChannels = WebRtcAudioManager.getStereoOutput() ? 2 : 1;
        this.inputChannels = WebRtcAudioManager.getStereoInput() ? 2 : 1;
        this.sampleRate = this.getNativeOutputSampleRate();
        this.hardwareAEC = WebRtcAudioManager.isAcousticEchoCancelerSupported();
        this.hardwareAGC = false;
        this.hardwareNS = WebRtcAudioManager.isNoiseSuppressorSupported();
        this.lowLatencyOutput = this.isLowLatencyOutputSupported();
        this.lowLatencyInput = this.isLowLatencyInputSupported();
        this.proAudio = this.isProAudioSupported();
        this.aAudio = this.isAAudioSupported();
        this.outputBufferSize = this.lowLatencyOutput ? this.getLowLatencyOutputFramesPerBuffer() : WebRtcAudioManager.getMinOutputFrameSize(this.sampleRate, this.outputChannels);
        this.inputBufferSize = this.lowLatencyInput ? this.getLowLatencyInputFramesPerBuffer() : WebRtcAudioManager.getMinInputFrameSize(this.sampleRate, this.inputChannels);
        this.preferAudioLayer = this.getPreferAudioLayer();
    }

    private boolean hasEarpiece() {
        return ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    private boolean isLowLatencyOutputSupported() {
        return ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.audio.low_latency");
    }

    public boolean isLowLatencyInputSupported() {
        return Build.VERSION.SDK_INT >= 21 && this.isLowLatencyOutputSupported();
    }

    private boolean isProAudioSupported() {
        return Build.VERSION.SDK_INT >= 23 && ContextUtils.getApplicationContext().getPackageManager().hasSystemFeature("android.hardware.audio.pro");
    }

    private boolean isAAudioSupported() {
        BaeLogging.w(TAG, "AAudio support is currently disabled on all devices!");
        return false;
    }

    private int getNativeOutputSampleRate() {
        if (WebRtcAudioUtils.runningOnEmulator()) {
            BaeLogging.i(TAG, "Running emulator, overriding sample rate to 8 kHz.");
            return 8000;
        }
        if (WebRtcAudioUtils.isDefaultSampleRateOverridden()) {
            BaeLogging.i(TAG, "Default sample rate is overriden to " + WebRtcAudioUtils.getDefaultSampleRateHz() + " Hz");
            return WebRtcAudioUtils.getDefaultSampleRateHz();
        }
        int sampleRateHz = WebRtcAudioUtils.getDefaultSampleRateHz();
        BaeLogging.i(TAG, "Sample rate is set to " + sampleRateHz + " Hz");
        return sampleRateHz;
    }

    private int getSampleRateForApiLevel() {
        if (Build.VERSION.SDK_INT < 17) {
            return WebRtcAudioUtils.getDefaultSampleRateHz();
        }
        String sampleRateString = this.audioManager.getProperty("android.media.property.OUTPUT_SAMPLE_RATE");
        return sampleRateString == null ? WebRtcAudioUtils.getDefaultSampleRateHz() : Integer.parseInt(sampleRateString);
    }

    private int getLowLatencyOutputFramesPerBuffer() {
        if (!this.isLowLatencyOutputSupported()) {
            return 256;
        }
        if (Build.VERSION.SDK_INT < 17) {
            return 256;
        }
        String framesPerBuffer = this.audioManager.getProperty("android.media.property.OUTPUT_FRAMES_PER_BUFFER");
        return framesPerBuffer == null ? 256 : Integer.parseInt(framesPerBuffer);
    }

    private static boolean isAcousticEchoCancelerSupported() {
        return WebRtcAudioEffects.canUseAcousticEchoCanceler();
    }

    private static boolean isNoiseSuppressorSupported() {
        return WebRtcAudioEffects.canUseNoiseSuppressor();
    }

    private static int getMinOutputFrameSize(int sampleRateInHz, int numChannels) {
        int bytesPerFrame = numChannels * 2;
        int channelConfig = numChannels == 1 ? 4 : 12;
        return AudioTrack.getMinBufferSize((int)sampleRateInHz, (int)channelConfig, (int)2) / bytesPerFrame;
    }

    private int getLowLatencyInputFramesPerBuffer() {
        return this.getLowLatencyOutputFramesPerBuffer();
    }

    private static int getMinInputFrameSize(int sampleRateInHz, int numChannels) {
        int bytesPerFrame = numChannels * 2;
        int channelConfig = numChannels == 1 ? 16 : 12;
        return AudioRecord.getMinBufferSize((int)sampleRateInHz, (int)channelConfig, (int)2) / bytesPerFrame;
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private boolean isPermissionGranted() {
        return WebRtcAudioUtils.isPermissionGranted();
    }

    private String getAudioDeviceInfo() {
        try {
            return "{ Audio State: audio mode: " + WebRtcAudioUtils.modeToString(this.audioManager.getMode()) + ", has mic: " + WebRtcAudioUtils.hasMicrophone() + ", mic muted: " + this.audioManager.isMicrophoneMute() + ", music active: " + this.audioManager.isMusicActive() + ", speakerphone: " + this.audioManager.isSpeakerphoneOn() + ", headset: " + this.audioManager.isWiredHeadsetOn() + "BT SCO: " + this.audioManager.isBluetoothScoOn() + "music actived: " + this.audioManager.isMusicActive() + "permission: " + WebRtcAudioUtils.isPermissionGranted() + " bt_sco_available_off_call: " + this.audioManager.isBluetoothScoAvailableOffCall() + " }";
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            BaeLogging.e(TAG, stringWriter.toString());
            return stringWriter.toString();
        }
    }

    private int getMode() {
        try {
            return this.audioManager.getMode();
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            BaeLogging.e(TAG, stringWriter.toString());
            return -1;
        }
    }

    private int getFixedDevicePlayVolume() {
        try {
            int mode = this.audioManager.getMode();
            int streamType = 0;
            switch (mode) {
                case 1: {
                    streamType = 2;
                    break;
                }
                case 0: {
                    streamType = 3;
                    break;
                }
                case 2: 
                case 3: {
                    streamType = 0;
                    break;
                }
                default: {
                    streamType = 3;
                }
            }
            return (int)(100.0 * (double)this.audioManager.getStreamVolume(streamType) / (double)this.audioManager.getStreamMaxVolume(streamType));
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            BaeLogging.e(TAG, stringWriter.toString());
            return -1;
        }
    }

    private int getFixedDeviceRecordVolume() {
        try {
            return this.audioManager.isMicrophoneMute() ? 0 : 100;
        }
        catch (Exception e) {
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            BaeLogging.e(TAG, stringWriter.toString());
            return -1;
        }
    }

    private int getPreferAudioLayer() {
        int preferAudioLayer = 0;
        return preferAudioLayer;
    }

    private void earBackInit() {
        this.mByteAudioEarback = new WebRtcAudioEarBack(this);
    }

    private int earBackEnable(boolean enable) {
        int enableSuccess = -1;
        if (this.mByteAudioEarback != null) {
            this.mByteAudioEarback.ByteAudioEarBackEnable(enable);
        }
        return enableSuccess;
    }

    private int earBackSetVolume(int value) {
        if (this.mByteAudioEarback != null) {
            this.mByteAudioEarback.ByteAudioEarBackSetVolume(value);
        }
        return 0;
    }

    private int earBackSetEffect(int value) {
        if (this.mByteAudioEarback != null) {
            this.mByteAudioEarback.ByteAudioEarBackEffect(value);
        }
        return 0;
    }

    private int earBackSetEqualizer(int value) {
        if (this.mByteAudioEarback != null) {
            this.mByteAudioEarback.ByteAudioEarBackEqualizer(value);
        }
        return 0;
    }

    private boolean earBackGetIsSupport() {
        if (this.mByteAudioEarback != null) {
            return this.mByteAudioEarback.ByteAudioEarBackSupport();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHardwareEarbackSupported(boolean isSupported) {
        WebRtcAudioManager webRtcAudioManager = this;
        synchronized (webRtcAudioManager) {
            if (this.nativeAudioManager != 0L) {
                this.nativeOnHardwareEarbackSupported(isSupported, this.nativeAudioManager);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onHardwareEarbackReleased(boolean success) {
        WebRtcAudioManager webRtcAudioManager = this;
        synchronized (webRtcAudioManager) {
            if (this.nativeAudioManager != 0L) {
                this.nativeOnHardwareEarbackReleased(success, this.nativeAudioManager);
            }
        }
    }

    private native void nativeCacheAudioParameters(int var1, int var2, int var3, boolean var4, boolean var5, boolean var6, boolean var7, boolean var8, boolean var9, boolean var10, int var11, int var12, int var13, long var14);

    private native void nativeOnHardwareEarbackSupported(boolean var1, long var2);

    private native void nativeOnHardwareEarbackReleased(boolean var1, long var2);

    private native void nativeRecordCallbackChanged(Object[] var1, long var2);

    private native void nativeOnPhoneCallStart(long var1);

    private native void nativeOnPhoneCallEnd(long var1);

    private native void onVolumeChanged(int var1, int var2, long var3);

    public class AudioManagerPhoneStateListener
    extends PhoneStateListener {
        private int callState = 0;

        public void onServiceStateChanged(ServiceState serviceState) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCallStateChanged(int state, String incomingNumber) {
            WebRtcAudioManager webRtcAudioManager = WebRtcAudioManager.this;
            synchronized (webRtcAudioManager) {
                int oldState = this.callState;
                this.callState = state;
                BaeLogging.i(WebRtcAudioManager.TAG, "onCallStateChanged, from: " + oldState + ", to: " + state);
                switch (state) {
                    case 0: {
                        if (oldState != 1 && oldState != 2) break;
                        if (WebRtcAudioManager.this.nativeAudioManager != 0L) {
                            BaeLogging.i(WebRtcAudioManager.TAG, "endPhoneCall");
                            WebRtcAudioManager.this.nativeOnPhoneCallEnd(WebRtcAudioManager.this.nativeAudioManager);
                            break;
                        }
                        BaeLogging.e(WebRtcAudioManager.TAG, "nativeAudioManager is null");
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (oldState != 0) break;
                        if (WebRtcAudioManager.this.nativeAudioManager != 0L) {
                            BaeLogging.i(WebRtcAudioManager.TAG, "startPhoneCall");
                            WebRtcAudioManager.this.nativeOnPhoneCallStart(WebRtcAudioManager.this.nativeAudioManager);
                            break;
                        }
                        BaeLogging.e(WebRtcAudioManager.TAG, "nativeAudioManager is null");
                    }
                }
            }
        }
    }

    class AudioManagerRecordingCallback
    extends AudioManager.AudioRecordingCallback {
        private WebRtcAudioManager manager = null;

        AudioManagerRecordingCallback(WebRtcAudioManager manager) {
            this.manager = manager;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onRecordingConfigChanged(List<AudioRecordingConfiguration> configs) {
            super.onRecordingConfigChanged(configs);
            HashSet<NativeRecordCallbackInfo> callbackInfoSet = new HashSet<NativeRecordCallbackInfo>();
            for (int i = 0; i < configs.size(); ++i) {
                AudioRecordingConfiguration config = configs.get(i);
                NativeRecordCallbackInfo callbackInfo = new NativeRecordCallbackInfo();
                callbackInfo.audio_session_id = config.getClientAudioSessionId();
                callbackInfo.client_audio_source = config.getClientAudioSource();
                callbackInfo.audio_source = Build.VERSION.SDK_INT >= 29 ? config.getAudioSource() : -1;
                callbackInfo.is_client_silenced = Build.VERSION.SDK_INT >= 29 ? (config.isClientSilenced() ? 1 : 0) : -1;
                callbackInfoSet.add(callbackInfo);
            }
            WebRtcAudioManager webRtcAudioManager = this.manager;
            synchronized (webRtcAudioManager) {
                if (!(WebRtcAudioManager.this.nativeAudioManager == 0L || WebRtcAudioManager.this.lastRecordcallbackInfos != null && WebRtcAudioManager.this.lastRecordcallbackInfos.equals(callbackInfoSet))) {
                    WebRtcAudioManager.this.nativeRecordCallbackChanged(callbackInfoSet.toArray(new NativeRecordCallbackInfo[callbackInfoSet.size()]), WebRtcAudioManager.this.nativeAudioManager);
                    WebRtcAudioManager.this.lastRecordcallbackInfos = callbackInfoSet;
                }
            }
        }
    }

    private final class NativeRecordCallbackInfo {
        private int audio_session_id = -1;
        private int client_audio_source = -1;
        private int audio_source = -1;
        private int is_client_silenced = -1;

        private NativeRecordCallbackInfo() {
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NativeRecordCallbackInfo that = (NativeRecordCallbackInfo)o;
            return this.audio_session_id == that.audio_session_id && this.client_audio_source == that.client_audio_source && this.audio_source == that.audio_source && this.is_client_silenced == that.is_client_silenced;
        }

        public int hashCode() {
            return Objects.hash(this.audio_session_id, this.client_audio_source, this.audio_source, this.is_client_silenced);
        }
    }

    private static final class NativeAudioLayer {
        public static final int kPlatformDefaultAudio = 0;
        public static final int kAndroidJavaAudio = 5;
        public static final int kAndroidOpenSLESAudio = 6;
        public static final int kAndroidJavaInputAndOpenSLESOutputAudio = 7;
        public static final int kAndroidAAudioAudio = 8;
        public static final int kAndroidJavaInputAndAAudioOutputAudio = 9;

        private NativeAudioLayer() {
        }
    }
}

