/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae.webrtc.observer;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.util.Log;
import com.bytedance.bae.base.ContextUtils;

public class VolumeChangedObserver {
    private static final String TAG = "VolumeChangedObserver";
    private static final String VOLUME_CHANGED_ACTION = "android.media.VOLUME_CHANGED_ACTION";
    private static final String EXTRA_VOLUME_STREAM_TYPE = "android.media.EXTRA_VOLUME_STREAM_TYPE";
    private static final int STREAM_BLUETOOTH_SCO = 6;
    private OnVolumeChangedListener onVolumeChangedListener;
    private VolumeBroadcastReceiver mVolumeBroadcastReceiver;

    public VolumeChangedObserver(OnVolumeChangedListener listener) {
        this.onVolumeChangedListener = listener;
        this.registerVolumeChangeAction();
    }

    private void registerVolumeChangeAction() {
        Context context = ContextUtils.getApplicationContext();
        if (context == null) {
            Log.e((String)TAG, (String)"context is null. unable to register broadcast receiver.");
            return;
        }
        this.mVolumeBroadcastReceiver = new VolumeBroadcastReceiver();
        IntentFilter filter = new IntentFilter();
        filter.addAction(VOLUME_CHANGED_ACTION);
        context.registerReceiver((BroadcastReceiver)this.mVolumeBroadcastReceiver, filter);
    }

    private void unregisterReceiver() {
        try {
            Context context = ContextUtils.getApplicationContext();
            if (this.mVolumeBroadcastReceiver != null) {
                context.unregisterReceiver((BroadcastReceiver)this.mVolumeBroadcastReceiver);
                this.mVolumeBroadcastReceiver = null;
            }
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("unregisterReceiver failed. msg: " + e.getMessage()));
        }
        finally {
            if (this.onVolumeChangedListener != null) {
                this.onVolumeChangedListener = null;
            }
            this.mVolumeBroadcastReceiver = null;
        }
    }

    public void release() {
        this.unregisterReceiver();
        this.onVolumeChangedListener = null;
    }

    public static interface OnVolumeChangedListener {
        public void onVolumeChanged(int var1, int var2);
    }

    class VolumeBroadcastReceiver
    extends BroadcastReceiver {
        VolumeBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            VolumeChangedObserver observer = VolumeChangedObserver.this;
            if (observer.onVolumeChangedListener == null) {
                return;
            }
            if (VolumeChangedObserver.VOLUME_CHANGED_ACTION.equals(intent.getAction())) {
                int streamType = -1;
                try {
                    streamType = intent.getIntExtra(VolumeChangedObserver.EXTRA_VOLUME_STREAM_TYPE, -1);
                    if (streamType == 3 || streamType == 0 || streamType == 6) {
                        AudioManager audioManager = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
                        observer.onVolumeChangedListener.onVolumeChanged(streamType, audioManager.getStreamVolume(streamType));
                    }
                }
                catch (Exception e) {
                    Log.e((String)VolumeChangedObserver.TAG, (String)("getIntExtra failed. key: EXTRA_VOLUME_STREAM_TYPE, msg: " + e.getMessage()));
                }
            }
        }
    }
}

