/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.realx.video.memory.bridge;

import android.graphics.Matrix;
import android.opengl.EGLContext;
import android.os.Build;
import com.bytedance.realx.base.CalledByNative;
import com.bytedance.realx.video.RXPixelFormat;
import com.bytedance.realx.video.RXVideoScaleFilter;
import org.webrtc.FilterType;
import org.webrtc.RefCountDelegate;
import org.webrtc.RendererCommon;
import org.webrtc.VideoFrame;

public class RXWebRTCTextureBuffer
implements VideoFrame.TextureBuffer {
    private final long nativeRXVideoFrame;
    private final RefCountDelegate refCountDelegate;

    @CalledByNative
    RXWebRTCTextureBuffer(long nativeRXVideoFrame) {
        this.nativeRXVideoFrame = nativeRXVideoFrame;
        this.refCountDelegate = new RefCountDelegate(() -> RXWebRTCTextureBuffer.nativeReleaseRXVideoFrame(nativeRXVideoFrame));
    }

    EGLContext getEGLContext() {
        return RXWebRTCTextureBuffer.nativeGetAndroidEGLContext(this.nativeRXVideoFrame);
    }

    @Override
    public int getWidth() {
        return RXWebRTCTextureBuffer.nativeGetWidth(this.nativeRXVideoFrame);
    }

    @Override
    public int getHeight() {
        return RXWebRTCTextureBuffer.nativeGetHeight(this.nativeRXVideoFrame);
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return RXWebRTCTextureBuffer.nativeToI420(this.nativeRXVideoFrame);
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        int width = this.getWidth();
        int height = this.getHeight();
        int unscaledWidth = this.getUnscaledWidth();
        int unscaledHeight = this.getUnscaledHeight();
        Matrix cropAndScaleMatrix = new Matrix();
        int cropYFromBottom = height - (cropY + cropHeight);
        cropAndScaleMatrix.preTranslate((float)cropX / (float)width, (float)cropYFromBottom / (float)height);
        cropAndScaleMatrix.preScale((float)cropWidth / (float)width, (float)cropHeight / (float)height);
        return this.applyTransformMatrix(cropAndScaleMatrix, Math.round((float)(unscaledWidth * cropWidth) / (float)width), Math.round((float)(unscaledHeight * cropHeight) / (float)height), scaleWidth, scaleHeight, FilterType.Origin);
    }

    @Override
    public VideoFrame.Buffer cropAndScaleWithFilter(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight, int scaleFilter) {
        int width = this.getWidth();
        int height = this.getHeight();
        int unscaledWidth = this.getUnscaledWidth();
        int unscaledHeight = this.getUnscaledHeight();
        Matrix cropAndScaleMatrix = new Matrix();
        int cropYFromBottom = height - (cropY + cropHeight);
        cropAndScaleMatrix.preTranslate((float)cropX / (float)width, (float)cropYFromBottom / (float)height);
        cropAndScaleMatrix.preScale((float)cropWidth / (float)width, (float)cropHeight / (float)height);
        return this.applyTransformMatrix(cropAndScaleMatrix, Math.round((float)(unscaledWidth * cropWidth) / (float)width), Math.round((float)(unscaledHeight * cropHeight) / (float)height), scaleWidth, scaleHeight, FilterType.fromValue(scaleFilter));
    }

    @Override
    public VideoFrame.Buffer scaleAndFill(int dstWidth, int dstHeight, int offsetX, int offsetY) {
        Matrix scaleAndFillMatrix = new Matrix();
        int src_scaled_width = Math.min(dstWidth, this.getWidth() * dstHeight / this.getHeight());
        int src_scaled_height = Math.min(dstHeight, this.getHeight() * dstWidth / this.getWidth());
        scaleAndFillMatrix.preScale((float)src_scaled_width / (float)this.getWidth(), (float)src_scaled_height / (float)this.getHeight());
        int offsetYFromBottom = dstHeight - (offsetY + src_scaled_height);
        scaleAndFillMatrix.preTranslate((float)(offsetX / dstWidth), (float)(offsetYFromBottom / dstHeight));
        return this.applyTransformMatrix(scaleAndFillMatrix, dstWidth, dstHeight);
    }

    @Override
    public EGLContext getEglContext() {
        return RXWebRTCTextureBuffer.nativeGetEGLContext(this.nativeRXVideoFrame);
    }

    @Override
    public long getNativeEglContext() {
        EGLContext eglContext = this.getEGLContext();
        if (eglContext == null) {
            return 0L;
        }
        return Build.VERSION.SDK_INT >= 21 ? eglContext.getNativeHandle() : (long)eglContext.getHandle();
    }

    @Override
    public VideoFrame.TextureBuffer.Type getType() {
        RXPixelFormat pixelFormat = RXWebRTCTextureBuffer.nativeGetPixelFormat(this.nativeRXVideoFrame);
        if (pixelFormat == RXPixelFormat.kVideoPixelFormatTexture2D) {
            return VideoFrame.TextureBuffer.Type.RGB;
        }
        if (pixelFormat == RXPixelFormat.kVideoPixelFormatTextureOES) {
            return VideoFrame.TextureBuffer.Type.OES;
        }
        return null;
    }

    @Override
    public int getTextureId() {
        return RXWebRTCTextureBuffer.nativeGetTextureId(this.nativeRXVideoFrame);
    }

    @Override
    public Matrix getTransformMatrix() {
        float[] floatMatrix = RXWebRTCTextureBuffer.nativeGetFloatTextureMatrix(this.nativeRXVideoFrame);
        return RendererCommon.convertMatrixToAndroidGraphicsMatrix(floatMatrix);
    }

    @Override
    public float[] nativeGetTransFormMatrix() {
        return RXWebRTCTextureBuffer.nativeGetFloatTextureMatrix(this.nativeRXVideoFrame);
    }

    @Override
    public int getTypeGlTarget() {
        return this.getType().getGlTarget();
    }

    @Override
    public FilterType getScaleFilter() {
        RXVideoScaleFilter scaleFilter = RXWebRTCTextureBuffer.nativeGetRXVideoScaleFilter(this.nativeRXVideoFrame);
        return FilterType.fromValue(scaleFilter.value());
    }

    @Override
    public int getUnscaledWidth() {
        return RXWebRTCTextureBuffer.nativeGetUnscaledWidth(this.nativeRXVideoFrame);
    }

    @Override
    public int getUnscaledHeight() {
        return RXWebRTCTextureBuffer.nativeGetUnscaledHeight(this.nativeRXVideoFrame);
    }

    @Override
    public int getBufferType() {
        return VideoFrame.TextureBuffer.super.getBufferType();
    }

    public VideoFrame.TextureBuffer applyTransformMatrix(Matrix transformMatrix, int newWidth, int newHeight) {
        return this.applyTransformMatrix(transformMatrix, newWidth, newHeight, newWidth, newHeight, FilterType.Origin);
    }

    private VideoFrame.TextureBuffer applyTransformMatrix(Matrix cropAndScraleMatrix, int unscaledWidth, int unscaledHeight, int scaledWidth, int scaledHeight, FilterType scaleFilter) {
        Matrix newMatrix = new Matrix(this.getTransformMatrix());
        newMatrix.preConcat(cropAndScraleMatrix);
        this.retain();
        RXVideoScaleFilter rxScaleFilter = RXVideoScaleFilter.fromId(scaleFilter.toInt());
        float[] floatMatrix = RendererCommon.convertMatrixFromAndroidGraphicsMatrix(newMatrix);
        long newNativeVideoFrame = RXWebRTCTextureBuffer.nativeCreateTextureRXVideoFrame(this.nativeRXVideoFrame, floatMatrix, unscaledWidth, unscaledHeight, scaledWidth, scaledHeight, rxScaleFilter);
        return new RXWebRTCTextureBuffer(newNativeVideoFrame);
    }

    private static native void nativeReleaseRXVideoFrame(long var0);

    private static native EGLContext nativeGetAndroidEGLContext(long var0);

    private static native int nativeGetWidth(long var0);

    private static native int nativeGetHeight(long var0);

    private static native int nativeGetUnscaledWidth(long var0);

    private static native int nativeGetUnscaledHeight(long var0);

    private static native VideoFrame.I420Buffer nativeToI420(long var0);

    private static native RXPixelFormat nativeGetPixelFormat(long var0);

    private static native int nativeGetTextureId(long var0);

    private static native float[] nativeGetFloatTextureMatrix(long var0);

    private static native RXVideoScaleFilter nativeGetRXVideoScaleFilter(long var0);

    private static native EGLContext nativeGetEGLContext(long var0);

    private static native long nativeCreateTextureRXVideoFrame(long var0, float[] var2, int var3, int var4, int var5, int var6, RXVideoScaleFilter var7);
}

