/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine;

import com.ss.bytertc.engine.VideoEncoderConfig;
import com.ss.bytertc.engine.data.VideoOrientation;
import org.webrtc.CalledByNative;

public class InternalVideoEncoderConfig {
    public int width;
    public int height;
    public int frameRate;
    public int maxBitrate;
    public InternalVideoEncoderPreference encodePreference = InternalVideoEncoderPreference.VIDEO_ENCODER_PREFERENCE_MAINTAIN_FRAMERATE;
    public VideoOrientation orientation = VideoOrientation.Adaptive;

    public InternalVideoEncoderConfig(VideoEncoderConfig videoEncoderConfig) {
        this.width = videoEncoderConfig.width;
        this.height = videoEncoderConfig.height;
        this.frameRate = videoEncoderConfig.frameRate;
        this.maxBitrate = videoEncoderConfig.maxBitrate;
        this.encodePreference = this.ConvertEnumValue(videoEncoderConfig.encodePreference);
        this.orientation = videoEncoderConfig.orientation;
    }

    private InternalVideoCodecMode ConvertEnumValue(VideoEncoderConfig.CodecMode codecMode) {
        InternalVideoCodecMode resCodecMode = InternalVideoCodecMode.VIDEO_CODEC_MODE_AUTO;
        switch (codecMode) {
            case CODEC_MODE_AUTO: {
                resCodecMode = InternalVideoCodecMode.VIDEO_CODEC_MODE_AUTO;
                break;
            }
            case CODEC_MODE_HARDWARE: {
                resCodecMode = InternalVideoCodecMode.VIDEO_CODEC_MODE_HARDWARE;
                break;
            }
            case CODEC_MODE_SOFTWARE: {
                resCodecMode = InternalVideoCodecMode.VIDEO_CODEC_MODE_SOFTWARE;
                break;
            }
            default: {
                resCodecMode = InternalVideoCodecMode.VIDEO_CODEC_MODE_AUTO;
            }
        }
        return resCodecMode;
    }

    private InternalVideoCodecType ConvertEnumValue(VideoEncoderConfig.VideoCodecType codecName) {
        InternalVideoCodecType resPreferredCodec = InternalVideoCodecType.VIDEO_CODEC_TYPE_AUTO;
        switch (codecName) {
            case CODEC_TYPE_AUTO: {
                resPreferredCodec = InternalVideoCodecType.VIDEO_CODEC_TYPE_AUTO;
                break;
            }
            case CODEC_TYPE_H264: {
                resPreferredCodec = InternalVideoCodecType.VIDEO_CODEC_TYPE_H264;
                break;
            }
            case CODEC_TYPE_BYTEVC1: {
                resPreferredCodec = InternalVideoCodecType.VIDEO_CODEC_TYPE_BYTEVC1;
                break;
            }
            default: {
                resPreferredCodec = InternalVideoCodecType.VIDEO_CODEC_TYPE_AUTO;
            }
        }
        return resPreferredCodec;
    }

    private InternalVideoEncoderPreference ConvertEnumValue(VideoEncoderConfig.EncoderPreference encodePreference) {
        InternalVideoEncoderPreference encPrefer = InternalVideoEncoderPreference.VIDEO_ENCODER_PREFERENCE_MAINTAIN_FRAMERATE;
        switch (encodePreference) {
            case MaintainFramerate: {
                encPrefer = InternalVideoEncoderPreference.VIDEO_ENCODER_PREFERENCE_MAINTAIN_FRAMERATE;
                break;
            }
            case MaintainQuality: {
                encPrefer = InternalVideoEncoderPreference.VIDEO_ENCODER_PREFERENCE_MAINTAIN_QUALITY;
                break;
            }
            case Balance: {
                encPrefer = InternalVideoEncoderPreference.VIDEO_ENCODER_PREFERENCE_BALANCE;
                break;
            }
        }
        return encPrefer;
    }

    @CalledByNative
    int getWidth() {
        return this.width;
    }

    @CalledByNative
    int getHeight() {
        return this.height;
    }

    @CalledByNative
    int getFrameRate() {
        return this.frameRate;
    }

    @CalledByNative
    int getMaxKBps() {
        return this.maxBitrate;
    }

    @CalledByNative
    InternalVideoEncoderPreference getEncoderPreference() {
        return this.encodePreference;
    }

    @CalledByNative
    int getOrientation() {
        return this.orientation.value();
    }

    public static enum InternalVideoEncoderPreference {
        VIDEO_ENCODER_PREFERENCE_DISABLED(0),
        VIDEO_ENCODER_PREFERENCE_MAINTAIN_FRAMERATE(1),
        VIDEO_ENCODER_PREFERENCE_MAINTAIN_QUALITY(2),
        VIDEO_ENCODER_PREFERENCE_BALANCE(3);

        private int value;

        private InternalVideoEncoderPreference(int v) {
            this.value = v;
        }

        @CalledByNative(value="InternalVideoEncoderPreference")
        public int getIntValue() {
            return this.value;
        }
    }

    public static enum InternalVideoCodecType {
        VIDEO_CODEC_TYPE_AUTO(0),
        VIDEO_CODEC_TYPE_H264(1),
        VIDEO_CODEC_TYPE_BYTEVC1(2);

        private int value;

        private InternalVideoCodecType(int v) {
            this.value = v;
        }

        @CalledByNative(value="InternalVideoCodecType")
        public int getIntValue() {
            return this.value;
        }
    }

    public static enum InternalVideoCodecMode {
        VIDEO_CODEC_MODE_AUTO(0),
        VIDEO_CODEC_MODE_HARDWARE(1),
        VIDEO_CODEC_MODE_SOFTWARE(2);

        private int value;

        private InternalVideoCodecMode(int v) {
            this.value = v;
        }

        @CalledByNative(value="InternalVideoCodecMode")
        public int getIntValue() {
            return this.value;
        }
    }
}

