/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine;

import com.ss.bytertc.engine.VideoStreamDescription;
import com.ss.bytertc.engine.data.VideoOrientation;
import org.webrtc.CalledByNative;

public class InternalVideoStreamDescription {
    public int width;
    public int height;
    public int frameRate;
    public int maxKbps;
    public VideoEncoderPreference encodePreference = VideoEncoderPreference.VIDEO_ENCODER_PREFERENCE_MAINTAIN_FRAMERATE;
    public VideoOrientation orientation = VideoOrientation.Adaptive;

    public InternalVideoStreamDescription(VideoStreamDescription videoStreamDescription) {
        this.width = (Integer)videoStreamDescription.videoSize.first;
        this.height = (Integer)videoStreamDescription.videoSize.second;
        this.frameRate = videoStreamDescription.frameRate;
        this.maxKbps = videoStreamDescription.maxKbps;
        this.encodePreference = this.ConvertEnumValue(videoStreamDescription.encodePreference);
        this.orientation = videoStreamDescription.orientation;
    }

    private VideoCodecMode ConvertEnumValue(VideoStreamDescription.CodecMode codecMode) {
        VideoCodecMode resCodecMode = VideoCodecMode.VIDEO_CODEC_MODE_AUTO;
        switch (codecMode) {
            case CODEC_MODE_AUTO: {
                resCodecMode = VideoCodecMode.VIDEO_CODEC_MODE_AUTO;
                break;
            }
            case CODEC_MODE_HARDWARE: {
                resCodecMode = VideoCodecMode.VIDEO_CODEC_MODE_HARDWARE;
                break;
            }
            case CODEC_MODE_SOFTWARE: {
                resCodecMode = VideoCodecMode.VIDEO_CODEC_MODE_SOFTWARE;
                break;
            }
            default: {
                resCodecMode = VideoCodecMode.VIDEO_CODEC_MODE_AUTO;
            }
        }
        return resCodecMode;
    }

    private VideoCodecType ConvertEnumValue(VideoStreamDescription.VideoCodecType codecName) {
        VideoCodecType resPreferredCodec = VideoCodecType.VIDEO_CODEC_TYPE_AUTO;
        switch (codecName) {
            case CODEC_TYPE_AUTO: {
                resPreferredCodec = VideoCodecType.VIDEO_CODEC_TYPE_AUTO;
                break;
            }
            case CODEC_TYPE_H264: {
                resPreferredCodec = VideoCodecType.VIDEO_CODEC_TYPE_H264;
                break;
            }
            case CODEC_TYPE_BYTEVC1: {
                resPreferredCodec = VideoCodecType.VIDEO_CODEC_TYPE_BYTEVC1;
                break;
            }
            default: {
                resPreferredCodec = VideoCodecType.VIDEO_CODEC_TYPE_AUTO;
            }
        }
        return resPreferredCodec;
    }

    private VideoEncoderPreference ConvertEnumValue(VideoStreamDescription.EncoderPreference encodePreference) {
        VideoEncoderPreference encPrefer = VideoEncoderPreference.VIDEO_ENCODER_PREFERENCE_MAINTAIN_FRAMERATE;
        switch (encodePreference) {
            case MaintainFramerate: {
                encPrefer = VideoEncoderPreference.VIDEO_ENCODER_PREFERENCE_MAINTAIN_FRAMERATE;
                break;
            }
            case MaintainQuality: {
                encPrefer = VideoEncoderPreference.VIDEO_ENCODER_PREFERENCE_MAINTAIN_QUALITY;
                break;
            }
            case Balance: {
                encPrefer = VideoEncoderPreference.VIDEO_ENCODER_PREFERENCE_BALANCE;
                break;
            }
        }
        return encPrefer;
    }

    @CalledByNative
    int getWidth() {
        return this.width;
    }

    @CalledByNative
    int getHeight() {
        return this.height;
    }

    @CalledByNative
    int getFrameRate() {
        return this.frameRate;
    }

    @CalledByNative
    int getMaxKBps() {
        return this.maxKbps;
    }

    @CalledByNative
    VideoEncoderPreference getEncoderPreference() {
        return this.encodePreference;
    }

    @CalledByNative
    int getOrientation() {
        return this.orientation.value();
    }

    public static enum VideoEncoderPreference {
        VIDEO_ENCODER_PREFERENCE_DISABLED(0),
        VIDEO_ENCODER_PREFERENCE_MAINTAIN_FRAMERATE(1),
        VIDEO_ENCODER_PREFERENCE_MAINTAIN_QUALITY(2),
        VIDEO_ENCODER_PREFERENCE_BALANCE(3);

        private int value;

        private VideoEncoderPreference(int v) {
            this.value = v;
        }

        @CalledByNative(value="VideoEncoderPreference")
        public int getIntValue() {
            return this.value;
        }
    }

    public static enum VideoCodecType {
        VIDEO_CODEC_TYPE_AUTO(0),
        VIDEO_CODEC_TYPE_H264(1),
        VIDEO_CODEC_TYPE_BYTEVC1(2);

        private int value;

        private VideoCodecType(int v) {
            this.value = v;
        }

        @CalledByNative(value="VideoCodecType")
        public int getIntValue() {
            return this.value;
        }
    }

    public static enum VideoCodecMode {
        VIDEO_CODEC_MODE_AUTO(0),
        VIDEO_CODEC_MODE_HARDWARE(1),
        VIDEO_CODEC_MODE_SOFTWARE(2);

        private int value;

        private VideoCodecMode(int v) {
            this.value = v;
        }

        @CalledByNative(value="VideoCodecMode")
        public int getIntValue() {
            return this.value;
        }
    }
}

