/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.data;

import org.webrtc.CalledByNative;

public enum AudioChannel {
    AUDIO_CHANNEL_AUTO(-1),
    AUDIO_CHANNEL_MONO(1),
    AUDIO_CHANNEL_STEREO(2);

    private int value = 1;

    private AudioChannel(int value) {
        this.value = value;
    }

    public int value() {
        return this.value;
    }

    public String toString() {
        String strValue = "kAudioChannelUnknown";
        switch (this) {
            case AUDIO_CHANNEL_AUTO: {
                strValue = "kAudioChannelAuto";
                break;
            }
            case AUDIO_CHANNEL_MONO: {
                strValue = "kAudioChannelMono";
                break;
            }
            case AUDIO_CHANNEL_STEREO: {
                strValue = "kAudioChannelStereo";
                break;
            }
        }
        return strValue;
    }

    @CalledByNative
    public static AudioChannel fromId(int id) {
        for (AudioChannel type : AudioChannel.values()) {
            if (type.value() != id) continue;
            return type;
        }
        return null;
    }
}

