/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.data;

import org.webrtc.CalledByNative;

public class ForwardStreamEventInfo {
    public String roomId;
    public ForwardStreamEvent event;

    public ForwardStreamEventInfo(String roomId, ForwardStreamEvent event) {
        this.roomId = roomId;
        this.event = event;
    }

    @CalledByNative
    private static ForwardStreamEventInfo create(String roomId, int eventId) {
        return new ForwardStreamEventInfo(roomId, ForwardStreamEvent.fromId(eventId));
    }

    public static enum ForwardStreamEvent {
        FORWARD_STREAM_EVENT_DISCONNECTED(0),
        FORWARD_STREAM_EVENT_CONNECTED(1),
        FORWARD_STREAM_EVENT_INTERRUPT(2),
        FORWARD_STREAM_EVENT_DST_ROOM_UPDATED(3),
        FORWARD_STREAM_EVENT_UN_EXPECT_API_CALL(4);

        private int value;

        private ForwardStreamEvent(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        @CalledByNative
        public static ForwardStreamEvent fromId(int id) {
            for (ForwardStreamEvent type : ForwardStreamEvent.values()) {
                if (type.value() != id) continue;
                return type;
            }
            return null;
        }
    }
}

