/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.engineimpl;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.opengl.EGLContext;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.util.Log;
import com.ss.bytertc.base.utils.NetworkConnectChangeReceiver;
import com.ss.bytertc.base.utils.NetworkUtils;
import com.ss.bytertc.base.utils.RtcContextUtils;
import com.ss.bytertc.engine.AudioMixingManager;
import com.ss.bytertc.engine.IAudioFrameObserver;
import com.ss.bytertc.engine.IAudioFrameProcessor;
import com.ss.bytertc.engine.IAudioProcessor;
import com.ss.bytertc.engine.IMetadataObserver;
import com.ss.bytertc.engine.IRTCAudioDeviceManager;
import com.ss.bytertc.engine.InternalCloudProxyInfo;
import com.ss.bytertc.engine.InternalExpressDetectConfig;
import com.ss.bytertc.engine.InternalVideoCaptureConfig;
import com.ss.bytertc.engine.InternalVideoEncoderConfig;
import com.ss.bytertc.engine.InternalVideoStreamDescription;
import com.ss.bytertc.engine.KTVManagerImpl;
import com.ss.bytertc.engine.NativeRTCVideoFunctions;
import com.ss.bytertc.engine.RTCAudioDeviceManager;
import com.ss.bytertc.engine.RTCRoom;
import com.ss.bytertc.engine.RTCRoomImpl;
import com.ss.bytertc.engine.RTCVideo;
import com.ss.bytertc.engine.SingScoringManager;
import com.ss.bytertc.engine.VideoCanvas;
import com.ss.bytertc.engine.VideoEncoderConfig;
import com.ss.bytertc.engine.VideoStreamDescription;
import com.ss.bytertc.engine.adapter.VideoSinkAdapter;
import com.ss.bytertc.engine.adapter.VideoSinkTask;
import com.ss.bytertc.engine.audio.IAudioMixingManager;
import com.ss.bytertc.engine.audio.ISingScoringManager;
import com.ss.bytertc.engine.data.AudioFormat;
import com.ss.bytertc.engine.data.AudioFrameCallbackMethod;
import com.ss.bytertc.engine.data.AudioPlaybackDevice;
import com.ss.bytertc.engine.data.AudioProcessorMethod;
import com.ss.bytertc.engine.data.AudioPropertiesConfig;
import com.ss.bytertc.engine.data.AudioRenderType;
import com.ss.bytertc.engine.data.AudioRoute;
import com.ss.bytertc.engine.data.AudioSourceType;
import com.ss.bytertc.engine.data.CameraId;
import com.ss.bytertc.engine.data.CloudProxyInfo;
import com.ss.bytertc.engine.data.EarMonitorMode;
import com.ss.bytertc.engine.data.EchoTestConfig;
import com.ss.bytertc.engine.data.EffectBeautyMode;
import com.ss.bytertc.engine.data.MirrorType;
import com.ss.bytertc.engine.data.MuteState;
import com.ss.bytertc.engine.data.RTCASRConfig;
import com.ss.bytertc.engine.data.RTCData;
import com.ss.bytertc.engine.data.RecordingConfig;
import com.ss.bytertc.engine.data.RemoteStreamKey;
import com.ss.bytertc.engine.data.ScreenMediaType;
import com.ss.bytertc.engine.data.StreamIndex;
import com.ss.bytertc.engine.data.StreamSycnInfoConfig;
import com.ss.bytertc.engine.data.VideoFrameType;
import com.ss.bytertc.engine.data.VideoOrientation;
import com.ss.bytertc.engine.data.VideoPixelFormat;
import com.ss.bytertc.engine.data.VideoRotationMode;
import com.ss.bytertc.engine.data.VideoSourceType;
import com.ss.bytertc.engine.data.VirtualBackgroundSource;
import com.ss.bytertc.engine.engineimpl.RTCEngineImpl;
import com.ss.bytertc.engine.handler.IExternalVideoEncoderEventHandler;
import com.ss.bytertc.engine.handler.IRTCASREngineEventHandler;
import com.ss.bytertc.engine.handler.IRTCEngineInternalEventHandler;
import com.ss.bytertc.engine.handler.IRTCVideoEventHandler;
import com.ss.bytertc.engine.handler.NativeAudioFrameProcessor;
import com.ss.bytertc.engine.handler.NativeAudioProcessor;
import com.ss.bytertc.engine.handler.RTCASREngineEventHandler;
import com.ss.bytertc.engine.handler.RTCAudioFrameObserver;
import com.ss.bytertc.engine.handler.RTCEncryptHandler;
import com.ss.bytertc.engine.handler.RTCEngineInternalEventHandler;
import com.ss.bytertc.engine.handler.RTCExternalVideoEncoderEventHandler;
import com.ss.bytertc.engine.handler.RTCFaceDetectionObserver;
import com.ss.bytertc.engine.handler.RTCLocalEncodedVideoFrameObserver;
import com.ss.bytertc.engine.handler.RTCRemoteEncodedVideoFrameObserver;
import com.ss.bytertc.engine.handler.RTCVideoEventHandler;
import com.ss.bytertc.engine.handler.RTCVideoProcessor;
import com.ss.bytertc.engine.live.ILiveTranscodingObserver;
import com.ss.bytertc.engine.live.IPushSingleStreamToCDNObserver;
import com.ss.bytertc.engine.live.LiveTranscoding;
import com.ss.bytertc.engine.live.LiveTranscodingObserver;
import com.ss.bytertc.engine.live.PushSingleStreamParam;
import com.ss.bytertc.engine.live.PushSingleStreamToCDNObserver;
import com.ss.bytertc.engine.loader.RTCNativeLibraryListenerImpl;
import com.ss.bytertc.engine.loader.RTCNativeLibraryLoaderInfo;
import com.ss.bytertc.engine.loader.RTCNativeLibraryLoaderListener;
import com.ss.bytertc.engine.mediaio.ILocalEncodedVideoFrameObserver;
import com.ss.bytertc.engine.mediaio.IRemoteEncodedVideoFrameObserver;
import com.ss.bytertc.engine.mediaio.RTCEncodedVideoFrame;
import com.ss.bytertc.engine.publicstream.PublicStreaming;
import com.ss.bytertc.engine.type.AudioProfileType;
import com.ss.bytertc.engine.type.AudioScenarioType;
import com.ss.bytertc.engine.type.BackgroundMode;
import com.ss.bytertc.engine.type.DivideModel;
import com.ss.bytertc.engine.type.MessageConfig;
import com.ss.bytertc.engine.type.NetworkDetectionStartReturn;
import com.ss.bytertc.engine.type.ProblemFeedback;
import com.ss.bytertc.engine.type.PublishFallbackOption;
import com.ss.bytertc.engine.type.RecordingType;
import com.ss.bytertc.engine.type.RemoteUserPriority;
import com.ss.bytertc.engine.type.SubscribeFallbackOptions;
import com.ss.bytertc.engine.type.TorchState;
import com.ss.bytertc.engine.type.VoiceChangerType;
import com.ss.bytertc.engine.type.VoiceReverbType;
import com.ss.bytertc.engine.utils.AppMonitor;
import com.ss.bytertc.engine.utils.AudioFrame;
import com.ss.bytertc.engine.utils.LogUtil;
import com.ss.bytertc.engine.utils.VideoFrameConverter;
import com.ss.bytertc.engine.video.IFaceDetectionObserver;
import com.ss.bytertc.engine.video.IVideoProcessor;
import com.ss.bytertc.engine.video.IVideoSink;
import com.ss.bytertc.engine.video.RTCWatermarkConfig;
import com.ss.bytertc.engine.video.VideoCaptureConfig;
import com.ss.bytertc.engine.video.VideoDecoderConfig;
import com.ss.bytertc.engine.video.VideoEffectExpressionConfig;
import com.ss.bytertc.engine.video.VideoEncoderConfiguration;
import com.ss.bytertc.engine.video.VideoFrame;
import com.ss.bytertc.engine.video.VideoPreprocessorConfig;
import com.ss.bytertc.ktv.KTVManager;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.EglBase;
import org.webrtc.ThreadUtils;

public class RTCVideoImpl
extends RTCVideo {
    private static boolean mLibraryLoaded = false;
    private static RTCNativeLibraryLoaderListener mRtcNativeLibraryListener = new RTCNativeLibraryListenerImpl();
    private static RTCNativeLibraryLoaderInfo sRtcLoaderInfo = new RTCNativeLibraryLoaderInfo();
    private IRTCVideoEventHandler mRtcEngineHandler;
    private IExternalVideoEncoderEventHandler mExternalVideoEncoderHandler;
    private IAudioFrameObserver mAudioFrameObserver;
    private IAudioProcessor mAudioProcessor;
    private IAudioFrameProcessor mAudioFrameProcessor;
    private ILocalEncodedVideoFrameObserver mLocalEncodedVideoFrameObserver;
    private IRemoteEncodedVideoFrameObserver mRemoteEncodedVideoFrameObserver;
    private IMetadataObserver mMetadataObserver;
    private ILiveTranscodingObserver mLiveTranscodingObserver;
    private PushSingleStreamToCDNObserver mSingleStreamToCDNObserver = null;
    private RTCVideoEventHandler mEngineEventHandler;
    private RTCEngineInternalEventHandler mEngineInternalEventHandler;
    private Context mContext;
    private VideoFrameConverter mVideoFrameConverter;
    private VideoFrameConverter mScreenFrameConverter;
    private RTCEngineImpl.State mState;
    private boolean mIsUseCustomEglEnv = false;
    private boolean mUseExtVideoSource = false;
    private long mNativeEngine = 0L;
    private LiveTranscoding mLiveTranscoding = null;
    private boolean mEnableTranscode = false;
    private static final String TAG = "RtcVideoImpl";
    private static final String sSoLibraryName = "byteplusrtc";
    private Runnable mOnDestroyCompletedCallback = null;
    private RTCVideoProcessor mRtcVideoPreprocessor = null;
    private RTCAudioFrameObserver mRtcAudioFrameObserver = null;
    private NativeAudioProcessor mNativeAudioProcessor = null;
    private NativeAudioFrameProcessor mNativeAudioFrameProcessor = null;
    private RTCExternalVideoEncoderEventHandler mRtcExVideoEncoderHandler = null;
    private RTCLocalEncodedVideoFrameObserver mRtcLocalEncodedVideoFrameObserver = null;
    private RTCRemoteEncodedVideoFrameObserver mRtcRemoteEncodedVideoFrameObserver = null;
    private VideoSinkTask mVideoSinkTask;
    private WeakReference<IFaceDetectionObserver> mFaceDetectionObserver;
    private boolean mIsVideoMirror = true;
    private EglBase mRootEglBase = null;
    private HandlerThread mEglThread;
    private Handler mEglHandler;
    private LiveTranscodingObserver mTranscodingObserver = null;
    private boolean mIsFront = true;
    private static String mDeviceId = "";
    private BroadcastReceiver mBroadcastReceiver = null;
    private RTCASREngineEventHandler mRTCASREngineEventHandler;
    private AudioMixingManager mAudioMixingManager = null;
    private RTCFaceDetectionObserver mRTCFaceDetectionObserver = null;
    private RTCAudioDeviceManager mAudioDeviceManagerInterval = null;
    private KTVManager mKTVManager = null;
    private SingScoringManager mSingScoringManager = null;
    private LogUtil.LoggerSink mLoggerSink = (level, msg, throwable) -> {
        IRTCVideoEventHandler handler = this.getRtcEngineHandler();
        try {
            if (handler != null) {
                handler.onLoggerMessage(level, msg, throwable);
            }
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("Exception in App thread when handler onLoggerMessage , e : " + e.getMessage()), (Throwable)e);
        }
    };
    private AppMonitor.Callback appStateCallback = state -> NativeRTCVideoFunctions.nativeSetAppState(this.mNativeEngine, state == 1 ? "active" : "background");
    private NetworkConnectChangeReceiver.Callback SetNetworkTypeCallback = (type, extraInfo) -> {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, SetNetworkType failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeSetNetworkType(this.mNativeEngine, type, extraInfo);
    };

    public static Context getApplicationContext() {
        return RtcContextUtils.getApplicationContext();
    }

    private static void loadSoFile() {
        if (mLibraryLoaded) {
            mRtcNativeLibraryListener.onLoadAlready(sSoLibraryName);
        } else {
            if (mRtcNativeLibraryLoader != null) {
                mLibraryLoaded = true;
                mLibraryLoaded &= mRtcNativeLibraryLoader.load("byteaudio");
                if (mLibraryLoaded &= mRtcNativeLibraryLoader.load(sSoLibraryName)) {
                    mRtcNativeLibraryListener.onLoadSuccess(sSoLibraryName);
                } else {
                    mRtcNativeLibraryListener.onLoadError(sSoLibraryName);
                }
                sRtcLoaderInfo.setLoaderClassName(mRtcNativeLibraryLoader.getClass().getSimpleName());
            } else {
                try {
                    System.loadLibrary("byteaudio");
                    System.loadLibrary(sSoLibraryName);
                    mLibraryLoaded = true;
                    mRtcNativeLibraryListener.onLoadSuccess(sSoLibraryName);
                    sRtcLoaderInfo.setLoaderClassName("System.loader");
                }
                catch (UnsatisfiedLinkError e) {
                    LogUtil.e(TAG, "Failed to load native library: byteplusrtc", e);
                }
                mRtcNativeLibraryListener.onLoadError(sSoLibraryName);
            }
            sRtcLoaderInfo.setLoadResult(mLibraryLoaded);
            sRtcLoaderInfo.setLoadTimeStamp(System.currentTimeMillis());
            sRtcLoaderInfo.setSdkVersion(RTCVideoImpl.getSdkVersion());
        }
        sRtcLoaderInfo.loadLibrary();
    }

    public EglBase getEGLContext() {
        if (this.mRootEglBase != null) {
            return this.mRootEglBase;
        }
        return null;
    }

    private void initEglContext(Object eglContext) {
        if (eglContext == null) {
            this.mRootEglBase = EglBase.create();
            this.mIsUseCustomEglEnv = false;
            return;
        }
        this.mRootEglBase = eglContext instanceof javax.microedition.khronos.egl.EGLContext ? EglBase.createEgl10((javax.microedition.khronos.egl.EGLContext)eglContext, EglBase.CONFIG_PLAIN) : (eglContext instanceof EGLContext ? EglBase.createEgl14((EGLContext)eglContext, EglBase.CONFIG_PLAIN) : (eglContext instanceof EglBase ? EglBase.create(((EglBase)eglContext).getEglBaseContext(), EglBase.CONFIG_PLAIN) : EglBase.create()));
        this.mIsUseCustomEglEnv = true;
    }

    private boolean engineInvalid() {
        return this.mNativeEngine == 0L;
    }

    public RTCVideoImpl(Context context, String appId, IRTCVideoEventHandler handler, Object eglContext, JSONObject parameters) throws IllegalStateException {
        LogUtil.d(TAG, "create RtcEngineImpl with appId: " + appId);
        if (mLibraryLoaded && appId != null) {
            Object eglEglBaseContext = null;
            long nativeEglContext = 0L;
            this.mEglThread = new HandlerThread("rtc_egl_thread");
            this.mEglThread.start();
            this.mVideoSinkTask = new VideoSinkTask();
            this.mVideoSinkTask.init();
            this.mEglHandler = new Handler(this.mEglThread.getLooper());
            ThreadUtils.invokeAtFrontUninterruptibly(this.mEglHandler, () -> {
                this.initEglContext(eglContext);
                this.mRootEglBase.createDummyPbufferSurface();
                this.mRootEglBase.makeCurrent();
                NativeRTCVideoFunctions.nativeSetHardWareEncodeContext();
                this.mRootEglBase.detachCurrent();
            });
            this.mRtcVideoPreprocessor = new RTCVideoProcessor(this);
            this.mContext = context.getApplicationContext();
            this.mState = RTCEngineImpl.State.IDLE;
            this.mRtcEngineHandler = handler;
            LogUtil.setLoggerSink(this.mLoggerSink);
            this.mEngineEventHandler = new RTCVideoEventHandler(this);
            this.mEngineInternalEventHandler = new RTCEngineInternalEventHandler(this);
            this.mVideoFrameConverter = new VideoFrameConverter();
            this.mScreenFrameConverter = new VideoFrameConverter();
            this.mRtcAudioFrameObserver = new RTCAudioFrameObserver(this);
            this.mNativeAudioProcessor = new NativeAudioProcessor(this);
            this.mNativeAudioFrameProcessor = new NativeAudioFrameProcessor(this);
            this.mRtcLocalEncodedVideoFrameObserver = new RTCLocalEncodedVideoFrameObserver(this);
            this.mRtcRemoteEncodedVideoFrameObserver = new RTCRemoteEncodedVideoFrameObserver(this);
            this.mTranscodingObserver = new LiveTranscodingObserver();
            this.mSingleStreamToCDNObserver = new PushSingleStreamToCDNObserver();
            this.mRTCASREngineEventHandler = new RTCASREngineEventHandler();
            this.mRtcExVideoEncoderHandler = new RTCExternalVideoEncoderEventHandler(this);
            this.mRTCFaceDetectionObserver = new RTCFaceDetectionObserver(this);
            try {
                this.mNativeEngine = NativeRTCVideoFunctions.nativeCreateRTCVideo(this.mContext.getApplicationContext(), appId, this.mEngineEventHandler, parameters == null ? "" : parameters.toString());
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                unsatisfiedLinkError.printStackTrace();
                throw new UnsatisfiedLinkError("rtc loader info:" + sRtcLoaderInfo.toString() + " exception info:" + unsatisfiedLinkError.getStackTrace().toString());
            }
            if (this.engineInvalid()) {
                LogUtil.e(TAG, "create native engine error, native engine is invalid.");
            } else {
                NativeRTCVideoFunctions.nativeRegisterInternalEventObserver(this.mNativeEngine, this.mEngineInternalEventHandler);
            }
        } else {
            int errorCode;
            String errorMessage;
            JSONObject params = new JSONObject();
            if (!mLibraryLoaded) {
                errorMessage = "rtc sdk load so failed";
                errorCode = -1072;
            } else {
                errorMessage = "app id is null";
                errorCode = -1005;
            }
            try {
                params.put("event_key", (Object)"rtc_error");
                params.put("rtc_app_id", (Object)appId);
                params.put("device_id", (Object)mDeviceId);
                params.put("error_code", errorCode);
                params.put("message", (Object)errorMessage);
                params.put("timestamp", System.currentTimeMillis());
                params.put("rtc_timestamp", System.currentTimeMillis());
                params.put("os", (Object)"android");
                params.put("product_line", (Object)"rtc");
                params.put("report_version", 5);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            if (handler != null) {
                handler.onLogReport("live_webrtc_monitor_log", params);
                handler.onError(errorCode);
            }
            LogUtil.e(TAG, errorMessage);
            throw new IllegalStateException("Create engine failed " + errorMessage);
        }
        this.mBroadcastReceiver = new NetworkConnectChangeReceiver(this.SetNetworkTypeCallback);
        NetworkUtils.registerReceiver(context, this.mBroadcastReceiver);
        AppMonitor.get(context).register(context, this.appStateCallback);
    }

    public void doDestroy() {
        LogUtil.d(TAG, "destroy RtcEngineImpl.");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, no need to destroy now.");
            return;
        }
        AudioMixingManager mixingManager = this.mAudioMixingManager;
        if (mixingManager instanceof AudioMixingManager) {
            mixingManager.destroy();
        }
        this.mState = RTCEngineImpl.State.DESTORY;
        NetworkUtils.unregisterReceiver(this.mContext, this.mBroadcastReceiver);
        this.mBroadcastReceiver = null;
        NativeRTCVideoFunctions.nativeDestroyRTCVideo(this.mNativeEngine);
        NativeRTCVideoFunctions.nativeClearHardWareEncodeContext();
        this.mNativeEngine = 0L;
        this.mIsFront = true;
        this.mIsVideoMirror = true;
        this.mVideoFrameConverter.dispose();
        this.mVideoFrameConverter = null;
        this.mScreenFrameConverter.dispose();
        this.mScreenFrameConverter = null;
        new Handler(Looper.getMainLooper()).post(() -> {
            if (this.mOnDestroyCompletedCallback != null) {
                this.mOnDestroyCompletedCallback.run();
            }
        });
        AppMonitor.get(this.mContext).unRegister(this.appStateCallback).release(this.mContext);
        this.mRtcVideoPreprocessor.dispose();
        this.mRtcVideoPreprocessor = null;
        ThreadUtils.invokeAtFrontUninterruptibly(this.mEglHandler, () -> {
            if (this.mRootEglBase != null) {
                this.mRootEglBase.release();
                this.mRootEglBase = null;
            }
        });
        if (this.mEglThread != null) {
            this.mEglThread.quit();
        }
        if (this.mVideoSinkTask != null) {
            this.mVideoSinkTask.exit();
        }
        if (this.mKTVManager != null) {
            this.mKTVManager.destroy();
            this.mKTVManager = null;
        }
        LogUtil.setLoggerSink(null);
    }

    public IRTCVideoEventHandler getRtcEngineHandler() {
        return this.mRtcEngineHandler;
    }

    @Override
    public void setInternalEventHandler(IRTCEngineInternalEventHandler handler) {
        this.mEngineInternalEventHandler.setInternalEventHandler(handler);
    }

    @Override
    public void setRtcVideoEventHandler(IRTCVideoEventHandler engineEventHandler) {
        LogUtil.d(TAG, "setRtcEngineEventHandler");
        this.mRtcEngineHandler = engineEventHandler;
    }

    @Override
    public IRTCAudioDeviceManager getAudioDeviceManager() {
        LogUtil.d(TAG, "getAudioDeviceManager");
        this.mAudioDeviceManagerInterval = new RTCAudioDeviceManager(this.mNativeEngine);
        return this.mAudioDeviceManagerInterval;
    }

    public IAudioFrameObserver getAudioFrameObserver() {
        return this.mAudioFrameObserver;
    }

    public IAudioProcessor getAudioProcessor() {
        return this.mAudioProcessor;
    }

    public IAudioFrameProcessor getAudioFrameProcessor() {
        return this.mAudioFrameProcessor;
    }

    public ILocalEncodedVideoFrameObserver getEncodedVideoFrameObserver() {
        return this.mLocalEncodedVideoFrameObserver;
    }

    public IRemoteEncodedVideoFrameObserver getRemoteEncodedVideoFrameObserver() {
        return this.mRemoteEncodedVideoFrameObserver;
    }

    public IMetadataObserver getMetadataObserver() {
        return this.mMetadataObserver;
    }

    public ILiveTranscodingObserver getLiveTranscodingObserver() {
        return this.mLiveTranscodingObserver;
    }

    public IExternalVideoEncoderEventHandler getExternalVideoEncoderEventHandler() {
        return this.mExternalVideoEncoderHandler;
    }

    @Override
    public void startVideoCapture() {
        LogUtil.d(TAG, "startVideoCapture");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, startVideoCapture failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeStartVideoCapture(this.mNativeEngine);
    }

    @Override
    public void stopVideoCapture() {
        LogUtil.d(TAG, "stopVideoCapture");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, stopVideoCapture failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeStopVideoCapture(this.mNativeEngine);
    }

    @Override
    public void startAudioCapture() {
        LogUtil.d(TAG, "startAudioCapture");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, startAudioCapture failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeStartAudioCapture(this.mNativeEngine);
    }

    @Override
    public void stopAudioCapture() {
        LogUtil.d(TAG, "stopAudioCapture");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, stopAudioCapture failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeStopAudioCapture(this.mNativeEngine);
    }

    @Override
    public void setAudioScenario(AudioScenarioType audioScenario) {
        LogUtil.d(TAG, "setAudioScenario...audioScenario: " + (Object)((Object)audioScenario));
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setAudioScenario failed.");
            return;
        }
        int scenario = 0;
        switch (audioScenario) {
            case AUDIO_SCENARIO_MUSIC: {
                scenario = 0;
                break;
            }
            case AUDIO_SCENARIO_HIGHQUALITY_COMMUNICATION: {
                scenario = 1;
                break;
            }
            case AUDIO_SCENARIO_COMMUNICATION: {
                scenario = 2;
                break;
            }
            case AUDIO_SCENARIO_MEDIA: {
                scenario = 3;
                break;
            }
            case AUDIO_SCENARIO_GAME_STREAMING: {
                scenario = 4;
                break;
            }
            case AUDIO_SCENARIO_HIGHQUALITY_CHAT: {
                scenario = 5;
                break;
            }
        }
        NativeRTCVideoFunctions.nativeSetAudioScenario(this.mNativeEngine, scenario);
    }

    @Override
    public void setAudioProfile(AudioProfileType audioProfile) {
        LogUtil.d(TAG, "setAudioProfile:" + (Object)((Object)audioProfile));
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setAudioProfile failed.");
            return;
        }
        if (audioProfile != null) {
            NativeRTCVideoFunctions.nativeSetAudioProfile(this.mNativeEngine, audioProfile.value());
        }
    }

    @Override
    public void setVoiceChangerType(VoiceChangerType voiceChanger) {
        LogUtil.d(TAG, "setVoiceChangerType...voiceChanger: " + (Object)((Object)voiceChanger));
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVoiceChangerType failed.");
        }
        int voice = 0;
        switch (voiceChanger) {
            case VOICE_CHANGER_ORIGINAL: {
                voice = 0;
                break;
            }
            case VOICE_CHANGER_GIANT: {
                voice = 1;
                break;
            }
            case VOICE_CHANGER_CHIPMUNK: {
                voice = 2;
                break;
            }
            case VOICE_CHANGER_MINIONST: {
                voice = 3;
                break;
            }
            case VOICE_CHANGER_VIBRATO: {
                voice = 4;
                break;
            }
            case VOICE_CHANGER_ROBOT: {
                voice = 5;
                break;
            }
        }
        NativeRTCVideoFunctions.nativeSetVoiceChangerType(this.mNativeEngine, voice);
    }

    @Override
    public void setVoiceReverbType(VoiceReverbType voiceReverb) {
        LogUtil.d(TAG, "setVoiceReverbType...voiceReverb: " + (Object)((Object)voiceReverb));
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVoiceReverbType failed.");
        }
        int effect = 0;
        switch (voiceReverb) {
            case VOICE_REVERB_ORIGINAL: {
                effect = 0;
                break;
            }
            case VOICE_REVERB_ECHO: {
                effect = 1;
                break;
            }
            case VOICE_REVERB_CONCERT: {
                effect = 2;
                break;
            }
            case VOICE_REVERB_ETHEREAL: {
                effect = 3;
                break;
            }
            case VOICE_REVERB_KTV: {
                effect = 4;
                break;
            }
            case VOICE_REVERB_STUDIO: {
                effect = 5;
                break;
            }
        }
        NativeRTCVideoFunctions.nativeSetVoiceReverbType(this.mNativeEngine, effect);
    }

    @Override
    public int setLocalVideoCanvas(StreamIndex streamIndex, VideoCanvas videoCanvas) {
        if (videoCanvas == null) {
            LogUtil.i(TAG, "EventType: setLocalVideoCanvas canvas is null");
            return -1;
        }
        NativeRTCVideoFunctions.nativeSetLocalVideoCanvas(this.mNativeEngine, streamIndex.value(), videoCanvas.renderView, videoCanvas.renderMode, videoCanvas.background_color);
        return 0;
    }

    @Override
    public int updateLocalVideoCanvas(StreamIndex streamIndex, int renderMode, int background_color) {
        NativeRTCVideoFunctions.nativeUpdateLocalVideoCanvas(this.mNativeEngine, streamIndex.value(), renderMode, background_color);
        return 0;
    }

    @Override
    public void setLocalVideoSink(StreamIndex index, IVideoSink videoSink, int requiredFormat) {
        if (index == null) {
            LogUtil.e(TAG, "EventType: setLocalVideoSink, streamIndex is null");
            return;
        }
        VideoSinkAdapter sinkAdapter = null;
        if (videoSink != null) {
            sinkAdapter = new VideoSinkAdapter(videoSink);
        }
        NativeRTCVideoFunctions.nativeSetLocalVideoSink(this.mNativeEngine, index.value(), sinkAdapter, requiredFormat);
    }

    @Override
    public void setRemoteVideoSink(RemoteStreamKey streamKey, IVideoSink videoSink, int requiredFormat) {
        if (streamKey == null) {
            LogUtil.e(TAG, "EventType: setupRemoteRenderInternal, streamKey is null");
            return;
        }
        if (streamKey.getStreamIndex() == null) {
            LogUtil.e(TAG, "EventType: setupRemoteRenderInternal, streamIndex is null");
            return;
        }
        String roomid = "";
        roomid = streamKey.getRoomId();
        VideoSinkAdapter sinkAdapter = null;
        if (videoSink != null) {
            sinkAdapter = new VideoSinkAdapter(videoSink);
        }
        NativeRTCVideoFunctions.nativeSetRemoteVideoSink(this.mNativeEngine, roomid, streamKey.getUserId(), streamKey.getStreamIndex().value(), sinkAdapter, requiredFormat);
    }

    @Override
    public void updateRemoteStreamVideoCanvas(String roomId, String userId, StreamIndex streamIndex, int renderMode, int background_color) {
        NativeRTCVideoFunctions.nativeUpdateRemoteVideoCanvas(this.mNativeEngine, roomId, userId, streamIndex.value(), renderMode, background_color);
    }

    @Override
    public int setRemoteVideoCanvas(String userId, StreamIndex streamIndex, VideoCanvas canvas) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setRemoteVideoCanvas failed.");
            return -1;
        }
        if (canvas == null || canvas.uid == null) {
            LogUtil.i(TAG, "EventType: setupRemoteVideo canvas or uid is null");
            return -1;
        }
        NativeRTCVideoFunctions.nativeSetRemoteVideoCanvas(this.mNativeEngine, canvas.roomId, canvas.uid, streamIndex.value(), canvas.renderView, canvas.renderMode, canvas.background_color);
        return 0;
    }

    @Override
    public int setLocalVideoMirrorType(MirrorType mirrorType) {
        NativeRTCVideoFunctions.nativeSetLocalVideoMirrorType(this.mNativeEngine, mirrorType.value());
        return 0;
    }

    @Override
    public int setVideoRotationMode(VideoRotationMode rotationMode) {
        return NativeRTCVideoFunctions.nativeSetVideoRotationMode(this.mNativeEngine, rotationMode.value());
    }

    @Override
    public int switchCamera(CameraId cameraId) {
        LogUtil.d(TAG, "switchCamera");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, switchCamera failed.");
            return -1;
        }
        NativeRTCVideoFunctions.nativeSwitchCamera(this.mNativeEngine, cameraId.value());
        this.mIsFront = !this.mIsFront;
        return 0;
    }

    @Override
    public int replaceBackground(BackgroundMode mode, DivideModel divide_model) {
        return 0;
    }

    @Override
    public int setAudioPlaybackDevice(AudioPlaybackDevice audioPlaybackDevice) {
        LogUtil.d(TAG, "setAudioPlaybackDevice: " + audioPlaybackDevice.value());
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setAudioPlaybackDevice failed.");
            return -1;
        }
        return NativeRTCVideoFunctions.nativeSetAudioPlaybackDevice(this.mNativeEngine, audioPlaybackDevice.value());
    }

    @Override
    public int setAudioRoute(AudioRoute audioRoute) {
        LogUtil.d(TAG, "setAudioRoute: " + audioRoute.value());
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setAudioRoute failed.");
            return -1;
        }
        return NativeRTCVideoFunctions.nativeSetAudioRoute(this.mNativeEngine, audioRoute.value());
    }

    @Override
    public AudioRoute getAudioRoute() {
        LogUtil.d(TAG, "getAudioRoute");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, getAudioRoute failed.");
            return null;
        }
        int res = NativeRTCVideoFunctions.nativeGetAudioRoute(this.mNativeEngine);
        return AudioRoute.fromId(res);
    }

    @Override
    public void enableExternalSoundCard(boolean enable) {
        LogUtil.d(TAG, "enableExternalSoundCard");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, enableExternalSoundCard failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeEnableExternalSoundCard(this.mNativeEngine, enable);
    }

    @Override
    public int setDefaultAudioRoute(AudioRoute audioRoute) {
        LogUtil.d(TAG, "setDefaultAudioRoute: " + audioRoute.value());
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setDefaultAudioRoute failed.");
            return -1;
        }
        return NativeRTCVideoFunctions.nativeSetDefaultAudioRoute(this.mNativeEngine, audioRoute.value());
    }

    @Override
    public void setPlaybackVolume(int volume) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setPlaybackVolume failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeSetPlaybackVolume(this.mNativeEngine, volume);
    }

    @Override
    public void setLocalVoicePitch(int pitch) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setLocalVoicePitch failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeSetLocalVoicePitch(this.mNativeEngine, pitch);
    }

    @Override
    public void enableVocalInstrumentBalance(boolean enable) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, EnableVocalInstrumentBalance failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeEnableVocalInstrumentBalance(this.mNativeEngine, enable);
    }

    @Override
    public void enablePlaybackDucking(boolean enable) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, EnablePlaybackDucking failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeEnablePlaybackDucking(this.mNativeEngine, enable);
    }

    @Override
    public long login(String token, String uid) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendBinaryMessage failed.");
            return -3L;
        }
        return NativeRTCVideoFunctions.nativeLogin(this.mNativeEngine, token, uid);
    }

    @Override
    public void logout() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendBinaryMessage failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeLogout(this.mNativeEngine);
    }

    @Override
    public void updateLoginToken(String token) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendBinaryMessage failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeUpdateLoginToken(this.mNativeEngine, token);
    }

    @Override
    public void setServerParams(String signature, String url) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendBinaryMessage failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeSetServerParams(this.mNativeEngine, signature, url);
    }

    @Override
    public void getPeerOnlineStatus(String peer_user_id) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendBinaryMessage failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeGetPeerOnlineStatus(this.mNativeEngine, peer_user_id);
    }

    @Override
    public long sendUserMessageOutsideRoom(String uid, String message, MessageConfig config) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendBinaryMessage failed.");
            return -1L;
        }
        if (uid == null) {
            LogUtil.e(TAG, "sendUserMessageOutsideRoom: uid is null send failed");
            return -2L;
        }
        return NativeRTCVideoFunctions.nativeSendUserMessageOutsideRoom(this.mNativeEngine, uid, message, config.value());
    }

    @Override
    public long sendUserBinaryMessageOutsideRoom(String uid, byte[] buffer, MessageConfig config) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendBinaryMessage failed.");
            return -1L;
        }
        if (uid == null) {
            LogUtil.e(TAG, "sendUserBinaryMessageOutsideRoom: uid is null send failed");
            return -2L;
        }
        return NativeRTCVideoFunctions.nativeSendUserBinaryMessageOutsideRoom(this.mNativeEngine, uid, buffer, config.value());
    }

    @Override
    public long sendServerMessage(String message) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendBinaryMessage failed.");
            return -1L;
        }
        return NativeRTCVideoFunctions.nativeSendServerMessage(this.mNativeEngine, message);
    }

    @Override
    public long sendServerBinaryMessage(byte[] buffer) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendBinaryMessage failed.");
            return -1L;
        }
        return NativeRTCVideoFunctions.nativeSendServerBinaryMessage(this.mNativeEngine, buffer);
    }

    @Override
    public NetworkDetectionStartReturn startNetworkDetection(boolean isTestUplink, int expectedUplinkBitrate, boolean isTestDownlink, int expectedDownlinkBitrate) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendCustomMessage failed.");
            return NetworkDetectionStartReturn.values()[-1];
        }
        return NetworkDetectionStartReturn.values()[NativeRTCVideoFunctions.nativeStartNetworkProbe(this.mNativeEngine, isTestUplink, expectedUplinkBitrate, isTestDownlink, expectedDownlinkBitrate)];
    }

    @Override
    public void stopNetworkDetection() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, sendCustomMessage failed.");
        }
        NativeRTCVideoFunctions.nativeStopNetworkProbe(this.mNativeEngine);
    }

    @Override
    public void enableAudioFrameCallback(AudioFrameCallbackMethod method, AudioFormat format) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, enableAudioFrameCallback failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeEnableAudioFrameCallback(this.mNativeEngine, method.value(), format.sampleRate.value(), format.channel.value());
    }

    @Override
    public void disableAudioFrameCallback(AudioFrameCallbackMethod method) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, disableAudioFrameCallback failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeDisableAudioFrameCallback(this.mNativeEngine, method.value());
    }

    @Override
    public int registerAudioFrameObserver(IAudioFrameObserver observer) {
        this.mAudioFrameObserver = observer;
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, registerAudioFrameObserver failed.");
            return -1;
        }
        if (observer == null) {
            NativeRTCVideoFunctions.nativeSetAudioFrameObserver(this.mNativeEngine, null);
        } else {
            NativeRTCVideoFunctions.nativeSetAudioFrameObserver(this.mNativeEngine, this.mRtcAudioFrameObserver);
        }
        return 0;
    }

    @Override
    public int registerLocalAudioProcessor(IAudioProcessor audioProcessor, AudioFormat audioFormat) {
        this.mAudioProcessor = audioProcessor;
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, registerAudioFrameObserver failed.");
            return -1;
        }
        if (audioProcessor == null) {
            NativeRTCVideoFunctions.nativeSetAudioProcessor(this.mNativeEngine, null, -1, -1);
        } else {
            NativeRTCVideoFunctions.nativeSetAudioProcessor(this.mNativeEngine, this.mNativeAudioProcessor, audioFormat.sampleRate.value(), audioFormat.channel.value());
        }
        return 0;
    }

    @Override
    public int registerAudioProcessor(IAudioFrameProcessor audioFrameProcessor) {
        this.mAudioFrameProcessor = audioFrameProcessor;
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, registerAudioProcessor failed.");
            return -1;
        }
        if (audioFrameProcessor == null) {
            NativeRTCVideoFunctions.nativeSetAudioFrameProcessor(this.mNativeEngine, null);
        } else {
            NativeRTCVideoFunctions.nativeSetAudioFrameProcessor(this.mNativeEngine, this.mNativeAudioFrameProcessor);
        }
        return 0;
    }

    @Override
    public void enableAudioProcessor(AudioProcessorMethod method, AudioFormat format) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, enableAudioProcessor failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeEnableAudioProcessor(this.mNativeEngine, method.value(), format.sampleRate.value(), format.channel.value());
    }

    @Override
    public void disableAudioProcessor(AudioProcessorMethod method) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, disableAudioProcessor failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeDisableAudioProcessor(this.mNativeEngine, method.value());
    }

    @Override
    public int registerLocalVideoProcessor(IVideoProcessor processor, VideoPreprocessorConfig config) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, registerLocalVideoProcessor failed.");
            return -1;
        }
        if (config == null) {
            config = new VideoPreprocessorConfig();
        }
        if (this.mRtcVideoPreprocessor == null || this.mRtcVideoPreprocessor.registerLocalVideoProcessor(processor, config.required_pixel_format) != 0) {
            return -1;
        }
        VideoPixelFormat adapted_format = config.required_pixel_format;
        if (adapted_format != VideoPixelFormat.kVideoPixelFormatI420 && adapted_format != VideoPixelFormat.kVideoPixelFormatUnknown) {
            adapted_format = VideoPixelFormat.kVideoPixelFormatUnknown;
        }
        if (processor == null) {
            return NativeRTCVideoFunctions.nativeRegisterLocalVideoProcessor(this.mNativeEngine, null, adapted_format.value());
        }
        return NativeRTCVideoFunctions.nativeRegisterLocalVideoProcessor(this.mNativeEngine, this.mRtcVideoPreprocessor, adapted_format.value());
    }

    @Override
    public void registerLocalEncodedVideoFrameObserver(ILocalEncodedVideoFrameObserver observer) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, registerAudioFrameObserver failed.");
            return;
        }
        this.mLocalEncodedVideoFrameObserver = observer;
        if (observer == null) {
            NativeRTCVideoFunctions.nativeRegisterLocalEncodedVideoFrameObserver(this.mNativeEngine, null);
        } else {
            NativeRTCVideoFunctions.nativeRegisterLocalEncodedVideoFrameObserver(this.mNativeEngine, this.mRtcLocalEncodedVideoFrameObserver);
        }
    }

    @Override
    public void registerRemoteEncodedVideoFrameObserver(IRemoteEncodedVideoFrameObserver observer) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, RegisterRemoteEncodedVideoFrameObserver failed.");
            return;
        }
        this.mRemoteEncodedVideoFrameObserver = observer;
        if (observer == null) {
            NativeRTCVideoFunctions.nativeRegisterRemoteEncodedVideoFrameObserver(this.mNativeEngine, null);
        } else {
            NativeRTCVideoFunctions.nativeRegisterRemoteEncodedVideoFrameObserver(this.mNativeEngine, this.mRtcRemoteEncodedVideoFrameObserver);
        }
    }

    @Override
    public void setVideoSourceType(StreamIndex index, VideoSourceType type) {
        boolean bl = this.mUseExtVideoSource = type == VideoSourceType.VIDEO_SOURCE_TYPE_EXTERNAL;
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoInputType failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeSetVideoSourceTypeWithStreamId(this.mNativeEngine, index.value(), type.value());
    }

    @Override
    public boolean pushExternalVideoFrame(VideoFrame frame) {
        return this.pushExternalVideoFrame(frame, this.mIsUseCustomEglEnv);
    }

    @Override
    public boolean pushExternalVideoFrame(VideoFrame frame, boolean directEncode) {
        if (this.engineInvalid() || this.mState == RTCEngineImpl.State.DESTORY) {
            LogUtil.e(TAG, "pushExternalVideoFrame: native engine is invalid, pushExternalVideoFrame failed.");
            frame.release();
            return false;
        }
        if (frame == null) {
            LogUtil.i(TAG, "pushExternalVideoFrame: videoFrame is null, drop frame.");
            return false;
        }
        if (!this.mUseExtVideoSource) {
            LogUtil.i(TAG, "pushExternalVideoFrame: not enable external video source, drop frame.");
            frame.release();
            return false;
        }
        frame.retain();
        Log.d((String)TAG, (String)("pushExternalVideoFrame directEncode:" + directEncode));
        if (frame.getFrameType() == VideoFrameType.kVideoFrameTypeRawMemory) {
            NativeRTCVideoFunctions.nativePushExternalByteRtcVideoFrame(this.mNativeEngine, frame);
        } else if (frame.getFrameType() == VideoFrameType.kVideoFrameTypeGLTexture) {
            if (this.mVideoFrameConverter == null) {
                LogUtil.e(TAG, "pushExternalVideoFrame failed because no videoFrameConverter");
                frame.release();
                return false;
            }
            long startTimeStamp = System.currentTimeMillis();
            org.webrtc.VideoFrame webrtcVideoFrame = directEncode ? this.mVideoFrameConverter.convert2WebrtcTextureFrame(frame) : this.mVideoFrameConverter.convert2WebrtcI420Frame(frame);
            if (webrtcVideoFrame == null) {
                LogUtil.e(TAG, "pushExternalVideoFrame failed because no converted webrtcVideoFrame is null");
                frame.release();
                return false;
            }
            ByteBuffer extendedDataDirectBuffer = frame.getExternalDataInfo();
            ByteBuffer supplementaryInfoDirectBuffer = frame.getSupplementaryInfo();
            NativeRTCVideoFunctions.nativePushExternalWebrtcVideoFrame(this.mNativeEngine, webrtcVideoFrame, extendedDataDirectBuffer, supplementaryInfoDirectBuffer, startTimeStamp);
            webrtcVideoFrame.release();
        }
        frame.release();
        return true;
    }

    @Override
    public void startLiveTranscoding(String taskId, LiveTranscoding liveTranscode, ILiveTranscodingObserver observer) {
        this.mLiveTranscodingObserver = observer;
        if (this.mTranscodingObserver != null) {
            this.mTranscodingObserver.setUserObserver(taskId, this.mLiveTranscodingObserver);
        }
        LogUtil.d(TAG, "enableLiveTranscoding...");
        if (liveTranscode == null) {
            LogUtil.d(TAG, "enableLiveTranscoding...liveTranscode is null, no effect, please check.");
            return;
        }
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, enableLiveTranscoding failed.");
            return;
        }
        this.mEnableTranscode = true;
        this.mLiveTranscoding = liveTranscode;
        this.mLiveTranscoding.setAction("started");
        JSONObject jsonObject = this.mLiveTranscoding.getTranscodeMessage();
        if (jsonObject == null) {
            return;
        }
        String message = jsonObject.toString();
        LogUtil.d(TAG, "enableLiveTranscoding...liveTranscodeJson: " + message);
        NativeRTCVideoFunctions.nativeStartLiveTranscoding(this.mNativeEngine, taskId, liveTranscode, this.mTranscodingObserver);
    }

    @Override
    public void stopLiveTranscoding(String taskId) {
        LogUtil.d(TAG, "disableLiveTranscoding...");
        this.mEnableTranscode = false;
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, disableLiveTranscoding failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeStopLiveTranscoding(this.mNativeEngine, taskId);
    }

    @Override
    public void updateLiveTranscoding(String taskId, LiveTranscoding transcoding) {
        LogUtil.d(TAG, "updateLiveTranscoding...");
        if (transcoding == null) {
            LogUtil.d(TAG, "updateLiveTranscoding...mLiveTranscoding is null, no effect, please check.");
            return;
        }
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, updateLiveTranscoding failed.");
            return;
        }
        transcoding.setAction("layoutChanged");
        JSONObject jsonObject = transcoding.getTranscodeMessage();
        if (jsonObject == null) {
            return;
        }
        String message = jsonObject.toString();
        LogUtil.d(TAG, "updateLiveTranscoding...liveTranscodeJson: " + message);
        NativeRTCVideoFunctions.nativeUpdateLiveTranscoding(this.mNativeEngine, taskId, transcoding);
    }

    @Override
    public void startPushSingleStreamToCDN(String taskId, PushSingleStreamParam param, IPushSingleStreamToCDNObserver observer) {
        if (this.mSingleStreamToCDNObserver != null) {
            this.mSingleStreamToCDNObserver.setUserObserver(observer);
        }
        LogUtil.d(TAG, "startSingleStreamToCDN...");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, startSingleStreamToCDN failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeStartPushSingleStreamToCDN(this.mNativeEngine, taskId, param.roomId, param.userId, param.url, param.isScreen, this.mSingleStreamToCDNObserver);
    }

    @Override
    public void stopPushStreamToCDN(String taskId) {
        LogUtil.d(TAG, "stopPushStreamToCDN...");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, stopPushStreamToCDN failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeStopPushStreamToCDN(this.mNativeEngine, taskId);
    }

    @Override
    public int setVideoCaptureConfig(VideoCaptureConfig videoCaptureConfig) {
        if (videoCaptureConfig == null || this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid or videoCaptureConfig is null, setVideoCaptureConfig failed.");
            return -1;
        }
        LogUtil.d(TAG, "setVideoCaptureConfig: " + videoCaptureConfig.toString());
        InternalVideoCaptureConfig captureConfig = new InternalVideoCaptureConfig(videoCaptureConfig.capturePreference.getValue(), videoCaptureConfig.width, videoCaptureConfig.height, videoCaptureConfig.frameRate);
        return NativeRTCVideoFunctions.nativeSetVideoCaptureConfig(this.mNativeEngine, captureConfig);
    }

    @Override
    public int enableSimulcastMode(boolean enabled) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoResolutions failed.");
            return -1;
        }
        NativeRTCVideoFunctions.nativeEnableSimulcastMode(this.mNativeEngine, enabled);
        return 0;
    }

    @Override
    public int setVideoEncoderConfig(List<VideoStreamDescription> videoStreamDescriptions, VideoEncoderConfiguration.OrientationMode orientationMode) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoResolutions failed.");
            return -1;
        }
        RTCData.instance().setOrientationMode(orientationMode);
        this.setVideoEncoderConfig(StreamIndex.STREAM_INDEX_MAIN, videoStreamDescriptions);
        return 0;
    }

    @Override
    public int setVideoEncoderConfig(StreamIndex streamIndex, List<VideoStreamDescription> videoStreamDescriptions) {
        if (videoStreamDescriptions == null) {
            videoStreamDescriptions = new ArrayList<VideoStreamDescription>();
        }
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoResolutions failed.");
            return -1;
        }
        ArrayList<InternalVideoStreamDescription> internalVideoStreamDescriptionList = new ArrayList<InternalVideoStreamDescription>();
        for (VideoStreamDescription description : videoStreamDescriptions) {
            if (streamIndex == StreamIndex.STREAM_INDEX_MAIN && !description.isValid()) {
                LogUtil.e(TAG, "setVideoResolutions with illegal params");
                return -2;
            }
            internalVideoStreamDescriptionList.add(new InternalVideoStreamDescription(description));
        }
        NativeRTCVideoFunctions.nativeSetVideoEncoderConfig(this.mNativeEngine, streamIndex.value(), internalVideoStreamDescriptionList);
        return 0;
    }

    @Override
    public int setVideoEncoderConfig(VideoEncoderConfig max_solution) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoResolutions failed.");
            return -1;
        }
        VideoEncoderConfig[] channel_solutions = new VideoEncoderConfig[]{max_solution};
        return this.setVideoEncoderConfig(channel_solutions);
    }

    @Override
    public int setVideoEncoderConfig(VideoEncoderConfig[] channel_solutions) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoEncoderConfig failed.");
            return -1;
        }
        if (channel_solutions == null) {
            return -1;
        }
        ArrayList<InternalVideoEncoderConfig> internalVideoEncoderConfigList = new ArrayList<InternalVideoEncoderConfig>();
        for (VideoEncoderConfig config : channel_solutions) {
            if (!config.isValid()) {
                LogUtil.e(TAG, "setVideoEncoderConfig with illegal params");
                return -2;
            }
            internalVideoEncoderConfigList.add(new InternalVideoEncoderConfig(config));
        }
        return NativeRTCVideoFunctions.nativeSetVideoEncoderConfigV2(this.mNativeEngine, internalVideoEncoderConfigList);
    }

    @Override
    public int setScreenVideoEncoderConfig(VideoEncoderConfig screen_solution) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoEncoderConfig failed.");
            return -1;
        }
        InternalVideoEncoderConfig internal_screen_solution = new InternalVideoEncoderConfig(screen_solution);
        return NativeRTCVideoFunctions.nativeSetScreenVideoEncoderConfig(this.mNativeEngine, internal_screen_solution);
    }

    @Override
    public int pushExternalAudioFrame(AudioFrame audioFrame) {
        if (this.engineInvalid() || this.mState == RTCEngineImpl.State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, pushExternalAudioFrame failed.");
            return -1;
        }
        boolean ret = NativeRTCVideoFunctions.nativePushExternalAudioFrame(this.mNativeEngine, audioFrame.buffer, audioFrame.samples, audioFrame.sampleRate.value(), audioFrame.channel.value());
        return ret ? 0 : -2;
    }

    @Override
    public int pullExternalAudioFrame(AudioFrame audioFrame) {
        if (this.engineInvalid() || this.mState == RTCEngineImpl.State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, pullExternalAudioFrame failed.");
            return -1;
        }
        boolean ret = NativeRTCVideoFunctions.nativePullExternalAudioFrame(this.mNativeEngine, audioFrame.buffer, audioFrame.samples, audioFrame.sampleRate.value(), audioFrame.channel.value());
        return ret ? 0 : -2;
    }

    @Override
    public int setAudioSourceType(AudioSourceType type) {
        LogUtil.d(TAG, "SetAudioSourceType");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, SetAudioSourceType failed.");
            return -1;
        }
        return NativeRTCVideoFunctions.nativeSetAudioSourceType(this.mNativeEngine, type.value());
    }

    @Override
    public int setAudioRenderType(AudioRenderType type) {
        LogUtil.d(TAG, "SetAudioRenderType");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, SetAudioRenderType failed.");
            return -1;
        }
        return NativeRTCVideoFunctions.nativeSetAudioRenderType(this.mNativeEngine, type.value());
    }

    @Override
    public boolean pushScreenFrame(VideoFrame frame) {
        if (this.engineInvalid() || this.mState == RTCEngineImpl.State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, pushExternalVideoFrame failed.");
            return false;
        }
        if (frame == null) {
            LogUtil.i(TAG, "videoFrame is null, drop frame.");
            return false;
        }
        frame.retain();
        boolean ret = false;
        if (frame.getFrameType() == VideoFrameType.kVideoFrameTypeRawMemory) {
            ret = NativeRTCVideoFunctions.nativePushScreenByteRtcFrame(this.mNativeEngine, frame);
        } else if (frame.getFrameType() == VideoFrameType.kVideoFrameTypeGLTexture) {
            if (this.mScreenFrameConverter == null) {
                frame.release();
                return false;
            }
            org.webrtc.VideoFrame videoFrame = this.mScreenFrameConverter.convert2WebrtcI420Frame(frame);
            if (videoFrame == null) {
                LogUtil.e(TAG, "pushExternalVideoFrame failed because no converted webrtcVideoFrame is null");
                frame.release();
                return false;
            }
            ret = NativeRTCVideoFunctions.nativePushScreenFrame(this.mNativeEngine, videoFrame);
            videoFrame.release();
        }
        frame.release();
        return ret;
    }

    @Override
    public void setOnDestroyCompletedCallback(Runnable callback) {
        this.mOnDestroyCompletedCallback = callback;
    }

    @Override
    public void setRemoteAudioPlaybackVolume(String roomId, @NonNull String uid, int volume) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setRemoteAudioPlaybackVolume failed.");
            return;
        }
        if (uid == null) {
            LogUtil.e(TAG, "setRemoteAudioPlaybackVolume: uid is null adjust failed");
            return;
        }
        NativeRTCVideoFunctions.nativeSetRemoteAudioPlaybackVolume(this.mNativeEngine, roomId, uid, volume);
    }

    @Override
    public RTCRoom createRTCRoom(String roomId) {
        long nativeRtcRoom;
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, createRoom failed.");
            return null;
        }
        if (roomId == null) {
            roomId = "";
        }
        if ((nativeRtcRoom = NativeRTCVideoFunctions.nativeCreateRoom(this.mNativeEngine, roomId)) == 0L) {
            LogUtil.e(TAG, "createRoom faildd, native room is invalid");
            return null;
        }
        RTCRoomImpl rtcRoom = new RTCRoomImpl(roomId, nativeRtcRoom);
        return rtcRoom;
    }

    @Override
    public int setPublishFallbackOption(PublishFallbackOption option) {
        LogUtil.d(TAG, "setPublishFallbackOption: option: " + (Object)((Object)option));
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setPublishFallbackOption failed.");
            return -1;
        }
        NativeRTCVideoFunctions.nativeSetPublishFallbackOption(this.mNativeEngine, option.value());
        return 0;
    }

    @Override
    public int setSubscribeFallbackOption(SubscribeFallbackOptions option) {
        LogUtil.d(TAG, "setRemoteSubscribeFallbackOption: option: " + (Object)((Object)option));
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setRemoteSubscribeFallbackOption failed.");
            return -1;
        }
        NativeRTCVideoFunctions.nativeSetRemoteSubscribeFallbackOption(this.mNativeEngine, option.value());
        return 0;
    }

    @Override
    public int setRemoteUserPriority(@NonNull String roomId, @NonNull String uid, RemoteUserPriority priority) {
        LogUtil.d(TAG, "setRemoteUserPriority: uid: " + uid + ", priority: " + (Object)((Object)priority));
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setRemoteUserPriority failed.");
            return -1;
        }
        if (uid == null) {
            LogUtil.e(TAG, "setRemoteUserPriority: uid is null set failed");
            return -2;
        }
        NativeRTCVideoFunctions.nativeSetRemoteUserPriority(this.mNativeEngine, roomId, uid, priority.value());
        return 0;
    }

    @Override
    public void setCaptureVolume(StreamIndex index, int volume) {
        LogUtil.d(TAG, "setCaptureVolume");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setCaptureVolume failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeSetCaptureVolume(this.mNativeEngine, volume, index.value());
    }

    @Override
    public int sendSEIMessage(StreamIndex streamIndex, byte[] message, int repeatCount) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, registerMetadataObserver failed.");
            return -1;
        }
        return NativeRTCVideoFunctions.nativeSendSEIMessage(this.mNativeEngine, streamIndex.value(), message, repeatCount);
    }

    @Override
    public int setBusinessId(String businessId) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setBusinessId failed.");
            return -1;
        }
        return NativeRTCVideoFunctions.nativeSetBusinessId(this.mNativeEngine, businessId);
    }

    @Override
    public void setEncryptInfo(int aesType, String key) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setEncryptInfo failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeSetEncryptInfo(this.mNativeEngine, aesType, key);
    }

    @Override
    public void setCustomizeEncryptHandler(RTCEncryptHandler handler) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setCustomizeEncryptHandler failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeSetCustomizeEncryptHandler(this.mNativeEngine, handler);
    }

    @Override
    public int checkVideoEffectLicense(Context context, String licenseFile) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, checkVideoEffectLicense failed.");
            return -1;
        }
        return NativeRTCVideoFunctions.nativeCheckVideoEffectLicense(context, this.mNativeEngine, licenseFile);
    }

    @Override
    public int initVirtualBackground(Context context, String licenseFile, String modelFile) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, initVirtualBackground failed.");
            return -1;
        }
        return NativeRTCVideoFunctions.nativeInitVirtualBackground(context, this.mNativeEngine, licenseFile, modelFile);
    }

    @Override
    public int enableVirtualBackground(VirtualBackgroundSource source) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, enableVirtualBackground failed.");
            return -1;
        }
        if (source == null) {
            LogUtil.e(TAG, "virtualBackgroundSource is invalid.");
            return -1;
        }
        if (source.sourcePath == null) {
            source.sourcePath = "";
        }
        return NativeRTCVideoFunctions.nativeEnableVirtualBackground(this.mNativeEngine, source.sourceType.ordinal(), source.sourceColor, source.sourcePath);
    }

    @Override
    public int disableVirtualBackground() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, disableVirtualBackground failed.");
            return -1;
        }
        return NativeRTCVideoFunctions.nativeDisableVirtualBackground(this.mNativeEngine);
    }

    @Override
    public int setVideoEffectAlgoModelResourceFinder(long finder, long deleter) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoEffectAlgoModelResourceFinder failed.");
            return 1000;
        }
        return NativeRTCVideoFunctions.nativeSetVideoEffectAlgoModelResourceFinder(this.mNativeEngine, finder, deleter);
    }

    @Override
    public int setVideoEffectExpressionDetect(VideoEffectExpressionConfig config) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoEffectExpressionDetect failed.");
            return 1000;
        }
        InternalExpressDetectConfig internalConfig = new InternalExpressDetectConfig(config);
        return NativeRTCVideoFunctions.nativeSetVideoEffectExpressionDetect(this.mNativeEngine, internalConfig);
    }

    @Override
    public void setVideoEffectAlgoModelPath(String modelPath) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoEffectAlgoModelPath failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeSetVideoEffectAlgoModelPath(this.mNativeEngine, modelPath);
    }

    @Override
    public int enableVideoEffect(boolean enable) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, enableVideoEffect failed.");
            return 1000;
        }
        return NativeRTCVideoFunctions.nativeEnableVideoEffect(this.mNativeEngine, enable);
    }

    @Override
    public int setVideoEffectNodes(List<String> effectPath) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoEffectPath failed.");
            return 1000;
        }
        String[] strArray = new String[effectPath.size()];
        effectPath.toArray(strArray);
        return NativeRTCVideoFunctions.nativeSetVideoEffectNodes(this.mNativeEngine, strArray);
    }

    @Override
    public int appendVideoEffectNodes(List<String> effectPath) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, appendVideoEffectNodes failed.");
            return 1000;
        }
        String[] strArray = new String[effectPath.size()];
        effectPath.toArray(strArray);
        return NativeRTCVideoFunctions.nativeAppendVideoEffectNodes(this.mNativeEngine, strArray);
    }

    @Override
    public int removeVideoEffectNodes(List<String> effectPath) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, removeVideoEffectNodes failed.");
            return 1000;
        }
        String[] strArray = new String[effectPath.size()];
        effectPath.toArray(strArray);
        return NativeRTCVideoFunctions.nativeRemoveVideoEffectNodes(this.mNativeEngine, strArray);
    }

    @Override
    public int updateVideoEffectNode(String effectNode, String key, float value) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, updateVideoEffect failed.");
            return 1000;
        }
        return NativeRTCVideoFunctions.nativeUpdateVideoEffectNode(this.mNativeEngine, effectNode, key, value);
    }

    @Override
    public int setBackgroundSticker(String modelPath, VirtualBackgroundSource source) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, enableVirtualBackground failed.");
            return -1;
        }
        String sourcePath = "";
        if (source != null && source.sourcePath != null) {
            sourcePath = source.sourcePath;
        }
        return NativeRTCVideoFunctions.nativeSetBackgroundSticker(this.mNativeEngine, modelPath == null ? "" : modelPath, source == null ? 0 : source.sourceType.ordinal(), source == null ? 0 : source.sourceColor, sourcePath);
    }

    @Override
    public int setVideoEffectColorFilter(String resFile) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoEffectColorFilter failed.");
            return 1000;
        }
        return NativeRTCVideoFunctions.nativeSetVideoEffectColorFilter(this.mNativeEngine, resFile);
    }

    @Override
    public int setVideoEffectColorFilterIntensity(float intensity) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoEffectColorFilterIntensity failed.");
            return 1000;
        }
        return NativeRTCVideoFunctions.nativeSetVideoEffectColorFilterIntensity(this.mNativeEngine, intensity);
    }

    @Override
    public int registerFaceDetectionObserver(IFaceDetectionObserver observer, int interval) {
        if (this.mNativeEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, registerFaceDetectionObserver failed.");
            return -1;
        }
        this.mFaceDetectionObserver = new WeakReference<IFaceDetectionObserver>(observer);
        if (observer == null) {
            NativeRTCVideoFunctions.nativeRegisterFaceDetectionObserver(this.mNativeEngine, null, interval);
        } else {
            NativeRTCVideoFunctions.nativeRegisterFaceDetectionObserver(this.mNativeEngine, this.mRTCFaceDetectionObserver, interval);
        }
        return 0;
    }

    public IFaceDetectionObserver getFaceDetectionObserver() {
        return (IFaceDetectionObserver)this.mFaceDetectionObserver.get();
    }

    @Override
    public int enableEffectBeauty(boolean enable) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, enableEffectBeauty failed.");
            return 1000;
        }
        return NativeRTCVideoFunctions.nativeEnableEffectBeauty(this.mNativeEngine, enable);
    }

    @Override
    public int setBeautyIntensity(EffectBeautyMode beautyMode, float intensity) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setBeautyIntensity failed.");
            return 1000;
        }
        return NativeRTCVideoFunctions.nativeSetBeautyIntensity(this.mNativeEngine, beautyMode.value(), intensity);
    }

    @Override
    public void setVideoOrientation(VideoOrientation orientation) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setVideoOrientation failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeSetVideoOrientation(this.mNativeEngine, orientation.value());
    }

    @Override
    public void setRuntimeParameters(JSONObject params) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, SetRuntimeParameters failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeSetRuntimeParameters(this.mNativeEngine, params == null ? "" : params.toString());
    }

    @Override
    public int feedback(List<ProblemFeedback> types, String problemDesc) {
        if (!mLibraryLoaded) {
            RTCVideoImpl.loadSoFile();
        }
        int[] typeArray = new int[types.size()];
        for (int i = 0; i < types.size(); ++i) {
            typeArray[i] = types.get((int)i).value;
        }
        return NativeRTCVideoFunctions.nativeReportFeedback(this.mNativeEngine, typeArray, problemDesc);
    }

    @Override
    public void startASR(RTCASRConfig asrConfig, IRTCASREngineEventHandler handler) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, startASR");
            return;
        }
        if (handler == null || asrConfig == null) {
            return;
        }
        String uid = asrConfig.userId == null ? "" : asrConfig.userId;
        String appId = asrConfig.appId == null ? "" : asrConfig.appId;
        String token = asrConfig.accessToken == null ? "" : asrConfig.accessToken;
        String secret = asrConfig.secretKey == null ? "" : asrConfig.secretKey;
        int authType = asrConfig.authorizationType.value();
        String cluster = asrConfig.cluster == null ? "" : asrConfig.cluster;
        this.mRTCASREngineEventHandler.setAsrEventHandler(handler);
        NativeRTCVideoFunctions.nativeStartASR(this.mNativeEngine, this.mRTCASREngineEventHandler, uid, appId, token, secret, authType, cluster);
    }

    @Override
    public void stopASR() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, stopASR");
            return;
        }
        NativeRTCVideoFunctions.nativeStopASR(this.mNativeEngine);
    }

    @Override
    public int startFileRecording(StreamIndex type, RecordingConfig config, RecordingType recordingType) {
        LogUtil.d(TAG, "startFileRecording");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, startFileRecording failed.");
            return -1;
        }
        return NativeRTCVideoFunctions.nativeStartFileRecording(this.mNativeEngine, type.value(), config.dirPath, config.recordingFileType.value(), recordingType.value());
    }

    @Override
    public void stopFileRecording(StreamIndex type) {
        LogUtil.d(TAG, "stopFileRecording");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, stopFileRecording failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeStopFileRecording(this.mNativeEngine, type.value());
    }

    @Override
    public IAudioMixingManager getAudioMixingManager() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, getAudioMixingManager");
            return null;
        }
        if (this.mAudioMixingManager != null) {
            return this.mAudioMixingManager;
        }
        long nativeAudioMixingManager = NativeRTCVideoFunctions.nativeGetAudioMixingManager(this.mNativeEngine);
        if (nativeAudioMixingManager == 0L) {
            LogUtil.e(TAG, "getAudioMixingManager failed");
            return null;
        }
        this.mAudioMixingManager = new AudioMixingManager(nativeAudioMixingManager);
        return this.mAudioMixingManager;
    }

    @Override
    public void setScreenAudioSourceType(AudioSourceType sourceType) {
        LogUtil.d(TAG, "SetScreenAudioSourceType");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, SetScreenAudioSourceType failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeSetScreenAudioSourceType(this.mNativeEngine, sourceType.value());
    }

    @Override
    public void setScreenAudioStreamIndex(StreamIndex index) {
        LogUtil.d(TAG, "SetScreenAudioStreamIndex");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, SetScreenAudioStreamIndex failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeSetScreenAudioStreamIndex(this.mNativeEngine, index.value());
    }

    @Override
    public int pushScreenAudioFrame(AudioFrame audioFrame) {
        if (this.engineInvalid() || this.mState == RTCEngineImpl.State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, PushScreenAudioFrame failed.");
            return -1;
        }
        int ret = NativeRTCVideoFunctions.nativePushScreenAudioFrame(this.mNativeEngine, audioFrame.buffer, audioFrame.samples, audioFrame.sampleRate.value(), audioFrame.channel.value());
        return ret;
    }

    @Override
    public void startScreenCapture(ScreenMediaType type, Intent mediaProjectionResultData) {
        LogUtil.d(TAG, "StartScreenAudioCapture");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, StopScreenAudioCapture failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeStartScreenCapture(this.mNativeEngine, type.value(), mediaProjectionResultData);
    }

    @Override
    public void updateScreenCapture(ScreenMediaType type) {
        LogUtil.d(TAG, "UpdateScreenCapture");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, StopScreenAudioCapture failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeUpdateScreenCapture(this.mNativeEngine, type.value());
    }

    @Override
    public void stopScreenCapture() {
        LogUtil.d(TAG, "StopScreenCapture");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, StopScreenAudioCapture failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeStopScreenCapture(this.mNativeEngine);
    }

    @Override
    public void setExternalVideoEncoderEventHandler(IExternalVideoEncoderEventHandler encoder_handler) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setExternalVideoEncoderEventHandler failed.");
            return;
        }
        this.mExternalVideoEncoderHandler = encoder_handler;
        if (encoder_handler == null) {
            NativeRTCVideoFunctions.nativeSetExternalVideoEncoderEventHandler(this.mNativeEngine, null);
        } else {
            NativeRTCVideoFunctions.nativeSetExternalVideoEncoderEventHandler(this.mNativeEngine, this.mRtcExVideoEncoderHandler);
        }
    }

    @Override
    public boolean pushExternalEncodedVideoFrame(StreamIndex index, int video_index, RTCEncodedVideoFrame video_stream) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, PushExternalEncodedVideoFrame failed.");
            return false;
        }
        return NativeRTCVideoFunctions.nativePushExternalEncodedVideoFrame(this.mNativeEngine, index.value(), video_index, video_stream.buffer, video_stream.timestampUs, video_stream.timestampDtsUs, video_stream.width, video_stream.height, video_stream.videoCodecType.value(), video_stream.videoPictureType.value(), video_stream.videoRotation.value());
    }

    @Override
    public void setVideoDecoderConfig(RemoteStreamKey key, VideoDecoderConfig config) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, SetVideoDecoderConfig failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeSetVideoDecoderConfig(this.mNativeEngine, key.getRoomId(), key.getUserId(), key.getStreamIndex().value(), config.value());
    }

    @Override
    public void requestRemoteVideoKeyFrame(RemoteStreamKey stream_info) {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, RequestRemoteVideoKeyFrame failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeRequestRemoteVideoKeyFrame(this.mNativeEngine, stream_info.getRoomId(), stream_info.getUserId(), stream_info.getStreamIndex().value());
    }

    @Override
    public void setEarMonitorMode(EarMonitorMode mode) {
        LogUtil.d(TAG, "setEarMonitorMode");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setEarMonitorMode failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeSetEarMonitorMode(this.mNativeEngine, mode.value());
    }

    @Override
    public void setEarMonitorVolume(int volume) {
        LogUtil.d(TAG, "setEarMonitorVolume");
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, setEarMonitorVolume failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeSetEarMonitorVolume(this.mNativeEngine, volume);
    }

    @Override
    public void enableAudioPropertiesReport(AudioPropertiesConfig config) {
        if (this.engineInvalid() || this.mState == RTCEngineImpl.State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, EnableAudioPropertiesReport failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeEnableAudioPropertiesReport(this.mNativeEngine, config.interval, config.enable_spectrum, config.enable_vad, config.local_main_report_mode.value(), config.audio_report_mode.value());
    }

    @Override
    public int sendStreamSyncInfo(byte[] data, StreamSycnInfoConfig config) {
        if (this.engineInvalid() || this.mState == RTCEngineImpl.State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, SendStreamSyncInfo failed.");
            return -1;
        }
        return NativeRTCVideoFunctions.nativeSendStreamSyncInfo(this.mNativeEngine, data, config.streamIndex.value(), config.repeatCount, 0);
    }

    @Override
    public boolean isCameraTorchSupported() {
        if (this.engineInvalid() || this.mState == RTCEngineImpl.State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, PushScreenAudioFrame failed.");
            return false;
        }
        return NativeRTCVideoFunctions.nativeIsSupportFlashLight(this.mNativeEngine);
    }

    @Override
    public boolean isCameraZoomSupported() {
        if (this.engineInvalid() || this.mState == RTCEngineImpl.State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, PushScreenAudioFrame failed.");
            return false;
        }
        return NativeRTCVideoFunctions.nativeIsCameraZoomSupported(this.mNativeEngine);
    }

    @Override
    public int setCameraZoomRatio(float zoom) {
        if (this.engineInvalid() || this.mState == RTCEngineImpl.State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, PushScreenAudioFrame failed.");
            return -1;
        }
        return NativeRTCVideoFunctions.nativeSetCameraZoomRatio(this.mNativeEngine, zoom);
    }

    @Override
    public float getCameraZoomMaxRatio() {
        if (this.engineInvalid() || this.mState == RTCEngineImpl.State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, PushScreenAudioFrame failed.");
            return -1.0f;
        }
        return NativeRTCVideoFunctions.nativeGetCameraZoomMaxRatio(this.mNativeEngine);
    }

    @Override
    public int setCameraTorch(TorchState torch_state) {
        if (this.engineInvalid() || this.mState == RTCEngineImpl.State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, PushScreenAudioFrame failed.");
            return -1;
        }
        boolean enalbed = false;
        if (torch_state == TorchState.TORCH_STATE_ON) {
            enalbed = true;
        }
        return NativeRTCVideoFunctions.nativeEnableCameraTorch(this.mNativeEngine, enalbed);
    }

    @Override
    public boolean isCameraFocusPositionSupported() {
        if (this.engineInvalid() || this.mState == RTCEngineImpl.State.DESTORY) {
            return false;
        }
        return NativeRTCVideoFunctions.nativeIsCameraFocusPositionSupported(this.mNativeEngine);
    }

    @Override
    public int setCameraFocusPosition(float x, float y) {
        if (this.engineInvalid() || this.mState == RTCEngineImpl.State.DESTORY) {
            return -1;
        }
        return NativeRTCVideoFunctions.nativeSetCameraFocusPosition(this.mNativeEngine, x, y);
    }

    @Override
    public boolean isCameraExposurePositionSupported() {
        if (this.engineInvalid() || this.mState == RTCEngineImpl.State.DESTORY) {
            return false;
        }
        return NativeRTCVideoFunctions.nativeIsCameraExposurePositionSupported(this.mNativeEngine);
    }

    @Override
    public int setCameraExposurePosition(float x, float y) {
        if (this.engineInvalid() || this.mState == RTCEngineImpl.State.DESTORY) {
            return -1;
        }
        return NativeRTCVideoFunctions.nativeSetCameraExposurePosition(this.mNativeEngine, x, y);
    }

    @Override
    public int setCameraExposureCompensation(float val) {
        if (this.engineInvalid() || this.mState == RTCEngineImpl.State.DESTORY) {
            return -1;
        }
        return NativeRTCVideoFunctions.nativeSetCameraExposureCompensation(this.mNativeEngine, val);
    }

    @Override
    public void muteAudioPlayback(MuteState muteState) {
        if (this.mNativeEngine == -1L || this.mState == RTCEngineImpl.State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, muteAudioPlayback failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeMuteAudioPlayback(this.mNativeEngine, muteState.value());
    }

    @Override
    public void setVideoWatermark(StreamIndex streamIndex, String imagePath, RTCWatermarkConfig watermarkConfig) {
        if (this.mNativeEngine == -1L || this.mState == RTCEngineImpl.State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, muteAudioPlayback failed.");
            return;
        }
        float lx = 0.0f;
        float ly = 0.0f;
        float lw = 0.0f;
        float lh = 0.0f;
        float px = 0.0f;
        float py = 0.0f;
        float pw = 0.0f;
        float ph = 0.0f;
        if (watermarkConfig.positionInLandscapeMode != null) {
            lx = watermarkConfig.positionInLandscapeMode.x;
            ly = watermarkConfig.positionInLandscapeMode.y;
            lw = watermarkConfig.positionInLandscapeMode.width;
            lh = watermarkConfig.positionInLandscapeMode.height;
        }
        if (watermarkConfig.positionInPortraitMode != null) {
            px = watermarkConfig.positionInPortraitMode.x;
            py = watermarkConfig.positionInPortraitMode.y;
            pw = watermarkConfig.positionInPortraitMode.width;
            ph = watermarkConfig.positionInPortraitMode.height;
        }
        NativeRTCVideoFunctions.nativeSetVideoWatermark(this.mNativeEngine, streamIndex.value(), imagePath, watermarkConfig.visibleInPreview, lx, ly, lw, lh, px, py, pw, ph);
    }

    @Override
    public void clearVideoWatermark(StreamIndex streamIndex) {
        if (this.mNativeEngine == -1L || this.mState == RTCEngineImpl.State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, clearVideoWatermark failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeClearVideoWatermark(this.mNativeEngine, streamIndex.value());
    }

    @Override
    public int startPushPublicStream(String publicStreamId, PublicStreaming publicStreaming) {
        if (this.mNativeEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, startPushPublicStream failed.");
            return -1;
        }
        if (publicStreaming == null) {
            LogUtil.e(TAG, "startPushPublicStream failed for publicStreaming is null.");
            return -1;
        }
        publicStreaming.setAction("started");
        JSONObject jsonObject = publicStreaming.getPublicStreamMessage();
        if (jsonObject == null) {
            LogUtil.e(TAG, "public stream parameter is invalid, startPushPublicStream failed.");
            return -1;
        }
        String message = jsonObject.toString();
        LogUtil.d(TAG, "startPushPublicStream...public stream parameter: " + message);
        return NativeRTCVideoFunctions.nativeStartPushPublicStream(this.mNativeEngine, publicStreamId, message);
    }

    @Override
    public int stopPushPublicStream(String publicStreamId) {
        if (this.mNativeEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, stopPushPublicStream failed.");
            return -1;
        }
        return NativeRTCVideoFunctions.nativeStopPushPublicStream(this.mNativeEngine, publicStreamId);
    }

    @Override
    public int updatePublicStreamParam(String publicStreamId, PublicStreaming publicStreaming) {
        if (this.mNativeEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, updatePublicStreamParam failed.");
            return -1;
        }
        if (publicStreaming == null) {
            LogUtil.e(TAG, "updatePublicStreamParam failed for publicStreaming is null.");
            return -1;
        }
        publicStreaming.setAction("layoutChanged");
        JSONObject jsonObject = publicStreaming.getPublicStreamMessage();
        if (jsonObject == null) {
            LogUtil.e(TAG, "public stream parameter is invalid, updatePublicStreamParam failed.");
            return -1;
        }
        String message = jsonObject.toString();
        LogUtil.d(TAG, "updatePublicStreamParam...public stream parameter: " + message);
        return NativeRTCVideoFunctions.nativeUpdatePublicStreamParam(this.mNativeEngine, publicStreamId, message);
    }

    @Override
    public int startPlayPublicStream(String publicStreamId) {
        if (this.mNativeEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, startPlayPublicStream failed.");
            return -1;
        }
        LogUtil.d(TAG, "startPlayPublicStream...public stream id: " + publicStreamId);
        return NativeRTCVideoFunctions.nativeStartPlayPublicStream(this.mNativeEngine, publicStreamId);
    }

    @Override
    public int stopPlayPublicStream(String publicStreamId) {
        if (this.mNativeEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, stopPlayPublicStream failed.");
            return -1;
        }
        LogUtil.d(TAG, "startPlayPublicStream...public stream id: " + publicStreamId);
        return NativeRTCVideoFunctions.nativeStopPlayPublicStream(this.mNativeEngine, publicStreamId);
    }

    @Override
    public int setPublicStreamVideoCanvas(String publicStreamId, VideoCanvas canvas) {
        if (this.mNativeEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, setPublicStreamVideoCanvas failed.");
            return -1;
        }
        LogUtil.d(TAG, "startPlayPublicStream...public stream id: " + publicStreamId);
        return NativeRTCVideoFunctions.nativeSetPublicStreamVideoCanvas(this.mNativeEngine, publicStreamId, canvas.renderView, canvas.renderMode);
    }

    @Override
    public void setPublicStreamVideoSink(String publicStreamId, IVideoSink videoSink, int requiredFormat) {
        if (this.mNativeEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, setPublicStreamVideoSink failed.");
            return;
        }
        LogUtil.d(TAG, "setPublicStreamVideoSink...public stream id: " + publicStreamId);
        VideoSinkAdapter sinkAdapter = null;
        if (videoSink != null) {
            sinkAdapter = new VideoSinkAdapter(videoSink);
        }
        NativeRTCVideoFunctions.nativeSetPublicStreamVideoSink(this.mNativeEngine, publicStreamId, sinkAdapter, requiredFormat);
    }

    @Override
    public int startEchoTest(EchoTestConfig config, int delayTime) {
        if (this.mNativeEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, startEchoTest failed.");
            return -4;
        }
        LogUtil.d(TAG, "startEchoTest");
        return NativeRTCVideoFunctions.nativeStartEchoTest(this.mNativeEngine, config, delayTime);
    }

    @Override
    public int stopEchoTest() {
        if (this.mNativeEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, stopEchoTest failed.");
            return -1;
        }
        LogUtil.d(TAG, "stopEchoTest");
        return NativeRTCVideoFunctions.nativeStopEchoTest(this.mNativeEngine);
    }

    @Override
    public void startCloudProxy(List<CloudProxyInfo> cloudProxiesInfo) {
        if (this.mNativeEngine == -1L || this.mState == RTCEngineImpl.State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, startCloudProxy failed.");
            return;
        }
        if (cloudProxiesInfo == null) {
            return;
        }
        ArrayList<InternalCloudProxyInfo> internalCloudProxiesInfo = new ArrayList<InternalCloudProxyInfo>();
        for (CloudProxyInfo cloudProxyInfo : cloudProxiesInfo) {
            internalCloudProxiesInfo.add(new InternalCloudProxyInfo(cloudProxyInfo));
        }
        NativeRTCVideoFunctions.nativeStartCloudProxy(this.mNativeEngine, internalCloudProxiesInfo);
    }

    @Override
    public void stopCloudProxy() {
        if (this.mNativeEngine == -1L || this.mState == RTCEngineImpl.State.DESTORY) {
            LogUtil.e(TAG, "native engine is invalid, stopCloudProxy failed.");
            return;
        }
        NativeRTCVideoFunctions.nativeStopCloudProxy(this.mNativeEngine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KTVManager getKTVManager() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, getKTVManger failed.");
            return null;
        }
        Class<RTCVideoImpl> clazz = RTCVideoImpl.class;
        synchronized (RTCVideoImpl.class) {
            if (this.mKTVManager != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.mKTVManager;
            }
            long nativeKTVManager = NativeRTCVideoFunctions.nativeGetKTVManager(this.mNativeEngine);
            if (nativeKTVManager == 0L) {
                LogUtil.e(TAG, "getKTVManger failed");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return null;
            }
            this.mKTVManager = new KTVManagerImpl(nativeKTVManager);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.mKTVManager;
        }
    }

    @Override
    public ISingScoringManager getSingScoringManager() {
        if (this.engineInvalid()) {
            LogUtil.e(TAG, "native engine is invalid, getSingScoringManager");
            return null;
        }
        if (this.mSingScoringManager != null) {
            return this.mSingScoringManager;
        }
        long nativeSingScoringManager = NativeRTCVideoFunctions.nativeGetSingScoringManager(this.mNativeEngine);
        if (nativeSingScoringManager == 0L) {
            LogUtil.e(TAG, "getSingScoringManager failed");
            return null;
        }
        this.mSingScoringManager = new SingScoringManager(this.mNativeEngine, nativeSingScoringManager);
        return this.mSingScoringManager;
    }

    static {
        RTCVideoImpl.loadSoFile();
    }
}

