/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.handler;

import com.bytedance.realx.base.CalledByNative;
import com.ss.bytertc.engine.utils.LogUtil;
import com.ss.bytertc.ktv.IKTVEventHandler;
import com.ss.bytertc.ktv.data.DownloadResult;
import com.ss.bytertc.ktv.data.HotMusicInfo;
import com.ss.bytertc.ktv.data.Music;

public class KTVEventHandler
extends IKTVEventHandler {
    private static final String TAG = "KTVEventHandler";
    private final IKTVEventHandler mHandler;

    public KTVEventHandler(IKTVEventHandler handler) {
        this.mHandler = handler;
    }

    public IKTVEventHandler getKTVHandler() {
        return this.mHandler;
    }

    @Override
    @CalledByNative
    public void onMusicListResult(int errorCode, int totalSize, Music[] musics) {
        LogUtil.d(TAG, "onMusicListResult...errorCode: " + errorCode + ",totalSize:" + totalSize + ",musicsLen:" + musics.length);
        try {
            if (this.mHandler != null) {
                this.mHandler.onMusicListResult(errorCode, totalSize, musics);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onMusicListResult callback catch exception.\n" + ex.getMessage());
        }
    }

    @Override
    @CalledByNative
    public void onSearchMusicResult(int errorCode, int totalSize, Music[] musics) {
        LogUtil.d(TAG, "onSearchMusicResult...errorCode: " + errorCode + ",totalSize:" + totalSize + ",musicsLen:" + musics.length);
        try {
            if (this.mHandler != null) {
                this.mHandler.onSearchMusicResult(errorCode, totalSize, musics);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onSearchMusicResult callback catch exception.\n" + ex.getMessage());
        }
    }

    @Override
    @CalledByNative
    public void onHotMusicResult(int errorCode, HotMusicInfo[] hotLists) {
        LogUtil.d(TAG, "onHotMusicResult...errorCode: " + errorCode + ",musicsLen:" + hotLists.length);
        try {
            if (this.mHandler != null) {
                this.mHandler.onHotMusicResult(errorCode, hotLists);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onHotMusicResult callback catch exception.\n" + ex.getMessage());
        }
    }

    @Override
    @CalledByNative
    public void onMusicDetailResult(int errorCode, Music music) {
        LogUtil.d(TAG, "onMusicDetailResult...errorCode: " + errorCode + ",music:" + music);
        try {
            if (this.mHandler != null) {
                this.mHandler.onMusicDetailResult(errorCode, music);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onMusicDetailResult callback catch exception.\n" + ex.getMessage());
        }
    }

    @Override
    @CalledByNative
    public void onDownloadSuccess(int downloadId, DownloadResult result) {
        LogUtil.d(TAG, "onDownloadSuccess...downloadId: " + downloadId + ",result:" + result);
        try {
            if (this.mHandler != null) {
                this.mHandler.onDownloadSuccess(downloadId, result);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onDownloadSuccess callback catch exception.\n" + ex.getMessage());
        }
    }

    @Override
    @CalledByNative
    public void onDownloadFail(int downloadId, int errorCode) {
        LogUtil.d(TAG, "onDownloadFailed...downloadId: " + downloadId + ",errorCode:" + errorCode);
        try {
            if (this.mHandler != null) {
                this.mHandler.onDownloadFail(downloadId, errorCode);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onDownloadFail callback catch exception.\n" + ex.getMessage());
        }
    }

    @Override
    @CalledByNative
    public void onDownloadMusicProgress(int downloadId, int downloadProgress) {
        LogUtil.d(TAG, "onDownloadMusicProgress...downloadId: " + downloadId + ",downloadProgress:" + downloadProgress);
        try {
            if (this.mHandler != null) {
                this.mHandler.onDownloadMusicProgress(downloadId, downloadProgress);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onDownloadMusicProgress callback catch exception.\n" + ex.getMessage());
        }
    }
}

