/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.handler;

import com.ss.bytertc.engine.data.StreamIndex;
import com.ss.bytertc.engine.engineimpl.RTCEngineImpl;
import com.ss.bytertc.engine.engineimpl.RTCVideoImpl;
import com.ss.bytertc.engine.handler.IExternalVideoEncoderEventHandler;
import java.lang.ref.WeakReference;
import org.webrtc.CalledByNative;

public class RTCExternalVideoEncoderEventHandler {
    private static final String TAG = "RTCExternalVideoEncoderEventHandler";
    private WeakReference<RTCEngineImpl> mRtcEngineImpl;
    private WeakReference<RTCVideoImpl> mRtcVideoImpl;

    public RTCExternalVideoEncoderEventHandler(RTCEngineImpl rtcEngineImpl) {
        this.mRtcEngineImpl = new WeakReference<RTCEngineImpl>(rtcEngineImpl);
    }

    public RTCExternalVideoEncoderEventHandler(RTCVideoImpl rtcVideoImpl) {
        this.mRtcVideoImpl = new WeakReference<RTCVideoImpl>(rtcVideoImpl);
    }

    @CalledByNative
    void OnStart(int index) {
        RTCVideoImpl strongVideo;
        IExternalVideoEncoderEventHandler externalVideoEncoderEventHandler;
        RTCEngineImpl strongEngine;
        if (this.mRtcEngineImpl != null && (strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get()) != null && (externalVideoEncoderEventHandler = strongEngine.getExternalVideoEncoderEventHandler()) != null) {
            externalVideoEncoderEventHandler.OnStart(StreamIndex.fromId(index));
        }
        if (this.mRtcVideoImpl != null && (strongVideo = (RTCVideoImpl)this.mRtcVideoImpl.get()) != null && (externalVideoEncoderEventHandler = strongVideo.getExternalVideoEncoderEventHandler()) != null) {
            externalVideoEncoderEventHandler.OnStart(StreamIndex.fromId(index));
        }
    }

    @CalledByNative
    void OnStop(int index) {
        RTCVideoImpl strongVideo;
        IExternalVideoEncoderEventHandler externalVideoEncoderEventHandler;
        RTCEngineImpl strongEngine;
        if (this.mRtcEngineImpl != null && (strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get()) != null && (externalVideoEncoderEventHandler = strongEngine.getExternalVideoEncoderEventHandler()) != null) {
            externalVideoEncoderEventHandler.OnStop(StreamIndex.fromId(index));
        }
        if (this.mRtcVideoImpl != null && (strongVideo = (RTCVideoImpl)this.mRtcVideoImpl.get()) != null && (externalVideoEncoderEventHandler = strongVideo.getExternalVideoEncoderEventHandler()) != null) {
            externalVideoEncoderEventHandler.OnStop(StreamIndex.fromId(index));
        }
    }

    @CalledByNative
    void OnRateUpdate(int stream_index, int video_index, int fps, int bitrateKbps) {
        RTCVideoImpl strongVideo;
        IExternalVideoEncoderEventHandler externalVideoEncoderEventHandler;
        RTCEngineImpl strongEngine;
        if (this.mRtcEngineImpl != null && (strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get()) != null && (externalVideoEncoderEventHandler = strongEngine.getExternalVideoEncoderEventHandler()) != null) {
            externalVideoEncoderEventHandler.OnRateUpdate(StreamIndex.fromId(stream_index), video_index, fps, bitrateKbps);
        }
        if (this.mRtcVideoImpl != null && (strongVideo = (RTCVideoImpl)this.mRtcVideoImpl.get()) != null && (externalVideoEncoderEventHandler = strongVideo.getExternalVideoEncoderEventHandler()) != null) {
            externalVideoEncoderEventHandler.OnRateUpdate(StreamIndex.fromId(stream_index), video_index, fps, bitrateKbps);
        }
    }

    @CalledByNative
    void OnRequestKeyFrame(int stream_index, int video_index) {
        RTCVideoImpl strongVideo;
        IExternalVideoEncoderEventHandler externalVideoEncoderEventHandler;
        RTCEngineImpl strongEngine;
        if (this.mRtcEngineImpl != null && (strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get()) != null && (externalVideoEncoderEventHandler = strongEngine.getExternalVideoEncoderEventHandler()) != null) {
            externalVideoEncoderEventHandler.OnRequestKeyFrame(StreamIndex.fromId(stream_index), video_index);
        }
        if (this.mRtcVideoImpl != null && (strongVideo = (RTCVideoImpl)this.mRtcVideoImpl.get()) != null && (externalVideoEncoderEventHandler = strongVideo.getExternalVideoEncoderEventHandler()) != null) {
            externalVideoEncoderEventHandler.OnRequestKeyFrame(StreamIndex.fromId(stream_index), video_index);
        }
    }
}

