/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.handler;

import com.ss.bytertc.engine.IMetadataObserver;
import com.ss.bytertc.engine.engineimpl.RTCEngineImpl;
import com.ss.bytertc.engine.engineimpl.RTCVideoImpl;
import java.lang.ref.WeakReference;
import org.webrtc.CalledByNative;

public class RTCMetadataObserver {
    private static final String TAG = "RtcMetadataObserver";
    private WeakReference<RTCEngineImpl> mRtcEngineImpl;
    private WeakReference<RTCVideoImpl> mRtcVideoImpl;

    public RTCMetadataObserver(RTCEngineImpl rtcEngineImpl) {
        this.mRtcEngineImpl = new WeakReference<RTCEngineImpl>(rtcEngineImpl);
    }

    public RTCMetadataObserver(RTCVideoImpl rtcVideoImpl) {
        this.mRtcVideoImpl = new WeakReference<RTCVideoImpl>(rtcVideoImpl);
    }

    @CalledByNative
    void onMetadataReceived(byte[] metadata, String uid, long timestamp) {
        RTCVideoImpl strongVideo;
        IMetadataObserver metadataObserver;
        RTCEngineImpl strongEngine;
        if (this.mRtcEngineImpl != null && (strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get()) != null && (metadataObserver = strongEngine.getMetadataObserver()) != null) {
            metadataObserver.onMetadataReceived(metadata, uid, timestamp);
        }
        if (this.mRtcVideoImpl != null && (strongVideo = (RTCVideoImpl)this.mRtcVideoImpl.get()) != null && (metadataObserver = strongVideo.getMetadataObserver()) != null) {
            metadataObserver.onMetadataReceived(metadata, uid, timestamp);
        }
    }

    @CalledByNative
    byte[] onReadyToSendMetadata(long timestamp) {
        RTCVideoImpl strongVideo;
        RTCEngineImpl strongEngine;
        IMetadataObserver metadataObserver = null;
        if (this.mRtcEngineImpl != null && (strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get()) != null) {
            metadataObserver = strongEngine.getMetadataObserver();
        }
        if (this.mRtcVideoImpl != null && (strongVideo = (RTCVideoImpl)this.mRtcVideoImpl.get()) != null) {
            metadataObserver = strongVideo.getMetadataObserver();
        }
        if (metadataObserver != null) {
            return metadataObserver.onReadyToSendMetadata(timestamp);
        }
        return null;
    }
}

