/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.utils;

import android.opengl.EGLContext;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import com.ss.bytertc.engine.data.VideoFrameType;
import com.ss.bytertc.engine.data.VideoPixelFormat;
import com.ss.bytertc.engine.utils.LogUtil;
import com.ss.bytertc.engine.utils.TextureBufferImpl;
import com.ss.bytertc.engine.utils.TextureHelper;
import com.ss.bytertc.engine.video.VideoFrame;
import com.ss.bytertc.engine.video.builder.GLTextureVideoFrameBuilder;
import org.webrtc.RendererCommon;
import org.webrtc.VideoFrame;

public class VideoFrameConverter {
    private static final String TAG = "VideoFrameConverter";
    private TextureHelper mTextureHelper;
    private long glNativeHandle;
    private TextureHelper mI420TextureConverter;
    private long gl420ConverterNativeHandle;
    private HandlerThread mHandlerThread = new HandlerThread("video-frame-converter");
    private Handler mHandler;
    private boolean mIsStart = false;

    public VideoFrameConverter() {
        this.mHandlerThread.start();
        this.mHandler = new Handler(this.mHandlerThread.getLooper());
        this.mIsStart = true;
    }

    public TextureHelper getTextureHelper() {
        return this.mTextureHelper;
    }

    public synchronized org.webrtc.VideoFrame convert2WebrtcI420Frame(VideoFrame frame) {
        if (frame == null) {
            LogUtil.w(TAG, "convert2WebrtcI420Frame frame is null");
            return null;
        }
        if (frame.getFrameType() != VideoFrameType.kVideoFrameTypeGLTexture) {
            LogUtil.w(TAG, "convert2WebrtcI420Frame: pushExternalVideoFrame VideoFrame type is not available");
            return null;
        }
        if (frame.getEGLContext() == null || !this.updateInnerI420Converter(frame.getEGLContext(), frame.getWidth(), frame.getHeight())) {
            LogUtil.e(TAG, "video frame  error frame eglContext14:" + frame.getEGLContext() + " isStart:" + this.mIsStart);
            return null;
        }
        if (this.mI420TextureConverter != null) {
            org.webrtc.VideoFrame wrappedTextureFrame = this.allocateVideoFrame(frame, this.mI420TextureConverter, null);
            org.webrtc.VideoFrame i420Frame = new org.webrtc.VideoFrame(wrappedTextureFrame.getBuffer().toI420(), wrappedTextureFrame.getRotation(), wrappedTextureFrame.getTimestampNs());
            wrappedTextureFrame.release();
            return i420Frame;
        }
        return null;
    }

    public synchronized org.webrtc.VideoFrame convert2WebrtcTextureFrame(VideoFrame frame) {
        if (frame == null) {
            LogUtil.w(TAG, "convert2VideoFrame frame is null");
            return null;
        }
        if (frame.getFrameType() != VideoFrameType.kVideoFrameTypeGLTexture) {
            LogUtil.w(TAG, "pushExternalVideoFrame VideoFrame type is not available");
            return null;
        }
        org.webrtc.VideoFrame videoFrame = null;
        if (frame.getEGLContext() != null) {
            this.updateEglContext(frame.getEGLContext(), frame.getWidth(), frame.getHeight());
        }
        if (this.mTextureHelper != null) {
            if (frame.hasReleaseCallback()) {
                videoFrame = this.allocateVideoFrame(frame, this.mTextureHelper, frame::release);
            } else {
                int format;
                int targetTextureId = this.mTextureHelper.dequeueTexture();
                if (targetTextureId == 0) {
                    return null;
                }
                if (frame.getPixelFormat() == VideoPixelFormat.kVideoPixelFormatTexture2D) {
                    format = 10;
                } else if (frame.getPixelFormat() == VideoPixelFormat.kVideoPixelFormatTextureOES) {
                    format = 11;
                } else {
                    return null;
                }
                this.mTextureHelper.drawTexture(format, frame.getTextureID(), targetTextureId);
                GLTextureVideoFrameBuilder builder = new GLTextureVideoFrameBuilder(VideoPixelFormat.kVideoPixelFormatTexture2D);
                builder.setColorSpace(frame.getColorSpace()).setTextureID(targetTextureId).setEGLContext(frame.getEGLContext()).setTextureMatrix(frame.getTextureMatrix()).setWidth(frame.getWidth()).setHeight(frame.getHeight()).setRotation(frame.getRotation()).setTimeStampUs(frame.getTimeStampUs()).setReleaseCallback(() -> this.mTextureHelper.queueTexture(targetTextureId));
                VideoFrame tempFrame = builder.build();
                videoFrame = this.allocateVideoFrame(tempFrame, this.mTextureHelper, tempFrame::release);
            }
        }
        return videoFrame;
    }

    public org.webrtc.VideoFrame allocateVideoFrame(VideoFrame bytertcFrame, TextureHelper textureHelper, Runnable runnable) {
        VideoFrame.TextureBuffer.Type webrtcFrameType;
        if (bytertcFrame.getFrameType() == VideoFrameType.kVideoFrameTypeRawMemory) {
            LogUtil.w(TAG, "allocateVideoFrame only glTexture format is avaliable");
            return null;
        }
        switch (bytertcFrame.getPixelFormat()) {
            case kVideoPixelFormatTexture2D: {
                webrtcFrameType = VideoFrame.TextureBuffer.Type.RGB;
                break;
            }
            case kVideoPixelFormatTextureOES: {
                webrtcFrameType = VideoFrame.TextureBuffer.Type.OES;
                break;
            }
            default: {
                LogUtil.w(TAG, "texture format is not support");
                return null;
            }
        }
        TextureBufferImpl webrtcBuffer2D = new TextureBufferImpl(bytertcFrame.getWidth(), bytertcFrame.getHeight(), webrtcFrameType, bytertcFrame.getTextureID(), RendererCommon.convertMatrixToAndroidGraphicsMatrix(bytertcFrame.getTextureMatrix()), textureHelper, runnable);
        webrtcBuffer2D.setEglBaseContext(textureHelper.getEglBaseContext());
        return new org.webrtc.VideoFrame(webrtcBuffer2D, bytertcFrame.getRotation().value(), bytertcFrame.getTimeStampUs() * 1000L);
    }

    private boolean updateInnerI420Converter(EGLContext eglContext, int frameWidth, int frameHeight) {
        if (this.mI420TextureConverter == null) {
            this.mI420TextureConverter = TextureHelper.create("EGLBaseTextureHelper", eglContext, frameWidth, frameHeight);
            this.gl420ConverterNativeHandle = this.getNativeEglContext(eglContext);
            LogUtil.i(TAG, "create EglBase 420 texture converter");
        } else if (this.gl420ConverterNativeHandle != this.getNativeEglContext(eglContext)) {
            this.gl420ConverterNativeHandle = this.getNativeEglContext(eglContext);
            this.mI420TextureConverter.dispose();
            this.mI420TextureConverter = TextureHelper.create("EGL14TextureConverter", eglContext, frameWidth, frameHeight);
            LogUtil.i(TAG, "update egl14texture converter nativeHandle:" + this.glNativeHandle + " ,eglContext:" + eglContext);
        }
        return true;
    }

    private void updateEglContext(EGLContext eglContext, int frameWidth, int frameHeight) {
        if (this.mTextureHelper == null) {
            this.mTextureHelper = TextureHelper.create("EGL14TextureHelper", eglContext, frameWidth, frameHeight);
            this.glNativeHandle = this.getNativeEglContext(eglContext);
            LogUtil.i(TAG, "create  egl14 texture helper");
        } else if (this.glNativeHandle != this.getNativeEglContext(eglContext) || this.mTextureHelper.getWidth() != frameWidth || this.mTextureHelper.getHeight() != frameHeight) {
            this.glNativeHandle = this.getNativeEglContext(eglContext);
            this.mTextureHelper.dispose();
            this.mTextureHelper = TextureHelper.create("EGL14TextureHelper", eglContext, frameWidth, frameHeight);
            LogUtil.i(TAG, "update egl14Context nativeHandle:" + this.glNativeHandle + " ,eglContext:" + eglContext + "frame size width:" + frameWidth + "height :" + frameHeight);
        }
    }

    private long getNativeEglContext(EGLContext egl14Context) {
        return Build.VERSION.SDK_INT >= 21 ? egl14Context.getNativeHandle() : (long)egl14Context.getHandle();
    }

    public long getNativeEglContext(javax.microedition.khronos.egl.EGLContext eglContext) {
        return 0L;
    }

    public synchronized void post(Runnable run) {
        if (!this.mIsStart) {
            return;
        }
        if (this.mTextureHelper != null) {
            this.mTextureHelper.post(run);
        } else {
            this.mHandler.post(run);
        }
    }

    public synchronized void dispose() {
        if (this.mTextureHelper != null) {
            this.mTextureHelper.dispose();
        }
        if (this.mI420TextureConverter != null) {
            this.mI420TextureConverter.dispose();
        }
        if (this.mHandlerThread != null) {
            this.mHandlerThread.quit();
        }
        this.mIsStart = false;
    }
}

