/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.media;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Matrix;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.opengl.GLES20;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import android.view.WindowManager;
import com.bytedance.realx.base.CalledByNative;
import com.ss.android.ttvecamera.TECameraCapture;
import com.ss.android.ttvecamera.TECameraFrame;
import com.ss.android.ttvecamera.TECameraSettings;
import com.ss.android.ttvecamera.TEFocusSettings;
import com.ss.android.ttvecamera.TEFrameRateRange;
import com.ss.android.ttvecamera.TEFrameSizei;
import com.ss.android.ttvecamera.TELogUtils;
import com.ss.android.ttvecamera.provider.TECameraProvider;
import com.ss.android.ttvecamera.provider.TECameraProviderManager;
import com.ss.bytertc.engine.UIDeviceOrientation;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.webrtc.ContextUtils;
import org.webrtc.EglBase;
import org.webrtc.GlUtil;
import org.webrtc.NV21Buffer;
import org.webrtc.TextureBufferImpl;
import org.webrtc.TimestampAligner;
import org.webrtc.VideoFrame;
import org.webrtc.YuvConverter;

public class VECameraWrapper {
    private Context mContext = null;
    private long mNativeObj = 0L;
    private TECameraCapture mCamera = null;
    private TECameraSettings mVESettings = null;
    private EglBase.Context mSharedCtx = null;
    private int mLastDeviceOrientation = 0;
    private int mLastUIOrientation = 0;
    private long mLastDeviceOrientationTS = 0L;
    private EventObserver mEventObserver = null;
    private FrameListener mFrameListener = null;
    CamParam mParam;
    private int mActWidth = 0;
    private int mActHeight = 0;
    private final int STA_STOPPED = 0;
    private final int STA_STARTING = 1;
    private final int STA_STARTED = 2;
    AtomicInteger mCamState = new AtomicInteger(0);
    private volatile LogCallback mLogger = new LogCallback();
    private final String TAG2SVR = "toSvr";
    private boolean mIsExposurePointSupported = true;
    private boolean mIsFocusPointSupported = true;
    private boolean mUseGravitySensor = false;
    private AtomicInteger mGravityOrientation = new AtomicInteger(UIDeviceOrientation.Portrait.value());
    private Camera.CameraInfo mCamInfo = null;
    private Camera.CameraInfo[] mCamInfoList = null;
    private final SensorEventListener mSensorListener = new SensorEventListener(){

        public void onSensorChanged(SensorEvent event) {
            float absY;
            float x = event.values[0];
            float y = event.values[1];
            float absX = Math.abs(x);
            if ((double)Math.abs(absX - (absY = Math.abs(y))) < 6.0) {
                return;
            }
            if (absX >= absY) {
                if (x >= 0.0f) {
                    VECameraWrapper.this.mGravityOrientation.set(UIDeviceOrientation.LandscapeRight.value());
                } else {
                    VECameraWrapper.this.mGravityOrientation.set(UIDeviceOrientation.LandscapeLeft.value());
                }
            } else if (y >= 0.0f) {
                VECameraWrapper.this.mGravityOrientation.set(UIDeviceOrientation.Portrait.value());
            } else {
                VECameraWrapper.this.mGravityOrientation.set(UIDeviceOrientation.PortraitUpsidedown.value());
            }
        }

        public void onAccuracyChanged(Sensor sensor, int accuracy) {
        }
    };

    public static native void nativeOnCaptureStarted(long var0);

    public static native void nativeOnCaptureStopped(long var0);

    public static native void nativeOnCaptureError(long var0, int var2, String var3);

    public static native void nativeOnFrameCaptured(long var0, VideoFrame var2);

    public static native void nativeOnCaptureLog(long var0, int var2, String var3, boolean var4);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeNativeOnCaptureStarted() {
        VECameraWrapper vECameraWrapper = this;
        synchronized (vECameraWrapper) {
            if (this.mNativeObj != 0L) {
                VECameraWrapper.nativeOnCaptureStarted(this.mNativeObj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeNativeOnCaptureStopped() {
        VECameraWrapper vECameraWrapper = this;
        synchronized (vECameraWrapper) {
            if (this.mNativeObj != 0L) {
                VECameraWrapper.nativeOnCaptureStopped(this.mNativeObj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeNativeOnCaptureError(int error, String errmsg) {
        VECameraWrapper vECameraWrapper = this;
        synchronized (vECameraWrapper) {
            if (this.mNativeObj != 0L) {
                VECameraWrapper.nativeOnCaptureError(this.mNativeObj, error, errmsg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeNativeOnFrameCaptured(VideoFrame videoFrame) {
        VECameraWrapper vECameraWrapper = this;
        synchronized (vECameraWrapper) {
            if (this.mNativeObj != 0L) {
                VECameraWrapper.nativeOnFrameCaptured(this.mNativeObj, videoFrame);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void safeNativeOnCaptureLog(int lvl, String msg, boolean toServer) {
        VECameraWrapper vECameraWrapper = this;
        synchronized (vECameraWrapper) {
            if (this.mNativeObj != 0L) {
                VECameraWrapper.nativeOnCaptureLog(this.mNativeObj, lvl, msg, toServer);
            } else {
                Log.d((String)"VECAM", (String)msg);
            }
        }
    }

    @SuppressLint(value={"DefaultLocale"})
    private String formatParams() {
        return String.format("[w:%d h:%d fr:%d pos:%d tex:%b cam2:%b faceae:%b wideangle:%b antishake:%b]", this.mParam.width, this.mParam.height, this.mParam.fps, this.mParam.pos, this.mParam.useTexture, this.mParam.camera2, this.mParam.faceAE, this.mParam.wideAngle, this.mParam.antiShake);
    }

    @CalledByNative
    VECameraWrapper(long nativeObj, EglBase.Context ctx) {
        this.mNativeObj = nativeObj;
        this.mSharedCtx = ctx;
    }

    @CalledByNative
    public void startCapture(CamParam p) {
        if (this.mCamState.get() != 0) {
            return;
        }
        this.mCamState.set(1);
        this.mParam = p;
        this.mContext = ContextUtils.getApplicationContext();
        if (ContextCompat.checkSelfPermission((Context)this.mContext, (String)"android.permission.CAMERA") != 0) {
            this.safeNativeOnCaptureError(-408, "camera disabled");
            return;
        }
        this.mLogger.Log((byte)8, "toSvr", "startCapture - input params " + this.formatParams());
        this.mCamInfo = new Camera.CameraInfo();
        int camNum = Camera.getNumberOfCameras();
        this.mCamInfoList = new Camera.CameraInfo[camNum];
        for (int i = 0; i < camNum; ++i) {
            try {
                this.mCamInfoList[i] = new Camera.CameraInfo();
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)this.mCamInfoList[i]);
                if (this.mCamInfoList[i].facing != this.mParam.pos) continue;
                this.mCamInfo = this.mCamInfoList[i];
                continue;
            }
            catch (Exception e) {
                Log.d((String)"VECAM", (String)e.toString());
            }
        }
        this.updateCameraCharacteristics();
        if (!this.mParam.useTexture) {
            this.mParam.camera2 = false;
        }
        this.mLogger.Log((byte)8, "toSvr", "startCapture - actual params " + this.formatParams());
        this.mFrameListener = new FrameListener();
        this.mEventObserver = new EventObserver();
        this.mFrameListener.startup();
        int camtype = 1;
        if (this.mParam.camera2) {
            camtype = 2;
        }
        this.mVESettings = new TECameraSettings(this.mContext, camtype, this.mParam.width, this.mParam.height);
        this.mVESettings.mFacing = this.mParam.pos;
        this.mVESettings.mPreferOpenCameraByCameraId = true;
        this.mVESettings.mStrCustomizedCameraID = this.mParam.camid;
        int minfps = 0;
        minfps = this.mParam.enable_dynamic_fps ? Math.min(this.mParam.min_dynamic_fps, this.mParam.fps) : (this.mParam.fps < 7 ? this.mParam.fps : 7);
        this.mVESettings.mFPSRange = new TEFrameRateRange(minfps, this.mParam.fps);
        this.mLogger.Log((byte)8, "toSvr", "enable_dynamic_fps:" + this.mParam.enable_dynamic_fps + " fpsRange min=" + minfps + " max:" + this.mParam.fps);
        this.mVESettings.mEnableManualReleaseCaptureResult = false;
        if (this.mParam.faceAE) {
            this.mVESettings.mExtParameters.putInt("useCameraFaceDetect", 3);
        }
        this.mVESettings.mEnableMonitorGyroscope = true;
        this.mVESettings.mIsCameraOpenCloseSync = true;
        this.mCamera = new TECameraCapture((TECameraCapture.CameraObserver)this.mEventObserver, null);
        TECameraCapture.registerLogOutput((byte)31, (TELogUtils.ILog)this.mLogger);
        this.mCamera.registerPreviewListener(new TECameraCapture.PreviewSizeCallback(){

            public TEFrameSizei getPreviewSize(List<TEFrameSizei> supportPreviewSizes) {
                if (supportPreviewSizes.size() == 0) {
                    return null;
                }
                TEFrameSizei sel = supportPreviewSizes.get(0);
                int d0 = Math.abs(VECameraWrapper.this.mParam.width - sel.width) + Math.abs(VECameraWrapper.this.mParam.height - sel.height);
                for (int i = 1; i < supportPreviewSizes.size(); ++i) {
                    TEFrameSizei cur = supportPreviewSizes.get(i);
                    int d1 = Math.abs(VECameraWrapper.this.mParam.width - cur.width) + Math.abs(VECameraWrapper.this.mParam.height - cur.height);
                    if (d1 >= d0) continue;
                    sel = cur;
                    d0 = d1;
                }
                return sel;
            }
        });
        this.mCamera.connect(this.mVESettings);
        this.mLastDeviceOrientationTS = System.currentTimeMillis();
        this.mLastDeviceOrientation = this.getDeviceOrientation();
        this.mLastUIOrientation = this.updateUIOrientation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public void stopCapture() {
        SensorManager sensorManager;
        this.mLogger.Log((byte)8, "toSvr", "stopCapture...");
        if (this.mUseGravitySensor && (sensorManager = (SensorManager)this.mContext.getSystemService("sensor")) != null) {
            sensorManager.unregisterListener(this.mSensorListener);
        }
        if (this.mCamera != null) {
            this.mCamera.stop();
            this.mCamera.disConnect();
            this.mVESettings = null;
            this.mCamera = null;
        }
        if (this.mFrameListener != null) {
            this.mFrameListener.shutdown();
            this.mFrameListener = null;
        }
        this.mEventObserver = null;
        this.mCamState.set(0);
        this.mLogger.Log((byte)8, "toSvr", "stopCapture done.");
        VECameraWrapper vECameraWrapper = this;
        synchronized (vECameraWrapper) {
            this.mNativeObj = 0L;
        }
    }

    @CalledByNative
    public int enableCameraTorch(boolean enable) {
        if (this.mCamState.get() != 2) {
            return 0;
        }
        this.mCamera.toggleTorch(enable);
        return 0;
    }

    @CalledByNative
    public boolean isCameraTorchSupported() {
        if (this.mCamState.get() != 2) {
            return false;
        }
        return this.mCamera.isTorchSupported();
    }

    private ZoomCallback queryZoomAbility() {
        CountDownLatch sigFinish = new CountDownLatch(1);
        ZoomCallback cb = new ZoomCallback(sigFinish);
        this.mCamera.queryZoomAbility((TECameraSettings.ZoomCallback)cb, false);
        try {
            sigFinish.await(2000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return cb;
    }

    @CalledByNative
    public boolean isCameraZoomSupported() {
        if (this.mCamState.get() != 2) {
            return false;
        }
        ZoomCallback cb = this.queryZoomAbility();
        return cb.mSupportZoom;
    }

    @CalledByNative
    public int setCameraZoomRatio(float zoom_val) {
        if (this.mCamState.get() != 2) {
            return -1;
        }
        ZoomCallback cb = new ZoomCallback(null);
        this.mCamera.startZoom(zoom_val, (TECameraSettings.ZoomCallback)cb);
        return 0;
    }

    @CalledByNative
    public float getCameraZoomMaxRatio() {
        if (this.mCamState.get() != 2) {
            return 1.0f;
        }
        ZoomCallback cb = this.queryZoomAbility();
        return cb.mMaxZoom;
    }

    int camera1FaceingToCamera2(int facing) {
        if (facing == 0) {
            return 1;
        }
        return 0;
    }

    private void updateCameraCharacteristics() {
        if (Build.VERSION.SDK_INT >= 21) {
            int cam2facing = this.camera1FaceingToCamera2(this.mParam.pos);
            CameraManager m = (CameraManager)this.mContext.getSystemService("camera");
            try {
                String[] camlist = m.getCameraIdList();
                for (int i = 0; i < camlist.length; ++i) {
                    CameraCharacteristics cch = m.getCameraCharacteristics(camlist[i]);
                    if ((Integer)cch.get(CameraCharacteristics.LENS_FACING) != cam2facing) continue;
                    int num_ae = (Integer)cch.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AE);
                    int num_af = (Integer)cch.get(CameraCharacteristics.CONTROL_MAX_REGIONS_AF);
                    this.mIsExposurePointSupported = num_ae > 0;
                    this.mIsFocusPointSupported = num_af > 0;
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @CalledByNative
    public boolean isCameraFocusPointSupported() {
        if (this.mCamState.get() != 2) {
            return false;
        }
        return this.mIsFocusPointSupported;
    }

    @CalledByNative
    public boolean isCameraExposurePointSupported() {
        if (this.mCamState.get() != 2) {
            return false;
        }
        return this.mIsExposurePointSupported;
    }

    @CalledByNative
    public int setExposureCompensation(float val) {
        if (val < -1.0f || val > 1.0f) {
            return -1;
        }
        if (this.mCamState.get() != 2) {
            return -1;
        }
        if (!this.mCamera.isSupportedExposureCompensation()) {
            return -1;
        }
        TECameraSettings.ExposureCompensationInfo info = this.mCamera.getCameraECInfo();
        int ec = 0;
        if (val < 0.0f) {
            ec = (int)Math.ceil(-Math.abs(val * (float)info.min));
        }
        if (val > 0.0f) {
            ec = (int)Math.floor(Math.abs(val * (float)info.max));
        }
        this.mCamera.setExposureCompensation(ec);
        return 0;
    }

    @CalledByNative
    public int setFocusPoint(float x, float y) {
        if (this.mCamState.get() != 2 || !this.mIsFocusPointSupported) {
            return -1;
        }
        return this.focusAtPointImpl(x, y, true, true);
    }

    @CalledByNative
    public int setExposurePoint(float x, float y) {
        if (this.mCamState.get() != 2 || !this.mIsExposurePointSupported) {
            return -1;
        }
        return this.focusAtPointImpl(x, y, false, true);
    }

    private int focusAtPointImpl(float x, float y, boolean focus, boolean exposure) {
        if (this.mCamState.get() != 2) {
            return -1;
        }
        if (this.mActWidth == 0 || this.mActHeight == 0) {
            return -1;
        }
        TEFocusSettings fs = new TEFocusSettings(this.mActWidth, this.mActHeight, (int)((float)this.mActWidth * x), (int)((float)this.mActHeight * y), 1.0f);
        fs.setCoordinatesMode(TEFocusSettings.CoordinatesMode.ORIGINAL_FRAME);
        fs.setNeedFocus(focus);
        fs.setNeedMetering(exposure);
        this.mCamera.focusAtPoint(fs);
        return 0;
    }

    @CalledByNative
    public int getCameraSensorOrientation() {
        return 0;
    }

    @CalledByNative
    public int getDeviceOrientation() {
        if (this.mUseGravitySensor) {
            return this.mGravityOrientation.get();
        }
        return this.getUIOrientation();
    }

    @CalledByNative
    public int getUIOrientation() {
        return this.mLastUIOrientation;
    }

    public int updateUIOrientation() {
        WindowManager wm = (WindowManager)this.mContext.getSystemService("window");
        switch (wm.getDefaultDisplay().getRotation()) {
            case 1: {
                return UIDeviceOrientation.LandscapeRight.value();
            }
            case 2: {
                return UIDeviceOrientation.PortraitUpsidedown.value();
            }
            case 3: {
                return UIDeviceOrientation.LandscapeLeft.value();
            }
        }
        return UIDeviceOrientation.Portrait.value();
    }

    private int getFrameOrientation() {
        int rotation = this.mLastDeviceOrientation;
        if (this.mUseGravitySensor) {
            rotation = this.mGravityOrientation.get();
        }
        if (this.mCamInfo.facing == 1) {
            rotation = 360 - rotation;
        }
        return (this.mCamInfo.orientation + rotation) % 360;
    }

    @CalledByNative
    public int enableGravitySensor(boolean enable) {
        SensorManager sensorManager = (SensorManager)this.mContext.getSystemService("sensor");
        if (sensorManager == null) {
            return -1;
        }
        Sensor gravitySensor = sensorManager.getDefaultSensor(9);
        if (gravitySensor == null) {
            return -1;
        }
        if (enable) {
            sensorManager.registerListener(this.mSensorListener, gravitySensor, 2);
            this.mUseGravitySensor = true;
        } else {
            sensorManager.unregisterListener(this.mSensorListener);
            this.mUseGravitySensor = false;
        }
        return 0;
    }

    @CalledByNative
    public static CamDevInfo[] getCameraList() {
        if (Build.VERSION.SDK_INT >= 21) {
            return VECameraWrapper.getCameraListByCamera2();
        }
        int camNum = Camera.getNumberOfCameras();
        CamDevInfo[] ret = new CamDevInfo[camNum];
        for (int i = 0; i < camNum; ++i) {
            Camera.CameraInfo info = new Camera.CameraInfo();
            try {
                Camera.getCameraInfo((int)i, (Camera.CameraInfo)info);
                String facing = "back";
                int pos = 1;
                if (info.facing == 1) {
                    pos = 0;
                    facing = "front";
                }
                String name = "Camera " + i + ", Facing " + facing + ", Orientation " + info.orientation;
                ret[i] = new CamDevInfo(Integer.toString(i), name, pos);
                continue;
            }
            catch (Exception e) {
                Log.e((String)"VECameraWrapper", (String)("getCameraInfo failed on index " + i), (Throwable)e);
                return null;
            }
        }
        return ret;
    }

    private static CamDevInfo[] getCameraListByCamera2() {
        CamDevInfo[] ret = null;
        if (Build.VERSION.SDK_INT >= 21) {
            Context ctx = ContextUtils.getApplicationContext();
            CameraManager m = (CameraManager)ctx.getSystemService("camera");
            try {
                String[] camlist = m.getCameraIdList();
                ret = new CamDevInfo[camlist.length];
                for (int i = 0; i < camlist.length; ++i) {
                    CameraCharacteristics cch = m.getCameraCharacteristics(camlist[i]);
                    int facing = (Integer)cch.get(CameraCharacteristics.LENS_FACING);
                    int orientation = (Integer)cch.get(CameraCharacteristics.SENSOR_ORIENTATION);
                    int pos = 0;
                    if (facing == 1) {
                        pos = 1;
                    }
                    String name = "Camera " + i + ", Facing " + pos + ", Orientation " + orientation;
                    ret[i] = new CamDevInfo(camlist[i], name, pos);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    @CalledByNative
    int getCameraSensorOrientations(boolean isFrontCamera) {
        int orientation;
        int n = orientation = isFrontCamera ? 270 : 90;
        if (this.mCamInfoList == null) {
            return orientation;
        }
        for (Camera.CameraInfo info : this.mCamInfoList) {
            if ((info.facing != 1 || !isFrontCamera) && (info.facing != 0 || isFrontCamera)) continue;
            orientation = info.orientation;
            break;
        }
        return orientation;
    }

    public static class CamDevInfo {
        private String id;
        private String name;
        private int pos;

        public CamDevInfo(String aId, String aName, int iPos) {
            this.id = aId;
            this.name = aName;
            this.pos = iPos;
        }

        @CalledByNative(value="CamDevInfo")
        public String getID() {
            return this.id;
        }

        @CalledByNative(value="CamDevInfo")
        public String getName() {
            return this.name;
        }

        @CalledByNative(value="CamDevInfo")
        public int getPosition() {
            return this.pos;
        }
    }

    class ZoomCallback
    implements TECameraSettings.ZoomCallback {
        public boolean mSupportZoom = false;
        public float mMaxZoom = 1.0f;
        CountDownLatch mSigFinish = null;

        public ZoomCallback(CountDownLatch sigFinish) {
            this.mSigFinish = sigFinish;
        }

        public boolean enableSmooth() {
            return true;
        }

        public void onZoomSupport(int cameraType, boolean supportZoom, boolean supportSmooth, float maxZoom, List<Integer> ratios) {
            this.mSupportZoom = supportZoom;
            this.mMaxZoom = maxZoom;
            if (this.mSigFinish != null) {
                this.mSigFinish.countDown();
            }
        }

        public void onChange(int cameraType, float zoomValue, boolean stopped) {
        }
    }

    public static class CamParam {
        public int width;
        public int height;
        public int fps;
        public int pos;
        public String camid;
        public boolean useTexture;
        public boolean camera2;
        public boolean faceAE;
        public boolean wideAngle;
        public boolean antiShake;
        public boolean enable_dynamic_fps;
        public int min_dynamic_fps;

        @CalledByNative(value="CamParam")
        public CamParam(int width, int height, int frameRate, int pos, String camid, boolean useTex, boolean camera2, boolean faceae, boolean wideAngle, boolean antiShake, boolean enable_dynamic_fps, int min_dynamic_fps) {
            this.width = width;
            this.height = height;
            this.fps = frameRate;
            this.pos = pos;
            this.camid = camid;
            this.useTexture = useTex;
            this.camera2 = camera2;
            this.faceAE = faceae;
            this.wideAngle = wideAngle;
            this.antiShake = antiShake;
            this.enable_dynamic_fps = enable_dynamic_fps;
            this.min_dynamic_fps = min_dynamic_fps;
        }
    }

    class EventObserver
    implements TECameraCapture.CameraObserver {
        EventObserver() {
        }

        public void onCaptureStarted(int cameraType, int ret) {
            VECameraWrapper.this.mLogger.Log((byte)8, "toSvr", "CameraObserver.onCaptureStarted");
            TEFrameSizei frameSize = new TEFrameSizei(VECameraWrapper.this.mParam.width, VECameraWrapper.this.mParam.height);
            TECameraProviderManager.ProviderSettings pdrSettings = null;
            pdrSettings = VECameraWrapper.this.mParam.useTexture ? new TECameraProviderManager.ProviderSettings(frameSize, (TECameraProvider.CaptureListener)VECameraWrapper.this.mFrameListener, true, VECameraWrapper.this.mFrameListener.mSurfaceTexture, VECameraWrapper.this.mFrameListener.mTexId) : new TECameraProviderManager.ProviderSettings(frameSize, (TECameraProvider.CaptureListener)VECameraWrapper.this.mFrameListener, true, VECameraWrapper.this.mFrameListener.mSurfaceTexture, TECameraFrame.ETEPixelFormat.PIXEL_FORMAT_NV21);
            int rst = VECameraWrapper.this.mCamera.addCameraProvider(pdrSettings);
            VECameraWrapper.this.mLogger.Log((byte)8, "", "addCameraProvider rst =" + String.valueOf(rst));
            VECameraWrapper.this.mCamera.start();
            VECameraWrapper.this.mCamState.set(2);
        }

        public void onCaptureStopped(int ret) {
            VECameraWrapper.this.mLogger.Log((byte)8, "toSvr", "CameraObserver.onCaptureStopped");
            VECameraWrapper.this.safeNativeOnCaptureStopped();
        }

        public void onError(int ret, String msg) {
            VECameraWrapper.this.mLogger.Log((byte)8, "toSvr", "CameraObserver.onError, err=" + Integer.toString(ret) + " msg=" + msg);
            VECameraWrapper.this.safeNativeOnCaptureError(ret, msg);
        }

        public void onInfo(int infoType, int ext, String msg) {
            VECameraWrapper.this.mLogger.Log((byte)8, "", "CameraObserver.onInfo, type=" + Integer.toString(infoType) + " msg=" + msg);
        }
    }

    class FrameListener
    implements TECameraProvider.CaptureListener {
        boolean mIsFirstFrame = true;
        boolean mStopped = false;
        private SurfaceTexture mSurfaceTexture = null;
        private int mTexId = -1;
        private YuvConverter mYuvConverter = null;
        EglBase mEglBase = null;
        private HandlerThread mThread = null;
        private Handler mHandler = null;
        private Matrix mTexMat = null;
        private TimestampAligner mTimestampAligner = new TimestampAligner();
        private Semaphore mFreeTexSema = null;
        private long frameCountReturned = 0L;
        private long frameCountSent = 0L;

        FrameListener() {
        }

        private void returnRawFrame() {
            ++this.frameCountReturned;
        }

        private void returnTextureFrame() {
            ++this.frameCountReturned;
            this.mFreeTexSema.release();
        }

        private void sendRawFrame(TECameraFrame frame) {
            int rotation = VECameraWrapper.this.getFrameOrientation();
            NV21Buffer frameBuffer = new NV21Buffer(frame.getBufferData(), frame.getSize().width, frame.getSize().height, new Runnable(){

                @Override
                public void run() {
                    FrameListener.this.returnRawFrame();
                }
            });
            VideoFrame vf = new VideoFrame((VideoFrame.Buffer)frameBuffer, rotation, frame.getTimeStampNS(), false);
            VECameraWrapper.this.safeNativeOnFrameCaptured(vf);
            ++this.frameCountSent;
            vf.release();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendTexFrame(final TECameraFrame frame) {
            if (this.mStopped) {
                return;
            }
            try {
                if (this.mFreeTexSema.availablePermits() == 0) {
                    this.mHandler.post(new Runnable(){

                        @Override
                        public void run() {
                            FrameListener.this.sendTexFrame(frame);
                        }
                    });
                    return;
                }
                this.mFreeTexSema.acquire();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            Object e = EglBase.lock;
            synchronized (e) {
                try {
                    this.mSurfaceTexture.updateTexImage();
                }
                catch (Exception e2) {
                    e2.printStackTrace();
                    VECameraWrapper.this.mLogger.Log((byte)8, "", "updateTexImage failed(could be caused by fd leak)");
                }
            }
            Matrix mat = new Matrix();
            float[] values = new float[]{1.0f, 0.0f, 0.0f, 0.0f, -1.0f, 1.0f, 0.0f, 0.0f, 1.0f};
            mat.setValues(values);
            int rotation = VECameraWrapper.this.getFrameOrientation();
            long timestampNs = this.mSurfaceTexture.getTimestamp();
            timestampNs = this.mTimestampAligner.translateTimestamp(timestampNs);
            TextureBufferImpl buffer = new TextureBufferImpl(frame.getSize().width, frame.getSize().height, VideoFrame.TextureBuffer.Type.OES, frame.getTextureID(), mat, this.mHandler, this.mYuvConverter, new Runnable(){

                @Override
                public void run() {
                    FrameListener.this.returnTextureFrame();
                }
            });
            VideoFrame videoFrame = new VideoFrame(buffer, rotation, timestampNs);
            VECameraWrapper.this.safeNativeOnFrameCaptured(videoFrame);
            ++this.frameCountSent;
            videoFrame.release();
        }

        public void onFrameCaptured(final TECameraFrame frame) {
            VECameraWrapper.this.mActWidth = frame.getSize().width;
            VECameraWrapper.this.mActHeight = frame.getSize().height;
            long cur = System.currentTimeMillis();
            if (Math.abs(cur - VECameraWrapper.this.mLastDeviceOrientationTS) > 500L) {
                VECameraWrapper.this.mLastDeviceOrientationTS = cur;
                VECameraWrapper.this.mLastDeviceOrientation = VECameraWrapper.this.getDeviceOrientation();
                VECameraWrapper.this.mLastUIOrientation = VECameraWrapper.this.updateUIOrientation();
            }
            if (this.mIsFirstFrame) {
                VECameraWrapper.this.safeNativeOnCaptureStarted();
                this.mIsFirstFrame = false;
            }
            if (VECameraWrapper.this.mParam.useTexture) {
                this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        FrameListener.this.sendTexFrame(frame);
                    }
                });
            } else {
                this.sendRawFrame(frame);
            }
        }

        public void onNewSurfaceTexture(SurfaceTexture surfaceTexture) {
            VECameraWrapper.this.mLogger.Log((byte)8, "", "IFrameListener.onNewSurfaceTexture");
        }

        public void startup() {
            this.mThread = new HandlerThread("vecam_handler");
            this.mThread.start();
            this.mHandler = new Handler(this.mThread.getLooper());
            this.mFreeTexSema = new Semaphore(1);
            final CountDownLatch startSignal = new CountDownLatch(1);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    FrameListener.this.mEglBase = EglBase.create(VECameraWrapper.this.mSharedCtx, EglBase.CONFIG_PIXEL_BUFFER);
                    try {
                        FrameListener.this.mEglBase.createDummyPbufferSurface();
                        FrameListener.this.mEglBase.makeCurrent();
                        FrameListener.this.mTexId = GlUtil.generateTexture(36197);
                        FrameListener.this.mSurfaceTexture = new SurfaceTexture(FrameListener.this.mTexId);
                        FrameListener.this.mYuvConverter = new YuvConverter();
                    }
                    catch (RuntimeException e) {
                        FrameListener.this.mEglBase.release();
                    }
                    startSignal.countDown();
                }
            });
            try {
                startSignal.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }

        public void shutdown() {
            final CountDownLatch stopSignal = new CountDownLatch(1);
            this.mHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (VECameraWrapper.this.mParam.useTexture && FrameListener.this.mFreeTexSema.availablePermits() == 0) {
                        try {
                            FrameListener.this.mFreeTexSema.acquire();
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                    }
                    FrameListener.this.mYuvConverter.release();
                    GLES20.glDeleteTextures((int)1, (int[])new int[]{FrameListener.this.mTexId}, (int)0);
                    FrameListener.this.mSurfaceTexture.release();
                    FrameListener.this.mEglBase.release();
                    stopSignal.countDown();
                    FrameListener.this.mStopped = true;
                }
            });
            try {
                stopSignal.await();
                this.mHandler.getLooper().quit();
                this.mThread.join();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    class LogCallback
    implements TELogUtils.ILog {
        LogCallback() {
        }

        public void Log(byte level, String TAG, String logStr) {
            byte[] lvls = new byte[]{1, 2, 4, 8, 16};
            int[] mapped = new int[]{4, 3, 2, 1, 0};
            int rtclvl = 0;
            for (int i = 0; i < 5; ++i) {
                if (level != lvls[i]) continue;
                rtclvl = mapped[i];
                break;
            }
            VECameraWrapper.this.safeNativeOnCaptureLog(rtclvl, "VECAM-" + logStr, TAG.endsWith("toSvr"));
        }
    }
}

